/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldRange;

class ExprBaseTable
extends Expr {
    private TableImpl theTargetTable;
    private ArrayList<TableImpl> theTables = new ArrayList(1);
    private ArrayList<String> theAliases = new ArrayList(1);
    private int theNumAncestors;
    private int theNumDescendants;
    private Expr[] theTablePreds;
    private Direction theDirection = Direction.FORWARD;
    private ArrayList<PrimaryKeyImpl> thePrimKeys;
    private ArrayList<IndexKeyImpl> theSecKeys;
    private ArrayList<FieldRange> theRanges;
    private ArrayList<Expr> thePushedExternals;
    private ArrayList<Expr> theShardKeyExternals;
    private boolean[] theUsesCoveringIndex;
    private List<IndexHint> theIndexHints = null;
    private IndexHint theForceIndexHint = null;
    private boolean theEliminateIndexDups;
    private boolean theEliminateIndexDupsAtServer;
    private boolean theIsUpdate;
    private boolean theIsDelete;

    ExprBaseTable(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location) {
        super(qcb, sctx, Expr.ExprKind.BASE_TABLE, location);
    }

    void addTable(TableImpl table, String alias, boolean isAncestor, boolean isDescendant, QueryException.Location loc) {
        this.theTables.add(table);
        this.theAliases.add(alias);
        if (isAncestor) {
            if (!this.theTargetTable.isAncestor(table)) {
                throw new QueryException("Table " + table.getFullName() + " is not an ancestor of target table " + this.theTargetTable.getFullName(), loc);
            }
            ++this.theNumAncestors;
        } else if (isDescendant) {
            if (!table.isAncestor(this.theTargetTable)) {
                throw new QueryException("Table " + table.getFullName() + " is not a descendant of target table " + this.theTargetTable.getFullName(), loc);
            }
            ++this.theNumDescendants;
        } else {
            this.theTargetTable = table;
        }
    }

    void setSortedTables(ArrayList<TableImpl> sortedTables, ArrayList<String> sortedAliases) {
        this.theTables = sortedTables;
        this.theAliases = sortedAliases;
        this.computeType();
    }

    void finalizeTables() {
        int numTables = this.theTables.size();
        this.theUsesCoveringIndex = new boolean[numTables];
        this.theTablePreds = new Expr[numTables];
        for (int i = 0; i < numTables; ++i) {
            this.theUsesCoveringIndex[i] = false;
            this.theTablePreds[i] = null;
        }
        assert (this.theType == null);
        this.computeType();
    }

    int getNumTables() {
        return this.theTables.size();
    }

    int getNumAncestors() {
        return this.theNumAncestors;
    }

    int getNumDescendants() {
        return this.theNumDescendants;
    }

    boolean hasNestedTables() {
        return this.theNumAncestors > 0 || this.theNumDescendants > 0;
    }

    boolean isDescendant(int tablePos) {
        return tablePos > this.theNumAncestors + 1;
    }

    TableImpl getTargetTable() {
        return this.theTargetTable;
    }

    int getTargetTablePos() {
        return this.theNumAncestors;
    }

    ArrayList<TableImpl> getTables() {
        return this.theTables;
    }

    TableImpl getTable(int pos) {
        return this.theTables.get(pos);
    }

    int getTablePos(TableImpl table) {
        for (int i = 0; i < this.theTables.size(); ++i) {
            if (this.theTables.get(i).getId() != table.getId()) continue;
            return i;
        }
        return -1;
    }

    void setTablePred(int tablePos, Expr pred, boolean destroy) {
        if (this.theTablePreds[tablePos] != null) {
            this.theTablePreds[tablePos].removeParent(this, destroy);
        }
        this.theTablePreds[tablePos] = pred = ExprPromote.create(null, pred, TypeManager.BOOLEAN_QSTN());
        pred.addParent(this);
    }

    Expr getTablePred(int tablePos) {
        return this.theTablePreds[tablePos];
    }

    void removeTablePred(int tablePos, boolean destroy) {
        this.theTablePreds[tablePos].removeParent(this, destroy);
        this.theTablePreds[tablePos] = null;
    }

    ArrayList<String> getAliases() {
        return this.theAliases;
    }

    TableImpl getTableForAlias(String alias) {
        for (int i = 0; i < this.theTables.size(); ++i) {
            if (!this.theAliases.get(i).equals(alias)) continue;
            return this.theTables.get(i);
        }
        throw new QueryStateException("Could not find table for alias " + alias);
    }

    IndexImpl getIndex() {
        if (this.theSecKeys == null) {
            return null;
        }
        return (IndexImpl)this.theSecKeys.get(0).getIndex();
    }

    @Override
    int getNumChildren() {
        return this.theNumAncestors + this.theNumDescendants + 1;
    }

    Direction getDirection() {
        return this.theDirection;
    }

    void setDirection(Direction dir) {
        this.theDirection = dir;
    }

    ArrayList<PrimaryKeyImpl> getPrimaryKeys() {
        return this.thePrimKeys;
    }

    void addPrimaryKeys(int tablePos, ArrayList<PrimaryKeyImpl> keys, ArrayList<FieldRange> ranges, boolean isCoveringIndex) {
        if (tablePos == this.theNumAncestors) {
            this.thePrimKeys = keys;
            this.theRanges = ranges;
        }
        this.theUsesCoveringIndex[tablePos] = isCoveringIndex;
    }

    void removePrimaryKeys() {
        this.thePrimKeys = null;
    }

    ArrayList<IndexKeyImpl> getSecondaryKeys() {
        return this.theSecKeys;
    }

    void addSecondaryKeys(int tablePos, ArrayList<IndexKeyImpl> keys, ArrayList<FieldRange> ranges, boolean isCoveringIndex) {
        if (tablePos == this.theNumAncestors) {
            this.theSecKeys = keys;
            this.theRanges = ranges;
        }
        this.theUsesCoveringIndex[tablePos] = isCoveringIndex;
    }

    ArrayList<FieldRange> getRanges() {
        return this.theRanges;
    }

    boolean[] getUsesCoveringIndex() {
        return this.theUsesCoveringIndex;
    }

    void setPushedExternals(ArrayList<Expr> v) {
        assert (this.thePushedExternals == null);
        this.thePushedExternals = v;
    }

    ArrayList<Expr> getPushedExternals() {
        return this.thePushedExternals;
    }

    void addShardKey(ArrayList<PrimaryKeyImpl> keys) {
        assert (keys.size() == 1);
        this.thePrimKeys = keys;
    }

    void setShardKeyExternals(ArrayList<Expr> v) {
        assert (this.theShardKeyExternals == null);
        this.theShardKeyExternals = v;
    }

    ArrayList<Expr> getShardKeyExternals() {
        return this.theShardKeyExternals;
    }

    boolean isIndexHint(IndexImpl index) {
        if (this.theIndexHints == null) {
            return false;
        }
        for (IndexHint hint : this.theIndexHints) {
            if (hint.theIndex != index) continue;
            return true;
        }
        return false;
    }

    IndexHint getForceIndexHint() {
        return this.theForceIndexHint;
    }

    void addIndexHint(IndexImpl index, boolean force, QueryException.Location loc) {
        IndexHint hint;
        if (this.theIndexHints == null) {
            this.theIndexHints = new ArrayList<IndexHint>();
        }
        if (!ExprBaseTable.containsHint(this.theIndexHints, hint = new IndexHint(index, force))) {
            this.theIndexHints.add(hint);
        }
        if (force) {
            if (this.theForceIndexHint != null) {
                throw new QueryException("Cannot have more than one FORCE_INDEX hints", loc);
            }
            this.theForceIndexHint = hint;
        }
    }

    private static boolean containsHint(List<IndexHint> indexHints, IndexHint hint) {
        for (IndexHint h : indexHints) {
            if ((h.theIndex != null || hint.theIndex != null) && !h.theIndex.getName().equals(hint.theIndex.getName())) continue;
            return true;
        }
        return false;
    }

    void setEliminateIndexDups(boolean atServer) {
        this.theEliminateIndexDups = true;
        this.theEliminateIndexDupsAtServer = atServer;
    }

    boolean getEliminateIndexDups() {
        return this.theEliminateIndexDups;
    }

    boolean getEliminateIndexDupsAtServer() {
        return this.theEliminateIndexDupsAtServer;
    }

    void setIsUpdate() {
        this.theIsUpdate = true;
    }

    boolean getIsUpdate() {
        return this.theIsUpdate;
    }

    void setIsDelete() {
        this.theIsDelete = true;
    }

    boolean getIsDelete() {
        return this.theIsDelete;
    }

    @Override
    ExprType computeType() {
        if (this.theType != null) {
            return this.theType;
        }
        if (this.theTables.size() == 1) {
            this.theType = TypeManager.createTableRecordType(this.theTargetTable, ExprType.Quantifier.STAR);
            return this.theType;
        }
        FieldMap unionMap = new FieldMap();
        for (int i = 0; i < this.theTables.size(); ++i) {
            TableImpl table = this.theTables.get(i);
            RecordDefImpl rowDef = table.getRowDef();
            String fname = this.theAliases.get(i);
            unionMap.put(fname, rowDef, true, null);
        }
        RecordDefImpl unionDef = FieldDefFactory.createRecordDef(unionMap, "fromDef");
        this.theType = TypeManager.createType(unionDef, ExprType.Quantifier.STAR);
        return this.theType;
    }

    @Override
    public boolean mayReturnNULL() {
        return false;
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("TABLE");
        this.displayContent(sb, formatter);
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        int numRanges = this.theRanges != null ? this.theRanges.size() : 0;
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        formatter.indent(sb);
        sb.append(this.theTargetTable.getName());
        if (this.thePrimKeys != null) {
            if (this.theUsesCoveringIndex[this.theNumAncestors]) {
                sb.append(" via covering primary index");
            } else {
                sb.append(" via primary index");
            }
            for (i = 0; i < numRanges; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("KEY: ");
                sb.append(this.thePrimKeys.get(i));
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRanges.get(i));
            }
        }
        if (this.theSecKeys != null) {
            if (this.theUsesCoveringIndex[this.theNumAncestors]) {
                sb.append(" via covering index ");
            } else {
                sb.append(" via index ");
            }
            sb.append(this.theSecKeys.get(0).getIndex().getName());
            if (this.theEliminateIndexDups) {
                sb.append(" with duplicate elimination");
            }
            for (i = 0; i < numRanges; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("SEC KEY: ");
                sb.append(this.theSecKeys.get(i));
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRanges.get(i));
            }
        }
        if (this.theNumAncestors > 0) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("Ancestors :\n");
            for (i = 0; i < this.theNumAncestors; ++i) {
                formatter.indent(sb);
                sb.append(this.theTables.get(i).getFullName());
                if (this.theUsesCoveringIndex[i]) {
                    sb.append(" via covering primary index");
                } else {
                    sb.append(" via primary index");
                }
                sb.append("\n");
            }
        }
        if (this.theNumDescendants > 0) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("Descendants :\n");
            for (i = this.theNumAncestors + 1; i < this.theTables.size(); ++i) {
                formatter.indent(sb);
                sb.append(this.theTables.get(i).getFullName());
                if (this.theUsesCoveringIndex[i]) {
                    sb.append(" via covering primary index");
                } else {
                    sb.append(" via primary index");
                }
                sb.append("\n");
            }
        }
        if (this.thePushedExternals != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("PUSHED EXTERNAL EXPRS: ");
            for (Expr expr : this.thePushedExternals) {
                sb.append("\n");
                if (expr == null) {
                    formatter.indent(sb);
                    sb.append("null");
                    continue;
                }
                expr.display(sb, formatter);
            }
        }
        if (this.theTablePreds != null) {
            if (this.theTablePreds[this.theNumAncestors] != null) {
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("Filtering Predicate:\n");
                this.theTablePreds[this.theNumAncestors].display(sb, formatter);
            }
            for (int i2 = 0; i2 < this.theTables.size(); ++i2) {
                if (i2 == this.theNumAncestors || this.theTablePreds[i2] == null) continue;
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("ON Predicate for table ").append(this.theTables.get(i2).getFullName()).append(":\n");
                this.theTablePreds[i2].display(sb, formatter);
            }
        }
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    static class IndexHint {
        IndexImpl theIndex;
        boolean theForce;

        IndexHint(IndexImpl index, boolean force) {
            this.theIndex = index;
            this.theForce = force;
        }

        public String toString() {
            String name;
            String string = name = this.theIndex == null ? "primary" : this.theIndex.getName();
            if (this.theForce) {
                return "FORCE_INDEX(" + name + ")";
            }
            return "PREFER_INDEX(" + name + ")";
        }
    }
}

