/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class ExprDeleteRow
extends Expr {
    private TableImpl theTable;
    private Expr theInput;
    private boolean theHasReturningClause;
    private int[] thePrimKeyPositions;

    ExprDeleteRow(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, ExprSFW input, boolean hasReturningClause) {
        super(qcb, sctx, Expr.ExprKind.DELETE_ROW, location);
        this.theInput = input;
        input.addParent(this);
        this.theTable = input.getFirstFrom().getTargetTable();
        this.theHasReturningClause = hasReturningClause;
        if (this.theHasReturningClause) {
            this.theType = this.theInput.getType();
        } else {
            FieldMap fieldMap = new FieldMap();
            fieldMap.put("numRowsDeleted", FieldDefImpl.longDef, false, null);
            RecordDefImpl recDef = FieldDefFactory.createRecordDef(fieldMap, null);
            this.theType = TypeManager.createType(recDef, ExprType.Quantifier.ONE);
        }
    }

    TableImpl getTable() {
        return this.theTable;
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
        this.computeType(false);
    }

    boolean hasReturningClause() {
        return this.theHasReturningClause;
    }

    void addPrimKeyPositions(int[] positions) {
        this.thePrimKeyPositions = positions;
        this.theType = this.computeType();
    }

    int[] getPrimKeyPositions() {
        return this.thePrimKeyPositions;
    }

    @Override
    ExprType computeType() {
        return this.theType;
    }

    @Override
    boolean mayReturnNULL() {
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

