/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprIsOfType;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprRecConstr;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprSeqMap;
import oracle.kv.impl.query.compiler.ExprUpdateField;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldDef;

class ExprUtils {
    ExprUtils() {
    }

    static void adjustConstructorTypes(Expr expr) {
        switch (expr.getKind()) {
            case ARRAY_CONSTR: {
                ExprArrayConstr arrExpr = (ExprArrayConstr)expr;
                ArrayDefImpl arrDef = arrExpr.getArrayType();
                if (!arrDef.getElement().equals(FieldDefImpl.jsonDef)) break;
                int numArgs = arrExpr.getNumArgs();
                for (int i = 0; i < numArgs; ++i) {
                    ExprUtils.constructJsonArrayMap(arrExpr.getArg(i));
                }
                break;
            }
            case MAP_CONSTR: {
                ExprMapConstr mapExpr = (ExprMapConstr)expr;
                MapDefImpl mapDef = mapExpr.getMapType();
                if (!mapDef.getElement().equals(FieldDefImpl.jsonDef)) break;
                int numArgs = mapExpr.getNumArgs();
                for (int i = 1; i < numArgs; i += 2) {
                    ExprUtils.constructJsonArrayMap(mapExpr.getArg(i));
                }
                break;
            }
            case REC_CONSTR: {
                ExprRecConstr recExpr = (ExprRecConstr)expr;
                RecordDefImpl recDef = recExpr.getDef();
                int numArgs = recExpr.getNumArgs();
                for (int i = 0; i < numArgs; ++i) {
                    if (!recDef.getFieldDef(i).equals(FieldDefImpl.jsonDef)) continue;
                    ExprUtils.constructJsonArrayMap(recExpr.getArg(i));
                }
                break;
            }
            case UPDATE_FIELD: {
                ExprUpdateField upd = (ExprUpdateField)expr;
                Expr path = expr.getInput();
                if (!path.getType().getDef().equals(FieldDefImpl.jsonDef) || upd.getNewValueExpr() == null) break;
                ExprUtils.constructJsonArrayMap(upd.getNewValueExpr());
                break;
            }
            case SFW: {
                ExprSFW sfw = (ExprSFW)expr;
                int numFields = sfw.getNumFields();
                for (int i = 0; i < numFields; ++i) {
                    Expr fieldExpr = sfw.getFieldExpr(i);
                    FieldDefImpl fieldDef = fieldExpr.getType().getDef();
                    if (!fieldDef.equals(FieldDefImpl.jsonDef)) continue;
                    ExprUtils.constructJsonArrayMap(fieldExpr);
                }
                break;
            }
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            ExprUtils.adjustConstructorTypes(child);
        }
        children.reset();
    }

    private static void constructJsonArrayMap(Expr expr) {
        FieldDefImpl exprDef = expr.getType().getDef();
        if (exprDef.isAtomic() || exprDef.isRecord() || exprDef.isAnyRecord()) {
            return;
        }
        block0 : switch (expr.getKind()) {
            case ARRAY_CONSTR: {
                ExprArrayConstr arrExpr = (ExprArrayConstr)expr;
                ArrayDefImpl arrayDef = arrExpr.getArrayType();
                if (!arrayDef.getElement().isSubtype(FieldDefImpl.jsonDef)) break;
                arrExpr.setJsonArrayType();
                arrExpr.computeType(false);
                break;
            }
            case MAP_CONSTR: {
                ExprMapConstr mapExpr = (ExprMapConstr)expr;
                MapDefImpl mapDef = mapExpr.getMapType();
                if (!mapDef.getElement().isSubtype(FieldDefImpl.jsonDef)) break;
                mapExpr.setJsonMapType();
                mapExpr.computeType(false);
                break;
            }
            case REC_CONSTR: {
                ExprRecConstr recExpr = (ExprRecConstr)expr;
                int numArgs = recExpr.getNumArgs();
                for (int i = 0; i < numArgs; ++i) {
                    ExprUtils.constructJsonArrayMap(recExpr.getArg(i));
                }
                break;
            }
            case VAR: {
                ExprVar var = (ExprVar)expr;
                if (var.isFor()) {
                    ExprUtils.constructJsonArrayMap(var.getDomainExpr());
                }
                return;
            }
            case SFW: {
                ExprSFW sfw = (ExprSFW)expr;
                int numFieldExprs = sfw.getNumFields();
                for (int i = 0; i < numFieldExprs; ++i) {
                    ExprUtils.constructJsonArrayMap(sfw.getFieldExpr(i));
                }
                return;
            }
            case ARRAY_SLICE: 
            case ARRAY_FILTER: 
            case MAP_FILTER: 
            case FIELD_STEP: {
                expr = expr.getInput();
                break;
            }
            case FUNC_CALL: {
                ExprFuncCall funcExpr = (ExprFuncCall)expr;
                switch (funcExpr.getFunction().getCode()) {
                    case FN_SEQ_CONCAT: {
                        break block0;
                    }
                }
                return;
            }
            case SEQ_MAP: {
                ExprSeqMap seqMapExpr = (ExprSeqMap)expr;
                expr = seqMapExpr.getMapExpr();
                break;
            }
            case PROMOTE: 
            case RECEIVE: 
            case CASE: 
            case SORT: {
                break;
            }
            case CONST: {
                ExprConst constExpr = (ExprConst)expr;
                FieldValueImpl val = constExpr.getValue();
                FieldDefImpl valDef = val.getDefinition();
                FieldValueImpl newVal = null;
                QueryException.Location loc = expr.getLocation();
                if (valDef.isArray() && !valDef.equals(FieldDefImpl.arrayJsonDef)) {
                    newVal = CastIter.castValue(val, FieldDefImpl.arrayJsonDef, loc);
                } else if (valDef.isMap() && !valDef.equals(FieldDefImpl.mapJsonDef)) {
                    newVal = CastIter.castValue(val, FieldDefImpl.mapJsonDef, loc);
                }
                if (newVal != null) {
                    ExprConst newExpr = new ExprConst(expr.getQCB(), expr.getSctx(), loc, newVal);
                    expr.replace(newExpr, true);
                }
                return;
            }
            case CAST: 
            case IS_OF_TYPE: 
            case BASE_TABLE: {
                return;
            }
            default: {
                throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)expr.getKind()));
            }
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            ExprUtils.constructJsonArrayMap(child);
        }
        children.reset();
    }

    static void propagateTypeChange(Expr expr) {
        int numParents = expr.getNumParents();
        for (int i = 0; i < numParents; ++i) {
            Expr parent = expr.getParent(i);
            switch (parent.getKind()) {
                case SFW: {
                    ExprSFW sfw = (ExprSFW)parent;
                    ArrayList<ExprVar> vars = sfw.findVarsForExpr(expr);
                    if (vars == null) break;
                    for (ExprVar var : vars) {
                        var.computeType(false);
                    }
                    break;
                }
                case MAP_FILTER: {
                    ExprMapFilter mapFilter = (ExprMapFilter)parent;
                    ExprVar ctxVar = mapFilter.getCtxItemVar();
                    ExprVar elemVar = mapFilter.getCtxElemVar();
                    if (ctxVar != null) {
                        ctxVar.computeType(false);
                    }
                    if (elemVar == null) break;
                    elemVar.computeType(false);
                    break;
                }
                case ARRAY_FILTER: {
                    ExprArrayFilter arrFilter = (ExprArrayFilter)parent;
                    ExprVar ctxVar = arrFilter.getCtxItemVar();
                    ExprVar elemVar = arrFilter.getCtxElemVar();
                    if (ctxVar != null) {
                        ctxVar.computeType(false);
                    }
                    if (elemVar == null) break;
                    elemVar.computeType(false);
                    break;
                }
                case ARRAY_SLICE: {
                    ExprArraySlice arrSlice = (ExprArraySlice)parent;
                    ExprVar ctxVar = arrSlice.getCtxItemVar();
                    if (ctxVar == null) break;
                    ctxVar.computeType(false);
                    break;
                }
                case FIELD_STEP: {
                    ExprFieldStep fieldStep = (ExprFieldStep)parent;
                    ExprVar ctxVar = fieldStep.getCtxItemVar();
                    if (ctxVar == null) break;
                    ctxVar.computeType(false);
                    break;
                }
                case SEQ_MAP: {
                    ExprSeqMap seqmap = (ExprSeqMap)parent;
                    ExprVar ctxVar = seqmap.getCtxVar();
                    if (ctxVar == null) break;
                    ctxVar.computeType(false);
                    break;
                }
                case ARRAY_CONSTR: 
                case MAP_CONSTR: 
                case REC_CONSTR: 
                case UPDATE_FIELD: 
                case FUNC_CALL: 
                case PROMOTE: 
                case RECEIVE: 
                case CASE: 
                case SORT: 
                case CAST: 
                case IS_OF_TYPE: 
                case INSERT_ROW: 
                case DELETE_ROW: 
                case UPDATE_ROW: {
                    break;
                }
                case VAR: 
                case CONST: 
                case BASE_TABLE: {
                    throw new QueryStateException("A " + (Object)((Object)parent.getKind()) + " expression cannot be the parent of any expression");
                }
            }
            parent.computeType(false);
        }
    }

    static boolean matchExprs(Expr expr1, Expr expr2) {
        return ExprUtils.matchExprsInternal(expr1, expr2, ++Expr.theVisitCounter);
    }

    private static boolean matchExprsInternal(Expr expr1, Expr expr2, int vid) {
        expr1.theVisitId = vid;
        expr2.theVisitId = vid;
        if (expr1.getKind() != expr2.getKind()) {
            return false;
        }
        if (expr1.getNumChildren() != expr2.getNumChildren()) {
            return false;
        }
        switch (expr1.getKind()) {
            case CONST: {
                ExprConst e1 = (ExprConst)expr1;
                ExprConst e2 = (ExprConst)expr2;
                return e1.getValue().equals(e2.getValue());
            }
            case BASE_TABLE: {
                ExprBaseTable e1 = (ExprBaseTable)expr1;
                ExprBaseTable e2 = (ExprBaseTable)expr2;
                assert (e1 == e2);
                return true;
            }
            case VAR: {
                ExprVar e1 = (ExprVar)expr1;
                ExprVar e2 = (ExprVar)expr2;
                if (e1.getVarKind() != e2.getVarKind()) {
                    return false;
                }
                if (e1.getVarKind() == ExprVar.VarKind.EXTERNAL) {
                    return e1.getVarId() == e2.getVarId();
                }
                if (e1.isContext()) {
                    Expr ctxExpr1 = e1.getCtxExpr();
                    Expr ctxExpr2 = e2.getCtxExpr();
                    if (ctxExpr1.theVisitId == vid && ctxExpr2.theVisitId == vid) {
                        return e1.getName().equals(e2.getName());
                    }
                    return ExprUtils.matchExprsInternal(ctxExpr1, ctxExpr2, vid);
                }
                if (e1.getTable() != null && e2.getTable() != null) {
                    return e1.getTable().getId() == e2.getTable().getId();
                }
                return ExprUtils.matchExprsInternal(e1.getDomainExpr(), e2.getDomainExpr(), vid);
            }
            case FUNC_CALL: {
                ExprFuncCall e1 = (ExprFuncCall)expr1;
                ExprFuncCall e2 = (ExprFuncCall)expr2;
                if (e1.getFunction() != e2.getFunction()) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case PROMOTE: {
                ExprPromote e1 = (ExprPromote)expr1;
                ExprPromote e2 = (ExprPromote)expr2;
                return e1.getTargetType().equals(e2.getTargetType()) && ExprUtils.matchExprsInternal(e1.getInput(), e2.getInput(), vid);
            }
            case IS_OF_TYPE: {
                ExprIsOfType e1 = (ExprIsOfType)expr1;
                ExprIsOfType e2 = (ExprIsOfType)expr2;
                if (e1.isNot() != e2.isNot()) {
                    return false;
                }
                List<FieldDef> types1 = e1.getTargetTypes();
                List<FieldDef> types2 = e2.getTargetTypes();
                List<ExprType.Quantifier> quants1 = e1.getTargetQuantifiers();
                List<ExprType.Quantifier> quants2 = e2.getTargetQuantifiers();
                List<Boolean> onlyflags1 = e1.getOnlyTargetFlags();
                List<Boolean> onlyflags2 = e2.getOnlyTargetFlags();
                if (types1.size() != types2.size()) {
                    return false;
                }
                for (int i = 0; i < types1.size(); ++i) {
                    if (quants1.get(i) == quants2.get(i) && onlyflags1.get(i) == onlyflags2.get(i) && types1.get(i).equals(types2.get(i))) continue;
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case CAST: {
                ExprCast e1 = (ExprCast)expr1;
                ExprCast e2 = (ExprCast)expr2;
                if (e1.getTargetQuantifier() != e2.getTargetQuantifier() || !e1.getTargetType().equals(e2.getTargetType())) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case FIELD_STEP: {
                ExprFieldStep e1 = (ExprFieldStep)expr1;
                ExprFieldStep e2 = (ExprFieldStep)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst() && (e1.getFieldPos() >= 0 && e2.getFieldPos() >= 0 ? e1.getFieldPos() != e2.getFieldPos() : !e1.getFieldName().equals(e2.getFieldName()))) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case MAP_FILTER: {
                ExprMapFilter e1 = (ExprMapFilter)expr1;
                ExprMapFilter e2 = (ExprMapFilter)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst() && e1.getConstValue() != e2.getConstValue()) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case ARRAY_FILTER: {
                ExprArrayFilter e1 = (ExprArrayFilter)expr1;
                ExprArrayFilter e2 = (ExprArrayFilter)expr2;
                if (e1.isConst() != e2.isConst()) {
                    return false;
                }
                if (e1.isConst() && !e1.getConstValue().equals(e2.getConstValue())) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case ARRAY_SLICE: {
                ExprArraySlice e1 = (ExprArraySlice)expr1;
                ExprArraySlice e2 = (ExprArraySlice)expr2;
                if (e1.getLowValue() != null ? !e1.getLowValue().equals(e2.getLowValue()) : e2.getLowValue() != null) {
                    return false;
                }
                if (e1.getHighValue() != null ? !e1.getHighValue().equals(e2.getHighValue()) : e2.getHighValue() != null) {
                    return false;
                }
                return ExprUtils.matchChildren(e1, e2, vid);
            }
            case SEQ_MAP: {
                return ExprUtils.matchChildren(expr1, expr2, vid);
            }
            case CASE: {
                return ExprUtils.matchChildren(expr1, expr2, vid);
            }
            case ARRAY_CONSTR: {
                return ExprUtils.matchChildren(expr1, expr2, vid);
            }
            case MAP_CONSTR: {
                ExprMapConstr map1 = (ExprMapConstr)expr1;
                ExprMapConstr map2 = (ExprMapConstr)expr2;
                if (map1.theArgs.size() != map2.theArgs.size()) {
                    return false;
                }
                int numArgs = map1.theArgs.size();
                boolean[] matched = new boolean[numArgs];
                for (int i = 0; i < numArgs; ++i) {
                    int j;
                    for (j = 0; j < numArgs; ++j) {
                        if (i % 2 != j % 2 || matched[j] || !ExprUtils.matchExprsInternal(map1.theArgs.get(i), map2.theArgs.get(j), vid)) continue;
                        matched[j] = true;
                        break;
                    }
                    if (j != numArgs) continue;
                    return false;
                }
                return true;
            }
            case REC_CONSTR: {
                ExprRecConstr rec1 = (ExprRecConstr)expr1;
                ExprRecConstr rec2 = (ExprRecConstr)expr2;
                if (!rec1.getDef().equals(rec2.getDef())) {
                    return false;
                }
                return ExprUtils.matchChildren(expr1, expr2, vid);
            }
            case SFW: {
                return ExprUtils.matchChildren(expr1, expr2, vid);
            }
            case UPDATE_FIELD: 
            case RECEIVE: 
            case SORT: 
            case INSERT_ROW: 
            case DELETE_ROW: 
            case UPDATE_ROW: {
                throw new QueryStateException("Unexprected expression kind : " + (Object)((Object)expr1.getKind()));
            }
        }
        throw new QueryStateException("Should not be here!!");
    }

    private static boolean matchChildren(Expr expr1, Expr expr2, int vid) {
        Expr.ExprIter children1 = expr1.getChildren();
        Expr.ExprIter children2 = expr2.getChildren();
        while (children1.hasNext()) {
            Expr child2;
            assert (children2.hasNext());
            Expr child1 = children1.next();
            if (ExprUtils.matchExprsInternal(child1, child2 = children2.next(), vid)) continue;
            return false;
        }
        children1.reset();
        return true;
    }

    static boolean isPrimKeyColumnRef(TableImpl table, int pkCol, Expr expr) {
        if (expr.getKind() != Expr.ExprKind.FIELD_STEP) {
            return false;
        }
        ExprFieldStep stepExpr = (ExprFieldStep)expr;
        int fieldPos = stepExpr.getFieldPos();
        if (fieldPos < 0) {
            return false;
        }
        if (stepExpr.getInput().getKind() != Expr.ExprKind.VAR) {
            return false;
        }
        ExprVar var = (ExprVar)stepExpr.getInput();
        TableImpl table2 = var.getTable();
        IndexImpl index = var.getIndex();
        if (table2 == null || table2.getId() != table.getId()) {
            return false;
        }
        if (index == null) {
            int[] pkPositions = table.getPrimKeyPositions();
            return fieldPos == pkPositions[pkCol];
        }
        return fieldPos == (pkCol += index.numFields());
    }

    static List<FieldValueImpl> computeConstExpr(Expr expr) {
        QueryControlBlock qcb = expr.getQCB();
        KVStoreImpl store = qcb.getStore();
        TableAPIImpl tapi = (TableAPIImpl)store.getTableAPI();
        ExecuteOptions options = qcb.getOptions();
        CodeGenerator codegen = new CodeGenerator(qcb);
        codegen.generatePlan(expr);
        if (codegen.getException() != null) {
            throw codegen.getException();
        }
        PlanIter plan = codegen.getRootIter();
        RuntimeControlBlock rcb = new RuntimeControlBlock(tapi.getStore(), tapi.getStore().getLogger(), tapi.getTableMetadataHelper(), null, null, options, plan, codegen.getNumIterators(), codegen.getNumRegs(), null);
        int resReg = plan.getResultReg();
        ArrayList<FieldValueImpl> results = new ArrayList<FieldValueImpl>();
        plan.open(rcb);
        while (plan.next(rcb)) {
            FieldValueImpl res = rcb.getRegVal(resReg);
            if (res.isTuple()) {
                res = ((TupleValue)res).toRecord();
            }
            results.add(res);
        }
        plan.close(rcb);
        return results;
    }
}

