/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.AndOrIter;
import oracle.kv.impl.query.runtime.ConstIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;

class FuncAndOr
extends Function {
    FuncAndOr(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.BOOLEAN_QSTN(), TypeManager.BOOLEAN_ONE(), true);
    }

    @Override
    public boolean mayReturnNULL(ExprFuncCall caller) {
        for (Expr arg : caller.getArgs()) {
            if (!arg.mayReturnNULL()) continue;
            return true;
        }
        return false;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        if (argIters.length == 1) {
            return argIters[0];
        }
        int resultReg = codegen.allocateResultReg(caller);
        if (argIters.length == 0) {
            return new ConstIter(caller, resultReg, BooleanValueImpl.trueValue, false);
        }
        return new AndOrIter(caller, resultReg, this.theCode, argIters);
    }
}

