/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.ConcatIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class FuncConcat
extends Function {
    FuncConcat() {
        super(FunctionLib.FuncCode.FN_SEQ_CONCAT, "seq_concat", TypeManager.ANY_STAR(), TypeManager.ANY_STAR(), true);
    }

    @Override
    ExprType getRetType(ExprFuncCall caller) {
        int numArgs = caller.getNumArgs();
        if (numArgs == 0) {
            return TypeManager.EMPTY();
        }
        ExprType type = caller.getArg(0).getType();
        for (int i = 1; i < numArgs; ++i) {
            type = TypeManager.getConcatType(type, caller.getArg(i).getType());
        }
        return type;
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        int numArgs = caller.getNumArgs();
        if (numArgs == 0) {
            return true;
        }
        for (int i = 0; i < numArgs; ++i) {
            if (!caller.getArg(i).mayReturnNULL()) continue;
            return true;
        }
        return false;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        return new ConcatIter((Expr)caller, resultReg, argIters);
    }
}

