/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.ExistsIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class FuncExists
extends Function {
    FuncExists(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_STAR(), TypeManager.BOOLEAN_ONE());
    }

    @Override
    Expr normalizeCall(ExprFuncCall funcCall) {
        Expr arg = funcCall.getArg(0);
        ExprType.Quantifier q = arg.getType().getQuantifier();
        if (q == ExprType.Quantifier.ONE || q == ExprType.Quantifier.PLUS) {
            if (this.theCode == FunctionLib.FuncCode.OP_EXISTS) {
                return new ExprConst(funcCall.getQCB(), funcCall.getSctx(), funcCall.getLocation(), true);
            }
            return new ExprConst(funcCall.getQCB(), funcCall.getSctx(), funcCall.getLocation(), false);
        }
        return funcCall;
    }

    @Override
    public boolean mayReturnNULL(ExprFuncCall caller) {
        return caller.getArg(0).mayReturnNULL();
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        return new ExistsIter(caller, resultReg, this.theCode, argIters[0]);
    }
}

