/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.FuncGeoSearchIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class FuncGeoSearch
extends Function {
    FuncGeoSearch(FunctionLib.FuncCode code, String name, ArrayList<ExprType> geoTypes) {
        super(code, name, geoTypes, TypeManager.BOOLEAN_ONE(), true);
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall fncall) {
        return fncall.getArg(0).mayReturnNULL() || fncall.getArg(1).mayReturnNULL() || fncall.getNumArgs() > 2 && fncall.getArg(2).mayReturnNULL();
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        int numargs = fncall.getNumArgs();
        if (this.theCode == FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE || this.theCode == FunctionLib.FuncCode.FN_GEO_NEAR) {
            if (numargs != 3) {
                throw new QueryException("Could not find function with name " + this.theName + " and arity " + numargs, fncall.getLocation());
            }
            FuncGeoSearch.normalizeArg(fncall, 0);
            FuncGeoSearch.normalizeArg(fncall, 1);
            Expr radiusExpr = fncall.getArg(2);
            if (Expr.ConstKind.isCompileConst(radiusExpr) && radiusExpr.getKind() != Expr.ExprKind.CONST) {
                QueryControlBlock qcb = fncall.getQCB();
                StaticContext sctx = fncall.getSctx();
                QueryException.Location loc = radiusExpr.getLocation();
                List<FieldValueImpl> res = ExprUtils.computeConstExpr(radiusExpr);
                if (res.size() == 0) {
                    throw new QueryException("The distance operand of the geo_within_distancefunction is an empty sequence.", loc);
                }
                if (res.size() > 1) {
                    throw new QueryException("The distance operand of the geo_within_distance function is a sequence with more than one items.", loc);
                }
                radiusExpr = new ExprConst(qcb, sctx, loc, res.get(0));
                fncall.setArg(2, radiusExpr, true);
            }
        } else {
            if (numargs != 2) {
                throw new QueryException("Could not find function with name " + this.theName + " and arity " + numargs, fncall.getLocation());
            }
            FuncGeoSearch.normalizeArg(fncall, 0);
            FuncGeoSearch.normalizeArg(fncall, 1);
        }
        return fncall;
    }

    static void normalizeArg(ExprFuncCall fncall, int i) {
        Function func = fncall.getFunction();
        FunctionLib.FuncCode funcCode = func.getCode();
        String funcName = func.getName();
        String lr = i == 0 ? "left" : "right";
        Expr arg = fncall.getArg(i);
        FieldDefImpl argDef = arg.getType().getDef();
        if (!argDef.mayBeJsonObject()) {
            throw new QueryException("The " + lr + " operand of the " + funcName + " function is not a json object. arg type = " + argDef.getDDLString(), arg.getLocation());
        }
        if (Expr.ConstKind.isCompileConst(arg)) {
            FieldValueImpl argVal = null;
            if (arg.getKind() == Expr.ExprKind.CONST) {
                argVal = ((ExprConst)arg).getValue();
            } else {
                List<FieldValueImpl> res = ExprUtils.computeConstExpr(arg);
                if (res.size() == 0) {
                    throw new QueryException("The " + lr + " operand of the " + funcName + " function is an empty sequence.", arg.getLocation());
                }
                if (res.size() > 1) {
                    throw new QueryException("The " + lr + " operand of the " + funcName + " function is a sequence with more than one items.", arg.getLocation());
                }
                argVal = res.get(0);
            }
            Geometry geom = CompilerAPI.getGeoUtils().castAsGeometry(argVal);
            if (geom == null) {
                throw new QueryException("The " + lr + " operand of the " + funcName + " function is not a valid geometry.", arg.getLocation());
            }
            if (funcCode == FunctionLib.FuncCode.FN_GEO_INSIDE && i == 1 && !geom.isPolygon()) {
                throw new QueryException("The second argument to the geo_inside function is not a polygon.", fncall.getLocation());
            }
            if (arg.getKind() != Expr.ExprKind.CONST) {
                QueryControlBlock qcb = fncall.getQCB();
                StaticContext sctx = fncall.getSctx();
                arg = new ExprConst(qcb, sctx, arg.getLocation(), argVal);
                fncall.setArg(i, arg, true);
            }
        }
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall fncall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(fncall);
        return new FuncGeoSearchIter(fncall, this.theCode, resultReg, argIters);
    }
}

