/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.FuncRegexLikeIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class FuncRegexLike
extends Function {
    public static String FLAGS = "dixlsucU";
    public static Map<String, String> validRegexAlpha = new HashMap<String, String>();
    public static Map<String, String> invalidRegexOps;

    public static FuncRegexLike getFuncRegexLike() {
        ArrayList<ExprType> regexLikeTypes = new ArrayList<ExprType>(3);
        regexLikeTypes.add(TypeManager.ANY_STAR());
        regexLikeTypes.add(TypeManager.STRING_ONE());
        regexLikeTypes.add(TypeManager.STRING_ONE());
        return new FuncRegexLike(regexLikeTypes);
    }

    private FuncRegexLike(ArrayList<ExprType> regexLikeTypes) {
        super(FunctionLib.FuncCode.FN_REGEX_LIKE, "regex_like", regexLikeTypes, TypeManager.BOOLEAN_ONE(), true);
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall fncall) {
        return true;
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        ExprConst ec;
        boolean isFlagsConst = true;
        String origFlagsString = null;
        int numargs = fncall.getNumArgs();
        if (numargs < 2 || numargs > 3) {
            throw new QueryException("The number of parameters specified for the regex_like function is invalid.");
        }
        FieldDefImpl fd = fncall.getArg(0).getType().getDef();
        if (!(fd.isString() || fd.isAny() || fd.isJson() || fd.isAnyJsonAtomic() || fd.isAnyAtomic())) {
            throw new QueryException("The data type of the source parameter specified for the regex_like function is invalid. The parameter may be either string or json type.");
        }
        boolean isPatternConst = Expr.ConstKind.isCompileConst(fncall.getArg(1));
        int flags = 0;
        if (numargs == 3 && (isFlagsConst = Expr.ConstKind.isCompileConst(fncall.getArg(2)))) {
            ec = (ExprConst)fncall.getArg(2);
            FieldValueImpl fv = ec.getValue();
            origFlagsString = fv.asString().get();
            flags = FuncRegexLike.convertFlags(origFlagsString);
        }
        if (isPatternConst && isFlagsConst) {
            ec = (ExprConst)fncall.getArg(1);
            String pattern = ec.getValue().asString().get();
            FuncRegexLike.verifyPattern(pattern);
            try {
                if (flags == 0) {
                    Pattern.compile(pattern);
                } else {
                    Pattern.compile(pattern, flags);
                }
            }
            catch (PatternSyntaxException e) {
                throw new QueryException("The pattern [" + pattern + "] specified for the regex_like function is invalid.");
            }
            catch (IllegalArgumentException e) {
                throw new QueryException("The flags parameter [" + origFlagsString + "]  specified for the regex_like function is invalid. Valid flag parameter values are [" + FLAGS + "].");
            }
        }
        return fncall;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall fncall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(fncall);
        return new FuncRegexLikeIter((Expr)fncall, resultReg, argIters);
    }

    public static int convertFlags(String sf) {
        int flags = 0;
        if (sf == null) {
            return flags;
        }
        block10: for (int i = 0; i < sf.length(); ++i) {
            switch (sf.charAt(i)) {
                case 'd': {
                    flags |= 1;
                    continue block10;
                }
                case 'i': {
                    flags |= 2;
                    continue block10;
                }
                case 'x': {
                    flags |= 4;
                    continue block10;
                }
                case 'l': {
                    flags |= 0x10;
                    continue block10;
                }
                case 's': {
                    flags |= 0x20;
                    continue block10;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block10;
                }
                case 'c': {
                    flags |= 0x80;
                    continue block10;
                }
                case 'U': {
                    flags |= 0x100;
                    continue block10;
                }
                default: {
                    if (Character.isWhitespace(sf.charAt(i))) continue block10;
                    throw new IllegalArgumentException("The flags parameter [" + sf.charAt(i) + "] specified for the regex_like function is invalid. Valid flag parameter values are [" + FLAGS + "].");
                }
            }
        }
        return flags;
    }

    public static void verifyPattern(String pattern) {
        int MAX_PATTERN_SIZE = 512;
        if (pattern.length() > 512) {
            throw new IllegalArgumentException("The regex_like pattern parameter [" + pattern + "] exceeds the maximum length of " + 512 + " characters.");
        }
        boolean escState = false;
        for (int pos = 0; pos < pattern.length(); ++pos) {
            if (pattern.charAt(pos) == '\\') {
                if (escState) {
                    escState = false;
                    continue;
                }
                escState = true;
                continue;
            }
            if (escState) {
                if (Character.isLetter(pattern.charAt(pos))) {
                    if (validRegexAlpha.get(String.valueOf(pattern.charAt(pos))) == null) {
                        throw new IllegalArgumentException("The pattern parameter [" + pattern + "] contains an unsupported regular expression.");
                    }
                    if (pattern.charAt(pos) == 'x') {
                        if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '{') {
                            ++pos;
                            while (pos < pattern.length() && pattern.charAt(pos) != '}') {
                                ++pos;
                            }
                        }
                    } else if (pattern.charAt(pos) == 'Q') {
                        ++pos;
                        while (pos + 1 < pattern.length()) {
                            if (pattern.charAt(pos) == '\\' && pattern.charAt(pos + 1) == 'E') {
                                ++pos;
                                break;
                            }
                            ++pos;
                        }
                    }
                }
                escState = false;
                continue;
            }
            if (invalidRegexOps.get(String.valueOf(pattern.charAt(pos))) == null) continue;
            throw new IllegalArgumentException("The pattern parameter [" + pattern + "] contains an unsupported regular expression.");
        }
    }

    static {
        validRegexAlpha.put("Q", "Q");
        validRegexAlpha.put("E", "E");
        validRegexAlpha.put("t", "t");
        validRegexAlpha.put("n", "n");
        validRegexAlpha.put("r", "r");
        validRegexAlpha.put("f", "f");
        validRegexAlpha.put("a", "a");
        validRegexAlpha.put("e", "e");
        validRegexAlpha.put("c", "c");
        validRegexAlpha.put("x", "x");
        validRegexAlpha.put("u", "u");
        invalidRegexOps = new HashMap<String, String>();
        invalidRegexOps.put("^", "^");
        invalidRegexOps.put("$", "$");
        invalidRegexOps.put("[", "[");
        invalidRegexOps.put("]", "]");
        invalidRegexOps.put("{", "{");
        invalidRegexOps.put("}", "}");
        invalidRegexOps.put("+", "+");
        invalidRegexOps.put("?", "?");
        invalidRegexOps.put("|", "|");
        invalidRegexOps.put("(", "(");
        invalidRegexOps.put(")", ")");
    }
}

