/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.FuncRemainingHoursIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.TypeManager;

public class FuncRemainingHours
extends Function {
    FuncRemainingHours() {
        super(FunctionLib.FuncCode.FN_REMAINING_HOURS, "remaining_hours", TypeManager.ANY_RECORD_ONE(), TypeManager.INT_ONE());
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        return true;
    }

    @Override
    Expr normalizeCall(ExprFuncCall funcCall) {
        Expr arg = funcCall.getArg(0);
        if (arg.getKind() == Expr.ExprKind.VAR && ((ExprVar)arg).getTable() != null) {
            return funcCall;
        }
        throw new QueryException("The argument to the remaining_hours function must be a row variable", funcCall.getLocation());
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(caller);
        Expr arg = caller.getArg(0);
        if (arg.getKind() != Expr.ExprKind.VAR || ((ExprVar)arg).getTable() == null) {
            throw new QueryException("The argument to the remaining_hours function must be a row variable", caller.getLocation());
        }
        return new FuncRemainingHoursIter((Expr)caller, resultReg, argIters[0]);
    }
}

