/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprRecConstr;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.impl.util.Pair;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;

class IndexAnalyzer
implements Comparable<IndexAnalyzer> {
    static int theTrace = 0;
    static final int eqValue = 32;
    static final int vrangeValue = 16;
    static final int arangeValue = 8;
    static final int filterEqValue = 17;
    static final int filterOtherValue = 7;
    private final QueryControlBlock theQCB;
    private final StaticContext theSctx;
    ExprSFW theSFW;
    private final ExprBaseTable theTableExpr;
    private final TableImpl theTable;
    private final int theTablePos;
    private final int theTargetTablePos;
    private final IndexImpl theIndex;
    private final boolean theIsHintIndex;
    private final boolean theIsPrimary;
    private final boolean theIsMapBothIndex;
    private final int theNumFields;
    final List<IndexImpl.IndexField> theIndexPaths;
    private final ArrayList<WherePredInfo> theWherePreds;
    private final ArrayList<PredGroup> thePredGroups;
    private PredGroup theUnnestedGroup;
    private final ArrayList<ArrayList<PredInfo>> theStartStopPreds;
    private PredGroup theBestPredGroup;
    private boolean theHaveMapKeyEqPred;
    private final ArrayList<PredInfo> theFilteringPreds;
    private final HashMap<Expr, ArrayList<ExprToReplace>> theExprRewriteMap;
    private ArrayList<PrimaryKeyImpl> thePrimaryKeys;
    private ArrayList<IndexKeyImpl> theSecondaryKeys;
    private ArrayList<FieldRange> theRanges;
    private final ArrayList<Expr> thePushedExternals;
    private boolean theHavePushedExternals;
    private boolean theIsMultiKeyRange;
    private boolean theIsCovering;
    private boolean theEliminateDups;
    private boolean theEliminateDupsAtServer;
    private int theScore = -1;
    private int theScore2 = -1;
    private int theNumEqPredsPushed = 0;
    private boolean theIsRejected;

    IndexAnalyzer(ExprSFW sfw, ExprBaseTable tableExpr, int tablePos, IndexImpl index) {
        int i;
        this.theQCB = sfw.getQCB();
        this.theSctx = sfw.getSctx();
        this.theSFW = sfw;
        this.theTableExpr = tableExpr;
        this.theTablePos = tablePos;
        this.theTable = tableExpr.getTable(tablePos);
        this.theTargetTablePos = tableExpr.getTargetTablePos();
        this.theIndex = index;
        this.theIsPrimary = this.theIndex == null;
        int pkStartPos = 0;
        int pkSize = this.theTable.getPrimaryKeySize();
        if (!this.theIsPrimary) {
            this.theNumFields = this.theIndex.numFields() + pkSize;
            pkStartPos = this.theIndex.numFields();
            this.theIndexPaths = new ArrayList<IndexImpl.IndexField>(this.theNumFields);
            this.theIndexPaths.addAll(this.theIndex.getIndexFields());
        } else {
            this.theNumFields = pkSize;
            this.theIndexPaths = new ArrayList<IndexImpl.IndexField>(this.theNumFields);
        }
        List<String> pkColumnNames = this.theTable.getPrimaryKeyInternal();
        for (i = 0; i < pkSize; ++i) {
            String name = pkColumnNames.get(i);
            IndexImpl.IndexField ipath = new IndexImpl.IndexField(this.theTable, name, null, i + pkStartPos);
            ipath.setType(this.theTable.getPrimKeyColumnDef(i));
            ipath.setNullable(false);
            this.theIndexPaths.add(ipath);
        }
        this.theIsHintIndex = this.theTableExpr.isIndexHint(this.theIndex);
        this.theWherePreds = new ArrayList(32);
        this.thePredGroups = new ArrayList(32);
        this.theStartStopPreds = new ArrayList(this.theNumFields);
        this.theFilteringPreds = new ArrayList();
        this.theExprRewriteMap = new HashMap();
        for (i = 0; i < this.theNumFields; ++i) {
            this.theStartStopPreds.add(null);
        }
        if (this.theIsPrimary) {
            this.thePrimaryKeys = new ArrayList(1);
            this.thePrimaryKeys.add(this.theTable.createPrimaryKey());
            this.theIsMapBothIndex = false;
        } else {
            this.theSecondaryKeys = new ArrayList(1);
            this.theSecondaryKeys.add(this.theIndex.createIndexKey());
            this.theIsMapBothIndex = this.theIndex.isMapBothIndex();
        }
        this.theRanges = new ArrayList(1);
        this.theRanges.add(null);
        this.thePushedExternals = new ArrayList();
    }

    boolean isPrimary() {
        return this.theIsPrimary;
    }

    boolean isRejected() {
        return this.theIsRejected;
    }

    private String getIndexName() {
        return this.theIsPrimary ? "primary" : this.theIndex.getName();
    }

    ArrayList<PrimaryKeyImpl> getPrimaryKeys() {
        return this.thePrimaryKeys;
    }

    boolean hasShardKey() {
        return this.theIsPrimary && this.thePrimaryKeys.size() == 1 && this.thePrimaryKeys.get(0).hasShardKey();
    }

    private PredGroup addPredGroup(PredInfo pi) {
        PredGroup pg = new PredGroup(this.thePredGroups.size(), pi);
        this.thePredGroups.add(pg);
        return pg;
    }

    private void addStartStopPred(PredInfo pi) {
        int ipos = pi.theIPathPos;
        ArrayList<PredInfo> startstopPIs = this.theStartStopPreds.get(ipos);
        if (startstopPIs == null) {
            startstopPIs = new ArrayList();
            this.theStartStopPreds.set(ipos, startstopPIs);
        }
        if (theTrace >= 1) {
            System.out.println("Added startstop pred at pos " + ipos + " pred = \n" + pi);
        }
        startstopPIs.add(pi);
    }

    private void removePred(Expr pred) {
        if (pred == null) {
            return;
        }
        int numParents = pred.getNumParents();
        if (numParents == 0) {
            return;
        }
        Expr parent = pred.getParent(0);
        if (numParents > 1 && (numParents != 2 || pred.getParent(1).getKind() != Expr.ExprKind.BASE_TABLE && pred.getParent(1).getFunction(FunctionLib.FuncCode.OP_AND) == null)) {
            throw new QueryStateException("Trying to remove a pred with more than one parents. pred:\n" + pred.display() + "\nnum parents = " + numParents + " 2nd parent:\n" + pred.getParent(1).display());
        }
        Expr whereExpr = this.theSFW.getWhereExpr();
        if (pred == whereExpr) {
            this.theSFW.removeWhereExpr(true);
        } else {
            parent.removeChild(pred, true);
            if (parent == whereExpr && whereExpr.getNumChildren() == 0) {
                this.theSFW.removeWhereExpr(true);
            }
        }
    }

    private void processAlwaysFalse() {
        Function empty = Function.getFunction(FunctionLib.FuncCode.FN_SEQ_CONCAT);
        Expr emptyExpr = ExprFuncCall.create(this.theQCB, this.theSctx, this.theSFW.getLocation(), empty, new ArrayList<Expr>());
        if (this.theQCB.getRootExpr() == this.theSFW) {
            this.theQCB.setRootExpr(emptyExpr);
        } else {
            this.theSFW.replace(emptyExpr, true);
        }
        this.theSFW = null;
    }

    @Override
    public int compareTo(IndexAnalyzer other) {
        int numFields1 = this.theNumFields;
        int numFields2 = other.theNumFields;
        boolean multiKey1 = this.theIsPrimary ? false : this.theIndex.isMultiKey();
        boolean multiKey2 = other.theIsPrimary ? false : other.theIndex.isMultiKey();
        this.getScore();
        other.getScore();
        if (theTrace >= 2) {
            System.out.println("Comparing indexes " + this.getIndexName() + " and " + other.getIndexName() + "\nscore1 = " + this.theScore + " score2 = " + other.theScore);
        }
        if (this.theIsCovering != other.theIsCovering) {
            if (this.theIsCovering) {
                if (!this.theIsHintIndex && other.theIsHintIndex) {
                    FieldRange range = this.theRanges.get(0);
                    return this.theNumEqPredsPushed > 0 || range != null && range.getStart() != null && range.getEnd() != null ? -1 : 1;
                }
                if (other.theScore != Integer.MAX_VALUE) {
                    return -1;
                }
                return this.theScore >= other.theScore2 ? -1 : 1;
            }
            if (other.theIsCovering) {
                if (!other.theIsHintIndex && this.theIsHintIndex) {
                    FieldRange range = this.theRanges.get(0);
                    return other.theNumEqPredsPushed > 0 || range != null && range.getStart() != null && range.getEnd() != null ? 1 : -1;
                }
                if (this.theScore != Integer.MAX_VALUE) {
                    return 1;
                }
                return other.theScore >= this.theScore2 ? 1 : -1;
            }
        }
        if (this.theScore == other.theScore) {
            if (this.theScore == 0) {
                if (this.theIsPrimary || other.theIsPrimary) {
                    return this.theIsPrimary ? -1 : 1;
                }
                if (multiKey1 != multiKey2) {
                    return multiKey1 ? 1 : -1;
                }
            }
            if (this.theIsHintIndex != other.theIsHintIndex) {
                return this.theIsHintIndex ? -1 : 1;
            }
            if (multiKey1 != multiKey2) {
                return multiKey1 ? 1 : -1;
            }
            if (this.theIsPrimary || other.theIsPrimary) {
                return this.theIsPrimary ? -1 : 1;
            }
            if (numFields1 != numFields2) {
                return numFields1 < numFields2 ? -1 : 1;
            }
            return 0;
        }
        if (this.theScore == Integer.MAX_VALUE || other.theScore == Integer.MAX_VALUE) {
            return this.theScore == Integer.MAX_VALUE ? -1 : 1;
        }
        if (this.theIsHintIndex != other.theIsHintIndex) {
            return this.theIsHintIndex ? -1 : 1;
        }
        return this.theScore > other.theScore ? -1 : 1;
    }

    private int getScore() {
        int numFields;
        if (this.theScore >= 0) {
            return this.theScore;
        }
        this.theScore = 0;
        this.theScore2 = 0;
        this.theScore += this.theNumEqPredsPushed * 32;
        FieldRange range = this.theRanges.get(0);
        if (range != null) {
            if (range.getStart() != null) {
                this.theScore += this.theIsMultiKeyRange ? 8 : 16;
            }
            if (range.getEnd() != null) {
                this.theScore += this.theIsMultiKeyRange ? 8 : 16;
            }
        }
        for (PredInfo pi : this.theFilteringPreds) {
            if (pi.isEq()) {
                this.theScore += 17;
                continue;
            }
            this.theScore += 7;
        }
        this.theScore2 = this.theScore;
        if (theTrace >= 2) {
            System.out.println("Score for index " + this.getIndexName() + " = " + this.theScore + "\ntheNumEqPredsPushed = " + this.theNumEqPredsPushed);
        }
        int numPrimKeyCols = this.theTable.getPrimaryKeySize();
        int n = numFields = this.theIsPrimary ? numPrimKeyCols : this.theNumFields - numPrimKeyCols;
        if (this.theNumEqPredsPushed == numFields) {
            this.theScore = Integer.MAX_VALUE;
            return this.theScore;
        }
        return this.theScore;
    }

    void apply(IndexAnalyzer primaryAnalyzer) {
        Expr pred;
        int numFroms = this.theSFW.getNumFroms();
        int[] varRefsCounts = new int[numFroms];
        for (int i = 0; i < numFroms; ++i) {
            ExprSFW.FromClause fc = this.theSFW.getFromClause(i);
            varRefsCounts[i] = fc.getTargetTable() != null ? 0 : fc.getVar().getNumParents();
        }
        if (this.theIsPrimary) {
            assert (this.theRanges.size() == this.thePrimaryKeys.size());
            this.theTableExpr.addPrimaryKeys(this.theTablePos, this.thePrimaryKeys, this.theRanges, this.theIsCovering);
            this.theQCB.setPushedPrimaryKey(this.thePrimaryKeys.get(0));
        } else if (this.theIndex.isGeoIndex()) {
            IndexKeyImpl ikey = this.theSecondaryKeys.get(0);
            int geoFieldPos = this.theIndex.getGeoFieldPos();
            ArrayList<PredInfo> geoPreds = this.theStartStopPreds.get(geoFieldPos);
            if (geoPreds != null && !geoPreds.isEmpty()) {
                assert (this.theSecondaryKeys.size() == 1);
                assert (geoPreds.size() == 1);
                PredInfo geopi = geoPreds.get(0);
                if (geopi.theGeom != null && (!geopi.isNear() || geopi.theDistance > 0.0)) {
                    List<Pair<String, String>> georanges = CompilerAPI.getGeoUtils().ranges(geopi.theGeom, geopi.theDistance, this.theQCB.getOptions());
                    List<String> geokeys = null;
                    if (this.theIndex.isGeometryIndex()) {
                        geokeys = CompilerAPI.getGeoUtils().keys(georanges);
                    }
                    this.theRanges.clear();
                    String pathName = this.theIndex.getFieldName(geoFieldPos);
                    StringDefImpl rangeDef = FieldDefImpl.stringDef;
                    for (int i = 0; i < georanges.size(); ++i) {
                        Pair<String, String> range = georanges.get(i);
                        FieldRange frange = new FieldRange(pathName, rangeDef, 0);
                        String start = range.first();
                        String end = range.second();
                        frange.setStart(start, true);
                        frange.setEnd(end, true);
                        this.theRanges.add(frange);
                        if (i <= 0) continue;
                        this.theSecondaryKeys.add(ikey);
                    }
                    if (geokeys != null && !geokeys.isEmpty()) {
                        for (String key : geokeys) {
                            ikey = ikey.clone();
                            ikey.put(geoFieldPos, key);
                            this.theSecondaryKeys.add(ikey);
                            this.theRanges.add(null);
                        }
                    }
                    this.thePushedExternals.add(null);
                    this.thePushedExternals.add(null);
                } else if (geopi.isNear()) {
                    this.thePushedExternals.add(geopi.theConstArg);
                    this.thePushedExternals.add(geopi.theDistanceArg);
                    this.theHavePushedExternals = true;
                } else {
                    this.thePushedExternals.add(geopi.theConstArg);
                    this.thePushedExternals.add(null);
                    this.theHavePushedExternals = true;
                }
            } else assert (this.theRanges.size() == this.theSecondaryKeys.size());
            this.theTableExpr.addSecondaryKeys(this.theTablePos, this.theSecondaryKeys, this.theRanges, this.theIsCovering);
        } else {
            assert (this.theRanges.size() == this.theSecondaryKeys.size());
            this.theTableExpr.addSecondaryKeys(this.theTablePos, this.theSecondaryKeys, this.theRanges, this.theIsCovering);
            if (primaryAnalyzer.hasShardKey()) {
                this.theTableExpr.addShardKey(primaryAnalyzer.thePrimaryKeys);
                if (primaryAnalyzer.theHavePushedExternals) {
                    int shardKeySize = this.theTable.getShardKeySize();
                    ArrayList<Expr> sharKeyExternals = new ArrayList<Expr>(shardKeySize);
                    for (int i = 0; i < shardKeySize; ++i) {
                        sharKeyExternals.add(primaryAnalyzer.thePushedExternals.get(i));
                    }
                    this.theTableExpr.setShardKeyExternals(sharKeyExternals);
                }
            }
        }
        if (this.theHavePushedExternals) {
            this.theTableExpr.setPushedExternals(this.thePushedExternals);
        }
        ExprVar idxVar = null;
        if (this.theIndex != null && (!this.theFilteringPreds.isEmpty() || this.theIsCovering)) {
            idxVar = this.theSFW.addIndexVar(this.theTable, this.theIndex);
        }
        int numFilteringPreds = this.theFilteringPreds.size();
        ArrayList<Expr> args = new ArrayList<Expr>(numFilteringPreds);
        for (PredInfo pi : this.theFilteringPreds) {
            pred = pi.thePred;
            if (this.theIndex != null) {
                pred = this.rewritePred(idxVar, pi);
            }
            args.add(pred);
        }
        if (args.size() > 1) {
            Iterator<WherePredInfo> fnlib = CompilerAPI.getFuncLib();
            Function andFunc = ((FunctionLib)((Object)fnlib)).getFunc(FunctionLib.FuncCode.OP_AND);
            pred = ExprFuncCall.create(this.theQCB, this.theSctx, this.theTableExpr.getLocation(), andFunc, args);
            this.theTableExpr.setTablePred(this.theTablePos, pred, false);
        } else if (args.size() == 1) {
            this.theTableExpr.setTablePred(this.theTablePos, (Expr)args.get(0), false);
        }
        if (this.theSFW.getNumFroms() > 1) {
            this.theEliminateDupsAtServer = true;
        }
        if (this.theEliminateDups) {
            this.theTableExpr.setEliminateIndexDups(this.theEliminateDupsAtServer);
        }
        for (WherePredInfo wpi : this.theWherePreds) {
            if (wpi.isFullyPushable()) {
                this.removePred(wpi.thePred);
                continue;
            }
            ArrayList<PredInfo> predinfos = wpi.thePredInfos;
            block11: for (PredInfo pi : predinfos) {
                switch (pi.theStatus) {
                    case STARTSTOP: 
                    case FILTERING: {
                        if (!pi.canBeRemoved()) continue block11;
                        this.removePred(pi.thePred);
                        continue block11;
                    }
                    case TRUE: {
                        this.removePred(pi.thePred);
                        continue block11;
                    }
                    case NOT_STARTSTOP: 
                    case SKIP: {
                        continue block11;
                    }
                }
                throw new QueryStateException("Unexpected state for predicate:\n" + pi);
            }
        }
        if (this.theIndex != null && this.theIsCovering) {
            if (this.theTableExpr.hasNestedTables()) {
                for (WherePredInfo wpi : this.theWherePreds) {
                    if (wpi.isFullyPushable()) continue;
                    this.rewriteExpr(idxVar, wpi.thePred);
                }
            }
            int numFields = this.theSFW.getNumFields();
            for (int i = 0; i < numFields; ++i) {
                Expr expr = this.theSFW.getFieldExpr(i);
                if (expr.getKind() == Expr.ExprKind.VAR && ((ExprVar)expr).getTable() != null && ((ExprVar)expr).getTable().getId() == this.theTable.getId()) {
                    int j;
                    RecordDefImpl rowDef = this.theTable.getRowDef();
                    int numCols = rowDef.getNumFields();
                    ArrayList<Expr> newFieldExprs = new ArrayList<Expr>(numCols);
                    for (j = 0; j < numCols; ++j) {
                        IndexImpl.IndexField ipath;
                        int k;
                        String colName = rowDef.getFieldName(j);
                        for (k = 0; !(k >= this.theNumFields || (ipath = this.theIndexPaths.get(k)).numSteps() == 1 && ipath.getStep(0).equalsIgnoreCase(colName)); ++k) {
                        }
                        if (k == this.theNumFields) {
                            throw new QueryStateException("Column " + colName + " is not indexed by index " + this.theIndex.getName());
                        }
                        newFieldExprs.add(new ExprFieldStep(expr.getQCB(), expr.getSctx(), expr.getLocation(), (Expr)idxVar, k));
                    }
                    if (numFields == 1) {
                        for (j = 0; j < numCols; ++j) {
                            this.theSFW.addField(rowDef.getFieldName(j), newFieldExprs.get(j));
                        }
                        this.theSFW.removeField(i, true);
                        continue;
                    }
                    ExprRecConstr newFieldExpr = new ExprRecConstr(expr.getQCB(), expr.getSctx(), expr.getLocation(), rowDef, newFieldExprs);
                    this.theSFW.setFieldExpr(i, newFieldExpr, true);
                    continue;
                }
                this.rewriteExpr(idxVar, expr);
            }
            int numSortExprs = this.theSFW.getNumSortExprs();
            for (int i = 0; i < numSortExprs; ++i) {
                Expr expr = this.theSFW.getSortExpr(i);
                this.rewriteExpr(idxVar, expr);
            }
            int numTables = this.theTableExpr.getNumTables();
            for (int i = 0; i < numTables; ++i) {
                Expr pred2;
                if (i == this.theTargetTablePos || (pred2 = this.theTableExpr.getTablePred(i)) == null) continue;
                this.rewriteExpr(idxVar, pred2);
            }
        }
        for (int i = numFroms - 1; i >= 0; --i) {
            ExprVar var;
            ExprSFW.FromClause fc = this.theSFW.getFromClause(i);
            if (fc.getTargetTable() != null || (var = fc.getVar()).getNumParents() != 0) continue;
            if (this.theSFW.getDomainExpr(i).isScalar()) {
                this.theSFW.removeFromClause(i, true);
                continue;
            }
            if (varRefsCounts[i] == 0) continue;
            if (this.theSFW.getDomainExpr(i).isMultiValued() && (this.theIndex == null || !this.theIndex.isMultiKey())) {
                throw new QueryStateException("Attempt to remove a multi-valued variable when a non-multikey index is being applied.\nvar name = " + var.getName() + " index name = " + this.theIndex.getName());
            }
            assert (var.getTable() == null);
            this.theSFW.removeFromClause(i, true);
        }
        this.analyzeNonTargetTables();
    }

    Expr rewritePred(ExprVar idxVar, PredInfo pi) {
        if (!pi.isMatched()) {
            this.rewriteExpr(idxVar, pi.thePred);
            return pi.thePred;
        }
        assert (pi.theEpath != null);
        QueryException.Location loc = pi.theEpath.theExpr.theLocation;
        int fieldPos = this.theIndex == null ? this.theTable.getPrimKeyPos(pi.theIPathPos) : pi.theIPathPos;
        ExprFieldStep idxColRef = new ExprFieldStep(this.theQCB, this.theSctx, loc, (Expr)idxVar, fieldPos);
        ExprFuncCall pred = (ExprFuncCall)pi.thePred;
        if (pred == null) {
            assert (this.theIsMapBothIndex);
            assert (pi.theEpath.getMapBothKey(this.theTable, this.theIndex) != null);
            ExprConst keyvalExpr = new ExprConst(this.theQCB, this.theSctx, loc, pi.theConstVal);
            ArrayList<Expr> args = new ArrayList<Expr>(2);
            args.add(idxColRef);
            args.add(keyvalExpr);
            pred = new ExprFuncCall(this.theQCB, this.theSctx, loc, FunctionLib.FuncCode.OP_EQ, args);
            return pred;
        }
        int numArgs = pred.getNumArgs();
        assert (numArgs <= 2);
        ArrayList<Expr> args = new ArrayList<Expr>(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Expr arg = pred.getArg(i);
            if (arg == pi.theVarArg) {
                args.add(idxColRef);
                continue;
            }
            args.add(arg);
        }
        pred = new ExprFuncCall(this.theQCB, this.theSctx, pred.theLocation, pred.getFunction(null), args);
        return pred;
    }

    void rewriteExpr(ExprVar idxVar, Expr expr) {
        ArrayList<ExprToReplace> exprsToReplace = this.theExprRewriteMap.get(expr);
        if (exprsToReplace == null) {
            return;
        }
        for (ExprToReplace etr : exprsToReplace) {
            int fieldPos = this.theIndex == null ? this.theTable.getPrimKeyPos(etr.theIndexFieldPos) : etr.theIndexFieldPos;
            ExprFieldStep idxColRef = new ExprFieldStep(this.theQCB, this.theSctx, etr.theExpr.theLocation, (Expr)idxVar, fieldPos);
            etr.theExpr.replace(idxColRef, true);
        }
    }

    void analyzeNonTargetTables() {
        int numTables = this.theTableExpr.getNumTables();
        for (int i = 0; i < numTables; ++i) {
            if (i == this.theTargetTablePos) continue;
            IndexAnalyzer analyzer = new IndexAnalyzer(this.theSFW, this.theTableExpr, i, null);
            analyzer.analyze();
            if (analyzer.theSFW == null) {
                return;
            }
            this.theTableExpr.addPrimaryKeys(i, null, null, analyzer.theIsCovering);
        }
    }

    void analyze() {
        Expr predsExpr;
        if (theTrace >= 1) {
            System.out.println("\nAnalysing index " + this.getIndexName() + "\n");
        }
        if ((predsExpr = this.theSFW.getWhereExpr()) != null) {
            ArrayList<Expr> preds;
            Function andOp = predsExpr.getFunction(FunctionLib.FuncCode.OP_AND);
            if (andOp != null) {
                preds = ((ExprFuncCall)predsExpr).getArgs();
            } else {
                preds = new ArrayList(1);
                preds.add(predsExpr);
            }
            for (Expr pred : preds) {
                WherePredInfo wpi = new WherePredInfo(pred);
                this.theWherePreds.add(wpi);
                this.collectPredInfo(wpi, pred);
                if (this.theSFW != null) continue;
                return;
            }
            for (int ipos = 0; ipos < this.theNumFields; ++ipos) {
                boolean alwaysFalse = this.skipExtraneousPreds(ipos);
                if (!alwaysFalse) continue;
                this.processAlwaysFalse();
                return;
            }
            this.chooseMultiKeyPredGroup();
        }
        if (this.theIndex != null && !this.theIndex.indexesNulls()) {
            for (int i = 0; i < this.theIndex.numFields(); ++i) {
                if (this.theStartStopPreds.get(i) != null && !this.theStartStopPreds.get(i).isEmpty()) continue;
                this.theIsRejected = true;
                return;
            }
        }
        if (this.theTablePos == this.theTargetTablePos) {
            for (WherePredInfo wpi : this.theWherePreds) {
                for (PredInfo pi : wpi.thePredInfos) {
                    boolean simplePathsOnly;
                    boolean bl = simplePathsOnly = pi.thePredGroup != this.theBestPredGroup;
                    if (pi.theStatus != PredicateStatus.NOT_STARTSTOP || !this.isIndexOnlyExpr(pi.thePred, true, simplePathsOnly)) continue;
                    pi.theStatus = PredicateStatus.FILTERING;
                    if (theTrace <= 0) continue;
                    System.out.println("NOT_STARTSTOP pred converted to filtering  pred:\n" + pi.thePred.display());
                }
            }
            this.pushStartStopPreds();
            for (WherePredInfo wpi : this.theWherePreds) {
                for (PredInfo pi : wpi.thePredInfos) {
                    if (pi.theStatus != PredicateStatus.FILTERING) continue;
                    this.theFilteringPreds.add(pi);
                }
            }
        }
        this.checkIsCovering();
    }

    private void collectPredInfo(WherePredInfo wpi, Expr pred) {
        List<Expr> filteringPreds;
        boolean added;
        Expr constArg;
        Expr varArg;
        boolean isGeo;
        Function func;
        PredInfo pi = new PredInfo(wpi, pred);
        if (pred.getKind() == Expr.ExprKind.CONST) {
            ExprConst constExpr = (ExprConst)pred;
            if (constExpr.getValue() == BooleanValueImpl.falseValue) {
                pi.theStatus = PredicateStatus.FALSE;
                this.processAlwaysFalse();
                return;
            }
            if (constExpr.getValue() == BooleanValueImpl.trueValue) {
                pi.theStatus = PredicateStatus.TRUE;
                return;
            }
        }
        if ((func = pred.getFunction(null)) == null) {
            pi.theStatus = PredicateStatus.NOT_STARTSTOP;
            wpi.add(pi);
            return;
        }
        FunctionLib.FuncCode op = func.getCode();
        ExprFuncCall compExpr = (ExprFuncCall)pred;
        FieldValueImpl constVal = null;
        boolean isComp = func.isComparison();
        boolean isExists = op == FunctionLib.FuncCode.OP_EXISTS;
        boolean isNotExists = op == FunctionLib.FuncCode.OP_NOT_EXISTS;
        boolean isNullOp = op == FunctionLib.FuncCode.OP_IS_NULL || op == FunctionLib.FuncCode.OP_IS_NOT_NULL;
        boolean bl = isGeo = op == FunctionLib.FuncCode.FN_GEO_INTERSECT || op == FunctionLib.FuncCode.FN_GEO_INSIDE || op == FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE;
        if (op == FunctionLib.FuncCode.OP_IS_NULL) {
            if (this.theIndex != null && !this.theIndex.indexesNulls()) {
                pi.theStatus = PredicateStatus.SKIP;
                wpi.add(pi);
                return;
            }
            op = FunctionLib.FuncCode.OP_EQ;
        } else if (op == FunctionLib.FuncCode.OP_IS_NOT_NULL) {
            op = FunctionLib.FuncCode.OP_LT;
        } else if (isExists) {
            op = FunctionLib.FuncCode.OP_NEQ;
        } else if (isNotExists) {
            if (this.theIndex != null && !this.theIndex.indexesNulls()) {
                pi.theStatus = PredicateStatus.SKIP;
                wpi.add(pi);
                return;
            }
            op = FunctionLib.FuncCode.OP_EQ;
        } else if (isComp) {
            if (func.isAnyComparison()) {
                op = FuncAnyOp.anyToComp(op);
            }
        } else {
            if (!isGeo) {
                pi.theStatus = PredicateStatus.NOT_STARTSTOP;
                wpi.add(pi);
                return;
            }
            if (this.theIsPrimary || !this.theIndex.isGeoIndex()) {
                pi.theStatus = PredicateStatus.SKIP;
                wpi.add(pi);
                return;
            }
        }
        if (isNullOp) {
            varArg = compExpr.getArg(0);
            constArg = null;
            constVal = NullValueImpl.getInstance();
        } else if (isExists || isNotExists) {
            varArg = compExpr.getArg(0);
            constArg = null;
            constVal = EmptyValueImpl.getInstance();
        } else {
            Expr arg0 = compExpr.getArg(0);
            Expr arg1 = compExpr.getArg(1);
            if (Expr.ConstKind.isConst(arg0)) {
                constArg = arg0;
                varArg = arg1;
                if (isComp) {
                    op = FuncCompOp.swapCompOp(op);
                }
            } else if (Expr.ConstKind.isConst(arg1)) {
                constArg = arg1;
                varArg = arg0;
            } else {
                pi.theStatus = PredicateStatus.NOT_STARTSTOP;
                wpi.add(pi);
                return;
            }
            if (constArg.getKind() == Expr.ExprKind.CONST) {
                constVal = ((ExprConst)constArg).getValue();
            } else if (Expr.ConstKind.isCompileConst(constArg)) {
                List<FieldValueImpl> res = ExprUtils.computeConstExpr(constArg);
                if (res.size() != 1) {
                    pi.theStatus = PredicateStatus.NOT_STARTSTOP;
                    wpi.add(pi);
                    return;
                }
                constVal = res.get(0);
                ExprConst ge = new ExprConst(this.theQCB, this.theSctx, constArg.getLocation(), constVal);
                constArg.replace(ge, true);
                constArg = ge;
            }
        }
        IndexExpr epath = varArg.getIndexExpr();
        if (epath == null || epath.theTable.getId() != this.theTable.getId()) {
            pi.theStatus = PredicateStatus.NOT_STARTSTOP;
            wpi.add(pi);
            return;
        }
        if (isNotExists && epath.getFilteringPreds() != null) {
            pi.theStatus = PredicateStatus.SKIP;
            wpi.add(pi);
            return;
        }
        pi.theOp = op;
        pi.theIsValueComp = func.isValueComparison();
        pi.theIsExists = isExists;
        pi.theIsNotExists = isNotExists;
        pi.theVarArg = varArg;
        pi.theConstArg = constArg;
        pi.theConstVal = constVal;
        pi.theEpath = epath;
        pi.theIsGeo = isGeo;
        boolean bl2 = wpi.theDoesSlicing = wpi.theDoesSlicing || epath.theDoesSlicing;
        if (isGeo) {
            if (constVal != null) {
                pi.theGeom = CompilerAPI.getGeoUtils().castAsGeometry(constVal);
            }
            if (pi.isNear()) {
                pi.theDistanceArg = compExpr.getArg(2);
                if (pi.theDistanceArg.getKind() == Expr.ExprKind.CONST) {
                    FieldValueImpl v = ((ExprConst)pi.theDistanceArg).getValue();
                    double dist = v.asDouble().get();
                    if (dist <= 0.0) {
                        this.processAlwaysFalse();
                        return;
                    }
                    pi.theDistance = dist;
                }
            }
        }
        if (func.isAnyComparison() && (this.theIsPrimary || !this.theIndex.isMultiKey())) {
            pi.theStatus = PredicateStatus.SKIP;
        }
        if (isGeo && (this.theIsPrimary || this.theIndex.isMultiKey() && this.theIndex.isGeometryIndex())) {
            pi.theStatus = PredicateStatus.SKIP;
        }
        if (op == FunctionLib.FuncCode.OP_NEQ && !isExists) {
            pi.theStatus = PredicateStatus.NOT_STARTSTOP;
        }
        if (added = wpi.add(pi)) {
            this.matchPred(pi);
        }
        if (pi.theStatus == PredicateStatus.FALSE) {
            this.processAlwaysFalse();
            return;
        }
        if (pi.theStatus == PredicateStatus.STARTSTOP) {
            this.addStartStopPred(pi);
            if (epath.theIsUnnested && epath.getMapBothKey() != null) {
                throw new QueryStateException("Found a pred factor that is both unnested and has a MapBoth key. Predicate = \n" + pi.thePred.display());
            }
            if (epath.theIsUnnested) {
                PredGroup.addUnnestedPred(this, pi);
            } else if (epath.getMapBothKey() != null && this.theIsMapBothIndex) {
                boolean found = PredGroup.addMapBothPred(this, pi);
                if (!found) {
                    StringValueImpl keyval = FieldDefImpl.stringDef.createString(epath.getMapBothKey());
                    PredInfo keypi = new PredInfo(wpi, null);
                    keypi.theOp = FunctionLib.FuncCode.OP_EQ;
                    keypi.theIsValueComp = true;
                    keypi.theConstVal = keyval;
                    keypi.theEpath = pi.theEpath;
                    keypi.theIPathPos = this.theIndex.getPosForKeysField();
                    keypi.theStatus = PredicateStatus.STARTSTOP;
                    wpi.add(keypi);
                    PredGroup.addMapBothPred(this, keypi);
                    this.addStartStopPred(keypi);
                }
            } else if (epath.isMultiKey()) {
                PredGroup pg;
                if (epath.theIsDirect || epath.getRelativeCtxVarPos() > 0) {
                    if (wpi.theLocalGroup == null) {
                        wpi.theLocalGroup = pg = this.addPredGroup(pi);
                    } else {
                        pg = wpi.theLocalGroup;
                        wpi.theLocalGroup.thePredInfos.add(pi);
                        pi.thePredGroup = wpi.theLocalGroup;
                    }
                } else {
                    pg = this.addPredGroup(pi);
                }
                pg.theCtxVar = epath.theCtxVar;
            }
        }
        if ((filteringPreds = epath.getFilteringPreds()) != null) {
            for (Expr fpred : filteringPreds) {
                if (pi.isUnnested() && this.theUnnestedGroup != null) {
                    boolean foundDuplicate = false;
                    for (PredInfo pi2 : this.theUnnestedGroup.thePredInfos) {
                        if (pi2.thePred != fpred) continue;
                        foundDuplicate = true;
                        break;
                    }
                    if (foundDuplicate) continue;
                }
                this.collectPredInfo(wpi, fpred);
            }
        }
    }

    private void matchPred(PredInfo pi) {
        FieldValueImpl constVal;
        if (pi.theStatus != PredicateStatus.UNKNOWN) {
            return;
        }
        IndexExpr epath = pi.theVarArg.getIndexExpr();
        boolean matched = this.matchPathExprToIndexPath(this.theIndex, epath, false);
        if (!matched) {
            pi.theStatus = PredicateStatus.SKIP;
            if (theTrace >= 2) {
                System.out.println("Match failure for epath " + epath.getPathName());
            }
            return;
        }
        if (epath.theIsMultiKey && pi.theVarArg.isMultiValued() && pi.theIsValueComp) {
            pi.theStatus = PredicateStatus.SKIP;
            return;
        }
        if (epath.theIsMultiKey && pi.theIsNotExists) {
            pi.theStatus = PredicateStatus.SKIP;
            return;
        }
        if (!this.theIsPrimary && epath.thePrimKeyPos >= 0 && epath.getPathPos() >= this.theIndex.numFields()) {
            pi.theStatus = PredicateStatus.NOT_STARTSTOP;
            return;
        }
        Expr constArg = pi.theConstArg;
        FieldValueImpl fieldValueImpl = constVal = pi.isGeo() ? null : pi.theConstVal;
        if (constArg != null && constVal != null && !constVal.isNull()) {
            FieldValueImpl newConstVal;
            FieldDefImpl constType;
            FieldDefImpl targetType = epath.getJsonDeclaredType() != null && !epath.theIsGeo ? epath.getJsonDeclaredType() : pi.theVarArg.getType().getDef();
            if (!TypeManager.areTypesComparable(targetType, constType = constVal.getDefinition())) {
                if (this.theQCB.strictMode()) {
                    throw new QueryException("Incompatible types for comparison operator: \nType1: " + pi.theVarArg.getType() + "\nType2: " + pi.theConstArg.getType(), pi.thePred.getLocation());
                }
                newConstVal = BooleanValueImpl.falseValue;
            } else {
                newConstVal = FuncCompOp.castConstInCompOp(targetType, epath.theIsJson, false, pi.theVarArg.isScalar(), constVal, pi.theOp, this.theQCB.strictMode());
            }
            if (newConstVal != constVal) {
                if (newConstVal == BooleanValueImpl.falseValue) {
                    pi.theStatus = PredicateStatus.FALSE;
                    return;
                }
                if (newConstVal == BooleanValueImpl.trueValue) {
                    pi.theStatus = PredicateStatus.TRUE;
                    return;
                }
                pi.theConstVal = constVal = newConstVal;
            }
        }
        if (constArg != null && !this.checkTypes(pi)) {
            if (theTrace >= 2) {
                System.out.println("Match failure due to type check for epath " + epath.getPathName());
            }
            pi.theStatus = PredicateStatus.NOT_STARTSTOP;
            return;
        }
        pi.theStatus = PredicateStatus.STARTSTOP;
        pi.theIPathPos = epath.getPathPos();
        if (pi.isUnnested() && !pi.getIndexPath().isMultiKey()) {
            throw new QueryStateException("An unnested predicate matches with the non-multikey index field at position pi.theIPathPos. predicate:\n" + pi);
        }
    }

    private boolean matchPathExprToIndexPath(IndexImpl index, IndexExpr epath, boolean matchSimplePathsOnly) {
        if (!epath.matchesIndex(this.theTable, index)) {
            return false;
        }
        if (matchSimplePathsOnly && this.theBestPredGroup != null && this.theBestPredGroup.theMapBothKey != null && this.theBestPredGroup.theMapBothKey.equals(epath.getMapBothKey())) {
            matchSimplePathsOnly = false;
        }
        return !epath.isMultiKey() || !matchSimplePathsOnly;
    }

    private boolean checkTypes(PredInfo pi) {
        boolean varIsScalar;
        FieldDefImpl varType;
        if (pi.theIsGeo) {
            return true;
        }
        Expr varArg = pi.theVarArg;
        Expr constArg = pi.theConstArg;
        IndexExpr epath = pi.theVarArg.getIndexExpr();
        if (!constArg.isScalar()) {
            return false;
        }
        FieldDefImpl constType = constArg.getType().getDef();
        FieldDef.Type constTypeCode = constType.getType();
        if (epath.getJsonDeclaredType() != null) {
            varType = epath.getJsonDeclaredType();
            boolean bl = varIsScalar = !epath.isMultiKey() || epath.getMapBothKey() != null;
            if (constTypeCode == FieldDef.Type.JSON) {
                return true;
            }
        } else {
            varType = varArg.getType().getDef();
            varIsScalar = varArg.isScalar();
        }
        FieldDef.Type varTypeCode = varType.getType();
        switch (varTypeCode) {
            case INTEGER: {
                return constTypeCode == FieldDef.Type.INTEGER || varIsScalar && constTypeCode == FieldDef.Type.LONG;
            }
            case LONG: {
                return constTypeCode == FieldDef.Type.LONG || constTypeCode == FieldDef.Type.INTEGER;
            }
            case FLOAT: {
                return constTypeCode == FieldDef.Type.FLOAT || varIsScalar && constTypeCode == FieldDef.Type.DOUBLE || constTypeCode == FieldDef.Type.INTEGER || constTypeCode == FieldDef.Type.LONG;
            }
            case DOUBLE: {
                return constTypeCode == FieldDef.Type.DOUBLE || constTypeCode == FieldDef.Type.FLOAT || constTypeCode == FieldDef.Type.INTEGER || constTypeCode == FieldDef.Type.LONG;
            }
            case NUMBER: {
                return constType.isNumeric();
            }
            case ENUM: {
                return constTypeCode == FieldDef.Type.STRING || constTypeCode == FieldDef.Type.ENUM;
            }
            case STRING: 
            case BOOLEAN: {
                return varTypeCode == constTypeCode;
            }
            case TIMESTAMP: {
                return varTypeCode == constTypeCode && ((TimestampDefImpl)varType).getPrecision() == ((TimestampDefImpl)constType).getPrecision();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean skipExtraneousPreds(int ipos) {
        ArrayList<PredInfo> predinfos = this.theStartStopPreds.get(ipos);
        if (predinfos == null) {
            return false;
        }
        int i = 0;
        while (i < predinfos.size()) {
            PredInfo pi1 = predinfos.get(i);
            for (int j = i + 1; j < predinfos.size(); ++j) {
                PredInfo pi2;
                block34: {
                    block39: {
                        block40: {
                            block37: {
                                block38: {
                                    block36: {
                                        block35: {
                                            pi2 = predinfos.get(j);
                                            if (!pi1.isCompatible(pi2)) continue;
                                            if (!pi2.isExists()) break block35;
                                            pi2.theStatus = PredicateStatus.TRUE;
                                            break block34;
                                        }
                                        if (!pi2.isGeo()) break block36;
                                        if (pi1.isExists()) {
                                            pi1.theStatus = PredicateStatus.TRUE;
                                            break block34;
                                        } else if (pi1.isGeo()) {
                                            this.checkGeoGeo(pi1, pi2);
                                            break block34;
                                        } else {
                                            if (!pi1.isEq()) {
                                                return true;
                                            }
                                            FieldDefImpl def = pi1.theConstArg.getType().getDef();
                                            if (def.mayBeJsonObject()) {
                                                pi1.theStatus = PredicateStatus.SKIP;
                                            }
                                            return true;
                                        }
                                    }
                                    if (!pi2.isEq()) break block37;
                                    if (!pi1.isExists()) break block38;
                                    pi1.theStatus = PredicateStatus.TRUE;
                                    break block34;
                                }
                                if (pi1.isGeo()) {
                                    FieldDefImpl def = pi2.theConstArg.getType().getDef();
                                    if (def.mayBeJsonObject()) {
                                        pi2.theStatus = PredicateStatus.SKIP;
                                    }
                                    return true;
                                }
                                if (pi1.isEq()) {
                                    this.checkEqEq(pi1, pi2);
                                    break block34;
                                } else if (pi1.isMin()) {
                                    this.checkEqMin(pi2, pi1);
                                    break block34;
                                } else {
                                    assert (pi1.isMax());
                                    this.checkEqMax(pi2, pi1);
                                }
                                break block34;
                            }
                            if (!pi2.isMin()) break block39;
                            if (!pi1.isExists()) break block40;
                            pi1.theStatus = PredicateStatus.TRUE;
                            break block34;
                        }
                        if (pi1.isGeo()) {
                            return true;
                        }
                        if (pi1.isEq()) {
                            this.checkEqMin(pi1, pi2);
                            break block34;
                        } else if (pi1.isMin()) {
                            this.checkMinMin(pi2, pi1);
                            break block34;
                        } else {
                            assert (pi1.isMax());
                            this.checkMinMax(pi2, pi1);
                        }
                        break block34;
                    }
                    assert (pi2.isMax());
                    if (pi1.isExists()) {
                        pi1.theStatus = PredicateStatus.TRUE;
                    } else {
                        if (pi1.isGeo()) {
                            return true;
                        }
                        if (pi1.isEq()) {
                            this.checkEqMax(pi1, pi2);
                        } else if (pi1.isMin()) {
                            this.checkMinMax(pi1, pi2);
                        } else {
                            assert (pi1.isMax());
                            this.checkMaxMax(pi2, pi1);
                        }
                    }
                }
                if (pi1.theStatus == PredicateStatus.FALSE || pi2.theStatus == PredicateStatus.FALSE) {
                    return true;
                }
                if (pi1.theStatus == PredicateStatus.TRUE || pi1.theStatus == PredicateStatus.SKIP || pi1.theStatus == PredicateStatus.FILTERING) {
                    predinfos.remove(i);
                    --i;
                    break;
                }
                if (pi2.theStatus != PredicateStatus.TRUE && pi2.theStatus != PredicateStatus.SKIP && pi2.theStatus != PredicateStatus.FILTERING) continue;
                predinfos.remove(j);
                --j;
            }
            ++i;
        }
        return false;
    }

    private void checkEqEq(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp == 0) {
                p1.theStatus = PredicateStatus.TRUE;
            } else {
                p1.theStatus = PredicateStatus.FALSE;
                p2.theStatus = PredicateStatus.FALSE;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.FILTERING;
        } else {
            p1.theStatus = PredicateStatus.FILTERING;
        }
    }

    private void checkEqMin(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && !p2.isInclusive()) {
                p1.theStatus = PredicateStatus.FALSE;
                p2.theStatus = PredicateStatus.FALSE;
            } else {
                p2.theStatus = PredicateStatus.TRUE;
            }
        } else {
            p2.theStatus = PredicateStatus.FILTERING;
        }
    }

    private void checkEqMax(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp > 0 || cmp == 0 && !p2.isInclusive()) {
                p1.theStatus = PredicateStatus.FALSE;
                p2.theStatus = PredicateStatus.FALSE;
            } else {
                p2.theStatus = PredicateStatus.TRUE;
            }
        } else {
            p2.theStatus = PredicateStatus.FILTERING;
        }
    }

    private void checkMinMin(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && p1.isInclusive()) {
                p1.theStatus = PredicateStatus.TRUE;
            } else {
                p2.theStatus = PredicateStatus.TRUE;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.FILTERING;
        } else {
            p1.theStatus = PredicateStatus.FILTERING;
        }
    }

    private void checkMaxMax(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
            if (cmp < 0 || cmp == 0 && p2.isInclusive()) {
                p2.theStatus = PredicateStatus.TRUE;
            } else {
                p1.theStatus = PredicateStatus.TRUE;
            }
        } else if (p1.theConstVal != null) {
            p2.theStatus = PredicateStatus.FILTERING;
        } else {
            p1.theStatus = PredicateStatus.FILTERING;
        }
    }

    private void checkMinMax(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal != null && p2.theConstVal != null) {
            int cmp = p1.theConstVal.compareTo(p2.theConstVal);
            if (cmp > 0 || cmp == 0 && (!p2.isInclusive() || !p1.isInclusive())) {
                p1.theStatus = PredicateStatus.FALSE;
                p2.theStatus = PredicateStatus.FALSE;
            } else if (cmp == 0) {
                p1.theOp = FunctionLib.FuncCode.OP_EQ;
                p2.theStatus = PredicateStatus.TRUE;
            }
        }
    }

    private void checkGeoGeo(PredInfo p1, PredInfo p2) {
        if (p1.theGeom != null && p2.theGeom != null) {
            double area2;
            double area1;
            Geometry geom1 = p1.theGeom;
            Geometry geom2 = p2.theGeom;
            if (p1.theOp == FunctionLib.FuncCode.FN_GEO_INSIDE) {
                if (!geom1.interact(geom2, p1.getLocation())) {
                    p1.theStatus = PredicateStatus.FALSE;
                    p2.theStatus = PredicateStatus.FALSE;
                    return;
                }
            } else if (p2.theOp == FunctionLib.FuncCode.FN_GEO_INSIDE && !geom2.interact(geom1, p2.getLocation())) {
                p1.theStatus = PredicateStatus.FALSE;
                p2.theStatus = PredicateStatus.FALSE;
                return;
            }
            if ((area1 = geom1.area(p1.getLocation())) <= (area2 = geom2.area(p2.getLocation()))) {
                p1.theGeom = geom1;
                p2.theStatus = PredicateStatus.SKIP;
            } else {
                p2.theGeom = geom2;
                p1.theStatus = PredicateStatus.SKIP;
            }
        } else if (p1.theGeom != null) {
            p2.theStatus = PredicateStatus.SKIP;
        } else {
            p1.theStatus = PredicateStatus.SKIP;
        }
    }

    private boolean checkAlwaysTrue(PredInfo p1, PredInfo p2) {
        if (p1.theConstVal == null || p2.theConstVal == null || p1.isGeo() || p2.isGeo() || p2.theEnclosingPred.doesFiltering() || p2.theEnclosingPred.theDoesSlicing) {
            return false;
        }
        int cmp = FieldValueImpl.compareFieldValues(p1.theConstVal, p2.theConstVal);
        if (p1.isEq()) {
            if (p2.isEq()) {
                return cmp == 0;
            }
            if (p2.isMin()) {
                return cmp >= 0 && (cmp != 0 || p2.isInclusive());
            }
            assert (p2.isMax());
            return cmp <= 0 && (cmp != 0 || p2.isInclusive());
        }
        if (p1.isMin()) {
            if (p2.isEq()) {
                return false;
            }
            if (p2.isMin()) {
                return cmp >= 0 && (cmp != 0 || !p1.isInclusive() || p2.isInclusive());
            }
            assert (p2.isMax());
            return false;
        }
        if (p1.isMax()) {
            if (p2.isEq()) {
                return false;
            }
            if (p2.isMin()) {
                return false;
            }
            assert (p2.isMax());
            return cmp < 0 || cmp == 0 && (!p1.isInclusive() || p2.isInclusive());
        }
        return false;
    }

    private void chooseMultiKeyPredGroup() {
        PredInfo pi;
        boolean filteringOnly = false;
        if (theTrace >= 1) {
            System.out.println("Choosing multikey predicate class");
        }
        for (int ipos = 0; ipos < this.theNumFields; ++ipos) {
            ArrayList<PredInfo> predinfos;
            if (theTrace >= 1) {
                System.out.println("processing ifield at pos " + ipos);
            }
            if ((predinfos = this.theStartStopPreds.get(ipos)) == null) {
                if (theTrace >= 1) {
                    System.out.println("no preds at pos " + ipos);
                }
                filteringOnly = true;
                continue;
            }
            if (this.theIsPrimary || !this.theIndexPaths.get(ipos).isMultiKey()) {
                if (predinfos.size() > 2) {
                    throw new QueryStateException("More than two predicates for non-multikey index field at position " + ipos);
                }
                if (predinfos.get(0).isEq()) continue;
                if (theTrace >= 1) {
                    System.out.println("no EQ preds at pos " + ipos);
                }
                filteringOnly = true;
                continue;
            }
            for (int i = 0; i < predinfos.size(); ++i) {
                pi = predinfos.get(i);
                PredGroup pg = pi.thePredGroup;
                if (theTrace >= 1) {
                    System.out.println("processing pred at pos " + ipos + "\nPG: " + pg.theId + " filtering = " + pg.theFilteringOnly + "\nMapBothKey = " + pg.theMapBothKey + "\nPred = \n" + pi);
                }
                if (pi.theStatus != PredicateStatus.STARTSTOP) {
                    throw new QueryStateException("Found a non STARTSTOP predicate in theStartStopPreds  as position " + ipos);
                }
                if (filteringOnly || pg.theFilteringOnly) {
                    pg.theFieldScore = pi.isEq() ? (pg.theFieldScore += 17) : (pg.theFieldScore += 7);
                } else if (pi.isEq()) {
                    pg.theFieldScore += 32;
                } else {
                    pg.theFieldScore += 16;
                    pg.theFoundRange = true;
                }
                if (theTrace < 1) continue;
                System.out.println("Field score = " + pg.theFieldScore);
            }
            for (PredGroup pg : this.thePredGroups) {
                pg.theScore += pg.theFieldScore;
                if (theTrace >= 1) {
                    System.out.println("Total score for PG " + pg.theId + " = " + pg.theScore);
                }
                if (pg.theFieldScore == 0 || pg.theFoundRange) {
                    pg.theFilteringOnly = true;
                }
                pg.theFieldScore = 0;
            }
        }
        for (PredGroup pg : this.thePredGroups) {
            if (this.theBestPredGroup == null) {
                if (pg.theScore <= 0) continue;
                this.theBestPredGroup = pg;
                continue;
            }
            if (pg.theScore > this.theBestPredGroup.theScore) {
                this.theBestPredGroup = pg;
                continue;
            }
            if (pg.theScore != this.theBestPredGroup.theScore || (pg.theIsUnnested || !this.theBestPredGroup.theIsUnnested) && pg.theId >= this.theBestPredGroup.theId) continue;
            this.theBestPredGroup = pg;
        }
        if (this.theBestPredGroup == null) {
            return;
        }
        if (this.theIndex != null && this.theIndex.isMultiKeyMapIndex()) {
            for (PredInfo pi2 : this.theBestPredGroup.thePredInfos) {
                if (pi2.theIPathPos < 0) continue;
                IndexImpl.IndexField ipath = this.theIndexPaths.get(pi2.theIPathPos);
                if (pi2.mapBothKey() == null && (!pi2.isEq() || !ipath.isMapKeys())) continue;
                this.theHaveMapKeyEqPred = true;
                break;
            }
        }
        if (theTrace >= 1) {
            System.out.println("Best pred group = \n" + this.theBestPredGroup.theId);
        }
        for (int i = 0; i < this.theNumFields; ++i) {
            ArrayList<PredInfo> preds;
            if (!this.theIndexPaths.get(i).isMultiKey() || (preds = this.theStartStopPreds.get(i)) == null) continue;
            for (int j = 0; j < preds.size(); ++j) {
                pi = preds.get(j);
                if (pi.theStatus == PredicateStatus.SKIP) {
                    preds.remove(j);
                    --j;
                    continue;
                }
                if (pi.thePredGroup == this.theBestPredGroup) continue;
                preds.remove(j);
                --j;
                if (pi.mapBothKey() == null) {
                    for (PredInfo pi2 : preds) {
                        if (pi2.thePredGroup != this.theBestPredGroup || pi2.isUnnested() != pi.isUnnested() && !pi2.isUnnested() || !this.checkAlwaysTrue(pi2, pi)) continue;
                        pi.theStatus = PredicateStatus.TRUE;
                        break;
                    }
                }
                if (pi.theStatus == PredicateStatus.TRUE) continue;
                pi.theStatus = PredicateStatus.SKIP;
            }
        }
    }

    private void pushStartStopPreds() {
        int ipos;
        boolean pushedMultiKeyPred = false;
        int lastStartStopPos = -2;
        for (ipos = 0; ipos < this.theNumFields; ++ipos) {
            FieldDefImpl rangeDef;
            String pathName;
            PredInfo pi2;
            ArrayList<PredInfo> predinfos = this.theStartStopPreds.get(ipos);
            if (predinfos == null || predinfos.isEmpty()) {
                if (lastStartStopPos != -2) continue;
                lastStartStopPos = ipos - 1;
                continue;
            }
            if (predinfos.size() > 2) {
                throw new QueryStateException("More than 2 start/stop predicates for index field at position " + ipos);
            }
            PredInfo pi1 = predinfos.get(0);
            PredInfo predInfo = pi2 = predinfos.size() > 1 ? predinfos.get(1) : null;
            if (pi1.theStatus != PredicateStatus.STARTSTOP) {
                throw new QueryStateException("Pushing a predicate marked as " + (Object)((Object)pi1.theStatus) + "\n" + pi1);
            }
            if (pi2 != null && pi2.theStatus != PredicateStatus.STARTSTOP) {
                throw new QueryStateException("Pushing a predicate marked as " + (Object)((Object)pi2.theStatus) + "\n" + pi2);
            }
            if (lastStartStopPos >= -1) {
                pi1.theStatus = PredicateStatus.FILTERING;
                if (pi2 == null) continue;
                pi2.theStatus = PredicateStatus.FILTERING;
                continue;
            }
            IndexImpl.IndexField ipath = this.theIndexPaths.get(ipos);
            boolean bl = pushedMultiKeyPred = pushedMultiKeyPred || ipath.isMultiKey();
            if (pi1.isEq()) {
                FieldValueImpl constVal;
                assert (predinfos.size() == 1);
                assert (!ipath.isMapKeys() || this.theHaveMapKeyEqPred);
                if (pi1.theConstVal != null) {
                    this.thePushedExternals.add(null);
                    constVal = pi1.theConstVal;
                } else {
                    this.theHavePushedExternals = true;
                    this.thePushedExternals.add(pi1.theConstArg);
                    constVal = IndexAnalyzer.createPlaceHolderValue(ipath.getType());
                }
                if (this.theIsPrimary) {
                    this.thePrimaryKeys.get(0).put(ipath.getStep(0), (FieldValue)constVal);
                } else {
                    this.theSecondaryKeys.get(0).put(ipos, (FieldValue)constVal);
                }
                ++this.theNumEqPredsPushed;
                continue;
            }
            if (pi1.isExists()) {
                assert (predinfos.size() == 1);
                assert (!this.theIsPrimary);
                this.theSecondaryKeys.add(this.theSecondaryKeys.get(0));
                pathName = this.theIndex.getFieldName(ipos);
                rangeDef = ipath.getType();
                FieldRange fr1 = new FieldRange(pathName, rangeDef, 0);
                FieldRange fr2 = new FieldRange(pathName, rangeDef, 0);
                fr1.setEnd(EmptyValueImpl.getInstance(), false, false);
                fr2.setStart(EmptyValueImpl.getInstance(), false, false);
                this.theRanges.set(0, fr1);
                this.theRanges.add(fr2);
                this.thePushedExternals.add(null);
                if (ipath.isMultiKey() && !this.theHaveMapKeyEqPred) {
                    this.theIsMultiKeyRange = true;
                    this.theEliminateDups = true;
                }
                lastStartStopPos = ipos;
                continue;
            }
            if (pi1.isGeo()) {
                lastStartStopPos = ipos;
                pathName = this.theIndex.getFieldName(ipos);
                rangeDef = FieldDefImpl.stringDef;
                FieldRange fr = new FieldRange(pathName, rangeDef, 0);
                fr.setEnd(EmptyValueImpl.getInstance(), false, false);
                fr.setStart(EmptyValueImpl.getInstance(), false, false);
                this.theRanges.set(0, fr);
                if (ipath.isMultiKey() || this.theIndex.isGeometryIndex()) {
                    this.theIsMultiKeyRange = true;
                    this.theEliminateDups = true;
                }
                if (theTrace < 2) continue;
                System.out.println("Added fake range for geo pred");
                continue;
            }
            PredInfo minpi = null;
            PredInfo maxpi = null;
            if (pi1.isMin()) {
                minpi = pi1;
                if (pi2 != null) {
                    assert (pi2.isMax());
                    maxpi = pi2;
                }
            } else {
                assert (pi1.isMax());
                maxpi = pi1;
                if (pi2 != null) {
                    assert (pi2.isMin());
                    minpi = pi2;
                }
            }
            this.createRange(ipath, minpi, maxpi);
            if (this.theIsMultiKeyRange) {
                this.theEliminateDups = true;
            }
            lastStartStopPos = ipos;
        }
        if (this.theIndex != null && this.theIndex.isMultiKey() && !this.theHaveMapKeyEqPred && !this.theEliminateDups) {
            if (!pushedMultiKeyPred) {
                this.theEliminateDups = true;
            } else {
                for (ipos = lastStartStopPos + 1; ipos < this.theIndexPaths.size(); ++ipos) {
                    IndexImpl.IndexField ipath = this.theIndexPaths.get(ipos);
                    if (!ipath.isMultiKey()) continue;
                    this.theEliminateDups = true;
                    break;
                }
            }
        }
    }

    private void createRange(IndexImpl.IndexField ipath, PredInfo minpi, PredInfo maxpi) {
        FieldValueImpl val;
        int storageSize = this.theIsPrimary ? this.theTable.getPrimaryKeySize(ipath.getStep(0)) : 0;
        FieldDefImpl rangeDef = ipath.getType();
        String pathName = this.theIsPrimary ? ipath.getStep(0) : this.theIndex.getFieldName(ipath.getPosition());
        FieldRange range = new FieldRange(pathName, rangeDef, storageSize);
        this.theRanges.set(0, range);
        if (minpi != null) {
            if (minpi.theConstVal == null) {
                this.theHavePushedExternals = true;
                this.thePushedExternals.add(minpi.theConstArg);
                val = IndexAnalyzer.createPlaceHolderValue(rangeDef);
                range.setStart(val, minpi.isInclusive(), false);
            } else {
                this.thePushedExternals.add(null);
                range.setStart(minpi.theConstVal, minpi.isInclusive());
            }
            if (ipath.isMultiKey() && !this.theHaveMapKeyEqPred) {
                this.theIsMultiKeyRange = true;
            }
        } else {
            this.thePushedExternals.add(null);
        }
        if (maxpi != null) {
            if (maxpi.theConstVal == null) {
                this.theHavePushedExternals = true;
                this.thePushedExternals.add(maxpi.theConstArg);
                val = IndexAnalyzer.createPlaceHolderValue(rangeDef);
                range.setEnd(val, maxpi.isInclusive(), false);
            } else {
                this.thePushedExternals.add(null);
                range.setEnd(maxpi.theConstVal, maxpi.isInclusive());
            }
            if (ipath.isMultiKey() && !this.theHaveMapKeyEqPred) {
                this.theIsMultiKeyRange = true;
            }
        } else {
            this.thePushedExternals.add(null);
        }
    }

    private void checkIsCovering() {
        boolean isKeyOnly;
        int numPreds = this.getNumPreds();
        int numIndexPreds = 0;
        if (this.theSFW == null) {
            this.theIsCovering = false;
            return;
        }
        boolean bl = isKeyOnly = this.theSFW != null && this.theTable.isKeyOnly();
        if (isKeyOnly) {
            assert (this.theIsPrimary || !this.theIndex.isMultiKey());
            assert (!this.theSFW.hasSort() || this.theSFW.hasPrimaryIndexBasedSort() && this.theIsPrimary || this.theSFW.getSortingIndexes().contains(this.theIndex));
        }
        boolean hasNestedTables = this.theTableExpr.hasNestedTables();
        for (WherePredInfo wpi : this.theWherePreds) {
            if (wpi.isFullyPushable()) {
                ++numIndexPreds;
                continue;
            }
            if (!hasNestedTables || !this.isIndexOnlyExpr(wpi.thePred, false, true)) continue;
            ++numIndexPreds;
        }
        assert (numIndexPreds <= numPreds);
        boolean bl2 = this.theIsCovering = numIndexPreds == numPreds;
        if (!this.theIsCovering) {
            assert (!isKeyOnly);
            return;
        }
        int numFieldExprs = this.theSFW.getNumFields();
        for (int i = 0; i < numFieldExprs; ++i) {
            Expr expr = this.theSFW.getFieldExpr(i);
            if (this.isIndexOnlyExpr(expr, false, true)) continue;
            if ((this.theIsPrimary || !this.theIndex.isMultiKey()) && expr.getKind() == Expr.ExprKind.VAR && ((ExprVar)expr).getTable() != null && ((ExprVar)expr).getTable().getId() == this.theTable.getId()) {
                int j;
                RecordDefImpl rowDef = this.theTable.getRowDef();
                int numCols = rowDef.getNumFields();
                for (j = 0; j < numCols; ++j) {
                    IndexImpl.IndexField ipath;
                    int k;
                    String colName = rowDef.getFieldName(j);
                    for (k = 0; !(k >= this.theNumFields || (ipath = this.theIndexPaths.get(k)).numSteps() == 1 && ipath.getStep(0).equalsIgnoreCase(colName)); ++k) {
                    }
                    if (k == this.theNumFields) break;
                }
                if (j == numCols) continue;
            }
            this.theIsCovering = false;
            return;
        }
        if (this.theTablePos == this.theTargetTablePos) {
            int numSortExprs = this.theSFW.getNumSortExprs();
            for (int i = 0; i < numSortExprs; ++i) {
                Expr expr = this.theSFW.getSortExpr(i);
                if (this.isIndexOnlyExpr(expr, true, true)) continue;
                this.theIsCovering = false;
                return;
            }
        }
        int numFroms = this.theSFW.getNumFroms();
        for (int i = 0; i < numFroms; ++i) {
            ExprSFW.FromClause fc = this.theSFW.getFromClause(i);
            Expr domExpr = fc.getDomainExpr();
            if (domExpr == this.theTableExpr) {
                if (!hasNestedTables) continue;
                int numTables = this.theTableExpr.getNumTables();
                for (int j = 0; j < numTables; ++j) {
                    Expr pred = this.theTableExpr.getTablePred(j);
                    if (pred == null || this.isIndexOnlyExpr(pred, false, true)) continue;
                    this.theIsCovering = false;
                    return;
                }
                continue;
            }
            ExprVar var = fc.getVar();
            if (var.getNumParents() != 0 || domExpr.isScalar() || this.isIndexOnlyExpr(domExpr, false, true)) continue;
            this.theIsCovering = false;
            assert (!isKeyOnly);
            return;
        }
    }

    private boolean isIndexOnlyExpr(Expr expr, boolean strict, boolean matchSimplePathsOnly) {
        return this.isIndexOnlyExpr(expr, expr, strict, matchSimplePathsOnly);
    }

    private boolean isIndexOnlyExpr(Expr initExpr, Expr expr, boolean strict, boolean matchSimplePathsOnly) {
        switch (expr.getKind()) {
            case FIELD_STEP: 
            case MAP_FILTER: 
            case ARRAY_FILTER: 
            case ARRAY_SLICE: 
            case VAR: {
                ExprVar var;
                if (expr.getKind() == Expr.ExprKind.VAR && (var = (ExprVar)expr).isExternal()) {
                    return true;
                }
                IndexExpr epath = expr.getIndexExpr();
                if (epath == null || epath.theDoesSlicing || epath.theIsGeo || epath.theFilteringPreds != null || strict && epath.theTable.getId() != this.theTable.getId()) {
                    return false;
                }
                if (!strict && epath.theTable.getId() != this.theTable.getId()) {
                    return true;
                }
                if (matchSimplePathsOnly && epath.getRelativeCtxVarPos(this.theTable, this.theIndex) > 0 && epath.theCtxVar == this.theBestPredGroup.theCtxVar) {
                    matchSimplePathsOnly = false;
                }
                if (!this.matchPathExprToIndexPath(this.theIndex, epath, matchSimplePathsOnly)) {
                    return false;
                }
                ArrayList<ExprToReplace> exprsToReplace = this.theExprRewriteMap.get(initExpr);
                if (exprsToReplace == null) {
                    exprsToReplace = new ArrayList();
                    this.theExprRewriteMap.put(initExpr, exprsToReplace);
                }
                exprsToReplace.add(new ExprToReplace(expr, epath.getPathPos()));
                return true;
            }
            case BASE_TABLE: {
                return false;
            }
            case CONST: {
                return true;
            }
            case FUNC_CALL: {
                Function func = expr.getFunction(null);
                if (func == null || func.getCode() != FunctionLib.FuncCode.FN_GEO_INTERSECT && func.getCode() != FunctionLib.FuncCode.FN_GEO_INSIDE) break;
                return false;
            }
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            if (this.isIndexOnlyExpr(initExpr, child, strict, matchSimplePathsOnly)) continue;
            children.reset();
            return false;
        }
        children.reset();
        return true;
    }

    static FieldValueImpl createPlaceHolderValue(FieldDefImpl type) {
        switch (type.getType()) {
            case INTEGER: {
                return FieldDefImpl.integerDef.createInteger(0);
            }
            case LONG: {
                return FieldDefImpl.longDef.createLong(0L);
            }
            case FLOAT: {
                return FieldDefImpl.floatDef.createFloat(0.0f);
            }
            case DOUBLE: {
                return FieldDefImpl.doubleDef.createDouble(0.0);
            }
            case NUMBER: {
                return FieldDefImpl.numberDef.createNumber(0);
            }
            case STRING: {
                return FieldDefImpl.stringDef.createString("");
            }
            case ENUM: {
                return ((EnumDefImpl)type).createEnum(1);
            }
        }
        throw new QueryStateException("Unexpected type for index key: " + type);
    }

    private int getNumPreds() {
        if (this.theSFW == null) {
            return 0;
        }
        Expr whereExpr = this.theSFW.getWhereExpr();
        if (whereExpr == null) {
            return 0;
        }
        Function andOp = whereExpr.getFunction(FunctionLib.FuncCode.OP_AND);
        if (andOp != null) {
            return whereExpr.getNumChildren();
        }
        return 1;
    }

    static enum PredicateStatus {
        UNKNOWN,
        NOT_STARTSTOP,
        STARTSTOP,
        FILTERING,
        SKIP,
        FALSE,
        TRUE;

    }

    private static class PredGroup {
        int theId;
        final ArrayList<PredInfo> thePredInfos = new ArrayList(8);
        ExprVar theCtxVar;
        String theMapBothKey;
        boolean theIsUnnested;
        int theScore;
        int theFieldScore;
        boolean theFoundRange;
        boolean theFilteringOnly;

        PredGroup(int id, PredInfo pi) {
            this.theId = id;
            this.thePredInfos.add(pi);
            pi.thePredGroup = this;
        }

        static void addUnnestedPred(IndexAnalyzer idx, PredInfo pi) {
            if (idx.theUnnestedGroup == null) {
                PredGroup pg = idx.addPredGroup(pi);
                pg.theIsUnnested = true;
                idx.theUnnestedGroup = pg;
                return;
            }
            ((IndexAnalyzer)idx).theUnnestedGroup.thePredInfos.add(pi);
            pi.thePredGroup = idx.theUnnestedGroup;
        }

        static boolean addMapBothPred(IndexAnalyzer idx, PredInfo pi) {
            boolean added = false;
            for (PredGroup pg : idx.thePredGroups) {
                if (!pi.mapBothKey().equals(pg.theMapBothKey)) continue;
                pg.thePredInfos.add(pi);
                pi.thePredGroup = pg;
                added = true;
                break;
            }
            if (!added) {
                PredGroup pg = idx.addPredGroup(pi);
                pg.theMapBothKey = pi.mapBothKey();
                return false;
            }
            return true;
        }
    }

    private class PredInfo {
        WherePredInfo theEnclosingPred;
        Expr thePred;
        FunctionLib.FuncCode theOp;
        boolean theIsValueComp;
        boolean theIsExists;
        boolean theIsNotExists;
        boolean theIsGeo;
        Expr theVarArg;
        Expr theConstArg;
        FieldValueImpl theConstVal;
        Expr theDistanceArg;
        double theDistance = -1.0;
        Geometry theGeom;
        IndexExpr theEpath;
        int theIPathPos = -1;
        PredGroup thePredGroup;
        PredicateStatus theStatus;

        PredInfo(WherePredInfo enclosingPred, Expr pred) {
            this.theEnclosingPred = enclosingPred;
            this.thePred = pred;
            this.theStatus = PredicateStatus.UNKNOWN;
        }

        boolean isEq() {
            return this.theOp == FunctionLib.FuncCode.OP_EQ;
        }

        boolean isMin() {
            return this.theOp == FunctionLib.FuncCode.OP_GT || this.theOp == FunctionLib.FuncCode.OP_GE;
        }

        boolean isMax() {
            return this.theOp == FunctionLib.FuncCode.OP_LT || this.theOp == FunctionLib.FuncCode.OP_LE;
        }

        boolean isInclusive() {
            return this.theOp == FunctionLib.FuncCode.OP_GE || this.theOp == FunctionLib.FuncCode.OP_LE;
        }

        boolean isExists() {
            return this.theIsExists;
        }

        boolean isGeo() {
            return this.theIsGeo;
        }

        boolean isNear() {
            return this.theOp == FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE;
        }

        boolean isUnnested() {
            return this.theEpath.theIsUnnested;
        }

        String mapBothKey() {
            return this.theEpath.getMapBothKey();
        }

        boolean isMatched() {
            return this.theIPathPos >= 0;
        }

        IndexImpl.IndexField getIndexPath() {
            return IndexAnalyzer.this.theIndexPaths.get(this.theIPathPos);
        }

        boolean isCompatible(PredInfo other) {
            assert (this.theIPathPos == other.theIPathPos);
            return !IndexAnalyzer.this.theIndexPaths.get(this.theIPathPos).isMultiKey() || this.thePredGroup == other.thePredGroup;
        }

        boolean canBeRemoved() {
            return this.isMatched() && this.thePred != this.theEnclosingPred.thePred && this.theEpath != null && (!this.getIndexPath().isMultiKey() || this.theEpath.getMapBothKey(IndexAnalyzer.this.theTable, IndexAnalyzer.this.theIndex) != null) && this.theEpath.getFilteringPreds() == null;
        }

        QueryException.Location getLocation() {
            return this.thePred.getLocation();
        }

        public String toString() {
            if (this.thePred != null) {
                return this.thePred.display();
            }
            return "Map Both key = " + this.mapBothKey();
        }
    }

    private class WherePredInfo {
        int theId;
        Expr thePred;
        final ArrayList<PredInfo> thePredInfos = new ArrayList(8);
        boolean theDoesSlicing;
        PredGroup theLocalGroup;

        WherePredInfo(Expr pred) {
            this.theId = IndexAnalyzer.this.theWherePreds.size();
            this.thePred = pred;
        }

        boolean add(PredInfo pi) {
            if (pi.thePred == null) {
                if (theTrace >= 2) {
                    System.out.println("Collected keys() pred for MapBoth key " + pi.mapBothKey());
                }
                this.thePredInfos.add(0, pi);
                return true;
            }
            boolean added = false;
            if (pi.isExists()) {
                Expr input = pi.thePred.getInput();
                if (input.getKind() == Expr.ExprKind.ARRAY_FILTER) {
                    ExprArrayFilter step = (ExprArrayFilter)input;
                    if (step.getPredExpr() == null) {
                        this.thePredInfos.add(pi);
                        added = true;
                    }
                } else if (input.getKind() == Expr.ExprKind.MAP_FILTER) {
                    ExprMapFilter step = (ExprMapFilter)input;
                    if (step.getPredExpr() == null) {
                        this.thePredInfos.add(pi);
                        added = true;
                    }
                } else {
                    this.thePredInfos.add(pi);
                    added = true;
                }
            } else {
                this.thePredInfos.add(pi);
                added = true;
            }
            if (added && theTrace >= 2) {
                System.out.println("WPI: " + this.theId + " Collected pred with status " + (Object)((Object)pi.theStatus) + "\nepath = " + (pi.theEpath != null ? pi.theEpath.getPathName() : null) + "\n" + pi.thePred.display() + "\n");
            }
            return added;
        }

        boolean doesFiltering() {
            return this.thePredInfos.size() > 1 || this.thePredInfos.get((int)0).thePred != this.thePred;
        }

        boolean isFullyPushable() {
            if (this.theDoesSlicing) {
                return false;
            }
            for (PredInfo pi : this.thePredInfos) {
                if (!(pi.theStatus != PredicateStatus.STARTSTOP && pi.theStatus != PredicateStatus.FILTERING && pi.theStatus != PredicateStatus.TRUE || pi.theEpath != null && pi.isUnnested()) && !pi.isGeo()) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExprToReplace {
        Expr theExpr;
        int theIndexFieldPos;

        ExprToReplace(Expr expr, int pos) {
            this.theExpr = expr;
            this.theIndexFieldPos = pos;
        }
    }
}

