/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.IndexAnalyzer;
import oracle.kv.table.Index;

class OptRulePushIndexPreds {
    private RuntimeException theException = null;
    private ArrayList<IndexAnalyzer> theAnalyzers;
    private boolean theCompletePrimaryKey;

    OptRulePushIndexPreds() {
    }

    RuntimeException getException() {
        return this.theException;
    }

    void apply(Expr expr) {
        try {
            this.applyInternal(expr);
        }
        catch (RuntimeException e) {
            this.theException = e;
        }
    }

    void applyInternal(Expr expr) {
        boolean applied;
        if (expr.getKind() == Expr.ExprKind.SFW && (applied = this.applyOnSFW((ExprSFW)expr))) {
            return;
        }
        Expr.ExprIter children = expr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            this.applyInternal(child);
        }
        children.reset();
        if (expr.getKind() == Expr.ExprKind.UPDATE_ROW) {
            if (!this.theCompletePrimaryKey) {
                throw new QueryException("Multi-row update is not supported. A complete and exact primary key must be specified in the WHERE clause.");
            }
            return;
        }
    }

    boolean applyOnSFW(ExprSFW sfw) {
        ExprSFW.FromClause fc = sfw.getFirstFrom();
        ExprBaseTable tableExpr = fc.getTableExpr();
        if (tableExpr == null) {
            return false;
        }
        boolean hasSort = sfw.hasSort() || sfw.hasGroupBy() && sfw.getNumGroupByExprs() > 0;
        String sortingOp = sfw.hasSort() ? "order-by" : "group-by";
        ExprBaseTable.IndexHint forceIndexHint = tableExpr.getForceIndexHint();
        TableImpl table = tableExpr.getTargetTable();
        int tablePos = tableExpr.getTargetTablePos();
        Map<String, Index> indexes = table.getIndexes();
        this.theAnalyzers = new ArrayList(1 + indexes.size());
        IndexAnalyzer primaryAnalyzer = null;
        primaryAnalyzer = new IndexAnalyzer(sfw, tableExpr, tablePos, null);
        primaryAnalyzer.analyze();
        boolean bl = this.theCompletePrimaryKey = primaryAnalyzer.getPrimaryKeys() != null && primaryAnalyzer.getPrimaryKeys().get(0).isComplete();
        if (primaryAnalyzer.theSFW == null) {
            return true;
        }
        if (this.theCompletePrimaryKey) {
            sfw.removeSort();
        }
        if (!hasSort || sfw.hasNearPred() || sfw.hasPrimaryIndexBasedSort()) {
            this.theAnalyzers.add(primaryAnalyzer);
        }
        if (forceIndexHint != null) {
            IndexAnalyzer analyzer;
            String indexName;
            IndexImpl forcedIndex = forceIndexHint.theIndex;
            String string = indexName = forcedIndex == null ? "primary" : forcedIndex.getName();
            if (hasSort && (sfw.hasPrimaryIndexBasedSort() && forcedIndex != null || sfw.getSortingIndexes() != null && !sfw.getSortingIndexes().contains(forcedIndex))) {
                throw new QueryException("Cannot perform " + sortingOp + " because the index forced via a hint is not one of the sorting indexes.\nHint index : " + indexName + "\n", sfw.getLocation());
            }
            IndexAnalyzer indexAnalyzer = analyzer = forcedIndex == null ? primaryAnalyzer : new IndexAnalyzer(sfw, tableExpr, tablePos, forcedIndex);
            if (analyzer != primaryAnalyzer) {
                analyzer.analyze();
            }
            if (analyzer.theSFW == null) {
                return true;
            }
            if (analyzer.isRejected()) {
                throw new QueryException("The index forced via a hint cannot be used by the query.\nHint index    : " + indexName + "\n", sfw.getLocation());
            }
            analyzer.apply(primaryAnalyzer);
            return true;
        }
        if (this.theCompletePrimaryKey) {
            primaryAnalyzer.apply(null);
            return true;
        }
        if (sfw.hasPrimaryIndexBasedSort()) {
            primaryAnalyzer.apply(null);
            return true;
        }
        boolean alwaysFalse = false;
        if (sfw.hasSecondaryIndexBasedSort()) {
            for (IndexImpl index : sfw.getSortingIndexes()) {
                IndexAnalyzer analyzer = new IndexAnalyzer(sfw, tableExpr, tablePos, index);
                analyzer.analyze();
                if (!analyzer.isRejected()) {
                    this.theAnalyzers.add(analyzer);
                }
                if (analyzer.theSFW != null) continue;
                alwaysFalse = true;
                break;
            }
        } else {
            for (Map.Entry<String, Index> entry : indexes.entrySet()) {
                IndexImpl index = (IndexImpl)entry.getValue();
                IndexAnalyzer analyzer = new IndexAnalyzer(sfw, tableExpr, tablePos, index);
                analyzer.analyze();
                if (!analyzer.isRejected()) {
                    this.theAnalyzers.add(analyzer);
                }
                if (analyzer.theSFW != null) continue;
                alwaysFalse = true;
                break;
            }
        }
        if (!alwaysFalse) {
            this.chooseIndex(sfw, primaryAnalyzer);
        }
        return true;
    }

    void chooseIndex(ExprSFW sfw, IndexAnalyzer primaryAnalyzer) {
        IndexAnalyzer bestIndex = null;
        if (!this.theAnalyzers.isEmpty()) {
            bestIndex = Collections.min(this.theAnalyzers);
        }
        if (bestIndex == null || sfw.hasSecondaryIndexBasedSort() && bestIndex.isPrimary()) {
            String sortingOp = sfw.hasSort() ? "order-by" : "group-by";
            throw new QueryException("Cannot perform " + sortingOp + " because the index(es) that may be used for " + sortingOp + " cannot actually be used because they don't index NULL and non-existent field values.", sfw.getLocation());
        }
        bestIndex.apply(primaryAnalyzer);
    }
}

