/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.HashSet;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Distributer;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.OptRulePushIndexPreds;
import oracle.kv.impl.query.compiler.StatementFactory;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.compiler.Translator;
import oracle.kv.impl.query.compiler.parser.KVParser;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.util.CommonLoggerUtils;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PrepareCallback;
import oracle.kv.table.FieldRange;

public class QueryControlBlock {
    private final KVStoreImpl theStore;
    private final ExecuteOptions theOptions;
    private final char[] theQueryString;
    private final TableMetadataHelper theTableMetaHelper;
    private final StatementFactory theStatementFactory;
    private final StaticContext theInitSctx;
    private final String theNamespace;
    private final PrepareCallback thePrepareCallback;
    private boolean theStrictMode;
    private int theInternalVarCounter = 0;
    private CodeGenerator theCodegen;
    private RecordDefImpl theResultDef;
    private String theWrapRecordFieldName;
    private Expr theRootExpr;
    private PlanIter theRootPlanIter;
    private boolean theHasReceiveIter;
    private ReceiveIter theReceiveIter;
    private RuntimeException theException = null;
    private final HashSet<String> generatedNames = new HashSet();
    PrimaryKeyImpl thePushedPrimaryKey;
    PreparedStatementImpl.DistributionKind theDistributionKind;
    TableImpl theTargetTable;
    FieldRange thePushedRange;
    boolean theHaveJsonConstructors;
    boolean hasSort;
    boolean hasGroupBy;
    boolean hasGroupByExpr;
    boolean theGroupByExprCompleteShardKey;
    boolean hasGeoNear;
    boolean hasOffsetOrLimit;

    QueryControlBlock(TableAPIImpl tableAPI, ExecuteOptions options, char[] queryString, StaticContext sctx, String namespace, PrepareCallback prepareCallback) {
        this.theStore = tableAPI != null ? tableAPI.getStore() : null;
        this.theOptions = options;
        this.theQueryString = queryString;
        this.theTableMetaHelper = tableAPI != null ? tableAPI.getTableMetadataHelper() : (prepareCallback != null ? prepareCallback.getMetadataHelper() : null);
        this.theInitSctx = sctx;
        this.theStatementFactory = null;
        this.theNamespace = namespace;
        this.thePrepareCallback = prepareCallback;
    }

    QueryControlBlock(TableMetadataHelper metadataHelper, StatementFactory statementFactory, char[] queryString, StaticContext sctx, String namespace, PrepareCallback prepareCallback) {
        this.theStore = null;
        this.theOptions = new ExecuteOptions();
        this.theQueryString = queryString;
        this.theTableMetaHelper = metadataHelper;
        this.theInitSctx = sctx;
        this.theStatementFactory = statementFactory;
        this.theNamespace = namespace;
        this.thePrepareCallback = prepareCallback;
    }

    public KVStoreImpl getStore() {
        return this.theStore;
    }

    ExecuteOptions getOptions() {
        return this.theOptions;
    }

    TableMetadataHelper getTableMetaHelper() {
        return this.theTableMetaHelper;
    }

    public StaticContext getInitSctx() {
        return this.theInitSctx;
    }

    public String getNamespace() {
        return this.theNamespace;
    }

    public PrepareCallback getPrepareCallback() {
        return this.thePrepareCallback;
    }

    boolean strictMode() {
        return this.theStrictMode;
    }

    StatementFactory getStatementFactory() {
        return this.theStatementFactory;
    }

    public RuntimeException getException() {
        return this.theException;
    }

    public boolean succeeded() {
        return this.theException == null;
    }

    public String getErrorMessage() {
        return CommonLoggerUtils.getStackTrace(this.theException);
    }

    public Expr getRootExpr() {
        return this.theRootExpr;
    }

    void setRootExpr(Expr e) {
        this.theRootExpr = e;
    }

    public PrimaryKeyImpl getPushedPrimaryKey() {
        return this.thePushedPrimaryKey;
    }

    public PreparedStatementImpl.DistributionKind getDistributionKind() {
        return this.theDistributionKind;
    }

    public long getTargetTableId() {
        if (this.theTargetTable != null) {
            return this.theTargetTable.getId();
        }
        return 0L;
    }

    public int getTargetTableVersion() {
        if (this.theTargetTable != null) {
            return this.theTargetTable.getTableVersion();
        }
        return 0;
    }

    public String getTargetTableName() {
        if (this.theTargetTable != null) {
            return this.theTargetTable.getFullName();
        }
        return null;
    }

    public void setPushedPrimaryKey(PrimaryKeyImpl key) {
        this.thePushedPrimaryKey = key;
    }

    public void setDistributionKind(PreparedStatementImpl.DistributionKind kind) {
        this.theDistributionKind = kind;
    }

    public void setTargetTable(TableImpl table) {
        this.theTargetTable = table;
    }

    public RecordDefImpl getResultDef() {
        return this.theResultDef;
    }

    void setWrapResultInRecord(String name) {
        this.theWrapRecordFieldName = name;
    }

    public String getResultColumnName() {
        return this.theWrapRecordFieldName;
    }

    public char[] getQueryString() {
        return this.theQueryString;
    }

    public void setHasOffsetOrLimit(boolean hasOffsetOrLimit) {
        this.hasOffsetOrLimit = hasOffsetOrLimit;
    }

    public boolean hasOffsetOrLimit() {
        return this.hasOffsetOrLimit;
    }

    public boolean eliminatesDuplicates() {
        return this.theReceiveIter != null && this.theReceiveIter.eliminatesDuplicates();
    }

    void setGeoNear(boolean hasGeoNear) {
        this.hasGeoNear = hasGeoNear;
    }

    public boolean hasGeoNear() {
        return this.hasGeoNear;
    }

    void setHasSort(boolean hasSort) {
        this.hasSort = hasSort;
    }

    public boolean hasSort() {
        return this.hasSort;
    }

    void setHasGroupBy(boolean value) {
        this.hasGroupBy = value;
    }

    public boolean hasGroupBy() {
        return this.hasGroupBy;
    }

    void setHasGroupByExpr(boolean value) {
        this.hasGroupByExpr = value;
    }

    public boolean hasGroupByExpr() {
        return this.hasGroupByExpr;
    }

    void setGroupByExprCompleteShardKey(boolean value) {
        this.theGroupByExprCompleteShardKey = value;
    }

    public boolean getGroupByExprCompleteShardKey() {
        return this.theGroupByExprCompleteShardKey;
    }

    void compile() {
        KVParser parser = new KVParser();
        parser.parse(this.theQueryString);
        if (!parser.succeeded()) {
            this.theException = parser.getParseException();
            return;
        }
        Translator translator = new Translator(this);
        translator.translate(parser.getParseTree());
        this.theException = translator.getException();
        if (this.theException != null) {
            return;
        }
        if (translator.isQuery()) {
            this.theRootExpr = translator.getRootExpr();
            FieldDefImpl resDef1 = this.theRootExpr.getType().getDef();
            OptRulePushIndexPreds rule = new OptRulePushIndexPreds();
            rule.apply(this.theRootExpr);
            this.theException = rule.getException();
            if (this.theException != null) {
                return;
            }
            Distributer distributer = new Distributer(this);
            distributer.distributeQuery();
            CodeGenerator codegen = new CodeGenerator(this);
            codegen.generatePlan(this.theRootExpr);
            this.theException = codegen.getException();
            if (this.theException == null) {
                this.theRootPlanIter = codegen.getRootIter();
                FieldDefImpl resDef2 = this.theRootExpr.getType().getDef();
                if (resDef2.isRecord()) {
                    this.theResultDef = (RecordDefImpl)resDef2;
                } else if (!resDef2.isEmpty()) {
                    this.theException = new QueryStateException("Result does not have a record type");
                } else if (!resDef1.isRecord()) {
                    String fname = this.getResultColumnName();
                    if (fname == null) {
                        fname = "Column_1";
                    }
                    FieldMap fieldMap = new FieldMap();
                    fieldMap.put(fname, resDef1, this.theRootExpr.mayReturnNULL(), null);
                    this.theResultDef = FieldDefFactory.createRecordDef(fieldMap, null);
                } else {
                    this.theResultDef = (RecordDefImpl)resDef1;
                }
            }
        }
    }

    void parse() {
        KVParser parser = new KVParser();
        parser.parse(this.theQueryString);
        if (!parser.succeeded()) {
            this.theException = parser.getParseException();
            return;
        }
        Translator translator = new Translator(this);
        translator.translate(parser.getParseTree());
        this.theException = translator.getException();
        if (this.theException != null) {
            return;
        }
        if (translator.isQuery()) {
            this.theRootExpr = translator.getRootExpr();
            OptRulePushIndexPreds rule = new OptRulePushIndexPreds();
            rule.apply(this.theRootExpr);
            this.theException = rule.getException();
        }
    }

    String createInternalVarName(String prefix) {
        if (prefix == null) {
            return "$internVar-" + this.theInternalVarCounter++;
        }
        return "$" + prefix + "-" + this.theInternalVarCounter++;
    }

    void setCodegen(CodeGenerator v) {
        this.theCodegen = v;
    }

    public int getNumRegs() {
        return this.theCodegen.getNumRegs();
    }

    public int incNumPlanIters() {
        return this.theCodegen.incNumPlanIters();
    }

    public int getNumIterators() {
        return this.theCodegen.getNumIterators();
    }

    public PlanIter getQueryPlan() {
        return this.theRootPlanIter;
    }

    void setHasReceiveIter() {
        this.theHasReceiveIter = true;
    }

    public boolean hasReceiveIter() {
        return this.theHasReceiveIter;
    }

    public void setReceiveIter(ReceiveIter receiveIter) {
        this.theReceiveIter = receiveIter;
    }

    public ReceiveIter getReceiveIter() {
        return this.theReceiveIter;
    }

    public String displayExprTree() {
        return this.theRootExpr.display();
    }

    public String displayQueryPlan() {
        return this.theRootPlanIter.display();
    }

    String generateFieldName(String prefix) {
        String gen = "_gen";
        int num = 0;
        StringBuilder sb = new StringBuilder(prefix);
        sb.append("_gen");
        String name = sb.toString();
        while (this.generatedNames.contains(name)) {
            sb.append(num++);
            name = sb.toString();
        }
        this.generatedNames.add(name);
        return name;
    }
}

