/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;

public class ArithOpIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter[] theArgs;
    private final String theOps;
    private final transient int theInitResult;
    private final transient boolean theHaveRealDiv;

    public ArithOpIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter[] argIters, String ops, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theCode = code;
        assert ((this.theCode == FunctionLib.FuncCode.OP_ADD_SUB || this.theCode == FunctionLib.FuncCode.OP_MULT_DIV) && argIters.length >= 2);
        this.theArgs = argIters;
        this.theOps = ops;
        this.theHaveRealDiv = this.theOps.contains("d");
        switch (this.theCode) {
            case OP_ADD_SUB: {
                this.theInitResult = 0;
                break;
            }
            case OP_MULT_DIV: {
                this.theInitResult = 1;
                break;
            }
            default: {
                throw new QueryStateException("Invalid operation code: " + (Object)((Object)this.theCode));
            }
        }
    }

    public ArithOpIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = ArithOpIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theCode = FunctionLib.FuncCode.valueOf(ordinal);
        this.theArgs = ArithOpIter.deserializeIters(in, serialVersion);
        this.theOps = serialVersion >= 15 ? SerializationUtil.readString(in, serialVersion) : in.readUTF();
        this.theHaveRealDiv = this.theOps.contains("d");
        switch (this.theCode) {
            case OP_ADD_SUB: {
                this.theInitResult = 0;
                break;
            }
            case OP_MULT_DIV: {
                this.theInitResult = 1;
                break;
            }
            default: {
                throw new QueryStateException("Invalid operation code: " + (Object)((Object)this.theCode));
            }
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        ArithOpIter.serializeIters(this.theArgs, out, serialVersion);
        if (serialVersion >= 15) {
            SerializationUtil.writeString(out, serialVersion, this.theOps);
        } else {
            out.writeUTF(this.theOps);
        }
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        out.writeShort(this.theCode.ordinal());
        CloudSerializer.writeIters(this.theArgs, out, driverVersion, valWriter);
        CloudSerializer.writeString(this.theOps, out);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARITH_OP;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter argIter : this.theArgs) {
            argIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        FieldDef.Type resultType = this.theHaveRealDiv ? FieldDef.Type.DOUBLE : FieldDef.Type.INTEGER;
        block48: for (int i = 0; i < this.theArgs.length; ++i) {
            PlanIter argIter = this.theArgs[i];
            boolean opNext = argIter.next(rcb);
            if (!opNext) {
                state.done();
                return false;
            }
            opNext = argIter.next(rcb);
            if (opNext) {
                throw new QueryException("Operand in arithmetic operation returns more than one items.", argIter.getLocation());
            }
            FieldValueImpl argValue = rcb.getRegVal(argIter.getResultReg());
            if (argValue.isNull()) {
                NullValueImpl res = NullValueImpl.getInstance();
                rcb.setRegVal(this.theResultReg, res);
                state.done();
                return true;
            }
            FieldDef.Type argType = argValue.getType();
            switch (argType) {
                case INTEGER: {
                    continue block48;
                }
                case LONG: {
                    if (resultType != FieldDef.Type.INTEGER) continue block48;
                    resultType = FieldDef.Type.LONG;
                    continue block48;
                }
                case FLOAT: {
                    if (resultType != FieldDef.Type.INTEGER && resultType != FieldDef.Type.LONG) continue block48;
                    resultType = FieldDef.Type.FLOAT;
                    continue block48;
                }
                case DOUBLE: {
                    if (resultType != FieldDef.Type.INTEGER && resultType != FieldDef.Type.LONG && resultType != FieldDef.Type.FLOAT) continue block48;
                    resultType = FieldDef.Type.DOUBLE;
                    continue block48;
                }
                case NUMBER: {
                    resultType = FieldDef.Type.NUMBER;
                    continue block48;
                }
                default: {
                    throw new QueryException("Operand in arithmetic operation has illegal type\nOperand : " + i + " type :\n" + argValue.getDefinition().getDDLString(), argIter.getLocation());
                }
            }
        }
        assert (this.theOps.length() == this.theArgs.length) : "Not enough operations: ops:" + (this.theOps.length() - 1) + " args:" + this.theArgs.length;
        int iRes = this.theInitResult;
        long lRes = this.theInitResult;
        float fRes = this.theInitResult;
        double dRes = this.theInitResult;
        BigDecimal nRes = null;
        try {
            block49: for (int i = 0; i < this.theArgs.length; ++i) {
                PlanIter argIter = this.theArgs[i];
                FieldValueImpl argValue = rcb.getRegVal(argIter.getResultReg());
                assert (argValue != null);
                if (this.theCode == FunctionLib.FuncCode.OP_ADD_SUB) {
                    if (this.theOps.charAt(i) == '+') {
                        switch (resultType) {
                            case INTEGER: {
                                iRes += argValue.castAsInt();
                                continue block49;
                            }
                            case LONG: {
                                lRes += argValue.castAsLong();
                                continue block49;
                            }
                            case FLOAT: {
                                fRes += argValue.castAsFloat();
                                continue block49;
                            }
                            case DOUBLE: {
                                dRes += argValue.castAsDouble();
                                continue block49;
                            }
                            case NUMBER: {
                                if (nRes == null) {
                                    nRes = argValue.castAsDecimal();
                                    continue block49;
                                }
                                nRes = nRes.add(argValue.castAsDecimal(), rcb.getMathContext());
                                continue block49;
                            }
                            default: {
                                throw new QueryStateException("Invalid result type: " + resultType);
                            }
                        }
                    }
                    switch (resultType) {
                        case INTEGER: {
                            iRes -= argValue.castAsInt();
                            continue block49;
                        }
                        case LONG: {
                            lRes -= argValue.castAsLong();
                            continue block49;
                        }
                        case FLOAT: {
                            fRes -= argValue.castAsFloat();
                            continue block49;
                        }
                        case DOUBLE: {
                            dRes -= argValue.castAsDouble();
                            continue block49;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = argValue.castAsDecimal().negate();
                                continue block49;
                            }
                            nRes = nRes.subtract(argValue.castAsDecimal(), rcb.getMathContext());
                            continue block49;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + resultType);
                        }
                    }
                }
                if (this.theOps.charAt(i) == '*') {
                    switch (resultType) {
                        case INTEGER: {
                            iRes *= argValue.castAsInt();
                            continue block49;
                        }
                        case LONG: {
                            lRes *= argValue.castAsLong();
                            continue block49;
                        }
                        case FLOAT: {
                            fRes *= argValue.castAsFloat();
                            continue block49;
                        }
                        case DOUBLE: {
                            dRes *= argValue.castAsDouble();
                            continue block49;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = argValue.castAsDecimal();
                                continue block49;
                            }
                            nRes = nRes.multiply(argValue.castAsDecimal(), rcb.getMathContext());
                            continue block49;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + resultType);
                        }
                    }
                }
                if (this.theOps.charAt(i) == '/') {
                    switch (resultType) {
                        case INTEGER: {
                            iRes /= argValue.castAsInt();
                            continue block49;
                        }
                        case LONG: {
                            lRes /= argValue.castAsLong();
                            continue block49;
                        }
                        case FLOAT: {
                            fRes /= argValue.castAsFloat();
                            continue block49;
                        }
                        case DOUBLE: {
                            dRes /= argValue.castAsDouble();
                            continue block49;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = new BigDecimal(1);
                            }
                            nRes = nRes.divide(argValue.castAsDecimal(), rcb.getMathContext());
                            continue block49;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + resultType);
                        }
                    }
                }
                switch (resultType) {
                    case DOUBLE: {
                        dRes /= argValue.castAsDouble();
                        continue block49;
                    }
                    case NUMBER: {
                        if (nRes == null) {
                            nRes = new BigDecimal(1);
                        }
                        nRes = nRes.divide(argValue.castAsDecimal(), rcb.getMathContext());
                        continue block49;
                    }
                    default: {
                        throw new QueryStateException("Invalid result type: " + resultType);
                    }
                }
            }
        }
        catch (ArithmeticException ae) {
            throw new QueryException("Arithmetic exception in query: " + ae.getMessage(), ae, this.getLocation());
        }
        FieldValueImpl res = null;
        switch (resultType) {
            case INTEGER: {
                res = FieldDefImpl.integerDef.createInteger(iRes);
                break;
            }
            case LONG: {
                res = FieldDefImpl.longDef.createLong(lRes);
                break;
            }
            case FLOAT: {
                res = FieldDefImpl.floatDef.createFloat(fRes);
                break;
            }
            case DOUBLE: {
                res = FieldDefImpl.doubleDef.createDouble(dRes);
                break;
            }
            case NUMBER: {
                res = FieldDefImpl.numberDef.createNumber(nRes);
                break;
            }
            default: {
                throw new QueryStateException("Invalid result type: " + resultType);
            }
        }
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter argIter : this.theArgs) {
            argIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter argIter : this.theArgs) {
            argIter.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i = 0;
        for (PlanIter argIter : this.theArgs) {
            formatter.indent(sb);
            if (this.theCode == FunctionLib.FuncCode.OP_ADD_SUB) {
                if (this.theOps.charAt(i) == '+') {
                    sb.append('+');
                } else {
                    sb.append('-');
                }
            } else if (this.theOps.charAt(i) == '*') {
                sb.append('*');
            } else if (this.theOps.charAt(i) == 'd') {
                sb.append("div");
            } else {
                sb.append('/');
            }
            sb.append(",\n");
            argIter.display(sb, formatter);
            if (i < this.theArgs.length - 1) {
                sb.append(",\n");
            }
            ++i;
        }
    }
}

