/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldRange;

public class BaseTableIter
extends PlanIter {
    protected final String theNamespace;
    protected final String[] theTableNames;
    protected final int theNumAncestors;
    protected final int theNumDescendants;
    protected final String theIndexName;
    protected final RecordDefImpl theTypeDef;
    protected final Direction theDirection;
    protected final RecordValueImpl[] thePrimKeys;
    protected final RecordValueImpl[] theSecKeys;
    protected final FieldRange[] theRanges;
    protected PlanIter[] thePredIters;
    protected final boolean[] theUsesCoveringIndex;
    protected final boolean theEliminateIndexDups;
    protected final boolean theIsUpdate;
    protected final boolean theIsDelete;
    protected final PlanIter[][] thePushedExternals;
    protected final int[] theTupleRegs;
    protected int[] theIndexTupleRegs;
    protected int theIndexResultReg;
    protected short theVersion;

    public BaseTableIter(Expr e, int resultReg, int[] tupleRegs, TableImpl table, List<TableImpl> tables, int numAncestors, int numDescendants, Direction dir, ArrayList<PrimaryKeyImpl> primKeys, ArrayList<IndexKeyImpl> secKeys, ArrayList<FieldRange> ranges, boolean[] coveringIndexes, boolean eliminateIndexDups, boolean isUpdate, boolean isDelete, PlanIter[] pushedExternals) {
        super(e, resultReg);
        int i;
        assert (primKeys == null || secKeys == null);
        assert (ranges == null || primKeys != null || secKeys != null);
        this.theNamespace = table.getInternalNamespace();
        this.theTableNames = new String[tables.size()];
        for (int i2 = 0; i2 < tables.size(); ++i2) {
            this.theTableNames[i2] = tables.get(i2).getFullName();
        }
        this.theNumAncestors = numAncestors;
        this.theNumDescendants = numDescendants;
        this.theTypeDef = (RecordDefImpl)e.getType().getDef();
        this.theDirection = dir;
        int numRanges = 1;
        if (primKeys == null && secKeys == null) {
            this.theSecKeys = null;
            this.theIndexName = null;
            this.thePrimKeys = new RecordValueImpl[numRanges];
            this.theRanges = new FieldRange[numRanges];
            this.thePrimKeys[0] = table.createPrimaryKey();
            this.theRanges[0] = null;
        } else if (primKeys != null) {
            this.theSecKeys = null;
            this.theIndexName = null;
            numRanges = ranges.size();
            this.thePrimKeys = new RecordValueImpl[numRanges];
            this.theRanges = new FieldRange[numRanges];
            for (i = 0; i < numRanges; ++i) {
                this.thePrimKeys[i] = table.createPrimaryKey();
                this.thePrimKeys[i].copyFrom(primKeys.get(i));
                this.theRanges[i] = ranges.get(i);
            }
        } else {
            this.thePrimKeys = null;
            this.theIndexName = secKeys.get(0).getIndex().getName();
            numRanges = ranges.size();
            this.theSecKeys = new RecordValueImpl[numRanges];
            this.theRanges = new FieldRange[numRanges];
            for (i = 0; i < numRanges; ++i) {
                this.theSecKeys[i] = secKeys.get(i).clone();
                this.theRanges[i] = ranges.get(i);
            }
        }
        this.thePredIters = new PlanIter[this.theTableNames.length];
        this.theUsesCoveringIndex = coveringIndexes;
        this.theEliminateIndexDups = eliminateIndexDups;
        this.theIsUpdate = isUpdate;
        this.theIsDelete = isDelete;
        this.thePushedExternals = new PlanIter[numRanges][];
        for (i = 0; i < numRanges; ++i) {
            this.thePushedExternals[i] = pushedExternals;
        }
        this.theTupleRegs = tupleRegs;
    }

    protected BaseTableIter(BaseTableIter parent) {
        super(parent.theStatePos, parent.theResultReg, parent.theLocation);
        this.theNamespace = parent.theNamespace;
        this.theTableNames = parent.theTableNames;
        this.thePredIters = parent.thePredIters;
        this.theNumAncestors = parent.theNumAncestors;
        this.theNumDescendants = parent.theNumDescendants;
        this.theIndexName = parent.theIndexName;
        this.theTypeDef = parent.theTypeDef;
        this.theDirection = parent.theDirection;
        this.thePrimKeys = parent.thePrimKeys;
        this.theSecKeys = parent.theSecKeys;
        this.theRanges = parent.theRanges;
        this.theUsesCoveringIndex = parent.theUsesCoveringIndex;
        this.theEliminateIndexDups = parent.theEliminateIndexDups;
        this.theIsUpdate = parent.theIsUpdate;
        this.theIsDelete = parent.theIsDelete;
        this.thePushedExternals = parent.thePushedExternals;
        this.theTupleRegs = parent.theTupleRegs;
        this.theIndexResultReg = parent.theIndexResultReg;
        this.theIndexTupleRegs = parent.theIndexTupleRegs;
        this.theVersion = parent.theVersion;
    }

    BaseTableIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        int i;
        this.theVersion = serialVersion;
        this.theNamespace = serialVersion >= 14 ? SerializationUtil.readString(in, serialVersion) : null;
        if (serialVersion >= 16) {
            this.theTableNames = PlanIter.deserializeStringArray(in, serialVersion);
            this.theNumAncestors = in.readInt();
            this.theNumDescendants = in.readInt();
        } else {
            this.theTableNames = new String[1];
            this.theTableNames[0] = SerializationUtil.readString(in, serialVersion);
            this.theNumAncestors = 0;
            this.theNumDescendants = 0;
        }
        this.theIndexName = SerializationUtil.readString(in, serialVersion);
        this.theTypeDef = (RecordDefImpl)BaseTableIter.deserializeFieldDef(in, serialVersion);
        short ordinal = BaseTableIter.readOrdinal(in, Direction.values().length);
        this.theDirection = Direction.valueOf(ordinal);
        int numRanges = 1;
        if (serialVersion >= 15) {
            numRanges = BaseTableIter.readPositiveInt(in);
        }
        if (this.theIndexName == null) {
            this.thePrimKeys = new RecordValueImpl[numRanges];
            for (i = 0; i < numRanges; ++i) {
                this.thePrimKeys[i] = BaseTableIter.deserializeKey(in, serialVersion);
            }
            this.theSecKeys = null;
        } else {
            this.thePrimKeys = null;
            this.theSecKeys = new RecordValueImpl[numRanges];
            for (i = 0; i < numRanges; ++i) {
                this.theSecKeys[i] = BaseTableIter.deserializeKey(in, serialVersion);
            }
        }
        this.theRanges = new FieldRange[numRanges];
        for (i = 0; i < numRanges; ++i) {
            this.theRanges[i] = BaseTableIter.deserializeFieldRange(in, serialVersion);
        }
        if (serialVersion >= 16) {
            this.theUsesCoveringIndex = PlanIter.deserializeBooleanArray(in);
        } else {
            this.theUsesCoveringIndex = new boolean[1];
            this.theUsesCoveringIndex[0] = in.readBoolean();
        }
        this.theEliminateIndexDups = serialVersion < 12 ? false : in.readBoolean();
        this.theIsUpdate = serialVersion < 15 ? false : in.readBoolean();
        this.theIsDelete = serialVersion < 18 ? false : in.readBoolean();
        this.thePushedExternals = new PlanIter[numRanges][];
        for (i = 0; i < numRanges; ++i) {
            this.thePushedExternals[i] = BaseTableIter.deserializeIters(in, serialVersion);
        }
        if (serialVersion >= 16) {
            this.thePredIters = PlanIter.deserializeIters(in, serialVersion);
        } else {
            PlanIter filterIter = BaseTableIter.deserializeIter(in, serialVersion);
            this.thePredIters = new PlanIter[1];
            this.thePredIters[0] = filterIter;
        }
        this.theTupleRegs = BaseTableIter.deserializeIntArray(in, serialVersion);
        if (serialVersion < 16) {
            this.theIndexResultReg = -1;
            this.theIndexTupleRegs = null;
        } else {
            this.theIndexResultReg = BaseTableIter.readPositiveInt(in, true);
            this.theIndexTupleRegs = BaseTableIter.deserializeIntArray(in, serialVersion);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeString(out, serialVersion, this.theNamespace);
        }
        if (serialVersion >= 16) {
            PlanIter.serializeStringArray(this.theTableNames, out, serialVersion);
            out.writeInt(this.theNumAncestors);
            out.writeInt(this.theNumDescendants);
        } else if (this.theTableNames.length == 1) {
            SerializationUtil.writeString(out, serialVersion, this.theTableNames[0]);
        } else {
            String QV6String = SerialVersion.getKVVersion((short)16).getNumericVersionString();
            throw new QueryException("Cannot execute a query with a NESTED TABLES clause at a server whose version is less than " + QV6String + "\nserialVersion = " + serialVersion + " expected version = " + 16);
        }
        SerializationUtil.writeString(out, serialVersion, this.theIndexName);
        BaseTableIter.serializeFieldDef(this.theTypeDef, out, serialVersion);
        out.writeShort(this.theDirection.ordinal());
        if (serialVersion >= 15) {
            if (this.theIndexName == null) {
                out.writeInt(this.thePrimKeys.length);
                for (RecordValueImpl recordValueImpl : this.thePrimKeys) {
                    BaseTableIter.serializeKey(recordValueImpl, out, serialVersion);
                }
            } else {
                out.writeInt(this.theSecKeys.length);
                for (RecordValueImpl recordValueImpl : this.theSecKeys) {
                    BaseTableIter.serializeKey(recordValueImpl, out, serialVersion);
                }
            }
            for (Cloneable cloneable : this.theRanges) {
                BaseTableIter.serializeFieldRange((FieldRange)cloneable, out, serialVersion);
            }
        } else if (this.theIndexName == null && this.thePrimKeys.length == 1) {
            BaseTableIter.serializeKey(this.thePrimKeys[0], out, serialVersion);
            BaseTableIter.serializeFieldRange(this.theRanges[0], out, serialVersion);
        } else if (this.theIndexName != null && this.theSecKeys.length == 1) {
            BaseTableIter.serializeKey(this.theSecKeys[0], out, serialVersion);
            BaseTableIter.serializeFieldRange(this.theRanges[0], out, serialVersion);
        } else {
            String QV5String = SerialVersion.getKVVersion((short)15).getNumericVersionString();
            throw new QueryException("Cannot execute a query that scans more than one ranges inside an index at a server whose version is less than " + QV5String + "\nserialVersion = " + serialVersion + " expected version = " + 15);
        }
        if (serialVersion >= 16) {
            PlanIter.serializeBooleanArray(this.theUsesCoveringIndex, out);
        } else {
            out.writeBoolean(this.theUsesCoveringIndex[0]);
        }
        if (serialVersion >= 12) {
            out.writeBoolean(this.theEliminateIndexDups);
        }
        if (serialVersion >= 15) {
            out.writeBoolean(this.theIsUpdate);
        }
        if (serialVersion >= 18) {
            out.writeBoolean(this.theIsUpdate);
        }
        if (serialVersion >= 15) {
            for (int i = 0; i < this.thePushedExternals.length; ++i) {
                BaseTableIter.serializeIters(this.thePushedExternals[i], out, serialVersion);
            }
        } else {
            BaseTableIter.serializeIters(this.thePushedExternals[0], out, serialVersion);
        }
        if (serialVersion >= 16) {
            BaseTableIter.serializeIters(this.thePredIters, out, serialVersion);
        } else if (this.thePredIters != null) {
            assert (this.thePredIters.length == 1);
            BaseTableIter.serializeIter(this.thePredIters[0], out, serialVersion);
        } else {
            BaseTableIter.serializeIter(null, out, serialVersion);
        }
        BaseTableIter.serializeIntArray(this.theTupleRegs, out, serialVersion);
        if (serialVersion < 16) {
            String QV6String = SerialVersion.getKVVersion((short)16).getNumericVersionString();
            throw new QueryException("Cannot execute a query that uses a covering index or applies index-filtering predicates at a server whose version is less than " + QV6String + "\nserialVersion = " + serialVersion + " expected version = " + 16);
        }
        out.writeInt(this.theIndexResultReg);
        BaseTableIter.serializeIntArray(this.theIndexTupleRegs, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.BASE_TABLE;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    public void setPredIter(int tablePos, PlanIter iter) {
        this.thePredIters[tablePos] = iter;
    }

    protected PlanIter getTargetTablePred() {
        if (this.thePredIters.length > 0) {
            return this.thePredIters[this.theNumAncestors];
        }
        return null;
    }

    public void setIndexRegs(int resultReg, int[] tupleRegs) {
        this.theIndexResultReg = resultReg;
        this.theIndexTupleRegs = tupleRegs;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        PlanIter worker = rcb.getServerIterFactory().createTableIter(rcb, this);
        worker.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        TableIterState state = (TableIterState)rcb.getState(this.theStatePos);
        if (state.theWorkerIter != null) {
            return state.theWorkerIter.next(rcb);
        }
        state.done();
        return false;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        TableIterState state = (TableIterState)rcb.getState(this.theStatePos);
        if (state.theWorkerIter != null) {
            state.theWorkerIter.reset(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        TableIterState state = (TableIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        if (state.theWorkerIter != null) {
            state.theWorkerIter.close(rcb);
        }
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append((Object)this.getKind());
        this.displayRegs(sb);
        if (this.theIndexTupleRegs != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("Index entry regs: ").append("(");
            sb.append("[").append(this.theIndexResultReg).append("], ");
            for (int i = 0; i < this.theIndexTupleRegs.length; ++i) {
                sb.append(this.theIndexTupleRegs[i]);
                if (i >= this.theIndexTupleRegs.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        this.displayContent(sb, formatter);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        int numRanges = this.theRanges.length;
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        formatter.indent(sb);
        sb.append(NameUtils.makeQualifiedName(this.theNamespace, this.theTableNames[this.theNumAncestors]));
        if (this.thePrimKeys != null) {
            if (this.theUsesCoveringIndex[this.theNumAncestors]) {
                sb.append(" via covering primary index");
            } else {
                sb.append(" via primary index");
            }
            for (i = 0; i < numRanges; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("KEY: ");
                sb.append(this.thePrimKeys[i]);
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRanges[i]);
                this.displayPushedExternals(sb, formatter, i);
            }
        }
        if (this.theSecKeys != null) {
            if (this.theUsesCoveringIndex[this.theNumAncestors]) {
                sb.append(" via covering index ");
            } else {
                sb.append(" via index ");
            }
            sb.append(this.theIndexName);
            if (this.theEliminateIndexDups) {
                sb.append(" with duplicate elimination");
            }
            for (i = 0; i < numRanges; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append("SEC KEY: ");
                sb.append(this.theSecKeys[i]);
                sb.append("\n");
                formatter.indent(sb);
                sb.append("RANGE: ");
                sb.append(this.theRanges[i]);
                this.displayPushedExternals(sb, formatter, i);
            }
        }
        if (this.theNumAncestors > 0) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("Ancestors :");
            for (i = 0; i < this.theNumAncestors; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append(this.theTableNames[i]);
                if (this.theUsesCoveringIndex[i]) {
                    sb.append(" via covering primary index");
                    continue;
                }
                sb.append(" via primary index");
            }
        }
        if (this.theNumDescendants > 0) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("Descendantss :");
            for (i = this.theNumAncestors + 1; i < this.theTableNames.length; ++i) {
                sb.append("\n");
                formatter.indent(sb);
                sb.append(this.theTableNames[i]);
                if (this.theUsesCoveringIndex[i]) {
                    sb.append(" via covering primary index");
                    continue;
                }
                sb.append(" via primary index");
            }
        }
        if (this.thePredIters != null) {
            if (this.thePredIters[this.theNumAncestors] != null) {
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("Filtering Predicate:\n");
                this.thePredIters[this.theNumAncestors].display(sb, formatter);
            }
            for (i = 0; i < this.theTableNames.length; ++i) {
                if (i == this.theNumAncestors || this.thePredIters[i] == null) continue;
                sb.append("\n\n");
                formatter.indent(sb);
                sb.append("ON Predicate for table ").append(this.theTableNames[i]).append(":\n");
                this.thePredIters[i].display(sb, formatter);
            }
        }
        sb.append("\n");
        formatter.decIndent();
        formatter.indent(sb);
        sb.append("]");
    }

    private void displayPushedExternals(StringBuilder sb, QueryFormatter formatter, int pos) {
        if (this.thePushedExternals == null) {
            return;
        }
        PlanIter[] pushedExternals = this.thePushedExternals[pos];
        if (pushedExternals == null) {
            return;
        }
        sb.append("\n\n");
        formatter.indent(sb);
        sb.append("EXTERNAL KEY EXPRS: ");
        sb.append(pushedExternals.length);
        for (PlanIter iter : pushedExternals) {
            sb.append("\n");
            if (iter != null) {
                iter.display(sb, formatter);
                continue;
            }
            formatter.indent(sb);
            sb.append("null");
        }
    }

    protected static FieldValueImpl castValueToIndexKey(TableImpl table, IndexImpl index, int keyPos, FieldValueImpl val, FunctionLib.FuncCode opcode) {
        if (index != null) {
            return FuncCompOp.castConstInCompOp(index.getFieldDef(keyPos), index.getIndexPath(keyPos).isJson(), false, true, val, opcode, false);
        }
        return FuncCompOp.castConstInCompOp(table.getPrimKeyColumnDef(keyPos), false, false, true, val, opcode, false);
    }

    public static class TableIterState
    extends PlanIterState {
        PlanIter theWorkerIter;

        public TableIterState(PlanIter worker) {
            this.theWorkerIter = worker;
        }
    }
}

