/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import com.sleepycat.util.PackedInteger;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.table.FieldValue;

public class CloudSerializer {
    private static final Charset utf8 = Charset.forName("UTF-8");

    public static void writeSortedPackedInt(DataOutput out, int value) throws IOException {
        byte[] buf = new byte[5];
        int offset = PackedInteger.writeSortedInt(buf, 0, value);
        out.write(buf, 0, offset);
    }

    public static void writeArrayLength(DataOutput out, Object array) throws IOException {
        int len;
        int n = len = array != null ? Array.getLength(array) : -1;
        if (len < -1) {
            throw new IllegalArgumentException("Invalid sequence length: " + len);
        }
        CloudSerializer.writeSortedPackedInt(out, len);
    }

    public static void writeString(String str, DataOutput out) throws IOException {
        if (str == null) {
            CloudSerializer.writeSortedPackedInt(out, -1);
            return;
        }
        ByteBuffer buffer = utf8.encode(str);
        int length = buffer.limit();
        CloudSerializer.writeSortedPackedInt(out, length);
        if (length > 0) {
            out.write(buffer.array(), 0, length);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] array) throws IOException {
        int length = array == null ? -1 : Array.getLength(array);
        CloudSerializer.writeArrayLength(out, array);
        if (length > 0) {
            out.write(array);
        }
    }

    public static void writeIntArray(int[] array, boolean packed, DataOutput out) throws IOException {
        CloudSerializer.writeArrayLength(out, array);
        if (array != null) {
            for (int val : array) {
                if (packed) {
                    CloudSerializer.writeSortedPackedInt(out, val);
                    continue;
                }
                out.writeInt(val);
            }
        }
    }

    static void writeStringArray(String[] array, DataOutput out) throws IOException {
        CloudSerializer.writeArrayLength(out, array);
        if (array != null) {
            for (String s : array) {
                CloudSerializer.writeString(s, out);
            }
        }
    }

    public static void writeIter(PlanIter iter, DataOutput out, short driverVersion, FieldValueWriter valWriter) throws IOException {
        if (iter == null) {
            out.writeByte(-1);
            return;
        }
        iter.writeForCloud(out, driverVersion, valWriter);
    }

    static void writeIters(PlanIter[] iters, DataOutput out, short driverVersion, FieldValueWriter valWriter) throws IOException {
        CloudSerializer.writeArrayLength(out, iters);
        for (PlanIter iter : iters) {
            iter.writeForCloud(out, driverVersion, valWriter);
        }
    }

    static void writeSortSpecs(SortSpec[] array, DataOutput out) throws IOException {
        CloudSerializer.writeArrayLength(out, array);
        if (array != null) {
            for (SortSpec s : array) {
                out.writeBoolean(s.theIsDesc);
                out.writeBoolean(s.theNullsFirst);
            }
        }
    }

    public static interface FieldValueWriter {
        public void writeFieldValue(DataOutput var1, FieldValue var2) throws IOException;
    }
}

