/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Stack;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;

public class FieldStepIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final PlanIter theFieldNameIter;
    private final String theFieldName;
    private final int theFieldPos;
    private final int theCtxItemReg;

    public FieldStepIter(Expr e, int resultReg, PlanIter inputIter, PlanIter fieldNameIter, String fieldName, int fieldPos, int ctxItemReg, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theInputIter = inputIter;
        this.theFieldNameIter = fieldNameIter;
        this.theFieldName = fieldName;
        this.theFieldPos = fieldPos;
        this.theCtxItemReg = ctxItemReg;
    }

    FieldStepIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theCtxItemReg = in.readInt();
        this.theFieldPos = in.readInt();
        this.theInputIter = FieldStepIter.deserializeIter(in, serialVersion);
        this.theFieldName = SerializationUtil.readString(in, serialVersion);
        boolean fieldNameIterExists = in.readBoolean();
        this.theFieldNameIter = fieldNameIterExists ? FieldStepIter.deserializeIter(in, serialVersion) : null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        out.writeInt(this.theFieldPos);
        FieldStepIter.serializeIter(this.theInputIter, out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.theFieldName);
        if (this.theFieldNameIter != null) {
            out.writeBoolean(true);
            FieldStepIter.serializeIter(this.theFieldNameIter, out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        this.theInputIter.writeForCloud(out, driverVersion, valWriter);
        CloudSerializer.writeString(this.theFieldName, out);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FIELD_STEP;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FieldStepState(this));
        this.theInputIter.open(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValueImpl result;
        FieldStepState state = (FieldStepState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        int inputReg = this.theInputIter.getResultReg();
        if (this.theFieldPos >= 0 && state.theHasTupleInput) {
            assert (this.theFieldName != null);
            assert (this.theInputIter.getTupleRegs() != null);
            boolean more = this.theInputIter.next(rcb);
            FieldValueImpl val = rcb.getRegVal(this.theResultReg);
            if (!more || val == EmptyValueImpl.getInstance()) {
                state.done();
                return false;
            }
            state.theCtxItem = rcb.getRegVal(inputReg);
            return true;
        }
        if (this.theFieldName == null && this.theCtxItemReg < 0) {
            this.computeFieldName(rcb, state, false);
            if (state.theFieldName == null) {
                state.done();
                return false;
            }
        }
        while (true) {
            FieldDef.Type ctxItemKind;
            FieldValueImpl ctxItem = null;
            if (state.theArrays.isEmpty()) {
                boolean more = this.theInputIter.next(rcb);
                ctxItem = rcb.getRegVal(inputReg);
                if (!more || ctxItem == EmptyValueImpl.getInstance()) {
                    state.done();
                    return false;
                }
                ctxItem = rcb.getRegVal(inputReg);
                if (ctxItem.isAtomic()) continue;
                if (ctxItem.isNull()) {
                    rcb.setRegVal(this.theResultReg, ctxItem);
                    state.theCtxItem = ctxItem;
                    return true;
                }
                ctxItemKind = ctxItem.getType();
            } else {
                ArrayAndPos arrayCtx = state.theArrays.peek();
                ArrayValueImpl array = arrayCtx.theArray;
                ctxItem = array.getElement(arrayCtx.thePos);
                ctxItemKind = ctxItem.getType();
                ++arrayCtx.thePos;
                if (arrayCtx.thePos >= array.size()) {
                    state.theArrays.pop();
                }
                if (ctxItem.isAtomic()) continue;
            }
            if (ctxItemKind == FieldDef.Type.ARRAY) {
                ArrayValueImpl array = (ArrayValueImpl)ctxItem;
                if (array.size() <= 0) continue;
                ArrayAndPos arrayCtx = new ArrayAndPos(array);
                state.theArrays.push(arrayCtx);
                continue;
            }
            if (ctxItemKind != FieldDef.Type.RECORD && ctxItemKind != FieldDef.Type.MAP) {
                throw new QueryException("Input value in field step has invalid type.\nExpected a complex type. Actual type is:\n" + ctxItem.getDefinition(), this.getLocation());
            }
            state.theCtxItem = ctxItem;
            if (this.theCtxItemReg >= 0) {
                this.computeFieldName(rcb, state, true);
                if (state.theFieldName == null) continue;
            }
            if (ctxItemKind == FieldDef.Type.RECORD) {
                if (ctxItem.isTuple()) {
                    TupleValue tuple = (TupleValue)ctxItem;
                    state.theFieldPos = this.theFieldPos >= 0 ? this.theFieldPos : tuple.getFieldPos(state.theFieldName);
                    result = tuple.get(state.theFieldPos);
                } else {
                    RecordValueImpl rec = (RecordValueImpl)ctxItem;
                    state.theFieldPos = this.theFieldPos >= 0 ? this.theFieldPos : rec.getFieldPos(state.theFieldName);
                    result = rec.get(state.theFieldPos);
                }
                if (result != null) break;
                throw new QueryException("There is no field named " + state.theFieldName + " in record\n" + ctxItem + "with type\n" + ctxItem.getDefinition(), this.getLocation());
            }
            assert (ctxItemKind == FieldDef.Type.MAP);
            MapValueImpl map = (MapValueImpl)ctxItem;
            result = map.get(state.theFieldName);
            if (result != null) break;
        }
        rcb.setRegVal(this.theResultReg, result);
        return true;
    }

    void computeFieldName(RuntimeControlBlock rcb, FieldStepState state, boolean reset) {
        boolean more;
        if (reset) {
            this.theFieldNameIter.reset(rcb);
        }
        if (this.theCtxItemReg >= 0) {
            rcb.setRegVal(this.theCtxItemReg, state.theCtxItem);
        }
        if (!(more = this.theFieldNameIter.next(rcb))) {
            state.theFieldName = null;
            return;
        }
        int nameReg = this.theFieldNameIter.getResultReg();
        FieldValueImpl name = rcb.getRegVal(nameReg);
        state.theFieldName = name.isNull() ? null : name.getString();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.close(rcb);
        }
        state.close();
    }

    @Override
    void getParentItemContext(RuntimeControlBlock rcb, PlanIter.ParentItemContext ctx) {
        FieldStepState state = (FieldStepState)rcb.getState(this.theStatePos);
        ctx.theParentItem = state.theCtxItem;
        ctx.theTargetPos = state.theFieldPos;
        ctx.theTargetKey = state.theFieldName;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append(",\n");
        if (this.theFieldNameIter != null) {
            this.theFieldNameIter.display(sb, formatter);
        } else {
            formatter.indent(sb);
            sb.append(this.theFieldName);
        }
        sb.append(",\n");
        formatter.indent(sb);
        sb.append("theFieldPos : ").append(this.theFieldPos);
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
    }

    private static class FieldStepState
    extends PlanIterState {
        final boolean theHasTupleInput;
        Stack<ArrayAndPos> theArrays = new Stack();
        FieldValueImpl theCtxItem = null;
        String theFieldName;
        int theFieldPos;

        FieldStepState(FieldStepIter iter) {
            this.theFieldName = iter.theFieldName;
            this.theFieldPos = iter.theFieldPos;
            this.theHasTupleInput = iter.theInputIter.producesTuples();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            if (this.theArrays != null) {
                this.theArrays.clear();
            }
            this.theCtxItem = null;
            this.theFieldName = ((FieldStepIter)iter).theFieldName;
            this.theFieldPos = ((FieldStepIter)iter).theFieldPos;
        }

        @Override
        public void close() {
            super.close();
            this.theArrays = null;
            this.theCtxItem = null;
            this.theFieldName = null;
        }
    }

    private static class ArrayAndPos {
        ArrayValueImpl theArray;
        int thePos;

        ArrayAndPos(ArrayValueImpl array) {
            this.theArray = array;
            this.thePos = 0;
        }
    }
}

