/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncCountIter
extends PlanIter {
    private final PlanIter theInput;
    private final FunctionLib.FuncCode theFuncCode;

    public FuncCountIter(Expr e, int resultReg, PlanIter input, FunctionLib.FuncCode code) {
        super(e, resultReg);
        this.theInput = input;
        this.theFuncCode = code;
    }

    FuncCountIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncCountIter.deserializeIter(in, serialVersion);
        short ordinal = in.readShort();
        this.theFuncCode = FunctionLib.FuncCode.valueOf(ordinal);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncCountIter.serializeIter(this.theInput, out, serialVersion);
        out.writeShort(this.theFuncCode.ordinal());
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_COUNT;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theFuncCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FuncCountState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more;
        while (more = this.theInput.next(rcb)) {
            FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
            if (val.isNull() || this.theFuncCode == FunctionLib.FuncCode.FN_COUNT_NUMBERS && !val.isNumeric()) continue;
            ++state.theCount;
        }
        return true;
    }

    @Override
    void initAggrValue(RuntimeControlBlock rcb, FieldValueImpl val) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        state.theCount = val != null ? ((LongValueImpl)val).get() : 0L;
    }

    @Override
    FieldValueImpl getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        LongValueImpl res = FieldDefImpl.longDef.createLong(state.theCount);
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }

    static class FuncCountState
    extends PlanIterState {
        long theCount;

        FuncCountState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCount = 0L;
        }
    }
}

