/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncCountStarIter
extends PlanIter {
    public FuncCountStarIter(Expr e, int resultReg) {
        super(e, resultReg);
    }

    FuncCountStarIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_COUNT_STAR;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FuncCountState());
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        ++state.theCount;
        return true;
    }

    @Override
    void initAggrValue(RuntimeControlBlock rcb, FieldValueImpl val) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        long l = state.theCount = val != null ? ((LongValueImpl)val).get() : 0L;
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Initialized count to " + state.theCount);
        }
    }

    @Override
    FieldValueImpl getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        FuncCountState state = (FuncCountState)rcb.getState(this.theStatePos);
        LongValueImpl res = FieldDefImpl.longDef.createLong(state.theCount);
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
    }

    static class FuncCountState
    extends PlanIterState {
        long theCount;

        FuncCountState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCount = 0L;
        }
    }
}

