/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.AggrIterState;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.CompOpIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncMinMaxIter
extends PlanIter {
    private final FunctionLib.FuncCode theFuncCode;
    private final PlanIter theInput;

    public FuncMinMaxIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter input, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theFuncCode = code;
        this.theInput = input;
    }

    FuncMinMaxIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theFuncCode = FunctionLib.FuncCode.values()[ordinal];
        this.theInput = FuncMinMaxIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theFuncCode.ordinal());
        FuncMinMaxIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        out.writeShort(this.theFuncCode.ordinal());
        this.theInput.writeForCloud(out, driverVersion, valWriter);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_MIN_MAX;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theFuncCode;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AggrIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more;
        while (more = this.theInput.next(rcb)) {
            FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
            if (val.isNull() || val.isJsonNull()) {
                if (rcb.getTraceLevel() < 2) continue;
                rcb.trace("Skipping " + (val.isNull() ? "NULL" : "jnull"));
                continue;
            }
            FuncMinMaxIter.minmaxNewVal(rcb, state, this.theFuncCode, this.theLocation, val);
        }
        return true;
    }

    @Override
    void aggregate(RuntimeControlBlock rcb, FieldValueImpl val) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        FuncMinMaxIter.minmaxNewVal(rcb, state, this.theFuncCode, this.theLocation, val);
    }

    static void minmaxNewVal(RuntimeControlBlock rcb, AggrIterState state, FunctionLib.FuncCode fncode, QueryException.Location loc, FieldValueImpl val) {
        if (val.isNull() || val.isJsonNull()) {
            return;
        }
        if (state.theMinMax.isNull()) {
            switch (val.getType()) {
                case BINARY: 
                case FIXED_BINARY: 
                case RECORD: 
                case MAP: {
                    return;
                }
            }
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Setting min/max to " + val);
            }
            state.theMinMax = val;
            return;
        }
        CompOpIter.compare(rcb, state.theMinMax, val, FunctionLib.FuncCode.OP_LT, state.theCompRes, loc);
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Compared values: \n" + state.theMinMax + "\n" + val + "\ncomp res = " + state.theCompRes);
        }
        if (fncode == FunctionLib.FuncCode.FN_MIN || fncode == FunctionLib.FuncCode.FN_SEQ_MIN ? state.theCompRes.incompatible || state.theCompRes.comp < 0 : state.theCompRes.incompatible || state.theCompRes.comp > 0) {
            return;
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("Setting min/max to " + val);
        }
        state.theMinMax = val;
    }

    @Override
    void initAggrValue(RuntimeControlBlock rcb, FieldValueImpl val) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        state.theMinMax = val != null ? val : NullValueImpl.getInstance();
    }

    @Override
    FieldValueImpl getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        FieldValueImpl res = state.theMinMax;
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

