/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FuncRegexLike;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncRegexLikeIter
extends PlanIter {
    private final PlanIter theRegexParam;
    private final Boolean theIsRegexConst;
    private final PlanIter theSource;
    private final PlanIter theFlagsParam;
    private final Boolean theIsFlagsParamConst;

    public FuncRegexLikeIter(Expr e, int resultReg, PlanIter[] argIters) {
        super(e, resultReg);
        ExprFuncCall fncall = (ExprFuncCall)e;
        this.theSource = argIters[0];
        this.theRegexParam = argIters[1];
        this.theIsRegexConst = Expr.ConstKind.isConst(fncall.getArg(1));
        if (argIters.length == 3) {
            this.theFlagsParam = argIters[2];
            this.theIsFlagsParamConst = Expr.ConstKind.isConst(fncall.getArg(2));
        } else {
            this.theFlagsParam = null;
            this.theIsFlagsParamConst = true;
        }
    }

    public FuncRegexLikeIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theRegexParam = FuncRegexLikeIter.deserializeIter(in, serialVersion);
        this.theSource = FuncRegexLikeIter.deserializeIter(in, serialVersion);
        this.theFlagsParam = FuncRegexLikeIter.deserializeIter(in, serialVersion);
        this.theIsRegexConst = in.readBoolean();
        this.theIsFlagsParamConst = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncRegexLikeIter.serializeIter(this.theRegexParam, out, serialVersion);
        FuncRegexLikeIter.serializeIter(this.theSource, out, serialVersion);
        FuncRegexLikeIter.serializeIter(this.theFlagsParam, out, serialVersion);
        out.writeBoolean(this.theIsRegexConst);
        out.writeBoolean(this.theIsFlagsParamConst);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_REGEX_LIKE;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FuncRegexLikeState());
        this.theRegexParam.open(rcb);
        this.theSource.open(rcb);
        if (this.theFlagsParam != null) {
            this.theFlagsParam.open(rcb);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theRegexParam.reset(rcb);
        this.theSource.reset(rcb);
        if (this.theFlagsParam != null) {
            this.theFlagsParam.reset(rcb);
        }
        FuncRegexLikeState state = (FuncRegexLikeState)rcb.getState(this.theStatePos);
        state.reset(this);
        if (!this.theIsFlagsParamConst.booleanValue() || !this.theIsRegexConst.booleanValue()) {
            state.thePattern = null;
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theRegexParam.close(rcb);
        this.theSource.close(rcb);
        if (this.theFlagsParam != null) {
            this.theFlagsParam.close(rcb);
        }
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean retVal;
        FieldValueImpl fvi;
        boolean more;
        String regex = null;
        String flags = null;
        String sourceValue = null;
        FuncRegexLikeState state = (FuncRegexLikeState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.thePattern == null) {
            more = this.theRegexParam.next(rcb);
            fvi = rcb.getRegVal(this.theRegexParam.getResultReg());
            if (fvi.isNull()) {
                rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
                state.done();
                return true;
            }
            regex = fvi.asString().get();
            if (this.theFlagsParam != null) {
                more = this.theFlagsParam.next(rcb);
                fvi = rcb.getRegVal(this.theFlagsParam.getResultReg());
                if (fvi.isNull()) {
                    rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
                    state.done();
                    return true;
                }
                flags = fvi.asString().get();
            }
            try {
                FuncRegexLike.verifyPattern(regex);
                state.thePattern = flags == null ? Pattern.compile(regex) : Pattern.compile(regex, FuncRegexLike.convertFlags(flags));
            }
            catch (PatternSyntaxException e) {
                throw new QueryException("The pattern [" + regex + "] specified for the regex_like function is invalid.", e, this.getLocation());
            }
        }
        if (!(more = this.theSource.next(rcb))) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
            state.done();
            return true;
        }
        fvi = rcb.getRegVal(this.theSource.getResultReg());
        if (this.theSource.next(rcb)) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
            state.done();
            return true;
        }
        if (fvi.isNull()) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        if (!fvi.isString()) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
            state.done();
            return true;
        }
        sourceValue = fvi.asString().get();
        try {
            retVal = state.thePattern.matcher(sourceValue).matches();
        }
        catch (Throwable t) {
            throw new QueryException("An error was encountered during regex_like processing. Cause: " + t, t, this.getLocation());
        }
        rcb.setRegVal(this.theResultReg, FieldDefImpl.booleanDef.createBoolean(retVal));
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theSource.display(sb, formatter);
        sb.append("\n");
        this.theRegexParam.display(sb, formatter);
        if (this.theFlagsParam != null) {
            sb.append("\n");
            this.theFlagsParam.display(sb, formatter);
        }
    }

    private static class FuncRegexLikeState
    extends PlanIterState {
        Pattern thePattern;

        private FuncRegexLikeState() {
        }
    }
}

