/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.AggrIterState;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldDef;

public class FuncSumIter
extends PlanIter {
    private final PlanIter theInput;

    public FuncSumIter(Expr e, int resultReg, PlanIter input, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theInput = input;
    }

    FuncSumIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncSumIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncSumIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        this.theInput.writeForCloud(out, driverVersion, valWriter);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_SUM;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AggrIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more;
        while (more = this.theInput.next(rcb)) {
            FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Summing up value " + val);
            }
            if (val.isNull()) continue;
            FuncSumIter.sumNewValue(state, val);
        }
        return true;
    }

    static void sumNewValue(AggrIterState state, FieldValueImpl val) {
        if (val.isNull()) {
            return;
        }
        block0 : switch (val.getType()) {
            case INTEGER: {
                state.theGotNumericInput = true;
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theLongSum += (long)((IntegerValueImpl)val).get();
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += (double)((IntegerValueImpl)val).get();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((IntegerValueImpl)val).get());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case LONG: {
                state.theGotNumericInput = true;
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theLongSum += ((LongValueImpl)val).get();
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += (double)((LongValueImpl)val).get();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((LongValueImpl)val).get());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case FLOAT: {
                state.theGotNumericInput = true;
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theDoubleSum = state.theLongSum;
                        state.theDoubleSum += (double)((FloatValueImpl)val).get();
                        state.theSumType = FieldDef.Type.DOUBLE;
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += (double)((FloatValueImpl)val).get();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((FloatValueImpl)val).get());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case DOUBLE: {
                state.theGotNumericInput = true;
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theDoubleSum = state.theLongSum;
                        state.theDoubleSum += ((DoubleValueImpl)val).get();
                        state.theSumType = FieldDef.Type.DOUBLE;
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += ((DoubleValueImpl)val).get();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((DoubleValueImpl)val).get());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case NUMBER: {
                state.theGotNumericInput = true;
                ++state.theCount;
                if (state.theNumberSum == null) {
                    state.theNumberSum = new BigDecimal(0);
                }
                switch (state.theSumType) {
                    case LONG: {
                        state.theNumberSum = new BigDecimal(state.theLongSum);
                        state.theNumberSum = state.theNumberSum.add(((NumberValueImpl)val).get());
                        state.theSumType = FieldDef.Type.NUMBER;
                        break block0;
                    }
                    case DOUBLE: {
                        state.theNumberSum = new BigDecimal(state.theDoubleSum);
                        state.theNumberSum = state.theNumberSum.add(((NumberValueImpl)val).get());
                        state.theSumType = FieldDef.Type.NUMBER;
                        break block0;
                    }
                    case NUMBER: {
                        state.theNumberSum = state.theNumberSum.add(((NumberValueImpl)val).get());
                        break block0;
                    }
                }
                assert (false);
                break;
            }
        }
    }

    @Override
    void aggregate(RuntimeControlBlock rcb, FieldValueImpl val) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        FuncSumIter.sumNewValue(state, val);
    }

    @Override
    void initAggrValue(RuntimeControlBlock rcb, FieldValueImpl val) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        if (val == null) {
            state.theLongSum = 0L;
            state.theSumType = FieldDef.Type.LONG;
            return;
        }
        if (val.isNull()) {
            return;
        }
        state.theGotNumericInput = true;
        switch (val.getType()) {
            case LONG: {
                state.theLongSum = ((LongValueImpl)val).get();
                state.theSumType = FieldDef.Type.LONG;
                break;
            }
            case DOUBLE: {
                state.theDoubleSum = ((DoubleValueImpl)val).get();
                state.theSumType = FieldDef.Type.DOUBLE;
                break;
            }
            case NUMBER: {
                state.theNumberSum = ((NumberValueImpl)val).get();
                state.theSumType = FieldDef.Type.NUMBER;
                break;
            }
            default: {
                throw new QueryStateException("Unexpected result type for SUM function: " + val.getType());
            }
        }
    }

    @Override
    FieldValueImpl getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        FieldValueImpl res = null;
        if (!state.theGotNumericInput) {
            return NullValueImpl.getInstance();
        }
        switch (state.theSumType) {
            case LONG: {
                res = FieldDefImpl.longDef.createLong(state.theLongSum);
                break;
            }
            case DOUBLE: {
                res = FieldDefImpl.doubleDef.createDouble(state.theDoubleSum);
                break;
            }
            case NUMBER: {
                res = FieldDefImpl.numberDef.createNumber(state.theNumberSum);
                break;
            }
            default: {
                throw new QueryStateException("Unexpected result type for SUM function: " + state.theSumType);
            }
        }
        if (rcb.getTraceLevel() >= 3) {
            rcb.trace("Computed sum = " + res);
        }
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

