/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Durability;
import oracle.kv.Key;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprInsertRow;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldValue;
import oracle.kv.table.TimeToLive;

public class InsertRowIter
extends PlanIter {
    static IntegerValueImpl one = FieldDefImpl.integerDef.createInteger(1);
    static IntegerValueImpl zero = FieldDefImpl.integerDef.createInteger(0);
    static KeySerializer keySerializer = KeySerializer.PROHIBIT_INTERNAL_KEYSPACE;
    final String theNamespace;
    final String theTableName;
    final RecordValueImpl theRow;
    final int[] theColPositions;
    final PlanIter[] theColIters;
    protected boolean theUpdateTTL;
    protected PlanIter theTTLIter;
    protected TimeUnit theTTLUnit;
    final boolean theIsUpsert;
    final boolean theHasReturningClause;

    public InsertRowIter(Expr e, int resultReg, TableImpl table, RecordValueImpl row, int[] pos, PlanIter[] ops, boolean updateTTL, PlanIter ttlIter, TimeUnit ttlUnit, boolean isUpsert, boolean hasReturningClause) {
        super(e, resultReg);
        this.theNamespace = table.getInternalNamespace();
        this.theTableName = table.getFullName();
        this.theRow = row;
        this.theColPositions = pos;
        this.theColIters = ops;
        this.theUpdateTTL = updateTTL;
        this.theTTLIter = ttlIter;
        this.theTTLUnit = ttlUnit;
        assert (this.theTTLIter == null || this.theUpdateTTL);
        this.theIsUpsert = isUpsert;
        this.theHasReturningClause = hasReturningClause;
    }

    public InsertRowIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNamespace = SerializationUtil.readString(in, serialVersion);
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        this.theRow = FieldValueSerialization.readRecord(null, true, in, serialVersion);
        this.theColPositions = InsertRowIter.deserializeIntArray(in, serialVersion);
        this.theColIters = InsertRowIter.deserializeIters(in, serialVersion);
        this.theUpdateTTL = in.readBoolean();
        if (this.theUpdateTTL) {
            this.theTTLIter = InsertRowIter.deserializeIter(in, serialVersion);
            if (this.theTTLIter != null) {
                this.theTTLUnit = TimeToLive.readTTLUnit(in, 1);
            }
        }
        this.theIsUpsert = in.readBoolean();
        this.theHasReturningClause = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.theNamespace);
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        FieldValueSerialization.writeRecord(this.theRow, true, true, out, serialVersion);
        InsertRowIter.serializeIntArray(this.theColPositions, out, serialVersion);
        InsertRowIter.serializeIters(this.theColIters, out, serialVersion);
        out.writeBoolean(this.theUpdateTTL);
        if (this.theUpdateTTL) {
            InsertRowIter.serializeIter(this.theTTLIter, out, serialVersion);
            if (this.theTTLIter != null) {
                out.writeByte((byte)this.theTTLUnit.ordinal());
            }
        }
        out.writeBoolean(this.theIsUpsert);
        out.writeBoolean(this.theHasReturningClause);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.INSERT_ROW;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        RowImpl row;
        for (PlanIter colIter : this.theColIters) {
            colIter.open(rcb);
        }
        if (this.theTTLIter != null) {
            this.theTTLIter.open(rcb);
        }
        if (this.theRow instanceof RowImpl) {
            row = ((RowImpl)this.theRow).clone();
        } else {
            TableMetadataHelper md = rcb.getMetadataHelper();
            TableImpl table = md.getTable(this.theNamespace, this.theTableName);
            row = table.createRow();
            int numCols = row.getNumFields();
            for (int i = 0; i < numCols; ++i) {
                FieldValueImpl val = this.theRow.get(i);
                if (val == null) continue;
                row.put(i, (FieldValue)val);
            }
        }
        rcb.setState(this.theStatePos, new InsertRowState(row));
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter colIter : this.theColIters) {
            colIter.close(rcb);
        }
        if (this.theTTLIter != null) {
            this.theTTLIter.close(rcb);
        }
        state.close();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter colIter : this.theColIters) {
            colIter.reset(rcb);
        }
        if (this.theTTLIter != null) {
            this.theTTLIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean wasInsert;
        Put put;
        RecordDefImpl rowDef;
        FieldValueImpl generatedValue;
        InsertRowState state = (InsertRowState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        RowImpl row = state.theRTRow;
        for (int i = 0; i < this.theColIters.length; ++i) {
            PlanIter colIter = this.theColIters[i];
            if (colIter.next(rcb)) {
                FieldValueImpl val = rcb.getRegVal(colIter.getResultReg());
                row.put(this.theColPositions[i], (FieldValue)val);
                continue;
            }
            row.putNull(this.theColPositions[i]);
        }
        KVStoreImpl store = rcb.getStore();
        TableImpl table = row.getTableImpl();
        int idCol = table.getIdentityColumn();
        if (table.hasIdentityColumn() && (row.get(idCol) == null || row.get(idCol).isEMPTY() || table.isIdentityOnNull() && row.get(idCol).isNull()) && (generatedValue = store.getIdentityNextValue(table, (rowDef = table.getRowDef()).getFieldDef(idCol), 0, row.get(idCol), idCol)) != null) {
            row.putInternal(idCol, (FieldValue)generatedValue, false);
        }
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("Row to insert =\n" + row);
        }
        long tableId = table.getId();
        Value rowval = row.createValue();
        Key rowkey = row.getPrimaryKey(false);
        byte[] keybytes = keySerializer.toByteArray(rowkey);
        if (this.theIsUpsert) {
            TimeToLive ttlObj = InsertRowIter.setRowExpTime(rcb, row, true, this.theTTLIter, this.theTTLUnit, this.theLocation);
            put = new Put(keybytes, rowval, ReturnValueVersion.Choice.NONE, tableId, ttlObj, this.theUpdateTTL);
        } else {
            TimeToLive ttlObj = InsertRowIter.setRowExpTime(rcb, row, true, this.theTTLIter, this.theTTLUnit, this.theLocation);
            ReturnValueVersion.Choice choice = !this.theHasReturningClause ? ReturnValueVersion.Choice.NONE : ReturnValueVersion.Choice.ALL;
            put = new PutIfAbsent(keybytes, rowval, choice, tableId, ttlObj, true);
        }
        PartitionId pid = store.getDispatcher().getPartitionId(keybytes);
        Durability durability = rcb.getDurability();
        long timeout = rcb.getTimeout();
        TimeUnit timeUnit = rcb.getTimeUnit();
        Request req = store.makeWriteRequest((InternalOperation)put, pid, durability, timeout, timeUnit);
        ExecuteOptions options = rcb.getExecuteOptions();
        if (options != null) {
            req.setLogContext(options.getLogContext());
            req.setAuthContext(options.getAuthContext());
        }
        Result.PutResult res = (Result.PutResult)store.executeRequest(req);
        rcb.tallyReadKB(res.getReadKB());
        rcb.tallyWriteKB(res.getWriteKB());
        boolean bl = this.theIsUpsert ? !res.getWasUpdate() : (wasInsert = res.getSuccess());
        if (this.theHasReturningClause) {
            if (!this.theIsUpsert && !wasInsert) {
                if ((row = row.getTable().initRowFromByteValue(row, res.getPreviousValue().toByteArray(), res.getPreviousExpirationTime(), res.getPreviousVersion())) == null) {
                    state.done();
                    return false;
                }
            } else {
                row.setVersion(res.getNewVersion());
                row.setExpirationTime(res.getNewExpirationTime());
            }
            rcb.setRegVal(this.theResultReg, row);
        } else {
            RecordValueImpl retval = ExprInsertRow.theNumRowsInsertedType.createRecord();
            retval.put(0, (FieldValue)(wasInsert ? one : zero));
            rcb.setRegVal(this.theResultReg, retval);
        }
        state.done();
        return true;
    }

    public static TimeToLive setRowExpTime(RuntimeControlBlock rcb, RowImpl row, boolean updateTTL, PlanIter ttlIter, TimeUnit ttlUnit, QueryException.Location loc) {
        if (!updateTTL) {
            return null;
        }
        TimeToLive ttlObj = null;
        if (ttlIter != null) {
            if (ttlIter.next(rcb)) {
                FieldValueImpl ttlVal = rcb.getRegVal(ttlIter.getResultReg());
                int ttl = ((IntegerValueImpl)(ttlVal = CastIter.castValue(ttlVal, FieldDefImpl.integerDef, loc))).get();
                if (ttl < 0) {
                    ttl = 0;
                }
                ttlObj = ttlUnit == TimeUnit.HOURS ? TimeToLive.ofHours(ttl) : TimeToLive.ofDays(ttl);
            } else {
                ttlObj = row.getTable().getDefaultTTL();
            }
        } else {
            ttlObj = row.getTable().getDefaultTTL();
        }
        if (ttlObj != null) {
            long expTime;
            TimeUnit unit = ttlObj.getUnit();
            long ttl = ttlObj.getValue();
            if (ttl == 0L) {
                expTime = 0L;
            } else if (unit == TimeUnit.DAYS) {
                expTime = (System.currentTimeMillis() + 86400000L - 1L) / 86400000L;
                expTime = (expTime + ttl) * 86400000L;
            } else {
                expTime = (System.currentTimeMillis() + 3600000L - 1L) / 3600000L;
                expTime = (expTime + ttl) * 3600000L;
            }
            if (rcb.getTraceLevel() > 3) {
                rcb.trace("ttl = " + ttl + " expiration time = " + expTime);
            }
            row.setExpirationTime(expTime);
        } else {
            row.setExpirationTime(0L);
        }
        return ttlObj;
    }

    @Override
    void displayName(StringBuilder sb) {
        if (this.theIsUpsert) {
            sb.append("UPSERT_ROW");
        } else {
            sb.append("INSERT_ROW");
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theColIters.length; ++i) {
            this.theColIters[i].display(sb, formatter);
            sb.append(",\n");
        }
        if (this.theTTLIter != null) {
            this.theTTLIter.display(sb, formatter);
        }
        sb.append(this.theRow.toJsonString(true));
        sb.append("\n");
    }

    public static class InsertRowState
    extends PlanIterState {
        RowImpl theRTRow;

        public InsertRowState(RowImpl row) {
            this.theRTRow = row;
        }
    }
}

