/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.PartitionId;

public class PartitionUnionIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final boolean theDoesSort;

    public PartitionUnionIter(Expr e, int resultReg, PlanIter input) {
        super(e, resultReg);
        this.theInputIter = input;
        this.theDoesSort = e.getQCB().hasSort();
    }

    PartitionUnionIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInputIter = PartitionUnionIter.deserializeIter(in, serialVersion);
        this.theDoesSort = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        PartitionUnionIter.serializeIter(this.theInputIter, out, serialVersion);
        out.writeBoolean(this.theDoesSort);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.PARTITION_UNION;
    }

    public boolean doesSort() {
        return this.theDoesSort;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PartitionUnionState(rcb, this));
        this.theInputIter.open(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        state.close();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
        this.theInputIter.reset(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PartitionUnionState state = (PartitionUnionState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (this.theDoesSort) {
            return this.sortingNext(rcb, state);
        }
        return this.simpleNext(rcb, state);
    }

    public boolean sortingNext(RuntimeControlBlock rcb, PartitionUnionState state) {
        int pid;
        ResumeInfo initRI = rcb.getResumeInfo();
        if (!initRI.isInSortPhase1()) {
            boolean more = this.theInputIter.next(rcb);
            if (!rcb.getReachedLimit() && initRI.getPrimResumeKey() == null) {
                state.done();
            }
            return more;
        }
        BitSet partitionsBitmap = initRI.getPartitionsBitmap();
        int batchSize = rcb.getBatchSize();
        int numDonePartitions = 0;
        boolean[] donePartitions = new boolean[state.theRepPids.length];
        state.theResumeInfos = new ResumeInfo[state.theRepPids.length];
        state.theResults = new ArrayList[state.theRepPids.length];
        for (int i = 0; i < state.theRepPids.length; ++i) {
            pid = state.theRepPids[i].getPartitionId();
            if (pid == state.theInitPid) {
                assert (!partitionsBitmap.get(pid));
                state.thePidIdx = i;
                state.theResumeInfos[i] = initRI;
                donePartitions[i] = false;
                continue;
            }
            if (partitionsBitmap.get(pid)) {
                ++numDonePartitions;
                donePartitions[i] = true;
            } else {
                donePartitions[i] = false;
            }
            state.theResumeInfos[i] = null;
        }
        if (state.thePidIdx < 0) {
            throw new IllegalStateException("Partition " + state.theInitPid + " has moved");
        }
        pid = state.theInitPid;
        ResumeInfo ri = initRI;
        while (true) {
            block25: {
                boolean more;
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("PartitionUnionIter in sort phase 1: Executing query on partition " + pid);
                    rcb.trace("Resume Info " + ri.hashCode() + " :\n" + ri);
                }
                if (more = this.theInputIter.next(rcb)) {
                    FieldValueImpl res;
                    if (state.theResults[state.thePidIdx] == null) {
                        ++state.theNumPartitionsWithResults;
                        state.theResults[state.thePidIdx] = new ArrayList<FieldValueImpl>();
                    }
                    if ((res = rcb.getRegVal(this.theInputIter.getResultReg())).isTuple()) {
                        res = ((TupleValue)res).toRecord();
                    }
                    state.theResults[state.thePidIdx].add(res);
                    ++state.theNumResults;
                    if (!partitionsBitmap.get(pid)) {
                        ++numDonePartitions;
                        partitionsBitmap.set(pid);
                    }
                    ri.setIsInSortPhase1(false);
                    ri.incNumResultsComputed();
                    if (rcb.getTraceLevel() >= 2) {
                        rcb.trace("PartitionUnionIter in sort phase 1: Produced result from partition " + pid + " :\n" + res);
                    }
                    if (ri.getPrimResumeKey() == null) {
                        state.theResumeInfos[state.thePidIdx] = null;
                        donePartitions[state.thePidIdx] = true;
                    }
                } else if (!rcb.getReachedLimit()) {
                    if (rcb.getTraceLevel() >= 2) {
                        rcb.trace("PartitionUnionIter in sort phase 1: no more results from partition " + pid);
                    }
                    ++numDonePartitions;
                    partitionsBitmap.set(pid);
                    state.theResumeInfos[state.thePidIdx] = null;
                    donePartitions[state.thePidIdx] = true;
                }
                if (rcb.getReachedLimit() || batchSize > 0 && state.theNumResults > batchSize) {
                    if (numDonePartitions == state.theRepPids.length) {
                        ri = new ResumeInfo(rcb);
                        rcb.setResumeInfo(ri);
                        ri.setPartitionsBitmap(partitionsBitmap);
                        ri.setIsInSortPhase1(false);
                    }
                    state.done();
                    return true;
                }
                int mark = state.thePidIdx;
                do {
                    ++state.thePidIdx;
                    if (state.thePidIdx == state.theRepPids.length) {
                        state.thePidIdx = 0;
                    }
                    if (!donePartitions[state.thePidIdx]) break block25;
                } while (state.thePidIdx != mark);
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("PartitionUnionIter in sort phase 1: no more results from local partitions");
                }
                ri = new ResumeInfo(rcb);
                rcb.setResumeInfo(ri);
                ri.setPartitionsBitmap(partitionsBitmap);
                ri.setIsInSortPhase1(false);
                state.done();
                return true;
            }
            pid = state.theRepPids[state.thePidIdx].getPartitionId();
            ri = state.theResumeInfos[state.thePidIdx];
            if (ri == null) {
                ri = new ResumeInfo(rcb);
                ri.setCurrentPid(pid);
                ri.setPartitionsBitmap(partitionsBitmap);
                ri.setIsInSortPhase1(true);
                state.theResumeInfos[state.thePidIdx] = ri;
            }
            rcb.setResumeInfo(ri);
            this.theInputIter.reset(rcb);
        }
    }

    public PartitionedResults getPartitionedResults(RuntimeControlBlock rcb) {
        PartitionUnionState state = (PartitionUnionState)rcb.getState(this.theStatePos);
        PartitionedResults res = new PartitionedResults();
        res.pids = new int[state.theNumPartitionsWithResults];
        res.numResultsPerPid = new int[state.theNumPartitionsWithResults];
        res.resumeInfos = new ResumeInfo[state.theNumPartitionsWithResults];
        res.results = new ArrayList<FieldValueImpl>(state.theNumResults);
        int p = 0;
        for (int i = 0; i < state.theRepPids.length; ++i) {
            if (state.theResults[i] == null) continue;
            res.pids[p] = state.theRepPids[i].getPartitionId();
            res.numResultsPerPid[p] = state.theResults[i].size();
            res.resumeInfos[p] = state.theResumeInfos[i];
            for (int j = 0; j < state.theResults[i].size(); ++j) {
                res.results.add(state.theResults[i].get(j));
            }
            ++p;
        }
        if (rcb.getTraceLevel() >= 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("PartitionUnionIter: Produced a batch of " + res.results.size() + " results during sort phase 1  number of KB read = " + rcb.getReadKB());
            sb.append("\n[pid, num results] = { ");
            for (int i = 0; i < state.theNumPartitionsWithResults; ++i) {
                sb.append("[").append(res.pids[i]).append(", ").append(res.numResultsPerPid[i]).append("] ");
            }
            sb.append("}");
            rcb.trace(sb.toString());
            rcb.trace("Global ResumeInfo =\n" + rcb.getResumeInfo().toString());
        }
        return res;
    }

    public boolean simpleNext(RuntimeControlBlock rcb, PartitionUnionState state) {
        boolean more;
        ResumeInfo ri = rcb.getResumeInfo();
        while (!(more = this.theInputIter.next(rcb))) {
            if (rcb.getReachedLimit()) {
                return false;
            }
            this.moveToNextPartition(rcb, state);
            if (!state.isDone()) continue;
            return false;
        }
        if (ri.getPrimResumeKey() == null) {
            this.moveToNextPartition(rcb, state);
        }
        return true;
    }

    private void moveToNextPartition(RuntimeControlBlock rcb, PartitionUnionState state) {
        block2: {
            int pid;
            ResumeInfo ri = rcb.getResumeInfo();
            BitSet partitionsBitmap = ri.getPartitionsBitmap();
            partitionsBitmap.set(state.thePid);
            while (true) {
                ++state.thePidIdx;
                if (state.thePidIdx == state.theRepPids.length) {
                    state.done();
                    ri.setCurrentPid(-1);
                    return;
                }
                pid = state.theRepPids[state.thePidIdx].getPartitionId();
                if (!partitionsBitmap.get(pid)) break;
                if (rcb.getTraceLevel() < 1) continue;
                rcb.trace("PartitionUnionIter: skipped partition " + pid);
            }
            state.thePid = pid;
            ri.setCurrentPid(pid);
            this.theInputIter.reset(rcb);
            rcb.getResumeInfo().reset();
            if (rcb.getTraceLevel() < 1) break block2;
            rcb.trace("PartitionUnionIter: Executing query on partition " + pid);
            rcb.trace("KBs read = " + rcb.getReadKB());
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("Does Sort = " + this.theDoesSort + "\n");
        this.theInputIter.display(sb, formatter);
    }

    public static class PartitionUnionState
    extends PlanIterState {
        int theInitPid;
        int thePid;
        PartitionId[] theRepPids;
        ResumeInfo[] theResumeInfos;
        List<FieldValueImpl>[] theResults;
        int theNumResults;
        int theNumPartitionsWithResults;
        int thePidIdx;

        public PartitionUnionState(RuntimeControlBlock rcb, PartitionUnionIter iter) {
            ResumeInfo ri = rcb.getResumeInfo();
            this.thePid = this.theInitPid = ri.getCurrentPid();
            this.thePidIdx = -1;
            this.theRepPids = rcb.getQueryHandler().getShardPids();
            if (iter.theDoesSort) {
                if (ri.isInSortPhase1()) {
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("PartitionUnionIter in sorting phase 1");
                    }
                } else if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("PartitionUnionIter in sorting phase 2");
                }
            }
            if (rcb.getTraceLevel() >= 3) {
                StringBuffer sb = new StringBuffer();
                sb.append("local partitions = {");
                for (PartitionId pid : this.theRepPids) {
                    sb.append(pid).append(", ");
                }
                sb.append("}");
                rcb.trace(sb.toString());
            }
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.thePid = this.theInitPid;
            this.thePidIdx = -1;
        }
    }

    public static class PartitionedResults {
        public List<FieldValueImpl> results;
        public int[] pids;
        public int[] numResultsPerPid;
        public ResumeInfo[] resumeInfos;
    }
}

