/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Key;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.AndOrIter;
import oracle.kv.impl.query.runtime.AnyOpIter;
import oracle.kv.impl.query.runtime.ArithOpIter;
import oracle.kv.impl.query.runtime.ArithUnaryOpIter;
import oracle.kv.impl.query.runtime.ArrayConstrIter;
import oracle.kv.impl.query.runtime.ArrayFilterIter;
import oracle.kv.impl.query.runtime.ArraySliceIter;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.CaseIter;
import oracle.kv.impl.query.runtime.CastIter;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.CompOpIter;
import oracle.kv.impl.query.runtime.ConcatIter;
import oracle.kv.impl.query.runtime.ConstIter;
import oracle.kv.impl.query.runtime.DeleteRowIter;
import oracle.kv.impl.query.runtime.ExistsIter;
import oracle.kv.impl.query.runtime.ExternalVarRefIter;
import oracle.kv.impl.query.runtime.FieldStepIter;
import oracle.kv.impl.query.runtime.FuncCountIter;
import oracle.kv.impl.query.runtime.FuncCountStarIter;
import oracle.kv.impl.query.runtime.FuncCurrentTimeIter;
import oracle.kv.impl.query.runtime.FuncCurrentTimeMillisIter;
import oracle.kv.impl.query.runtime.FuncExpirationTimeIter;
import oracle.kv.impl.query.runtime.FuncExpirationTimeMillisIter;
import oracle.kv.impl.query.runtime.FuncExtractFromTimestampIter;
import oracle.kv.impl.query.runtime.FuncGeoDistanceIter;
import oracle.kv.impl.query.runtime.FuncGeoIsGeometryIter;
import oracle.kv.impl.query.runtime.FuncGeoSearchIter;
import oracle.kv.impl.query.runtime.FuncMinMaxIter;
import oracle.kv.impl.query.runtime.FuncParseJsonIter;
import oracle.kv.impl.query.runtime.FuncRegexLikeIter;
import oracle.kv.impl.query.runtime.FuncRemainingDaysIter;
import oracle.kv.impl.query.runtime.FuncRemainingHoursIter;
import oracle.kv.impl.query.runtime.FuncRowVersionIter;
import oracle.kv.impl.query.runtime.FuncSeqAggrIter;
import oracle.kv.impl.query.runtime.FuncSizeIter;
import oracle.kv.impl.query.runtime.FuncSumIter;
import oracle.kv.impl.query.runtime.InsertRowIter;
import oracle.kv.impl.query.runtime.IsNullIter;
import oracle.kv.impl.query.runtime.IsOfTypeIter;
import oracle.kv.impl.query.runtime.MapConstrIter;
import oracle.kv.impl.query.runtime.MapFilterIter;
import oracle.kv.impl.query.runtime.NotIter;
import oracle.kv.impl.query.runtime.PartitionUnionIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.PromoteIter;
import oracle.kv.impl.query.runtime.RecConstrIter;
import oracle.kv.impl.query.runtime.ReceiveIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.SFWIter;
import oracle.kv.impl.query.runtime.SeqMapIter;
import oracle.kv.impl.query.runtime.UpdateFieldIter;
import oracle.kv.impl.query.runtime.UpdateRowIter;
import oracle.kv.impl.query.runtime.VarRefIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;

public abstract class PlanIter
implements FastExternalizable {
    private static final int NULL_VALUE = -1;
    private static final PlanIter[] NO_PLAN_ITERS = new PlanIter[0];
    protected final int theResultReg;
    protected final int theStatePos;
    protected final QueryException.Location theLocation;
    protected final boolean theIsCloudDriverIter;

    PlanIter(Expr e, int resultReg, boolean forCloud) {
        this.theResultReg = resultReg;
        this.theStatePos = e.getQCB().incNumPlanIters();
        this.theLocation = e.getLocation();
        this.theIsCloudDriverIter = forCloud;
    }

    PlanIter(Expr e, int resultReg) {
        this(e, resultReg, false);
    }

    protected PlanIter(int statePos, int resultReg, QueryException.Location location) {
        this.theResultReg = resultReg;
        this.theStatePos = statePos;
        this.theLocation = location;
        this.theIsCloudDriverIter = false;
    }

    protected PlanIter(DataInput in, short serialVersion) throws IOException {
        this.theResultReg = PlanIter.readPositiveInt(in, true);
        this.theStatePos = PlanIter.readPositiveInt(in);
        this.theLocation = new QueryException.Location(PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in));
        this.theIsCloudDriverIter = false;
    }

    static int readPositiveInt(DataInput in) throws IOException {
        return PlanIter.readPositiveInt(in, false);
    }

    static int readPositiveInt(DataInput in, boolean allowNegOne) throws IOException {
        int value = in.readInt();
        PlanIter.checkPositiveInt(value, allowNegOne);
        return value;
    }

    static short readOrdinal(DataInput in, int numValues) throws IOException {
        short index = in.readShort();
        if (index < 0 || index >= numValues) {
            throw new IllegalArgumentException(index + " is invalid, it must be in a range 0 ~ " + numValues);
        }
        return index;
    }

    private static void checkPositiveInt(int value, boolean allowNegOne) {
        if (allowNegOne) {
            if (value < -1) {
                throw new IllegalArgumentException(value + " is invalid, it must be a positive value or -1");
            }
        } else if (value < 0) {
            throw new IllegalArgumentException(value + " is invalid, it must be a positive value");
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeByte(this.getKind().ordinal());
        out.writeInt(this.theResultReg);
        out.writeInt(this.theStatePos);
        out.writeInt(this.theLocation.getStartLine());
        out.writeInt(this.theLocation.getStartColumn());
        out.writeInt(this.theLocation.getEndLine());
        out.writeInt(this.theLocation.getEndColumn());
    }

    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        throw new QueryException("Cannot execute this kind of query in the cloud environment (because it uses a " + this.getName() + " operation)", this.theLocation);
    }

    void writeForCloudCommon(DataOutput out, short driverVersion) throws IOException {
        out.writeByte(this.getKind().ordinal());
        out.writeInt(this.theResultReg);
        out.writeInt(this.theStatePos);
        out.writeInt(this.theLocation.getStartLine());
        out.writeInt(this.theLocation.getStartColumn());
        out.writeInt(this.theLocation.getEndLine());
        out.writeInt(this.theLocation.getEndColumn());
    }

    public final int getResultReg() {
        return this.theResultReg;
    }

    public QueryException.Location getLocation() {
        return this.theLocation;
    }

    PlanIterState getState(RuntimeControlBlock rcb) {
        return rcb.getState(this.theStatePos);
    }

    public abstract PlanIterKind getKind();

    public int[] getTupleRegs() {
        return null;
    }

    public boolean producesTuples() {
        return this.getTupleRegs() != null;
    }

    PlanIter getInputIter() {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    void getParentItemContext(RuntimeControlBlock rcb, ParentItemContext ctx) {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    void aggregate(RuntimeControlBlock rcb, FieldValueImpl val) {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    void initAggrValue(RuntimeControlBlock rcb, FieldValueImpl val) {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    FieldValueImpl getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    public abstract void open(RuntimeControlBlock var1);

    public abstract boolean next(RuntimeControlBlock var1);

    public abstract void reset(RuntimeControlBlock var1);

    public abstract void close(RuntimeControlBlock var1);

    public boolean hasNext(RuntimeControlBlock rcb) {
        return !rcb.getState(this.theStatePos).isDone();
    }

    public boolean nextLocal(RuntimeControlBlock rcb) {
        return this.next(rcb);
    }

    public void setIterationHandleNotifier(IterationHandleNotifier iterHandleNotifier) {
    }

    public Throwable getCloseException(RuntimeControlBlock rcb) {
        return null;
    }

    public boolean isClosed(RuntimeControlBlock rcb) {
        return rcb.getState(this.theStatePos).isClosed();
    }

    public boolean isDone(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        return state.isDone() || state.isClosed();
    }

    public final String display() {
        StringBuilder sb = new StringBuilder();
        this.display(sb, new QueryFormatter());
        return sb.toString();
    }

    FunctionLib.FuncCode getFuncCode() {
        return null;
    }

    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayName(sb);
        this.displayRegs(sb);
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        this.displayContent(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    void displayName(StringBuilder sb) {
        if (this.getFuncCode() != null) {
            sb.append((Object)this.getFuncCode());
        } else {
            sb.append((Object)this.getKind());
        }
    }

    String getName() {
        StringBuilder sb = new StringBuilder();
        this.displayName(sb);
        return sb.toString();
    }

    final void displayRegs(StringBuilder sb) {
        sb.append("(");
        sb.append("[").append(this.theResultReg).append("]");
        int[] tupleRegs = this.getTupleRegs();
        if (tupleRegs != null) {
            sb.append(", ");
            for (int i = 0; i < tupleRegs.length; ++i) {
                sb.append(tupleRegs[i]);
                if (i >= tupleRegs.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
    }

    protected abstract void displayContent(StringBuilder var1, QueryFormatter var2);

    static void serializeIters(PlanIter[] iters, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            if (iters == null) {
                iters = NO_PLAN_ITERS;
            }
            SerializationUtil.writeNonNullSequenceLength(out, iters.length);
            for (PlanIter iter : iters) {
                PlanIter.serializeIter(iter, out, serialVersion);
            }
            return;
        }
        if (iters == null) {
            out.writeInt(0);
        } else {
            out.writeInt(iters.length);
            for (PlanIter iter : iters) {
                PlanIter.serializeIter(iter, out, serialVersion);
            }
        }
    }

    static PlanIter[] deserializeIters(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            int numArgs = SerializationUtil.readNonNullSequenceLength(in);
            PlanIter[] iters = new PlanIter[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                iters[i] = PlanIter.deserializeIter(in, serialVersion);
            }
            return iters;
        }
        int numArgs = in.readInt();
        PlanIter[] iters = new PlanIter[numArgs];
        if (numArgs > 0) {
            for (int i = 0; i < numArgs; ++i) {
                iters[i] = PlanIter.deserializeIter(in, serialVersion);
            }
        }
        return iters;
    }

    public static void serializeIter(PlanIter iter, DataOutput out, short serialVersion) throws IOException {
        if (iter == null) {
            out.writeByte(-1);
            return;
        }
        iter.writeFastExternal(out, serialVersion);
    }

    public static PlanIter deserializeIter(DataInput in, short serialVersion) throws IOException {
        byte iterType = in.readByte();
        if (iterType == -1) {
            return null;
        }
        PlanIter iter = null;
        PlanIterKind kind = PlanIterKind.values()[iterType];
        switch (kind) {
            case CONST: {
                iter = new ConstIter(in, serialVersion);
                break;
            }
            case VAR_REF: {
                iter = new VarRefIter(in, serialVersion);
                break;
            }
            case EXTERNAL_VAR_REF: {
                iter = new ExternalVarRefIter(in, serialVersion);
                break;
            }
            case ARRAY_CONSTR: {
                iter = new ArrayConstrIter(in, serialVersion);
                break;
            }
            case MAP_CONSTR: {
                iter = new MapConstrIter(in, serialVersion);
                break;
            }
            case REC_CONSTR: {
                iter = new RecConstrIter(in, serialVersion);
                break;
            }
            case BASE_TABLE: {
                iter = new BaseTableIter(in, serialVersion);
                break;
            }
            case COMP_OP: {
                iter = new CompOpIter(in, serialVersion);
                break;
            }
            case ANY_OP: {
                iter = new AnyOpIter(in, serialVersion);
                break;
            }
            case AND_OR: {
                iter = new AndOrIter(in, serialVersion);
                break;
            }
            case PROMOTE: {
                iter = new PromoteIter(in, serialVersion);
                break;
            }
            case IS_OF_TYPE: {
                iter = new IsOfTypeIter(in, serialVersion);
                break;
            }
            case CAST: {
                iter = new CastIter(in, serialVersion);
                break;
            }
            case FIELD_STEP: {
                iter = new FieldStepIter(in, serialVersion);
                break;
            }
            case MAP_FILTER: {
                iter = new MapFilterIter(in, serialVersion);
                break;
            }
            case ARRAY_SLICE: {
                iter = new ArraySliceIter(in, serialVersion);
                break;
            }
            case ARRAY_FILTER: {
                iter = new ArrayFilterIter(in, serialVersion);
                break;
            }
            case SFW: {
                iter = new SFWIter(in, serialVersion);
                break;
            }
            case FUNC_SIZE: {
                iter = new FuncSizeIter(in, serialVersion);
                break;
            }
            case ARITH_OP: {
                iter = new ArithOpIter(in, serialVersion);
                break;
            }
            case ARITH_UNARY_OP: {
                iter = new ArithUnaryOpIter(in, serialVersion);
                break;
            }
            case CONCAT: {
                iter = new ConcatIter(in, serialVersion);
                break;
            }
            case RECV: {
                iter = new ReceiveIter(in, serialVersion);
                break;
            }
            case CASE: {
                iter = new CaseIter(in, serialVersion);
                break;
            }
            case EXISTS: {
                iter = new ExistsIter(in, serialVersion);
                break;
            }
            case NOT: {
                iter = new NotIter(in, serialVersion);
                break;
            }
            case IS_NULL: {
                iter = new IsNullIter(in, serialVersion);
                break;
            }
            case FUNC_EXTRACT_FROM_TIMESTAMP: {
                iter = new FuncExtractFromTimestampIter(in, serialVersion);
                break;
            }
            case UPDATE_FIELD: {
                iter = new UpdateFieldIter(in, serialVersion);
                break;
            }
            case UPDATE_ROW: {
                iter = new UpdateRowIter(in, serialVersion);
                break;
            }
            case INSERT_ROW: {
                iter = new InsertRowIter(in, serialVersion);
                break;
            }
            case DELETE_ROW: {
                iter = new DeleteRowIter(in, serialVersion);
                break;
            }
            case FUNC_PARSE_JSON: {
                iter = new FuncParseJsonIter(in, serialVersion);
                break;
            }
            case FUNC_EXPIRATION_TIME: {
                iter = new FuncExpirationTimeIter(in, serialVersion);
                break;
            }
            case FUNC_EXPIRATION_TIME_MILLIS: {
                iter = new FuncExpirationTimeMillisIter(in, serialVersion);
                break;
            }
            case FUNC_CURRENT_TIME_MILLIS: {
                iter = new FuncCurrentTimeMillisIter(in, serialVersion);
                break;
            }
            case FUNC_CURRENT_TIME: {
                iter = new FuncCurrentTimeIter(in, serialVersion);
                break;
            }
            case FUNC_REMAINING_HOURS: {
                iter = new FuncRemainingHoursIter(in, serialVersion);
                break;
            }
            case FUNC_REMAINING_DAYS: {
                iter = new FuncRemainingDaysIter(in, serialVersion);
                break;
            }
            case FUNC_ROW_VERSION: {
                iter = new FuncRowVersionIter(in, serialVersion);
                break;
            }
            case FUNC_COUNT_STAR: {
                iter = new FuncCountStarIter(in, serialVersion);
                break;
            }
            case FUNC_COUNT: {
                iter = new FuncCountIter(in, serialVersion);
                break;
            }
            case FUNC_SUM: {
                iter = new FuncSumIter(in, serialVersion);
                break;
            }
            case FUNC_MIN_MAX: {
                iter = new FuncMinMaxIter(in, serialVersion);
                break;
            }
            case SEQ_MAP: {
                iter = new SeqMapIter(in, serialVersion);
                break;
            }
            case GEO_SEARCH: {
                iter = new FuncGeoSearchIter(in, serialVersion);
                break;
            }
            case GEO_DISTANCE: {
                iter = new FuncGeoDistanceIter(in, serialVersion);
                break;
            }
            case GEO_IS_GEOMETRY: {
                iter = new FuncGeoIsGeometryIter(in, serialVersion);
                break;
            }
            case SEQ_AGGR: {
                iter = new FuncSeqAggrIter(in, serialVersion);
                break;
            }
            case PARTITION_UNION: {
                iter = new PartitionUnionIter(in, serialVersion);
                break;
            }
            case FUNC_REGEX_LIKE: {
                iter = new FuncRegexLikeIter(in, serialVersion);
                break;
            }
            default: {
                throw new QueryStateException("Unknown query iterator kind: " + (Object)((Object)kind));
            }
        }
        return iter;
    }

    public static void serializeByteArray(byte[] array, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            if (array != null && array.length == 0) {
                array = null;
            }
            SerializationUtil.writeByteArray(out, array);
            return;
        }
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        for (byte element : array) {
            out.writeByte(element);
        }
    }

    public static byte[] deserializeByteArray(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            return SerializationUtil.readByteArray(in);
        }
        int len = in.readInt();
        if (len > 0) {
            byte[] array = new byte[len];
            for (int i = 0; i < len; ++i) {
                array[i] = in.readByte();
            }
            return array;
        }
        return null;
    }

    public static void serializeBooleanArray(boolean[] array, DataOutput out) throws IOException {
        if (array != null && array.length == 0) {
            array = null;
        }
        SerializationUtil.writeArrayLength(out, array);
        if (array != null) {
            for (boolean b : array) {
                out.writeBoolean(b);
            }
        }
    }

    public static boolean[] deserializeBooleanArray(DataInput in) throws IOException {
        int len = SerializationUtil.readSequenceLength(in);
        if (len == -1) {
            return null;
        }
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = in.readBoolean();
        }
        return array;
    }

    public static void serializeIntArray(int[] array, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            if (array != null && array.length == 0) {
                array = null;
            }
            SerializationUtil.writeArrayLength(out, array);
        } else {
            if (array == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(array.length);
        }
        if (array != null) {
            for (int element : array) {
                out.writeInt(element);
            }
        }
    }

    public static int[] deserializeIntArray(DataInput in, short serialVersion) throws IOException {
        int len;
        if (serialVersion >= 15 ? (len = SerializationUtil.readSequenceLength(in)) == -1 : (len = in.readInt()) <= 0) {
            return null;
        }
        int[] intArray = new int[len];
        for (int i = 0; i < len; ++i) {
            intArray[i] = in.readInt();
            PlanIter.checkPositiveInt(intArray[i], false);
        }
        return intArray;
    }

    static void serializeStringArray(String[] array, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            if (array != null && array.length == 0) {
                array = null;
            }
            SerializationUtil.writeArrayLength(out, array);
            if (array != null) {
                for (String s : array) {
                    SerializationUtil.writeNonNullString(out, serialVersion, s);
                }
            }
            return;
        }
        if (array == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(array.length);
        for (String element : array) {
            out.writeUTF(element);
        }
    }

    static String[] deserializeStringArray(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            int len = SerializationUtil.readSequenceLength(in);
            if (len == -1) {
                return null;
            }
            String[] array = new String[len];
            for (int i = 0; i < len; ++i) {
                array[i] = SerializationUtil.readNonNullString(in, serialVersion);
            }
            return array;
        }
        int len = in.readInt();
        if (len > 0) {
            String[] array = new String[len];
            for (int i = 0; i < len; ++i) {
                array[i] = in.readUTF();
            }
            return array;
        }
        return null;
    }

    static void serializeFieldRange(FieldRange range, DataOutput out, short serialVersion) throws IOException {
        if (range != null) {
            out.writeBoolean(true);
            range.writeFastExternal(out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    static FieldRange deserializeFieldRange(DataInput in, short serialVersion) throws IOException {
        boolean hasRange = in.readBoolean();
        if (hasRange) {
            return new FieldRange(in, serialVersion);
        }
        return null;
    }

    public static void serializeFieldDef(FieldDef def, DataOutput out, short serialVersion) throws IOException {
        FieldDefSerialization.writeFieldDef(def, out, serialVersion);
    }

    public static FieldDef deserializeFieldDef(DataInput in, short serialVersion) throws IOException {
        return FieldDefSerialization.readFieldDef(in, serialVersion);
    }

    public static void serializeQuantifier(ExprType.Quantifier quantifier, DataOutput out, short serialVersion) throws IOException {
        int code;
        switch (quantifier) {
            case ONE: {
                code = 1;
                break;
            }
            case QSTN: {
                code = 2;
                break;
            }
            case STAR: {
                code = 3;
                break;
            }
            case PLUS: {
                code = 4;
                break;
            }
            default: {
                throw new IOException("Unknown quantifier: " + quantifier.name());
            }
        }
        out.writeShort(code);
    }

    public static ExprType.Quantifier deserializeQuantifier(DataInput in, short serialVersion) throws IOException {
        short code = in.readShort();
        switch (code) {
            case 1: {
                return ExprType.Quantifier.ONE;
            }
            case 2: {
                return ExprType.Quantifier.QSTN;
            }
            case 3: {
                return ExprType.Quantifier.STAR;
            }
            case 4: {
                return ExprType.Quantifier.PLUS;
            }
        }
        throw new IOException("Unknown quantifier code: " + code);
    }

    public static void serializeFieldValues(FieldValueImpl[] values, DataOutput out, short serialVersion) throws IOException {
        if (values != null && values.length == 0) {
            values = null;
        }
        SerializationUtil.writeArrayLength(out, values);
        if (values != null) {
            for (FieldValueImpl v : values) {
                PlanIter.serializeFieldValue(v, out, serialVersion);
            }
        }
    }

    public static FieldValueImpl[] deserializeFieldValues(DataInput in, short serialVersion) throws IOException {
        int len = SerializationUtil.readSequenceLength(in);
        if (len == -1) {
            return null;
        }
        FieldValueImpl[] values = new FieldValueImpl[len];
        for (int i = 0; i < len; ++i) {
            values[i] = PlanIter.deserializeFieldValue(in, serialVersion);
        }
        return values;
    }

    static void serializeFieldValue(FieldValue value, DataOutput out, short serialVersion) throws IOException {
        FieldValueSerialization.writeFieldValue(value, true, out, serialVersion);
    }

    static FieldValueImpl deserializeFieldValue(DataInput in, short serialVersion) throws IOException {
        return (FieldValueImpl)FieldValueSerialization.readFieldValue(null, in, serialVersion);
    }

    static void serializeKey(RecordValueImpl value, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 21) {
            FieldValueSerialization.writeRecord(value, true, true, out, serialVersion);
        } else {
            FieldValueSerialization.writeNonNullFieldValue(value, true, true, out, serialVersion);
        }
    }

    static RecordValueImpl deserializeKey(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 21) {
            return FieldValueSerialization.readRecord(null, true, in, serialVersion);
        }
        return (RecordValueImpl)FieldValueSerialization.readNonNullFieldValue(null, null, in, serialVersion);
    }

    public static void serializeExprType(ExprType type, DataOutput out, short serialVersion) throws IOException {
        if (type != null) {
            out.writeBoolean(true);
            TypeManager.serializeExprType(type, out, serialVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    public static ExprType deserializeExprType(DataInput in, short serialVersion) throws IOException {
        boolean hasType = in.readBoolean();
        if (hasType) {
            return TypeManager.deserializeExprType(in, serialVersion);
        }
        return null;
    }

    static void serializeSortSpecs(SortSpec[] specs, DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 15) {
            if (specs != null && specs.length == 0) {
                specs = null;
            }
            SerializationUtil.writeArrayLength(out, specs);
            if (specs == null) {
                return;
            }
        } else {
            if (specs == null) {
                out.writeShort(0);
                return;
            }
            out.writeShort(specs.length);
        }
        for (SortSpec spec : specs) {
            spec.writeFastExternal(out, serialVersion);
        }
    }

    static SortSpec[] deserializeSortSpecs(DataInput in, short serialVersion) throws IOException {
        int num;
        if (serialVersion >= 15 ? (num = SerializationUtil.readSequenceLength(in)) == -1 : (num = (int)in.readShort()) == 0) {
            return null;
        }
        SortSpec[] specs = new SortSpec[num];
        for (int i = 0; i < num; ++i) {
            specs[i] = new SortSpec(in, serialVersion);
        }
        return specs;
    }

    public static String printKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return "null";
        }
        Key key = Key.fromByteArray(keyBytes);
        return key.toString();
    }

    public static String printByteArray(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (byte b : bytes) {
            sb.append(b).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    static class ParentItemContext {
        FieldValueImpl theParentItem = null;
        int theTargetPos = -1;
        String theTargetKey = null;

        ParentItemContext() {
        }

        void reset() {
            this.theParentItem = null;
            this.theTargetPos = -1;
            this.theTargetKey = null;
        }
    }

    public static enum PlanIterKind {
        CONST(0),
        VAR_REF(1),
        EXTERNAL_VAR_REF(2),
        ARRAY_CONSTR(3),
        BASE_TABLE(4),
        COMP_OP(5),
        ANY_OP(6),
        AND_OR(7),
        ARITH_OP(8),
        ARITH_UNARY_OP(9),
        PROMOTE(10),
        FIELD_STEP(11),
        ARRAY_SLICE(12),
        ARRAY_FILTER(13),
        SFW(14),
        FUNC_SIZE(15),
        FUNC_KEYS(16),
        RECV(17),
        CONCAT(18),
        CASE(19),
        MAP_CONSTR(20),
        EXISTS(21),
        NOT(22),
        MAP_FILTER(23),
        IS_OF_TYPE(24),
        CAST(25),
        IS_NULL(26),
        FUNC_EXTRACT_FROM_TIMESTAMP(27),
        UPDATE_FIELD(28),
        UPDATE_ROW(29),
        FUNC_EXPIRATION_TIME(30),
        FUNC_EXPIRATION_TIME_MILLIS(31),
        FUNC_CURRENT_TIME(32),
        FUNC_CURRENT_TIME_MILLIS(33),
        FUNC_REMAINING_HOURS(34),
        FUNC_REMAINING_DAYS(35),
        FUNC_ROW_VERSION(36),
        FUNC_COUNT_STAR(37),
        FUNC_COUNT(38),
        FUNC_SUM(39),
        FUNC_AVG(40),
        FUNC_MIN_MAX(41),
        SEQ_MAP(42),
        REC_CONSTR(43),
        GEO_SEARCH(44),
        GEO_DISTANCE(45),
        GEO_IS_GEOMETRY(46),
        SORT(47),
        SEQ_AGGR(48),
        INSERT_ROW(49),
        DELETE_ROW(50),
        FUNC_PARSE_JSON(51),
        PARTITION_UNION(52),
        FUNC_REGEX_LIKE(53);


        private PlanIterKind(int ord) {
            if (ord != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }
    }
}

