/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;
import oracle.kv.impl.api.parallelscan.ShardScanIterator;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.NumberValueImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.async.AbstractUncaughtResultHandler;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.runtime.BaseTableIter;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.FieldValue;

public class ReceiveIter
extends PlanIter {
    private static final long theFixedMemoryConsumption = SizeOf.OBJECT_REF_OVERHEAD + SizeOf.HASHSET_OVERHEAD + 8;
    private final PlanIter theInputIter;
    private volatile transient CachedBinaryPlan theSerializedInputIter = null;
    private final FieldDefImpl theInputType;
    private final boolean theMayReturnNULL;
    private final int[] theSortFieldPositions;
    private final SortSpec[] theSortSpecs;
    private final int[] thePrimKeyPositions;
    private final int[] theTupleRegs;
    private final PreparedStatementImpl.DistributionKind theDistributionKind;
    private final RecordValueImpl thePrimaryKey;
    private PartitionId thePartitionId;
    private final long theTableId;
    private final String theTableName;
    private final String theNamespace;
    private final PlanIter[] theShardKeyExternals;
    private final int theNumRegs;
    private final int theNumIters;
    private final boolean theIsUpdate;
    private volatile transient IterationHandleNotifier theAsyncIterHandleNotifier;

    public ReceiveIter(Expr e, int resultReg, PlanIter input, FieldDefImpl inputType, boolean mayReturnNULL, int[] sortFieldPositions, SortSpec[] sortSpecs, int[] primKeyPositions, PreparedStatementImpl.DistributionKind distrKind, PrimaryKeyImpl primKey, PlanIter[] shardkeyExternals, int numRegs, int numIters, boolean isUpdate, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theInputIter = input;
        this.theInputType = inputType;
        this.theMayReturnNULL = mayReturnNULL;
        this.theSortFieldPositions = sortFieldPositions;
        this.theSortSpecs = sortSpecs;
        this.thePrimKeyPositions = primKeyPositions;
        this.theDistributionKind = distrKind;
        this.theShardKeyExternals = shardkeyExternals;
        this.theTupleRegs = (int[])(input.producesTuples() && e.getQCB().getRootExpr() != e ? input.getTupleRegs() : null);
        this.theTableId = e.getQCB().getTargetTableId();
        if (primKey != null) {
            this.thePrimaryKey = primKey;
            this.theTableName = primKey.getTable().getFullName();
            this.theNamespace = primKey.getTable().getInternalNamespace();
            if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.theShardKeyExternals == null || this.theShardKeyExternals.length == 0)) {
                this.thePartitionId = primKey.getPartitionId(e.getQCB().getStore());
            }
        } else {
            this.thePrimaryKey = null;
            this.theTableName = null;
            this.theNamespace = null;
        }
        this.theNumRegs = numRegs;
        this.theNumIters = numIters;
        this.theIsUpdate = isUpdate;
    }

    public ReceiveIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNumRegs = ReceiveIter.readPositiveInt(in);
        this.theNumIters = ReceiveIter.readPositiveInt(in);
        this.theInputType = (FieldDefImpl)ReceiveIter.deserializeFieldDef(in, serialVersion);
        this.theMayReturnNULL = in.readBoolean();
        this.theSortFieldPositions = ReceiveIter.deserializeIntArray(in, serialVersion);
        this.theSortSpecs = ReceiveIter.deserializeSortSpecs(in, serialVersion);
        this.thePrimKeyPositions = ReceiveIter.deserializeIntArray(in, serialVersion);
        this.theTupleRegs = ReceiveIter.deserializeIntArray(in, serialVersion);
        short ordinal = in.readShort();
        this.theDistributionKind = PreparedStatementImpl.DistributionKind.values()[ordinal];
        this.theTableId = in.readLong();
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        if (this.theTableName != null) {
            this.theNamespace = SerializationUtil.readString(in, serialVersion);
            this.thePrimaryKey = ReceiveIter.deserializeKey(in, serialVersion);
        } else {
            this.thePrimaryKey = null;
            this.theNamespace = null;
        }
        this.theShardKeyExternals = ReceiveIter.deserializeIters(in, serialVersion);
        this.theIsUpdate = in.readBoolean();
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.theShardKeyExternals == null || this.theShardKeyExternals.length == 0)) {
            this.thePartitionId = new PartitionId(in.readInt());
        }
        byte[] bytes = SerializationUtil.readNonNullByteArray(in);
        this.setSerializedIter(bytes, serialVersion);
        this.theInputIter = null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theNumRegs);
        out.writeInt(this.theNumIters);
        ReceiveIter.serializeFieldDef(this.theInputType, out, serialVersion);
        out.writeBoolean(this.theMayReturnNULL);
        ReceiveIter.serializeIntArray(this.theSortFieldPositions, out, serialVersion);
        ReceiveIter.serializeSortSpecs(this.theSortSpecs, out, serialVersion);
        ReceiveIter.serializeIntArray(this.thePrimKeyPositions, out, serialVersion);
        ReceiveIter.serializeIntArray(this.theTupleRegs, out, serialVersion);
        out.writeShort(this.theDistributionKind.ordinal());
        out.writeLong(this.theTableId);
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        if (this.theTableName != null) {
            SerializationUtil.writeString(out, serialVersion, this.theNamespace);
            ReceiveIter.serializeKey(this.thePrimaryKey, out, serialVersion);
        }
        ReceiveIter.serializeIters(this.theShardKeyExternals, out, serialVersion);
        out.writeBoolean(this.theIsUpdate);
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION && (this.theShardKeyExternals == null || this.theShardKeyExternals.length == 0)) {
            out.writeInt(this.thePartitionId.getPartitionId());
        }
        byte[] bytes = this.ensureSerializedIter(serialVersion);
        SerializationUtil.writeNonNullByteArray(out, bytes);
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        int i;
        RecordDefImpl recDef;
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        out.writeShort(this.theDistributionKind.ordinal());
        String[] sortFields = null;
        String[] primKeyFields = null;
        if (this.theSortFieldPositions != null) {
            recDef = (RecordDefImpl)this.theInputType;
            sortFields = new String[this.theSortFieldPositions.length];
            for (i = 0; i < sortFields.length; ++i) {
                sortFields[i] = recDef.getFieldName(this.theSortFieldPositions[i]);
            }
        }
        if (this.thePrimKeyPositions != null) {
            recDef = (RecordDefImpl)this.theInputType;
            primKeyFields = new String[this.thePrimKeyPositions.length];
            for (i = 0; i < primKeyFields.length; ++i) {
                primKeyFields[i] = recDef.getFieldName(this.thePrimKeyPositions[i]);
            }
        }
        CloudSerializer.writeStringArray(sortFields, out);
        CloudSerializer.writeSortSpecs(this.theSortSpecs, out);
        CloudSerializer.writeStringArray(primKeyFields, out);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.RECV;
    }

    public int getNumRegisters() {
        return this.theNumRegs;
    }

    public int getNumIterators() {
        return this.theNumIters;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    public boolean doesSort() {
        return this.theSortFieldPositions != null;
    }

    public boolean hasSortPhase1Result(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state.theRemoteResultsIter instanceof AllPartitionsIterator) {
            AllPartitionsIterator iter = (AllPartitionsIterator)state.theRemoteResultsIter;
            return iter.hasSortPhase1Result();
        }
        return false;
    }

    public int writeSortPhase1Results(RuntimeControlBlock rcb, DataOutput out, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        AllPartitionsIterator iter = (AllPartitionsIterator)state.theRemoteResultsIter;
        return iter.writeSortPhase1Results(rcb, out, valWriter);
    }

    public boolean eliminatesDuplicates() {
        return this.thePrimKeyPositions != null;
    }

    public FieldDefImpl getResultDef() {
        return this.theInputType;
    }

    @Override
    public void setIterationHandleNotifier(IterationHandleNotifier iterHandleNotifier) {
        this.theAsyncIterHandleNotifier = iterHandleNotifier;
    }

    public byte[] ensureSerializedIter(short serialVersion) {
        CachedBinaryPlan cachedPlan = this.theSerializedInputIter;
        if (cachedPlan != null && cachedPlan.getPlan() != null && cachedPlan.getSerialVersion() == serialVersion) {
            return cachedPlan.thePlan;
        }
        ReceiveIter receiveIter = this;
        synchronized (receiveIter) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(baos);
                PlanIter.serializeIter(this.theInputIter, dataOut, serialVersion);
                byte[] ba = baos.toByteArray();
                this.theSerializedInputIter = cachedPlan = CachedBinaryPlan.create(ba, serialVersion);
                return ba;
            }
            catch (IOException ioe) {
                throw new QueryException(ioe);
            }
        }
    }

    public synchronized void setSerializedIter(byte[] bytes, short serialVersion) {
        assert (this.theSerializedInputIter == null);
        this.theSerializedInputIter = CachedBinaryPlan.create(bytes, serialVersion);
    }

    private void ensureIterator(RuntimeControlBlock rcb, ReceiveIterState state) {
        if (state.theRemoteResultsIter != null) {
            return;
        }
        switch (this.theDistributionKind) {
            case SINGLE_PARTITION: {
                state.theRemoteResultsIter = this.runOnOnePartition(rcb);
                break;
            }
            case ALL_PARTITIONS: {
                state.theRemoteResultsIter = this.runOnAllPartitions(rcb);
                break;
            }
            case ALL_SHARDS: {
                state.theRemoteResultsIter = this.runOnAllShards(rcb);
                break;
            }
            default: {
                throw new QueryStateException("Unknown distribution kind: " + (Object)((Object)this.theDistributionKind));
            }
        }
        rcb.setTableIterator(state.theRemoteResultsIter);
    }

    private AsyncTableIterator<FieldValueImpl> runOnAllPartitions(final RuntimeControlBlock rcb) {
        final ExecuteOptions options = rcb.getExecuteOptions();
        if (rcb.getUseBytesLimit() || rcb.getUseBatchSizeAsLimit()) {
            if (options.getDriverQueryVersion() >= 2) {
                return new AllPartitionsIterator(rcb);
            }
            return new SequentialPartitionsIterator(rcb, null);
        }
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        StoreIteratorParams params = new StoreIteratorParams(dir, rcb.getBatchSize(), null, null, Depth.PARENT_AND_DESCENDANTS, rcb.getConsistency(), rcb.getTimeout(), rcb.getTimeUnit(), rcb.getPartitionSet());
        return new PartitionScanIterator<FieldValueImpl>(rcb.getStore(), options, params, this.theAsyncIterHandleNotifier){

            @Override
            protected QueryPartitionStream createStream(RepGroupId groupId, int partitionId) {
                return new QueryPartitionStream(groupId, partitionId);
            }

            @Override
            protected TableQuery generateGetterOp(byte[] resumeKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryPartitionStream
            extends PartitionScanIterator.PartitionStream {
                private ResumeInfo theResumeInfo;

                QueryPartitionStream(RepGroupId groupId, int partitionId) {
                    super(groupId, partitionId, null);
                    this.theResumeInfo = new ResumeInfo(rcb);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(PreparedStatementImpl.DistributionKind.ALL_PARTITIONS, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, rcb.getMathContext(), rcb.getTraceLevel(), rcb.getBatchSize(), 0, 0, 0, this.theResumeInfo, 1, rcb.getDeleteLimit());
                    if (ReceiveIter.this.theIsUpdate) {
                        Request req = storeImpl.makeWriteRequest((InternalOperation)op, new PartitionId(this.partitionId), rcb.getDurability(), rcb.getTimeout(), rcb.getTimeUnit());
                        if (options != null) {
                            req.setAuthContext(options.getAuthContext());
                            req.setLogContext(options.getLogContext());
                        }
                        return req;
                    }
                    Request req = storeImpl.makeReadRequest((InternalOperation)op, new PartitionId(this.partitionId), storeIteratorParams.getConsistency(), storeIteratorParams.getTimeout(), storeIteratorParams.getTimeoutUnit());
                    if (options != null) {
                        req.setAuthContext(options.getAuthContext());
                        req.setLogContext(options.getLogContext());
                    }
                    return req;
                }

                @Override
                protected void setResumeKey(Result result) {
                    Result.QueryResult res = (Result.QueryResult)result;
                    this.theResumeInfo.refresh(res.getResumeInfo());
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("Received " + res.getNumRecords() + " results from group : " + this.groupId + " partition " + this.partitionId);
                    }
                    if (rcb.getTraceLevel() >= 4) {
                        rcb.trace(this.theResumeInfo.toString());
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryPartitionStream other = (QueryPartitionStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.compareRecords(rec1, rec2, ReceiveIter.this.theSortFieldPositions, ReceiveIter.this.theSortSpecs);
                    } else {
                        cmp = ReceiveIter.compareAtomics(v1, v2, 0, ReceiveIter.this.theSortSpecs);
                    }
                    if (cmp == 0) {
                        return this.partitionId < other.partitionId ? -1 : 1;
                    }
                    return cmp;
                }
            }
        };
    }

    private AsyncTableIterator<FieldValueImpl> runOnOnePartition(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        return new SinglePartitionIterator(rcb, state.thePartitionId);
    }

    private AsyncTableIterator<FieldValueImpl> runOnAllShards(final RuntimeControlBlock rcb) {
        if (rcb.getUseBytesLimit() || rcb.getUseBatchSizeAsLimit()) {
            return new SequentialShardsIterator(rcb);
        }
        Direction dir = this.theSortFieldPositions != null ? Direction.FORWARD : Direction.UNORDERED;
        return new ShardScanIterator<FieldValueImpl>(rcb.getStore(), rcb.getExecuteOptions(), dir, rcb.getShardSet(), this.theAsyncIterHandleNotifier){

            @Override
            protected QueryShardStream createStream(RepGroupId groupId) {
                return new QueryShardStream(groupId);
            }

            @Override
            protected TableQuery createOp(byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
                throw new QueryStateException("Unexpected call");
            }

            @Override
            protected void convertResult(Result result, List<FieldValueImpl> elementList) {
                List<FieldValueImpl> queryResults = result.getQueryResults();
                for (FieldValueImpl res : queryResults) {
                    elementList.add(res);
                }
            }

            @Override
            protected int compare(FieldValueImpl one, FieldValueImpl two) {
                throw new QueryStateException("Unexpected call");
            }

            class QueryShardStream
            extends ShardScanIterator.ShardStream {
                private ResumeInfo theResumeInfo;

                QueryShardStream(RepGroupId groupId) {
                    super(groupId, null, null);
                    this.theResumeInfo = new ResumeInfo(rcb);
                }

                @Override
                protected Request makeReadRequest() {
                    TableQuery op = new TableQuery(PreparedStatementImpl.DistributionKind.ALL_SHARDS, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, rcb.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, rcb.getMathContext(), rcb.getTraceLevel(), rcb.getBatchSize(), 0, 0, 0, this.theResumeInfo, 1, rcb.getDeleteLimit());
                    ExecuteOptions exeOptions = rcb.getExecuteOptions();
                    if (ReceiveIter.this.theIsUpdate) {
                        Request req = storeImpl.makeWriteRequest((InternalOperation)op, this.groupId, rcb.getDurability(), requestTimeoutMs, TimeUnit.MILLISECONDS);
                        if (exeOptions != null) {
                            req.setLogContext(exeOptions.getLogContext());
                            req.setAuthContext(exeOptions.getAuthContext());
                        }
                        return req;
                    }
                    Request req = storeImpl.makeReadRequest((InternalOperation)op, this.groupId, consistency, requestTimeoutMs, TimeUnit.MILLISECONDS);
                    if (exeOptions != null) {
                        req.setLogContext(exeOptions.getLogContext());
                        req.setAuthContext(exeOptions.getAuthContext());
                    }
                    return req;
                }

                @Override
                protected void setResumeKey(Result result) {
                    Result.QueryResult res = (Result.QueryResult)result;
                    this.theResumeInfo.refresh(res.getResumeInfo());
                    if (rcb.getTraceLevel() >= 1) {
                        rcb.trace("Received " + res.getNumRecords() + " results from shard : " + this.groupId);
                    }
                    if (rcb.getTraceLevel() >= 4) {
                        rcb.trace(this.theResumeInfo.toString());
                    }
                }

                @Override
                protected int compareInternal(BaseParallelScanIteratorImpl.Stream o) {
                    int cmp;
                    QueryShardStream other = (QueryShardStream)o;
                    FieldValueImpl v1 = this.currentResultSet.getQueryResults().get(this.currentResultPos);
                    FieldValueImpl v2 = other.currentResultSet.getQueryResults().get(other.currentResultPos);
                    if (ReceiveIter.this.theInputType.isRecord()) {
                        RecordValueImpl rec1 = (RecordValueImpl)v1;
                        RecordValueImpl rec2 = (RecordValueImpl)v2;
                        cmp = ReceiveIter.compareRecords(rec1, rec2, ReceiveIter.this.theSortFieldPositions, ReceiveIter.this.theSortSpecs);
                    } else {
                        cmp = ReceiveIter.compareAtomics(v1, v2, 0, ReceiveIter.this.theSortSpecs);
                    }
                    if (cmp == 0) {
                        return this.getGroupId().compareTo(other.getGroupId());
                    }
                    return cmp;
                }
            }
        };
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        boolean alwaysFalse = false;
        PartitionId pid = PartitionId.NULL_ID;
        if (this.theDistributionKind == PreparedStatementImpl.DistributionKind.SINGLE_PARTITION) {
            if (this.theShardKeyExternals != null && this.theShardKeyExternals.length > 0) {
                TableImpl table;
                PrimaryKeyImpl primaryKey;
                if (this.thePrimaryKey instanceof PrimaryKeyImpl) {
                    primaryKey = (PrimaryKeyImpl)this.thePrimaryKey.clone();
                    table = primaryKey.getTable();
                } else {
                    table = rcb.getMetadataHelper().getTable(this.theNamespace, this.theTableName);
                    primaryKey = table.createPrimaryKey(this.thePrimaryKey);
                }
                int size = this.theShardKeyExternals.length;
                for (int i = 0; i < size; ++i) {
                    PlanIter iter = this.theShardKeyExternals[i];
                    if (iter == null) continue;
                    iter.open(rcb);
                    iter.next(rcb);
                    FieldValueImpl val = rcb.getRegVal(iter.getResultReg());
                    iter.close(rcb);
                    FieldValueImpl newVal = BaseTableIter.castValueToIndexKey(table, null, i, val, FunctionLib.FuncCode.OP_EQ);
                    if (newVal != val) {
                        if (newVal == BooleanValueImpl.falseValue) {
                            alwaysFalse = true;
                            break;
                        }
                        val = newVal;
                    }
                    String colName = table.getPrimaryKeyColumnName(i);
                    primaryKey.put(colName, (FieldValue)val);
                }
                pid = primaryKey.getPartitionId(rcb.getStore());
            } else {
                pid = this.thePartitionId;
            }
        }
        ReceiveIterState state = new ReceiveIterState(pid, this.thePrimKeyPositions != null);
        rcb.setState(this.theStatePos, state);
        rcb.incMemoryConsumption(state.theMemoryConsumption);
        if (this.theTupleRegs != null) {
            TupleValue tuple = new TupleValue((RecordDefImpl)this.theInputType, rcb.getRegisters(), this.theTupleRegs);
            rcb.setRegVal(this.theResultReg, tuple);
        }
        if (alwaysFalse) {
            state.done();
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, false);
    }

    @Override
    public boolean nextLocal(RuntimeControlBlock rcb) {
        return this.nextInternal(rcb, true);
    }

    private boolean nextInternal(RuntimeControlBlock rcb, boolean localOnly) {
        try {
            boolean convertEmptyToNull;
            FieldValueImpl res;
            block19: {
                BinaryValueImpl binPrimKey;
                boolean added;
                ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
                if (state.isDone()) {
                    return false;
                }
                this.ensureIterator(rcb, state);
                do {
                    if (localOnly) {
                        res = state.theRemoteResultsIter.nextLocal();
                        if (res == null) {
                            if (state.theRemoteResultsIter.isClosed() && !state.isClosed()) {
                                state.done();
                            }
                            return false;
                        }
                    } else {
                        boolean more = state.theRemoteResultsIter.hasNext();
                        if (!more) {
                            if (state.theRemoteResultsIter instanceof AllPartitionsIterator) {
                                AllPartitionsIterator iter = (AllPartitionsIterator)state.theRemoteResultsIter;
                                if (!iter.hasSortPhase1Result()) {
                                    state.done();
                                }
                            } else {
                                state.done();
                            }
                            return false;
                        }
                        res = (FieldValueImpl)state.theRemoteResultsIter.next();
                        if (rcb.getTraceLevel() >= 3) {
                            rcb.trace("ReceiveIter: received result " + res);
                        }
                    }
                    if (this.thePrimKeyPositions == null) break block19;
                } while (!(added = state.thePrimKeysSet.add(binPrimKey = this.createBinaryPrimKey(res))));
                long sz = binPrimKey.sizeof() + 24L;
                state.theMemoryConsumption += sz;
                rcb.incMemoryConsumption(sz);
            }
            boolean bl = convertEmptyToNull = this.doesSort() && res.isRecord() && !rcb.isCloudQuery();
            if (this.theTupleRegs != null) {
                TupleValue tuple = (TupleValue)rcb.getRegVal(this.theResultReg);
                tuple.toTuple((RecordValueImpl)res, convertEmptyToNull);
            } else if (convertEmptyToNull) {
                ((RecordValueImpl)res).convertEmptyToNull();
                rcb.setRegVal(this.theResultReg, res);
            } else {
                rcb.setRegVal(this.theResultReg, res.isEMPTY() ? NullValueImpl.getInstance() : res);
            }
            return true;
        }
        catch (StoreIteratorException sie) {
            Throwable cause = sie.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Unexpected exception: " + cause, cause);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        rcb.decMemoryConsumption(state.theMemoryConsumption - theFixedMemoryConsumption);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    public Throwable getCloseException(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return null;
        }
        if (state.theRemoteResultsIter != null) {
            return state.theRemoteResultsIter.getCloseException();
        }
        return state.theRemoteResultsIterCloseException;
    }

    private BinaryValueImpl createBinaryPrimKey(FieldValueImpl result) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            if (!result.isRecord()) {
                assert (this.thePrimKeyPositions.length == 1);
                this.writeValue(out, result, 0);
            } else {
                for (int i = 0; i < this.thePrimKeyPositions.length; ++i) {
                    FieldValueImpl fval = ((RecordValueImpl)result).get(this.thePrimKeyPositions[i]);
                    this.writeValue(out, fval, i);
                }
            }
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to create binary prim key due to IOException:\n" + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return FieldDefImpl.binaryDef.createBinary(bytes);
    }

    private void writeValue(DataOutput out, FieldValueImpl val, int i) throws IOException {
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, val.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, val.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(val.getDouble());
                break;
            }
            case FLOAT: {
                out.writeFloat(val.getFloat());
                break;
            }
            case STRING: {
                SerializationUtil.writeString(out, SerialVersion.CURRENT, val.getString());
                break;
            }
            case ENUM: {
                out.writeShort(val.asEnum().getIndex());
                break;
            }
            case TIMESTAMP: {
                TimestampValueImpl ts = (TimestampValueImpl)val;
                SerializationUtil.writeNonNullByteArray(out, ts.getBytes());
                break;
            }
            case NUMBER: {
                NumberValueImpl num = (NumberValueImpl)val;
                SerializationUtil.writeNonNullByteArray(out, num.getBytes());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected type for primary key column : " + val.getType() + ", at result column " + i);
            }
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        if (this.theSortFieldPositions != null) {
            formatter.indent(sb);
            sb.append("Sort Field Positions : ");
            for (i = 0; i < this.theSortFieldPositions.length; ++i) {
                sb.append(this.theSortFieldPositions[i]);
                if (i >= this.theSortFieldPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        if (this.thePrimKeyPositions != null) {
            formatter.indent(sb);
            sb.append("Primary Key Positions : ");
            for (i = 0; i < this.thePrimKeyPositions.length; ++i) {
                sb.append(this.thePrimKeyPositions[i]);
                if (i >= this.thePrimKeyPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        formatter.indent(sb);
        sb.append("DistributionKind : ").append((Object)this.theDistributionKind);
        sb.append(",\n");
        if (this.theShardKeyExternals != null) {
            sb.append("\n");
            formatter.indent(sb);
            sb.append("EXTERNAL KEY EXPRS: ").append(this.theShardKeyExternals.length);
            for (PlanIter iter : this.theShardKeyExternals) {
                sb.append("\n");
                if (iter != null) {
                    iter.display(sb, formatter);
                    continue;
                }
                formatter.indent(sb);
                sb.append("null");
            }
            sb.append(",\n\n");
        }
        formatter.indent(sb);
        sb.append("Number of Registers :").append(this.theNumRegs);
        sb.append(",\n");
        formatter.indent(sb);
        sb.append("Number of Iterators :").append(this.theNumIters);
        sb.append(",\n");
        if (this.theInputIter != null) {
            this.theInputIter.display(sb, formatter);
        }
    }

    static int compareRecords(RecordValueImpl rec1, RecordValueImpl rec2, int[] sortFieldPositions, SortSpec[] sortSpecs) {
        for (int i = 0; i < sortFieldPositions.length; ++i) {
            FieldValueImpl v2;
            int pos = sortFieldPositions[i];
            FieldValueImpl v1 = rec1.get(pos);
            int comp = ReceiveIter.compareAtomics(v1, v2 = rec2.get(pos), i, sortSpecs);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    static int compareAtomics(FieldValueImpl v1, FieldValueImpl v2, int sortPos, SortSpec[] sortSpecs) {
        int comp = v1.isNull() ? (v2.isNull() ? 0 : (sortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : (v1.isEMPTY() ? (v2.isEMPTY() ? 0 : (v2.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : (sortSpecs[sortPos].theNullsFirst ? -1 : 1))) : (v2.isEMPTY() ? (v1.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? -1 : 1) : (sortSpecs[sortPos].theNullsFirst ? 1 : -1)) : (v1.isJsonNull() ? (v1.isJsonNull() ? 0 : (sortSpecs[sortPos].theNullsFirst ? -1 : 1)) : (v2.isJsonNull() ? (sortSpecs[sortPos].theNullsFirst ? 1 : -1) : v1.compareTo(v2))))));
        return sortSpecs[sortPos].theIsDesc ? -comp : comp;
    }

    private class AbstractScanIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private PartitionId thePid;
        private RepGroupId theGroupId;
        private int theMaxResults;
        private int theMaxReadKB;
        private int theMaxWriteKB;
        private int theEmptyReadFactor;
        private Result.QueryResult theResult;
        private Iterator<FieldValueImpl> theResultsIter;
        private boolean theMoreRemoteResults;
        private Throwable theAsyncCloseException;
        private boolean theIsClosed;
        private boolean theAsyncRequestExecuting;

        public AbstractScanIterator(RuntimeControlBlock rcb, PartitionId pid, RepGroupId gid, int emptyReadFactor) {
            this.theRCB = rcb;
            this.thePid = pid;
            this.theGroupId = gid;
            this.theMaxResults = this.theRCB.getBatchSize();
            this.theMaxReadKB = this.theRCB.getMaxReadKB();
            this.theMaxWriteKB = this.theRCB.getMaxWriteKB();
            this.theMoreRemoteResults = true;
            this.theResultsIter = null;
            this.theEmptyReadFactor = emptyReadFactor;
        }

        void initForNextPartition(PartitionId pid, int emptyReadFactor) {
            this.initForNextScan(pid, null, emptyReadFactor);
        }

        void initForNextShard(RepGroupId gid, int emptyReadFactor) {
            this.initForNextScan(null, gid, emptyReadFactor);
        }

        private void initForNextScan(PartitionId pid, RepGroupId gid, int emptyReadFactor) {
            this.thePid = pid;
            this.theGroupId = gid;
            this.theRCB.getResumeInfo().reset();
            this.theMoreRemoteResults = true;
            this.theResultsIter = null;
            this.theEmptyReadFactor = emptyReadFactor;
        }

        Request createRequest() {
            TableQuery op = new TableQuery(ReceiveIter.this.theDistributionKind, ReceiveIter.this.theInputType, ReceiveIter.this.theMayReturnNULL, ReceiveIter.this, this.theRCB.getExternalVars(), ReceiveIter.this.theNumIters, ReceiveIter.this.theNumRegs, ReceiveIter.this.theTableId, this.theRCB.getMathContext(), this.theRCB.getTraceLevel(), this.theMaxResults, this.theRCB.getMaxReadKB(), this.theMaxReadKB, this.theMaxWriteKB, this.theRCB.getResumeInfo(), this.theEmptyReadFactor, this.theRCB.getDeleteLimit());
            Consistency consistency = this.theRCB.getConsistency();
            Durability durability = this.theRCB.getDurability();
            long timeout = this.theRCB.getTimeout();
            TimeUnit timeUnit = this.theRCB.getTimeUnit();
            KVStoreImpl store = this.theRCB.getStore();
            ExecuteOptions execOptions = this.theRCB.getExecuteOptions();
            if (this.thePid != null) {
                if (ReceiveIter.this.theIsUpdate) {
                    Request req = store.makeWriteRequest((InternalOperation)op, this.thePid, durability, timeout, timeUnit);
                    if (execOptions != null) {
                        req.setLogContext(execOptions.getLogContext());
                        req.setAuthContext(execOptions.getAuthContext());
                    }
                    return req;
                }
                Request req = store.makeReadRequest((InternalOperation)op, this.thePid, consistency, timeout, timeUnit);
                if (execOptions != null) {
                    req.setLogContext(execOptions.getLogContext());
                    req.setAuthContext(execOptions.getAuthContext());
                }
                return req;
            }
            if (ReceiveIter.this.theIsUpdate) {
                Request req = store.makeWriteRequest((InternalOperation)op, this.theGroupId, durability, timeout, timeUnit);
                if (execOptions != null) {
                    req.setLogContext(execOptions.getLogContext());
                    req.setAuthContext(execOptions.getAuthContext());
                }
                return req;
            }
            Request req = store.makeReadRequest((InternalOperation)op, this.theGroupId, consistency, timeout, timeUnit);
            if (execOptions != null) {
                req.setLogContext(execOptions.getLogContext());
                req.setAuthContext(execOptions.getAuthContext());
            }
            return req;
        }

        boolean hasMoreRemoteResults() {
            return this.theMoreRemoteResults;
        }

        List<FieldValueImpl> getLocalResults() {
            return this.theResult.getQueryResults();
        }

        int[] getPids() {
            return this.theResult.getPids();
        }

        int[] getNumResultsPerPid() {
            return this.theResult.getNumResultsPerPid();
        }

        ResumeInfo getResumeInfo(int i) {
            return this.theResult.getResumeInfo(i);
        }

        @Override
        public boolean hasNext() {
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return true;
            }
            this.theResultsIter = null;
            if (!this.theMoreRemoteResults || this.theRCB.getReachedLimit()) {
                return false;
            }
            Request req = this.createRequest();
            if (this.theRCB.getTraceLevel() >= 2) {
                if (this.thePid != null) {
                    this.theRCB.trace("AbstractScanIterator: Executing remote request for partition " + this.thePid + " with read limit = " + this.theMaxReadKB);
                } else {
                    this.theRCB.trace("AbstractScanIterator: Executing remote request for shard " + this.theGroupId + " with read limit = " + this.theMaxReadKB);
                }
            }
            KVStoreImpl store = this.theRCB.getStore();
            this.theResult = (Result.QueryResult)store.executeRequest(req);
            return this.processResults();
        }

        private boolean processResults() {
            List<FieldValueImpl> results = this.theResult.getQueryResults();
            this.theMoreRemoteResults = this.theResult.hasMoreElements();
            this.theRCB.getResumeInfo().refresh(this.theResult.getResumeInfo());
            this.theRCB.tallyReadKB(this.theResult.getReadKB());
            this.theRCB.tallyWriteKB(this.theResult.getWriteKB());
            if (this.theRCB.getUseBatchSizeAsLimit()) {
                this.theRCB.tallyResultSize(results.size());
            }
            if (this.theRCB.getTraceLevel() >= 2) {
                this.theRCB.trace("AbstractScanIterator: received " + results.size() + " results from partition " + this.thePid + ". Num bytes read = " + this.theResult.getReadKB() + " more remote results = " + this.theMoreRemoteResults + " reached byte limit =" + this.theResult.getExceededSizeLimit());
            }
            if (!this.theResult.getExceededSizeLimit()) {
                this.theMaxReadKB -= this.theResult.getReadKB();
                this.theMaxWriteKB -= this.theResult.getWriteKB();
                if (this.theRCB.getUseBatchSizeAsLimit()) {
                    this.theMaxResults -= results.size();
                }
            }
            boolean reachedLimit = this.theResult.getExceededSizeLimit() || this.theRCB.getMaxReadKB() > 0 && this.theMaxReadKB <= 0 || this.theRCB.getMaxWriteKB() > 0 && this.theMaxWriteKB <= 0 || this.theRCB.getUseBatchSizeAsLimit() && this.theMaxResults <= 0;
            this.theRCB.setReachedLimit(reachedLimit);
            if (this.theRCB.getTraceLevel() >= 2) {
                this.theRCB.trace("AbstractScanIterator: remaining limits = (" + this.theMaxReadKB + ", " + this.theMaxWriteKB + ", " + this.theMaxResults + ") reached limit = " + reachedLimit);
            }
            if (results.isEmpty()) {
                assert (this.theResult.getExceededSizeLimit() || !this.theMoreRemoteResults);
                return false;
            }
            this.theResultsIter = results.iterator();
            if (this.thePid != null) {
                this.thePid = new PartitionId(this.theRCB.getResumeInfo().getCurrentPid());
            }
            return true;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException("nextLocal called with lock held");
            }
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return this.theResultsIter.next();
            }
            if (this.theAsyncCloseException instanceof RuntimeException) {
                throw (RuntimeException)this.theAsyncCloseException;
            }
            if (this.theAsyncCloseException instanceof Error) {
                throw (Error)this.theAsyncCloseException;
            }
            if (this.theAsyncCloseException != null) {
                throw new IllegalStateException("Unexpected exception from async iteration: " + this.theAsyncCloseException, this.theAsyncCloseException);
            }
            if (this.isClosed()) {
                return null;
            }
            if (this.theAsyncRequestExecuting) {
                return null;
            }
            Request request = this.createRequest();
            this.theAsyncRequestExecuting = true;
            this.theRCB.getStore().executeRequest(request, (ResultHandler<Result>)new AbstractUncaughtResultHandler<Result>(){

                @Override
                protected void uncaughtException(Throwable e) {
                    AbstractScanIterator.this.theAsyncCloseException = e;
                    AbstractScanIterator.this.close();
                }

                @Override
                protected void onResultInternal(Result r, Throwable e) {
                    AbstractScanIterator.this.theAsyncRequestExecuting = false;
                    AbstractScanIterator.this.theResult = (Result.QueryResult)r;
                    AbstractScanIterator.this.handleExecuteResult(e);
                }
            });
            return null;
        }

        private void handleExecuteResult(Throwable e) {
            assert (!Thread.holdsLock(this));
            if (this.theResult != null) {
                this.processResults();
            } else {
                this.theAsyncCloseException = e;
                this.close();
            }
            ReceiveIter.this.theAsyncIterHandleNotifier.notifyNext();
        }

        @Override
        public FieldValueImpl next() {
            if (!this.theResultsIter.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.theResultsIter.next();
        }

        @Override
        public void close() {
            this.theResultsIter = null;
            this.theIsClosed = true;
        }

        @Override
        public boolean isClosed() {
            if (this.theIsClosed) {
                return true;
            }
            if (this.theResultsIter != null && this.theResultsIter.hasNext()) {
                return false;
            }
            if (!this.theMoreRemoteResults) {
                this.close();
                return true;
            }
            return false;
        }

        @Override
        public synchronized Throwable getCloseException() {
            return this.theAsyncCloseException;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }
    }

    private class SequentialShardsIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private final RepGroupId[] theShards;
        private AbstractScanIterator theShardIter;

        SequentialShardsIterator(RuntimeControlBlock rcb) {
            this.theRCB = rcb;
            Set<RepGroupId> gpIds = rcb.getShardSet();
            if (gpIds == null) {
                gpIds = rcb.getStore().getTopology().getRepGroupIds();
            }
            this.theShards = gpIds.toArray(new RepGroupId[gpIds.size()]);
            int shardIdx = this.theRCB.getShardIdx();
            if (shardIdx < 0 || shardIdx >= this.theShards.length) {
                throw new IllegalArgumentException("Invalid shard id in continuation key: " + shardIdx);
            }
            int emptyReadFactor = this.theShards.length == 1 ? 1 : 0;
            this.theShardIter = new AbstractScanIterator(this.theRCB, null, this.theShards[shardIdx], emptyReadFactor);
        }

        @Override
        public boolean hasNext() {
            if (this.theShardIter == null) {
                return false;
            }
            while (!this.theShardIter.hasNext()) {
                int shardIdx;
                if (this.theRCB.getReachedLimit()) {
                    if (!this.theShardIter.hasMoreRemoteResults() && (shardIdx = this.theRCB.incShardIdx()) == this.theShards.length) {
                        this.close();
                        this.theRCB.setContinuationKey(null);
                        return false;
                    }
                    this.theRCB.createContinuationKey();
                    return false;
                }
                shardIdx = this.theRCB.incShardIdx();
                if (shardIdx == this.theShards.length) {
                    this.close();
                    this.theRCB.setContinuationKey(null);
                    return false;
                }
                int emptyReadFactor = this.theRCB.getReadKB() == 0 && shardIdx == this.theShards.length - 1 ? 1 : 0;
                this.theShardIter.initForNextShard(this.theShards[shardIdx], emptyReadFactor);
            }
            return true;
        }

        @Override
        public FieldValueImpl next() {
            return this.theShardIter.next();
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.theShardIter == null) {
                return null;
            }
            return this.theShardIter.nextLocal();
        }

        @Override
        public void close() {
            if (this.theShardIter != null) {
                this.theShardIter.close();
                this.theShardIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.theShardIter == null || this.theShardIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.theShardIter != null ? this.theShardIter.getCloseException() : null;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SequentialPartitionsIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private final PartitionId[] thePartitions;
        private AbstractScanIterator thePartitionIter;

        SequentialPartitionsIterator(RuntimeControlBlock rcb, PartitionId[] partitions) {
            this.theRCB = rcb;
            if (partitions != null) {
                this.thePartitions = partitions;
            } else {
                Set pids = rcb.getStore().getTopology().getPartitionMap().getAllIds();
                this.thePartitions = pids.toArray(new PartitionId[pids.size()]);
            }
            int pidIdx = rcb.getPidIdx();
            if (pidIdx < 0 || pidIdx >= this.thePartitions.length) {
                throw new IllegalArgumentException("Invalid partition id in continuation key: " + pidIdx);
            }
            int emptyReadFactor = this.thePartitions.length == 1 ? 1 : 0;
            this.thePartitionIter = new AbstractScanIterator(this.theRCB, this.thePartitions[pidIdx], null, emptyReadFactor);
        }

        @Override
        public boolean hasNext() {
            if (this.thePartitionIter == null) {
                return false;
            }
            while (!this.thePartitionIter.hasNext()) {
                int pidIdx;
                if (this.theRCB.getReachedLimit()) {
                    if (!this.thePartitionIter.hasMoreRemoteResults() && (pidIdx = this.theRCB.incPidIdx()) == this.thePartitions.length) {
                        this.close();
                        this.theRCB.setContinuationKey(null);
                        return false;
                    }
                    this.theRCB.createContinuationKey();
                    return false;
                }
                pidIdx = this.theRCB.incPidIdx();
                if (pidIdx == this.thePartitions.length) {
                    this.close();
                    this.theRCB.setContinuationKey(null);
                    return false;
                }
                int emptyReadFactor = this.theRCB.getReadKB() == 0 && pidIdx == this.thePartitions.length - 1 ? 1 : 0;
                this.thePartitionIter.initForNextPartition(this.thePartitions[pidIdx], emptyReadFactor);
            }
            return true;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.thePartitionIter == null) {
                return null;
            }
            return this.thePartitionIter.nextLocal();
        }

        @Override
        public FieldValueImpl next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.thePartitionIter.next();
        }

        @Override
        public void close() {
            if (this.thePartitionIter != null) {
                this.thePartitionIter.close();
                this.thePartitionIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.thePartitionIter == null || this.thePartitionIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.thePartitionIter != null ? this.thePartitionIter.getCloseException() : null;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AllPartitionsIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private int theNumShards;
        private int theNumPartitions;
        private PartitionId theCurrentPid;
        private AbstractScanIterator thePartitionIter;
        private int theNumRemoteTrips = 1;
        private boolean theInSortPhase1 = false;
        private boolean theInSortPhase2 = false;

        AllPartitionsIterator(RuntimeControlBlock rcb) {
            assert (ReceiveIter.this.theDistributionKind == PreparedStatementImpl.DistributionKind.ALL_PARTITIONS);
            this.theRCB = rcb;
            this.theNumShards = rcb.getStore().getTopology().getNumRepGroups();
            this.theNumPartitions = rcb.getStore().getNPartitions();
            ResumeInfo ri = rcb.getResumeInfo();
            BitSet partitionsBitmap = ri.getPartitionsBitmap();
            int pid = ri.getCurrentPid();
            if (partitionsBitmap == null) {
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("AllPartitionsIterator constructor. First batch");
                }
                partitionsBitmap = new BitSet(this.theNumPartitions + 1);
                ri.setPartitionsBitmap(partitionsBitmap);
                pid = 1;
                this.theCurrentPid = new PartitionId(pid);
                ri.setCurrentPid(pid);
                this.theInSortPhase1 = ReceiveIter.this.doesSort();
                this.theInSortPhase2 = false;
                ri.setIsInSortPhase1(this.theInSortPhase1);
            } else {
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("AllPartitionsIterator constructor. ResumeInfo =\n" + ri);
                }
                this.theCurrentPid = new PartitionId(pid);
                if (ReceiveIter.this.doesSort()) {
                    this.theInSortPhase1 = ri.isInSortPhase1();
                    boolean bl = this.theInSortPhase2 = !this.theInSortPhase1;
                }
            }
            if (pid <= 0 || pid > this.theNumPartitions) {
                throw new IllegalStateException("Invalid partition id in continuation key: " + pid);
            }
            this.thePartitionIter = new AbstractScanIterator(this.theRCB, this.theCurrentPid, null, 0);
        }

        boolean hasSortPhase1Result() {
            return this.theInSortPhase1;
        }

        @Override
        public boolean hasNext() {
            if (this.thePartitionIter == null) {
                return false;
            }
            ResumeInfo ri = this.theRCB.getResumeInfo();
            if (this.theInSortPhase1) {
                if (this.theRCB.getTraceLevel() >= 1) {
                    this.theRCB.trace("AllPartitionsIterator sort phase 1 start. ResumeInfo =\n" + ri);
                }
                this.thePartitionIter.hasNext();
                assert (ri == this.theRCB.getResumeInfo());
                if (!ri.isInSortPhase1()) {
                    int pid = this.getNextPid(ri);
                    if (this.theRCB.getTraceLevel() >= 1) {
                        this.theRCB.trace("AllPartitionsIterator chose new  resume pid " + pid);
                    }
                    ri.reset();
                    ri.setCurrentPid(pid);
                    if (pid > 0) {
                        ri.setIsInSortPhase1(true);
                    }
                }
                if (this.theRCB.getTraceLevel() >= 1) {
                    this.theRCB.trace("AllPartitionsIterator sort phase 1 done. ResumeInfo =\n" + ri);
                }
                this.theRCB.createContinuationKey(false);
                return false;
            }
            while (!this.thePartitionIter.hasNext()) {
                if (!this.thePartitionIter.hasMoreRemoteResults()) {
                    int pid;
                    if (this.theInSortPhase2) {
                        pid = -1;
                    } else {
                        pid = this.getNextPid(ri);
                        ri.setCurrentPid(pid);
                        this.theCurrentPid = new PartitionId(pid);
                        ++this.theNumRemoteTrips;
                    }
                    if (pid == -1) {
                        this.close();
                        this.theRCB.setContinuationKey(null);
                        return false;
                    }
                }
                if (this.theRCB.getReachedLimit()) {
                    this.theRCB.createContinuationKey();
                    return false;
                }
                int emptyReadFactor = 0;
                if (this.theRCB.getReadKB() == 0 && this.theNumRemoteTrips == this.theNumShards - 1) {
                    emptyReadFactor = 1;
                }
                this.theCurrentPid = new PartitionId(ri.getCurrentPid());
                this.thePartitionIter.initForNextPartition(this.theCurrentPid, emptyReadFactor);
            }
            return true;
        }

        private int getNextPid(ResumeInfo ri) {
            int pid;
            BitSet partitionsBitmap = ri.getPartitionsBitmap();
            if (partitionsBitmap.cardinality() == this.theNumPartitions) {
                return -1;
            }
            int i = pid = this.theCurrentPid.getPartitionId();
            int mark = pid;
            do {
                if (!partitionsBitmap.get(i)) {
                    return i;
                }
                if (++i <= this.theNumPartitions) continue;
                i = 1;
            } while (i != mark);
            return -1;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.thePartitionIter == null) {
                return null;
            }
            return this.thePartitionIter.nextLocal();
        }

        @Override
        public FieldValueImpl next() {
            return this.thePartitionIter.next();
        }

        @Override
        public void close() {
            if (this.thePartitionIter != null) {
                this.thePartitionIter.close();
                this.thePartitionIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.thePartitionIter == null || this.thePartitionIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.thePartitionIter != null ? this.thePartitionIter.getCloseException() : null;
        }

        public int writeSortPhase1Results(RuntimeControlBlock rcb, DataOutput out, CloudSerializer.FieldValueWriter valWriter) throws IOException {
            ResumeInfo ri = rcb.getResumeInfo();
            int[] pids = this.thePartitionIter.getPids();
            int[] numResultsPerPid = this.thePartitionIter.getNumResultsPerPid();
            List<FieldValueImpl> results = this.thePartitionIter.getLocalResults();
            for (FieldValueImpl val : results) {
                valWriter.writeFieldValue(out, val);
                if (rcb.getTraceLevel() < 4) continue;
                rcb.trace("ReceiveIter.writeSortPhase1Results() : Wrote result:\n" + val);
            }
            out.writeBoolean(ri.isInSortPhase1());
            CloudSerializer.writeIntArray(pids, true, out);
            if (pids != null) {
                CloudSerializer.writeIntArray(numResultsPerPid, true, out);
                for (int i = 0; i < pids.length; ++i) {
                    ri = this.thePartitionIter.getResumeInfo(i);
                    byte[] contKey = null;
                    if (ri != null) {
                        contKey = RuntimeControlBlock.createContinuationKey(pids[i], ri);
                    }
                    CloudSerializer.writeByteArray(out, contKey);
                }
            }
            return results.size();
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SinglePartitionIterator
    implements AsyncTableIterator<FieldValueImpl> {
        private final RuntimeControlBlock theRCB;
        private AbstractScanIterator thePartitionIter;

        SinglePartitionIterator(RuntimeControlBlock rcb, PartitionId pid) {
            this.theRCB = rcb;
            this.thePartitionIter = new AbstractScanIterator(this.theRCB, pid, null, 1);
        }

        @Override
        public boolean hasNext() {
            if (this.thePartitionIter == null) {
                return false;
            }
            if (!this.thePartitionIter.hasNext()) {
                if (!this.thePartitionIter.hasMoreRemoteResults()) {
                    this.close();
                    this.theRCB.setContinuationKey(null);
                    return false;
                }
                assert (this.theRCB.getReachedLimit());
                this.theRCB.createContinuationKey();
                return false;
            }
            return true;
        }

        @Override
        public FieldValueImpl nextLocal() {
            if (this.thePartitionIter == null) {
                return null;
            }
            return this.thePartitionIter.nextLocal();
        }

        @Override
        public FieldValueImpl next() {
            return this.thePartitionIter.next();
        }

        @Override
        public void close() {
            if (this.thePartitionIter != null) {
                this.thePartitionIter.close();
                this.thePartitionIter = null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.thePartitionIter == null || this.thePartitionIter.isClosed();
        }

        @Override
        public Throwable getCloseException() {
            return this.thePartitionIter != null ? this.thePartitionIter.getCloseException() : null;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CachedBinaryPlan {
        private byte[] thePlan = null;
        private short theSerialVersion = (short)-1;

        private CachedBinaryPlan(byte[] plan, short serialVersion) {
            this.thePlan = plan;
            this.theSerialVersion = serialVersion;
        }

        public static CachedBinaryPlan create(byte[] plan, short serialVersion) {
            return new CachedBinaryPlan(plan, serialVersion);
        }

        byte[] getPlan() {
            return this.thePlan;
        }

        short getSerialVersion() {
            return this.theSerialVersion;
        }
    }

    private static class ReceiveIterState
    extends PlanIterState {
        final PartitionId thePartitionId;
        AsyncTableIterator<FieldValueImpl> theRemoteResultsIter;
        Throwable theRemoteResultsIterCloseException;
        HashSet<BinaryValueImpl> thePrimKeysSet;
        long theMemoryConsumption = ReceiveIter.access$000();

        ReceiveIterState(PartitionId pid, boolean eliminateIndexDups) {
            this.thePartitionId = pid;
            if (eliminateIndexDups) {
                this.thePrimKeysSet = new HashSet(1000);
            }
        }

        @Override
        public void done() {
            super.done();
            this.clear();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.clear();
            this.theMemoryConsumption = theFixedMemoryConsumption;
        }

        @Override
        public void close() {
            super.close();
            if (this.theRemoteResultsIter != null) {
                this.theRemoteResultsIterCloseException = this.theRemoteResultsIter.getCloseException();
            }
            this.clear();
        }

        void clear() {
            if (this.theRemoteResultsIter != null) {
                this.theRemoteResultsIter.close();
                this.theRemoteResultsIter = null;
            }
            if (this.thePrimKeysSet != null) {
                this.thePrimKeysSet.clear();
            }
        }
    }
}

