/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class ResumeInfo
implements FastExternalizable {
    RuntimeControlBlock theRCB;
    private int theNumResultsComputed;
    private int theCurrentPid = -1;
    private BitSet thePartitionsBitmap;
    private boolean theIsInSortPhase1;
    private long theOffset = -1L;
    private int theCurrentIndexRange;
    private byte[] thePrimResumeKey;
    private byte[] theSecResumeKey;
    private byte[] theDescResumeKey;
    private boolean theMoveAfterResumeKey = true;
    private int[] theJoinPathTables;
    private byte[] theJoinPathKey;
    private byte[] theJoinPathSecKey;
    private boolean theJoinPathMatched;
    private FieldValueImpl[] theGBTuple;

    public ResumeInfo() {
        this(null);
    }

    public ResumeInfo(RuntimeControlBlock rcb) {
        this.theRCB = rcb;
    }

    void reset() {
        this.theCurrentIndexRange = 0;
        this.thePrimResumeKey = null;
        this.theSecResumeKey = null;
        this.theDescResumeKey = null;
        this.theMoveAfterResumeKey = true;
        this.theJoinPathKey = null;
        this.theJoinPathSecKey = null;
        this.theJoinPathTables = null;
        this.theJoinPathMatched = true;
        this.theGBTuple = null;
    }

    void refresh(ResumeInfo src) {
        this.theNumResultsComputed += src.theNumResultsComputed;
        this.theCurrentPid = src.theCurrentPid;
        this.thePartitionsBitmap = src.thePartitionsBitmap;
        this.theIsInSortPhase1 = src.theIsInSortPhase1;
        this.theOffset = src.theOffset;
        this.theCurrentIndexRange = src.theCurrentIndexRange;
        this.thePrimResumeKey = src.thePrimResumeKey;
        this.theSecResumeKey = src.theSecResumeKey;
        this.theDescResumeKey = src.theDescResumeKey;
        this.theMoveAfterResumeKey = src.theMoveAfterResumeKey;
        this.theJoinPathTables = src.theJoinPathTables;
        this.theJoinPathKey = src.theJoinPathKey;
        this.theJoinPathSecKey = src.theJoinPathSecKey;
        this.theJoinPathMatched = src.theJoinPathMatched;
        this.theGBTuple = src.theGBTuple;
    }

    public void setRCB(RuntimeControlBlock rcb) {
        this.theRCB = rcb;
    }

    public int getNumResultsComputed() {
        return this.theNumResultsComputed;
    }

    public void setNumResultsComputed(int v) {
        this.theNumResultsComputed = v;
    }

    void incNumResultsComputed() {
        ++this.theNumResultsComputed;
    }

    public int getCurrentPid() {
        return this.theCurrentPid;
    }

    public void setCurrentPid(int pid) {
        this.theCurrentPid = pid;
    }

    public BitSet getPartitionsBitmap() {
        return this.thePartitionsBitmap;
    }

    public void setPartitionsBitmap(BitSet bs) {
        this.thePartitionsBitmap = bs;
    }

    public void setIsInSortPhase1(boolean v) {
        this.theIsInSortPhase1 = v;
    }

    public boolean isInSortPhase1() {
        return this.theIsInSortPhase1;
    }

    public long getOffset() {
        return this.theOffset;
    }

    public void setOffset(long v) {
        this.theOffset = v;
    }

    public int getCurrentIndexRange() {
        return this.theCurrentIndexRange;
    }

    public void setCurrentIndexRange(int v) {
        this.theCurrentIndexRange = v;
    }

    public byte[] getPrimResumeKey() {
        return this.thePrimResumeKey;
    }

    public void setPrimResumeKey(byte[] resumeKey) {
        if (this.theRCB != null && this.theRCB.getTraceLevel() >= 3) {
            this.theRCB.trace("Setting resume key to\n" + PlanIter.printKey(resumeKey));
        }
        this.thePrimResumeKey = resumeKey;
    }

    public byte[] getSecResumeKey() {
        return this.theSecResumeKey;
    }

    public void setSecResumeKey(byte[] resumeKey) {
        if (this.theRCB != null && this.theRCB.getTraceLevel() >= 3) {
            this.theRCB.trace("Setting secondary resume key to\n" + PlanIter.printByteArray(resumeKey));
        }
        this.theSecResumeKey = resumeKey;
    }

    public byte[] getDescResumeKey() {
        return this.theDescResumeKey;
    }

    public void setDescResumeKey(byte[] key) {
        if (this.theRCB != null && this.theRCB.getTraceLevel() >= 3) {
            this.theRCB.trace("Setting secondary resume key to\n" + PlanIter.printKey(key));
        }
        this.theDescResumeKey = key;
    }

    public boolean getMoveAfterResumeKey() {
        return this.theMoveAfterResumeKey;
    }

    public void setMoveAfterResumeKey(boolean v) {
        this.theMoveAfterResumeKey = v;
    }

    public int[] getJoinPathTables() {
        return this.theJoinPathTables;
    }

    public byte[] getJoinPathKey() {
        return this.theJoinPathKey;
    }

    public byte[] getJoinPathSecKey() {
        return this.theJoinPathSecKey;
    }

    public boolean getJoinPathMatched() {
        return this.theJoinPathMatched;
    }

    public void setJoinPathMatched(boolean v) {
        this.theJoinPathMatched = v;
    }

    public void setJoinPath(int[] tables, byte[] primKey, byte[] idxKey, boolean matched) {
        this.theJoinPathTables = tables;
        this.theJoinPathKey = primKey;
        this.theJoinPathSecKey = idxKey;
        this.theJoinPathMatched = matched;
    }

    public FieldValueImpl[] getGBTuple() {
        return this.theGBTuple;
    }

    public void setGBTuple(FieldValueImpl[] gbTuple) {
        this.theGBTuple = gbTuple;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("theNumResultsComputed = ").append(this.theNumResultsComputed);
        sb.append("\n");
        sb.append("theCurrentPid = ").append(this.theCurrentPid);
        sb.append("\n");
        sb.append("thePartitionsBitmap = ").append(this.thePartitionsBitmap);
        sb.append("\n");
        sb.append("theIsInSortPhase1 = ").append(this.theIsInSortPhase1);
        sb.append("\n");
        sb.append("theOffset = ").append(this.theOffset);
        sb.append("\n");
        sb.append("theCurrentIndexRange = ").append(this.theCurrentIndexRange);
        sb.append("\n");
        if (this.thePrimResumeKey != null) {
            sb.append("thePrimResumeKey = ");
            sb.append(PlanIter.printKey(this.thePrimResumeKey));
            sb.append("\n");
        }
        if (this.theSecResumeKey != null) {
            sb.append("theSecResumeKey = ");
            sb.append(PlanIter.printByteArray(this.theSecResumeKey));
            sb.append("\n");
        }
        if (this.theDescResumeKey != null) {
            sb.append("theDescResumeKey = ");
            sb.append(PlanIter.printKey(this.theDescResumeKey));
            sb.append("\n");
        }
        if (this.thePrimResumeKey != null) {
            sb.append("theMoveAfterResumeKey = ").append(this.theMoveAfterResumeKey);
            sb.append("\n");
        }
        if (this.theJoinPathKey != null) {
            sb.append("theJoinPathKey = ");
            sb.append(PlanIter.printKey(this.theJoinPathKey));
            sb.append("\n");
            sb.append("theJoinPathMatched = ").append(this.theJoinPathMatched);
            sb.append("\n");
        }
        if (this.theJoinPathSecKey != null) {
            sb.append("theJoinPathSecKey = ");
            sb.append(PlanIter.printByteArray(this.theJoinPathSecKey));
            sb.append("\n");
        }
        if (this.theGBTuple != null) {
            sb.append("GB tuple = [ ");
            for (int i = 0; i < this.theGBTuple.length; ++i) {
                sb.append(this.theGBTuple[i]).append(" ");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeInt(this.theNumResultsComputed);
        if (serialVersion >= 21) {
            out.writeInt(this.theCurrentPid);
            if (this.thePartitionsBitmap != null) {
                SerializationUtil.writeByteArray(out, this.thePartitionsBitmap.toByteArray());
            } else {
                SerializationUtil.writeByteArray(out, null);
            }
            out.writeBoolean(this.theIsInSortPhase1);
            out.writeLong(this.theOffset);
        }
        out.writeInt(this.theCurrentIndexRange);
        SerializationUtil.writeByteArray(out, this.thePrimResumeKey);
        if (this.thePrimResumeKey != null) {
            SerializationUtil.writeByteArray(out, this.theSecResumeKey);
            SerializationUtil.writeByteArray(out, this.theDescResumeKey);
            out.writeBoolean(this.theMoveAfterResumeKey);
            PlanIter.serializeIntArray(this.theJoinPathTables, out, serialVersion);
            PlanIter.serializeByteArray(this.theJoinPathKey, out, serialVersion);
            PlanIter.serializeByteArray(this.theJoinPathSecKey, out, serialVersion);
            out.writeBoolean(this.theJoinPathMatched);
        }
        PlanIter.serializeFieldValues(this.theGBTuple, out, serialVersion);
    }

    public ResumeInfo(DataInput in, short serialVersion) throws IOException {
        this.theRCB = null;
        try {
            this.theNumResultsComputed = in.readInt();
            if (serialVersion >= 21) {
                this.theCurrentPid = in.readInt();
                byte[] array = SerializationUtil.readByteArray(in);
                this.thePartitionsBitmap = array == null ? null : BitSet.valueOf(array);
                this.theIsInSortPhase1 = in.readBoolean();
                this.theOffset = in.readLong();
            }
            this.theCurrentIndexRange = in.readInt();
            this.thePrimResumeKey = SerializationUtil.readByteArray(in);
            if (this.thePrimResumeKey != null) {
                this.theSecResumeKey = SerializationUtil.readByteArray(in);
                this.theDescResumeKey = SerializationUtil.readByteArray(in);
                this.theMoveAfterResumeKey = in.readBoolean();
                this.theJoinPathTables = PlanIter.deserializeIntArray(in, serialVersion);
                this.theJoinPathKey = PlanIter.deserializeByteArray(in, serialVersion);
                this.theJoinPathSecKey = PlanIter.deserializeByteArray(in, serialVersion);
                this.theJoinPathMatched = in.readBoolean();
            }
            this.theGBTuple = PlanIter.deserializeFieldValues(in, serialVersion);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw new QueryStateException("Failed to deserialize ResumeInfo.", re);
        }
    }
}

