/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.MathContext;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.ParallelScanIterator;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.ops.TableQueryHandler;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.query.runtime.ServerIterFactory;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.table.FieldValue;

public class RuntimeControlBlock {
    private final KVStoreImpl theStore;
    private final Logger theLogger;
    private final TableMetadataHelper theMetadataHelper;
    private final Set<Integer> thePartitions;
    private final Set<RepGroupId> theShards;
    private final ExecuteOptions theExecuteOptions;
    private final byte theTraceLevel;
    private TableQuery theQueryOp;
    private TableQueryHandler theQueryHandler;
    private final PlanIter theRootIter;
    private final ServerIterFactory theServerIterFactory;
    private final PlanIterState[] theIteratorStates;
    private final FieldValueImpl[] theRegisters;
    private final FieldValue[] theExternalVars;
    private int theCurrentMaxReadKB;
    private int theCurrentMaxWriteKB;
    private byte[] theContinuationKey;
    private int thePidOrShardIdx;
    private ResumeInfo theResumeInfo;
    private int theReadKB;
    private int theWriteKB;
    private int theResultSize;
    private boolean theReachedLimit;
    private ParallelScanIterator<FieldValueImpl> theTableIterator;
    private long theMemoryConsumption;

    public RuntimeControlBlock(KVStoreImpl store, Logger logger, TableMetadataHelper mdHelper, Set<Integer> partitions, Set<RepGroupId> shards, ExecuteOptions executeOptions, PlanIter rootIter, int numIters, int numRegs, FieldValue[] externalVars) {
        this.theStore = store;
        this.theLogger = logger;
        this.theMetadataHelper = mdHelper;
        this.thePartitions = partitions;
        this.theShards = shards;
        this.theExecuteOptions = executeOptions;
        this.theTraceLevel = executeOptions != null ? executeOptions.getTraceLevel() : (byte)0;
        this.theRootIter = rootIter;
        this.theIteratorStates = new PlanIterState[numIters];
        this.theRegisters = new FieldValueImpl[numRegs];
        this.theExternalVars = externalVars;
        this.theContinuationKey = this.theExecuteOptions != null ? this.theExecuteOptions.getContinuationKey() : null;
        this.parseContinuationKey();
        this.theServerIterFactory = null;
    }

    public RuntimeControlBlock(Logger logger, TableMetadataHelper mdHelper, ExecuteOptions options, TableQuery queryOp, TableQueryHandler queryHandler, ServerIterFactory serverIterFactory) {
        this.theStore = null;
        this.thePartitions = null;
        this.theShards = null;
        this.theExecuteOptions = options;
        this.theLogger = logger;
        this.theMetadataHelper = mdHelper;
        this.theQueryOp = queryOp;
        this.theQueryHandler = queryHandler;
        this.theServerIterFactory = serverIterFactory;
        this.theTraceLevel = queryOp.getTraceLevel();
        this.theExternalVars = queryOp.getExternalVars();
        this.theRootIter = queryOp.getQueryPlan();
        this.theCurrentMaxReadKB = this.theQueryOp.getCurrentMaxReadKB();
        this.theCurrentMaxWriteKB = this.theQueryOp.getCurrentMaxWriteKB();
        this.theIteratorStates = new PlanIterState[queryOp.getNumIterators()];
        this.theRegisters = new FieldValueImpl[queryOp.getNumRegisters()];
        this.theResumeInfo = this.theQueryOp.getResumeInfo();
    }

    boolean isServerRCB() {
        return this.theStore == null;
    }

    public KVStoreImpl getStore() {
        return this.theStore;
    }

    public Logger getLogger() {
        return this.theLogger;
    }

    public TableMetadataHelper getMetadataHelper() {
        return this.theMetadataHelper;
    }

    public Set<Integer> getPartitionSet() {
        return this.thePartitions;
    }

    public Set<RepGroupId> getShardSet() {
        return this.theShards;
    }

    public ExecuteOptions getExecuteOptions() {
        return this.theExecuteOptions;
    }

    public byte getTraceLevel() {
        return this.theTraceLevel;
    }

    public void trace(String msg) {
        if (this.isServerRCB()) {
            this.theLogger.info("QUERY: " + msg);
        } else {
            System.out.println("QUERY: " + msg);
        }
    }

    Consistency getConsistency() {
        return this.theExecuteOptions.getConsistency();
    }

    Durability getDurability() {
        return this.theExecuteOptions.getDurability();
    }

    long getTimeout() {
        return this.theExecuteOptions.getTimeout();
    }

    TimeUnit getTimeUnit() {
        return this.theExecuteOptions.getTimeoutUnit();
    }

    public MathContext getMathContext() {
        return this.isServerRCB() ? this.theQueryOp.getMathContext() : this.theExecuteOptions.getMathContext();
    }

    int getBatchSize() {
        return this.isServerRCB() ? this.theQueryOp.getBatchSize() : this.theExecuteOptions.getResultsBatchSize();
    }

    public boolean getUseBatchSizeAsLimit() {
        return this.theExecuteOptions.getUseBatchSizeAsLimit();
    }

    public boolean getUseBytesLimit() {
        return this.getMaxReadKB() > 0;
    }

    public int getMaxReadKB() {
        return this.isServerRCB() ? this.theQueryOp.getMaxReadKB() : this.theExecuteOptions.getMaxReadKB();
    }

    public int getMaxWriteKB() {
        return this.theExecuteOptions.getMaxWriteKB();
    }

    public long getMaxMemoryConsumption() {
        return this.theExecuteOptions.getMaxMemoryConsumption();
    }

    public int getDeleteLimit() {
        return this.isServerRCB() ? this.theQueryOp.getDeleteLimit() : this.theExecuteOptions.getDeleteLimit();
    }

    boolean isCloudQuery() {
        return this.theExecuteOptions.isCloudQuery();
    }

    void incMemoryConsumption(long v) {
        this.theMemoryConsumption += v;
        assert (this.theMemoryConsumption >= 0L);
        if (this.theMemoryConsumption > this.getMaxMemoryConsumption()) {
            throw new QueryStateException("Memory consumption at the client exceeded maximum allowed value " + this.getMaxMemoryConsumption());
        }
    }

    void decMemoryConsumption(long v) {
        this.theMemoryConsumption -= v;
        assert (this.theMemoryConsumption >= 0L);
    }

    public TableQuery getQueryOp() {
        return this.theQueryOp;
    }

    public TableQueryHandler getQueryHandler() {
        return this.theQueryHandler;
    }

    public ResumeInfo getResumeInfo() {
        return this.theResumeInfo;
    }

    void setResumeInfo(ResumeInfo ri) {
        this.theResumeInfo = ri;
    }

    public ServerIterFactory getServerIterFactory() {
        return this.theServerIterFactory;
    }

    PlanIter getRootIter() {
        return this.theRootIter;
    }

    public void setState(int pos, PlanIterState state) {
        this.theIteratorStates[pos] = state;
    }

    public PlanIterState getState(int pos) {
        return this.theIteratorStates[pos];
    }

    public FieldValueImpl[] getRegisters() {
        return this.theRegisters;
    }

    public FieldValueImpl getRegVal(int regId) {
        return this.theRegisters[regId];
    }

    public void setRegVal(int regId, FieldValueImpl value) {
        this.theRegisters[regId] = value;
    }

    FieldValue[] getExternalVars() {
        return this.theExternalVars;
    }

    FieldValueImpl getExternalVar(int id) {
        if (this.theExternalVars == null) {
            return null;
        }
        return (FieldValueImpl)this.theExternalVars[id];
    }

    public int getCurrentMaxReadKB() {
        return this.theCurrentMaxReadKB;
    }

    public int getCurrentMaxWriteKB() {
        return this.theCurrentMaxWriteKB;
    }

    public byte[] getContinuationKey() {
        return this.theContinuationKey;
    }

    public void setContinuationKey(byte[] key) {
        this.theContinuationKey = key;
    }

    public void tallyReadKB(int nkb) {
        this.theReadKB += nkb;
    }

    public void tallyWriteKB(int nkb) {
        this.theWriteKB += nkb;
    }

    public void setReadKB(int kb) {
        this.theReadKB = kb;
    }

    public int getReadKB() {
        return this.theReadKB;
    }

    public int getWriteKB() {
        return this.theWriteKB;
    }

    public void tallyResultSize(int size) {
        this.theResultSize += size;
    }

    public int getResultSize() {
        return this.theResultSize;
    }

    public void setReachedLimit(boolean value) {
        this.theReachedLimit = value;
    }

    public boolean getReachedLimit() {
        return this.isServerRCB() || this.getUseBytesLimit() || this.getUseBatchSizeAsLimit() ? this.theReachedLimit : false;
    }

    int getPidIdx() {
        return this.thePidOrShardIdx;
    }

    int incPidIdx() {
        return ++this.thePidOrShardIdx;
    }

    int getShardIdx() {
        return this.thePidOrShardIdx;
    }

    int incShardIdx() {
        return ++this.thePidOrShardIdx;
    }

    private void parseContinuationKey() {
        if (this.theContinuationKey == null) {
            this.theResumeInfo = new ResumeInfo(this);
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.theContinuationKey);
        DataInputStream in = new DataInputStream(bais);
        short v = SerialVersion.CURRENT;
        try {
            this.thePidOrShardIdx = in.readInt();
            this.theResumeInfo = new ResumeInfo(in, v);
            this.theResumeInfo.setRCB(this);
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to parse continuation key");
        }
    }

    void createContinuationKey() {
        this.createContinuationKey(true);
    }

    void createContinuationKey(boolean setReachedLimit) {
        this.theContinuationKey = RuntimeControlBlock.createContinuationKey(this.thePidOrShardIdx, this.theResumeInfo);
        if (setReachedLimit) {
            this.theReachedLimit = true;
        }
    }

    static byte[] createContinuationKey(int pid, ResumeInfo ri) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        short v = SerialVersion.CURRENT;
        try {
            out.writeInt(pid);
            ri.writeFastExternal(out, v);
        }
        catch (IOException e) {
            throw new QueryStateException("Failed to create continuation key. Reason:\n" + e.getMessage());
        }
        return baos.toByteArray();
    }

    void setTableIterator(ParallelScanIterator<FieldValueImpl> iter) {
        this.theTableIterator = iter;
    }

    public ParallelScanIterator<FieldValueImpl> getTableIterator() {
        return this.theTableIterator;
    }
}

