/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CloudSerializer;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.util.SerializationUtil;

public class VarRefIter
extends PlanIter {
    private final String theName;
    private final int[] theTupleRegs;

    public VarRefIter(Expr e, int resultReg, int[] tupleRegs, String name, boolean forCloud) {
        super(e, resultReg, forCloud);
        this.theName = name;
        this.theTupleRegs = tupleRegs;
    }

    VarRefIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theName = serialVersion >= 15 ? SerializationUtil.readString(in, serialVersion) : in.readUTF();
        this.theTupleRegs = VarRefIter.deserializeIntArray(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 15) {
            SerializationUtil.writeString(out, serialVersion, this.theName);
        } else {
            out.writeUTF(this.theName);
        }
        VarRefIter.serializeIntArray(this.theTupleRegs, out, serialVersion);
    }

    @Override
    public void writeForCloud(DataOutput out, short driverVersion, CloudSerializer.FieldValueWriter valWriter) throws IOException {
        assert (this.theIsCloudDriverIter);
        this.writeForCloudCommon(out, driverVersion);
        CloudSerializer.writeString(this.theName, out);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.VAR_REF;
    }

    @Override
    public int[] getTupleRegs() {
        return this.theTupleRegs;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            if (rcb.getTraceLevel() >= 4) {
                rcb.trace("No Value for variable " + this.theName + " in register " + this.theResultReg);
            }
            return false;
        }
        if (rcb.getTraceLevel() >= 4) {
            rcb.trace("Value for variable " + this.theName + " in register " + this.theResultReg + ":\n" + rcb.getRegVal(this.theResultReg));
        }
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayContent(sb, formatter);
        this.displayRegs(sb);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        sb.append("VAR_REF(");
        sb.append(this.theName);
        sb.append(")");
    }
}

