/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.impl.mgmt.NodeStatusReceiver;
import oracle.kv.impl.mgmt.RepNodeStatusReceiver;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.NetworkRestoreStatus;
import oracle.kv.impl.rep.OperationsStatsTracker;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.IllegalRepNodeServiceStateException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminFaultHandler;
import oracle.kv.impl.rep.admin.RepNodeInfo;
import oracle.kv.impl.rep.admin.ResourceInfo;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.KVStorePrivilegeLabel;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureInternalMethod;
import oracle.kv.impl.security.util.KerberosPrincipals;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.DatabaseUtils;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

@SecureAPI
public class RepNodeAdminImpl
extends VersionedRemoteImpl
implements RepNodeAdmin {
    private final RepNode repNode;
    private final RepNodeService repNodeService;
    private final RepNodeAdminFaultHandler faultHandler;
    private final Logger logger;
    private RepNodeAdmin exportableRepNodeAdmin;
    private DbBackup dbBackup;
    RepNodeStatusReceiver statusReceiver = null;
    private RemoteTestInterface rti;
    private static final int REQUEST_QUIESCE_POLL_MS = 100;
    private static final int REQUEST_QUIESCE_MS = 10000;
    private volatile boolean shutdownActive = false;
    private static final String TEST_INTERFACE_NAME = "oracle.kv.impl.rep.RepNodeTestInterface";

    public RepNodeAdminImpl(RepNodeService repNodeService, RepNode repNode) {
        this.repNodeService = repNodeService;
        this.repNode = repNode;
        this.rti = null;
        this.logger = LoggerUtils.getLogger(this.getClass(), (RepNodeService.Params)repNodeService.getParams());
        this.faultHandler = new RepNodeAdminFaultHandler(repNodeService, this.logger, ProcessExitCode.RESTART);
    }

    private void assertRunning() {
        ConfigurableService.ServiceStatus status = this.repNodeService.getStatusTracker().getServiceStatus();
        if (status != ConfigurableService.ServiceStatus.RUNNING) {
            throw new IllegalRepNodeServiceStateException("RepNode is not RUNNING, current status is " + (Object)((Object)status));
        }
    }

    private void startTestInterface() {
        try {
            Class<?> cl = Class.forName(TEST_INTERFACE_NAME);
            Constructor<?> c = cl.getConstructor(this.repNodeService.getClass());
            this.rti = (RemoteTestInterface)c.newInstance(this.repNodeService);
            this.rti.start(SerialVersion.CURRENT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void newParameters(AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.repNodeService.newParameters();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void newGlobalParameters(AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.repNodeService.newGlobalParameters();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public Topology getTopology(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Topology>(){

            @Override
            public Topology execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getTopology() : null;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public int getTopoSeqNum(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                if (status != ConfigurableService.ServiceStatus.RUNNING) {
                    return 0;
                }
                Topology topology = RepNodeAdminImpl.this.repNode.getTopology();
                return topology != null ? topology.getSequenceNumber() : 0;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public LoadParameters getParams(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<LoadParameters>(){

            @Override
            public LoadParameters execute() {
                return RepNodeAdminImpl.this.repNode.getAllParams();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void configure(final Set<Metadata<? extends MetadataInfo>> metadataSet, AuthContext authCtx, short serialVersion) {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                Iterator iter = metadataSet.iterator();
                while (iter.hasNext()) {
                    Metadata md = (Metadata)iter.next();
                    if (!md.getType().equals((Object)Metadata.MetadataType.TOPOLOGY)) continue;
                    RepNodeAdminImpl.this.repNode.updateMetadata(md);
                    iter.remove();
                    break;
                }
                for (Metadata md : metadataSet) {
                    RepNodeAdminImpl.this.repNode.updateMetadata(md);
                }
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public int updateTopology(TopologyInfo topoInfo, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.updateMetadata(topoInfo, authCtx, serialVersion);
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void shutdown(boolean force, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.shutdown(force, false, authCtx, serialVersion);
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void shutdown(final boolean force, final boolean checkStream, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.logger.log(Level.INFO, "RepNodeAdmin shutdown({0})", force);
                RepNodeAdminImpl.this.shutdownActive = true;
                try {
                    RepNodeAdminImpl.this.repNodeService.stop(force, checkStream);
                }
                finally {
                    RepNodeAdminImpl.this.shutdownActive = false;
                }
            }
        });
    }

    public void startup() throws RemoteException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                String kvsName = RepNodeAdminImpl.this.repNodeService.getParams().getGlobalParams().getKVStoreName();
                RepNodeParams rnp = RepNodeAdminImpl.this.repNodeService.getRepNodeParams();
                StorageNodeParams snp = RepNodeAdminImpl.this.repNodeService.getParams().getStorageNodeParams();
                String csfName = ClientSocketFactory.factoryName(kvsName, RepNodeId.getPrefix(), RegistryUtils.InterfaceType.ADMIN.interfaceName());
                RMISocketPolicy rmiPolicy = RepNodeAdminImpl.this.repNodeService.getParams().getSecurityParams().getRMISocketPolicy();
                RMISocketPolicy.SocketFactoryPair sfp = rnp.getAdminSFP(rmiPolicy, snp.getServicePortRange(), csfName);
                if (sfp.getServerFactory() != null) {
                    sfp.getServerFactory().setConnectionLogger(RepNodeAdminImpl.this.logger);
                }
                RepNodeAdminImpl.this.initExportableRepNodeAdmin();
                RepNodeAdminImpl.this.repNodeService.rebind((Remote)RepNodeAdminImpl.this.exportableRepNodeAdmin, RegistryUtils.InterfaceType.ADMIN, sfp.getClientFactory(), sfp.getServerFactory());
                RepNodeAdminImpl.this.logger.info("RepNodeAdmin registered");
                RepNodeAdminImpl.this.startTestInterface();
            }
        });
    }

    private void initExportableRepNodeAdmin() {
        try {
            this.exportableRepNodeAdmin = (RepNodeAdmin)SecureProxy.create((Object)this, (AccessChecker)this.repNodeService.getRepNodeSecurity().getAccessChecker(), (ProcessFaultHandler)this.faultHandler);
            this.logger.info("Successfully created secure proxy for the repnode admin");
        }
        catch (ConfigurationException ce) {
            this.logger.info("Unable to create proxy: " + (Object)((Object)ce) + " : " + ce.getMessage());
            throw new IllegalStateException("Unable to create proxy", ce);
        }
    }

    public void stop() {
        try {
            boolean quiesced;
            this.repNodeService.unbind((Remote)this.exportableRepNodeAdmin, RegistryUtils.InterfaceType.ADMIN);
            this.logger.info("RepNodeAdmin stopping");
            if (this.rti != null) {
                this.rti.stop(SerialVersion.CURRENT);
            }
            if (!(quiesced = new PollCondition(100, 10000L){

                @Override
                protected boolean condition() {
                    return RepNodeAdminImpl.this.faultHandler.getActiveRequests() == (RepNodeAdminImpl.this.shutdownActive ? 1 : 0);
                }
            }.await())) {
                this.logger.info(this.faultHandler.getActiveRequests() + " admin requests were active on close.");
            }
        }
        catch (RemoteException e) {
            this.logger.log(Level.INFO, "Ignoring exception while stopping repNodeAdmin", e);
            return;
        }
    }

    @Override
    @PublicMethod
    public RepNodeStatus ping(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeStatus>(){

            @Override
            public RepNodeStatus execute() {
                boolean envStatsAvailable;
                long usedLogSize;
                long availableLogSize;
                ReplicatedEnvironmentStats repEnvStats;
                long currentVLSN;
                ReplicatedEnvironment.State state;
                ConfigurableService.ServiceStatus status;
                block7: {
                    status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                    state = ReplicatedEnvironment.State.DETACHED;
                    currentVLSN = 0L;
                    repEnvStats = null;
                    EnvironmentStats envStats = null;
                    availableLogSize = 0L;
                    usedLogSize = 0L;
                    envStatsAvailable = false;
                    try {
                        ReplicatedEnvironment env = RepNodeAdminImpl.this.repNode.getEnv(1L);
                        if (env == null) break block7;
                        RepImpl repImpl = RepInternal.getRepImpl((ReplicatedEnvironment)env);
                        VLSNIndex vlsnIndex = repImpl == null ? null : RepInternal.getRepImpl((ReplicatedEnvironment)env).getVLSNIndex();
                        currentVLSN = vlsnIndex == null ? VLSN.NULL_VLSN.getSequence() : vlsnIndex.getRange().getLast().getSequence();
                        try {
                            state = env.getState();
                        }
                        catch (IllegalStateException iae) {
                            state = ReplicatedEnvironment.State.DETACHED;
                        }
                        try {
                            repEnvStats = env.getRepStats(StatsConfig.DEFAULT);
                            envStats = env.getStats(StatsConfig.DEFAULT);
                            if (envStats != null) {
                                availableLogSize = envStats.getAvailableLogSize();
                                usedLogSize = envStats.getTotalLogSize();
                                envStatsAvailable = true;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    catch (EnvironmentFailureException env) {
                        // empty catch block
                    }
                }
                String haHostPort = RepNodeAdminImpl.this.repNode.getRepNodeParams().getJENodeHostPort();
                String enabledRequestType = RepNodeAdminImpl.this.repNode.getRepNodeParams().getEnabledRequestType().name();
                return new RepNodeStatus(status, state, currentVLSN, haHostPort, enabledRequestType, RepNodeAdminImpl.this.repNode.getMigrationStatus(), repEnvStats, availableLogSize, usedLogSize, envStatsAvailable, RepNodeAdminImpl.this.repNode.getNetworkRestoreStats(), RepNodeAdminImpl.this.repNode.getIsAuthoritativeMaster());
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeInfo getInfo(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeInfo>(){

            @Override
            public RepNodeInfo execute() {
                return new RepNodeInfo(RepNodeAdminImpl.this.repNode);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public String[] startBackup(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<String[]>(){

            @Override
            public String[] execute() {
                ReplicatedEnvironment env;
                RepNodeAdminImpl.this.assertRunning();
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    RepNodeAdminImpl.this.logger.warning("startBackup: dbBackup not null");
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                }
                if ((env = RepNodeAdminImpl.this.repNode.getEnv(1L)) == null) {
                    throw new OperationFaultException("Environment unavailable");
                }
                RepNodeAdminImpl.this.logger.info("startBackup: starting backup/snapshot");
                RepNodeAdminImpl.this.dbBackup = new DbBackup((Environment)env);
                RepNodeAdminImpl.this.dbBackup.startBackup();
                return RepNodeAdminImpl.this.dbBackup.getLogFilesInBackupSet();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public long stopBackup(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Long>(){

            @Override
            public Long execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.logger.info("Ending backup/snapshot");
                long lastFile = -1L;
                if (RepNodeAdminImpl.this.dbBackup != null) {
                    lastFile = RepNodeAdminImpl.this.dbBackup.getLastFileInBackupSet();
                    RepNodeAdminImpl.this.dbBackup.endBackup();
                    RepNodeAdminImpl.this.dbBackup = null;
                }
                return lastFile;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean updateMemberHAAddress(final String groupName, final String targetNodeName, final String targetHelperHosts, final String newNodeHostPort, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() {
                RepNodeAdminImpl.this.assertRunning();
                try {
                    RepNodeAdminImpl.this.repNodeService.updateMemberHAAddress(groupName, targetNodeName, targetHelperHosts, newNodeHostPort);
                    return true;
                }
                catch (ReplicaStateException | UnknownMasterException e) {
                    return false;
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean deleteMember(final String groupName, final String targetNodeName, final String targetHelperHosts, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.Operation<Boolean, RemoteException>(){

            @Override
            public Boolean execute() {
                RepNodeAdminImpl.this.assertRunning();
                try {
                    RepNodeAdminImpl.this.repNodeService.deleteMember(groupName, targetNodeName, targetHelperHosts);
                    return true;
                }
                catch (ReplicaStateException | UnknownMasterException e) {
                    return false;
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean initiateMasterTransfer(final RepNodeId replicaId, final int timeout, final TimeUnit timeUnit, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status != ConfigurableService.ServiceStatus.RUNNING ? false : RepNodeAdminImpl.this.repNode.initiateMasterTransfer(replicaId, timeout, timeUnit);
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.PartitionMigrationState migratePartition(PartitionId partitionId, RepGroupId sourceRGId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.migratePartitionV2(partitionId, sourceRGId, authCtx, serialVersion).getPartitionMigrationState();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.MigrationState migratePartitionV2(final PartitionId partitionId, final RepGroupId sourceRGId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.MigrationState>(){

            @Override
            public RepNodeAdmin.MigrationState execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.migratePartition(partitionId, sourceRGId);
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.PartitionMigrationState getMigrationState(PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.getMigrationStateV2(partitionId, authCtx, serialVersion).getPartitionMigrationState();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.MigrationState getMigrationStateV2(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.MigrationState>(){

            @Override
            public RepNodeAdmin.MigrationState execute() {
                try {
                    RepNodeAdminImpl.this.assertRunning();
                    return RepNodeAdminImpl.this.repNode.getMigrationState(partitionId);
                }
                catch (IllegalRepNodeServiceStateException irnsse) {
                    return new RepNodeAdmin.MigrationState(RepNodeAdmin.PartitionMigrationState.UNKNOWN, (Exception)((Object)irnsse));
                }
            }
        });
    }

    @Override
    @Deprecated
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.PartitionMigrationState canCancel(PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.canCancelV2(partitionId, authCtx, serialVersion).getPartitionMigrationState();
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public RepNodeAdmin.MigrationState canCancelV2(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<RepNodeAdmin.MigrationState>(){

            @Override
            public RepNodeAdmin.MigrationState execute() {
                try {
                    RepNodeAdminImpl.this.assertRunning();
                    return RepNodeAdminImpl.this.repNode.canCancel(partitionId);
                }
                catch (IllegalRepNodeServiceStateException irnsse) {
                    return new RepNodeAdmin.MigrationState(RepNodeAdmin.PartitionMigrationState.UNKNOWN, (Exception)((Object)irnsse));
                }
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean canceled(final PartitionId partitionId, final RepGroupId targetRGId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status != ConfigurableService.ServiceStatus.RUNNING ? false : RepNodeAdminImpl.this.repNode.canceled(partitionId, targetRGId);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public PartitionMigrationStatus getMigrationStatus(final PartitionId partitionId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<PartitionMigrationStatus>(){

            @Override
            public PartitionMigrationStatus execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.getMigrationStatus(partitionId);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public void installStatusReceiver(final RepNodeStatusReceiver receiver, AuthContext authCtx, short serialVersion) throws RemoteException {
        this.statusReceiver = receiver;
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<RemoteException>(){

            @Override
            public void execute() throws RemoteException {
                ServiceStatusTracker rnStatusTracker = RepNodeAdminImpl.this.repNodeService.getStatusTracker();
                rnStatusTracker.addListener((ServiceStatusTracker.Listener)new StatusListener(), (NodeStatusReceiver)receiver);
                OperationsStatsTracker opStatsTracker = RepNodeAdminImpl.this.repNodeService.getOpStatsTracker();
                opStatsTracker.addListener((OperationsStatsTracker.Listener)new OpStatsListener());
                RepNodeAdminImpl.this.repNodeService.addParameterListener((ParameterListener)new ParameterChangeListener());
                RepNodeAdminImpl.this.repNodeService.setReplicationStateListener((RepNode.ReplicationStateListener)new RnStateListener());
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean awaitConsistency(long targetTime, final int timeout, final TimeUnit timeoutUnit, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.awaitConsistency(timeout, timeoutUnit);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int getMetadataSeqNum(final Metadata.MetadataType type, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataAccessContext(type));
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                if (status != ConfigurableService.ServiceStatus.RUNNING) {
                    return 0;
                }
                return RepNodeAdminImpl.this.repNode.getMetadataSeqNum(type);
            }
        });
    }

    @Override
    @SecureInternalMethod
    public Metadata<?> getMetadata(final Metadata.MetadataType type, AuthContext authCtx, short serialVersion) {
        return (Metadata)this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Metadata<?>>(){

            @Override
            public Metadata<?> execute() {
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataAccessContext(type));
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type) : null;
            }
        });
    }

    @Override
    @SecureInternalMethod
    public MetadataInfo getMetadata(final Metadata.MetadataType type, final int seqNum, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataAccessContext(type));
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type, seqNum) : null;
            }
        });
    }

    @Override
    @SecureInternalMethod
    public MetadataInfo getMetadata(final Metadata.MetadataType type, final MetadataKey key, final int seqNum, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataAccessContext(type));
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getMetadata(type, key, seqNum) : null;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.DBVIEW})
    public MetadataInfo getTableById(final long tableId, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getTable(tableId) : null;
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.DBVIEW})
    public MetadataInfo getTable(final String namespace, final String tableName, final int cost, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<MetadataInfo>(){

            @Override
            public MetadataInfo execute() {
                ConfigurableService.ServiceStatus status = RepNodeAdminImpl.this.repNodeService.getStatusTracker().getServiceStatus();
                return status == ConfigurableService.ServiceStatus.RUNNING ? RepNodeAdminImpl.this.repNode.getTable(namespace, tableName, cost) : null;
            }
        });
    }

    @Override
    @SecureInternalMethod
    public void updateMetadata(final Metadata<?> newMetadata, AuthContext authCtx, short serialVersion) {
        this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

            @Override
            public void execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataUpdateContext(newMetadata.getType()));
                if (!RepNodeAdminImpl.this.repNode.updateMetadata(newMetadata)) {
                    throw new OperationFaultException("Update " + (Object)((Object)newMetadata.getType()) + " metadata seq# " + newMetadata.getSequenceNumber() + " failed");
                }
            }
        });
    }

    @Override
    @SecureInternalMethod
    public int updateMetadata(final MetadataInfo metadataInfo, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Integer>(){

            @Override
            public Integer execute() {
                RepNodeAdminImpl.this.assertRunning();
                RepNodeAdminImpl.this.checkAccessPermission(new MetadataUpdateContext(metadataInfo.getType()));
                return RepNodeAdminImpl.this.repNode.updateMetadata(metadataInfo);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean addIndexComplete(String indexId, String tableName, AuthContext authCtx, short serialVersion) {
        return this.addIndexComplete(null, indexId, tableName, authCtx, serialVersion);
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean addIndexComplete(final String namespace, final String indexId, final String tableName, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.addIndexComplete(namespace, indexId, tableName);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean removeTableDataComplete(String tableName, AuthContext authCtx, short serialVersion) {
        return this.removeTableDataComplete(null, tableName, authCtx, serialVersion);
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean removeTableDataComplete(final String namespace, final String tableName, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.removeTableDataComplete(namespace, tableName);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.USRVIEW})
    public KerberosPrincipals getKerberosPrincipals(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<KerberosPrincipals>(){

            @Override
            public KerberosPrincipals execute() {
                return RepNodeAdminImpl.this.repNode.getKerberosPrincipals();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public boolean startNetworkRestore(final RepNodeId sourceNode, final boolean retainOriginalLogFile, final long minVLSN, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return RepNodeAdminImpl.this.repNode.startAsyncNetworkRestore(sourceNode, retainOriginalLogFile, minVLSN);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.INTLOPER})
    public NetworkRestoreStatus getNetworkRestoreStatus(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<NetworkRestoreStatus>(){

            @Override
            public NetworkRestoreStatus execute() {
                return RepNodeAdminImpl.this.repNode.getAsyncNetworkRestoreStatus();
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSVIEW})
    public ResourceInfo exchangeResourceInfo(final long sinceMillis, final Collection<ResourceInfo.UsageRecord> usageRecords, AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<ResourceInfo>(){

            @Override
            public ResourceInfo execute() {
                try {
                    RepNodeAdminImpl.this.assertRunning();
                    return RepNodeAdminImpl.this.repNode.exchangeResourceInfo(sinceMillis, usageRecords);
                }
                catch (IllegalRepNodeServiceStateException irnsse) {
                    return null;
                }
            }
        });
    }

    private void checkAccessPermission(OperationContext opCtx) throws SessionAccessException, KVSecurityException {
        AccessChecker accessChecker = this.repNodeService.getRepNodeSecurity().getAccessChecker();
        if (accessChecker != null) {
            try {
                accessChecker.checkAccess(ExecutionContext.getCurrent(), opCtx);
            }
            catch (KVSecurityException kvse) {
                throw new ClientAccessException(kvse);
            }
        }
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER})
    @Deprecated
    public void verifyData(boolean verifyBtree, boolean verifyLog, boolean verifyIndex, boolean verifyRecord, long btreeDelay, long logDelay, AuthContext authCtx, short serialVersion) throws RemoteException, IOException {
        this.faultHandler.execute(new ProcessFaultHandler.Procedure<IOException>(){

            @Override
            public void execute() throws IOException {
                throw new IllegalCommandException("This API has been deprecated. Please upgrade the store and rerun the plan.");
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER, KVStorePrivilegeLabel.READ_ANY})
    public DatabaseUtils.VerificationInfo startAndPollVerifyData(final DatabaseUtils.VerificationOptions options, final int planId, AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<DatabaseUtils.VerificationInfo>(){

            @Override
            public DatabaseUtils.VerificationInfo execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.startAndPollVerifyData(options, planId);
            }
        });
    }

    @Override
    @SecureAutoMethod(privileges={KVStorePrivilegeLabel.SYSOPER, KVStorePrivilegeLabel.READ_ANY})
    public boolean interruptVerifyData(AuthContext authCtx, short serialVersion) throws RemoteException {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<Boolean>(){

            @Override
            public Boolean execute() {
                RepNodeAdminImpl.this.assertRunning();
                return RepNodeAdminImpl.this.repNode.interruptVerify();
            }
        });
    }

    private class RnStateListener
    implements RepNode.ReplicationStateListener {
        private RnStateListener() {
        }

        public void doNotify(final StateChangeEvent sce) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RepNodeAdminImpl.this.statusReceiver.updateReplicationState(sce);
                    }
                    catch (RemoteException re) {
                        RepNodeAdminImpl.this.logger.log(Level.INFO, "Failure to deliver replication state change to MgmtAgent: " + re.getMessage());
                        return;
                    }
                }
            }.start();
        }
    }

    private class ParameterChangeListener
    implements ParameterListener {
        private ParameterChangeListener() {
        }

        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            try {
                RepNodeAdminImpl.this.statusReceiver.receiveNewParams(newMap);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.INFO, "Failure to deliver parameter change to MgmtAgent: " + re.getMessage());
                return;
            }
        }
    }

    private class OpStatsListener
    implements OperationsStatsTracker.Listener {
        private OpStatsListener() {
        }

        public void receiveStats(StatsPacket packet) {
            try {
                RepNodeAdminImpl.this.statusReceiver.receiveStats(packet);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.INFO, "Failure to deliver perf stats to MgmtAgent: " + re.getMessage());
                return;
            }
        }
    }

    private class StatusListener
    implements ServiceStatusTracker.Listener {
        private StatusListener() {
        }

        public void update(ServiceStatusChange prevStatus, ServiceStatusChange newStatus) {
            try {
                RepNodeAdminImpl.this.statusReceiver.updateNodeStatus(newStatus);
            }
            catch (RemoteException re) {
                RepNodeAdminImpl.this.logger.log(Level.INFO, "Failure to deliver status update to SNA: " + re.getMessage());
                return;
            }
        }
    }

    private static class MetadataUpdateContext
    implements OperationContext {
        private final Metadata.MetadataType mdType;

        private MetadataUpdateContext(Metadata.MetadataType type) {
            this.mdType = type;
        }

        public String describe() {
            return "Metadata update for type: " + (Object)((Object)this.mdType);
        }

        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            switch (this.mdType) {
                case TOPOLOGY: {
                    return SystemPrivilege.usrviewPrivList;
                }
            }
            return SystemPrivilege.internalPrivList;
        }
    }

    private static class MetadataAccessContext
    implements OperationContext {
        private final Metadata.MetadataType mdType;

        private MetadataAccessContext(Metadata.MetadataType type) {
            this.mdType = type;
        }

        public String describe() {
            return "Metadata request for type: " + (Object)((Object)this.mdType);
        }

        public List<? extends KVStorePrivilege> getRequiredPrivileges() {
            switch (this.mdType) {
                case TABLE: {
                    return SystemPrivilege.dbviewPrivList;
                }
                case TOPOLOGY: {
                    return SystemPrivilege.usrviewPrivList;
                }
            }
            return SystemPrivilege.internalPrivList;
        }
    }
}

