/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.Serializable;
import oracle.kv.KVVersion;
import oracle.kv.impl.rep.RepNode;

public class RepNodeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EnvironmentConfig envConfig;
    private final EnvironmentStats envStats;
    private final KVVersion version = KVVersion.CURRENT_VERSION;

    RepNodeInfo(RepNode repNode) {
        ReplicatedEnvironment env = repNode.getEnv(0L);
        if (env == null) {
            this.envConfig = null;
            this.envStats = null;
            return;
        }
        this.envConfig = env.getConfig();
        this.envStats = env.getStats(null);
    }

    public EnvironmentConfig getEnvConfig() {
        return this.envConfig;
    }

    public EnvironmentStats getEnvStats() {
        return this.envStats;
    }

    public KVVersion getSoftwareVersion() {
        assert (this.version != null);
        return this.version;
    }

    public String toString() {
        return "Environment Configuration:\n" + this.envConfig + "\n" + this.envStats;
    }
}

