/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.rmi.RemoteException;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.util.registry.RemoteAPI;

public final class UserLoginAPI
extends RemoteAPI {
    private static final AuthContext NULL_CTX = null;
    private UserLogin proxyRemote;

    private UserLoginAPI(UserLogin remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static UserLoginAPI wrap(UserLogin remote) throws RemoteException {
        return UserLoginAPI.wrap(remote, null);
    }

    public static UserLoginAPI wrap(UserLogin remote, LoginHandle loginHdl) throws RemoteException {
        return new UserLoginAPI(remote, loginHdl);
    }

    public LoginResult login(LoginCredentials creds) throws AuthenticationFailureException, RemoteException {
        return this.proxyRemote.login(creds, this.getSerialVersion());
    }

    public LoginResult proxyLogin(ProxyCredentials creds) throws AuthenticationFailureException, AuthenticationRequiredException, UnauthorizedException, SessionAccessException, RemoteException {
        return this.proxyRemote.proxyLogin(creds, NULL_CTX, this.getSerialVersion());
    }

    public LoginResult renewPasswordLogin(PasswordCredentials oldCreds, char[] newPassword) throws AuthenticationFailureException, RemoteException {
        return this.proxyRemote.renewPasswordLogin(oldCreds, newPassword, this.getSerialVersion());
    }

    public LoginToken requestSessionExtension(LoginToken loginToken) throws SessionAccessException, RemoteException {
        return this.proxyRemote.requestSessionExtension(loginToken, this.getSerialVersion());
    }

    public Subject validateLoginToken(LoginToken loginToken) throws SessionAccessException, RemoteException {
        return this.proxyRemote.validateLoginToken(loginToken, NULL_CTX, this.getSerialVersion());
    }

    public void logout(LoginToken loginToken) throws AuthenticationRequiredException, SessionAccessException, RemoteException {
        this.proxyRemote.logout(loginToken, this.getSerialVersion());
    }
}

