/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

public class AdminId
extends ResourceId
implements Comparable<AdminId> {
    private static final long serialVersionUID = 1L;
    private static final String ADMIN_PREFIX = "admin";
    private final int nodeId;

    public AdminId(int nodeId) {
        this.nodeId = nodeId;
    }

    AdminId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.nodeId = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.nodeId);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.ADMIN;
    }

    public int getAdminInstanceId() {
        return this.nodeId;
    }

    @Override
    public String getFullName() {
        return ADMIN_PREFIX + this.getAdminInstanceId();
    }

    public static AdminId parse(String s) {
        return new AdminId(AdminId.parseForInt(ADMIN_PREFIX, s));
    }

    public static String getPrefix() {
        return ADMIN_PREFIX;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public Topology.Component<?> getComponent(Topology topology) {
        throw new UnsupportedOperationException("Method not implemented: getComponent");
    }

    @Override
    protected Topology.Component<?> readComponent(Topology topology, DataInput in, short serialVersion) {
        throw new UnsupportedOperationException("The readComponent method not supported for AdminId");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdminId other = (AdminId)obj;
        return this.nodeId == other.nodeId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeId;
        return result;
    }

    @Override
    public int compareTo(AdminId other) {
        int y;
        int x = this.getAdminInstanceId();
        return x < (y = other.getAdminInstanceId()) ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public AdminId clone() {
        return new AdminId(this.nodeId);
    }
}

