/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerializationUtil;

public class ArbNode
extends Topology.Component<ArbNodeId>
implements Comparable<ArbNode> {
    private static final long serialVersionUID = 1L;
    private final StorageNodeId storageNodeId;

    public ArbNode(StorageNodeId storageNodeId) {
        this.storageNodeId = storageNodeId;
    }

    private ArbNode(ArbNode arbNode) {
        super(arbNode);
        this.storageNodeId = arbNode.storageNodeId.clone();
    }

    ArbNode(Topology topology, ArbNodeId anId, DataInput in, short serialVersion) throws IOException {
        super(topology, anId, in, serialVersion);
        if (in.readBoolean()) {
            ResourceId rId = ResourceId.readFastExternal(in, serialVersion);
            if (!(rId instanceof StorageNodeId)) {
                throw new IOException("Expected StorageNodeId: " + rId);
            }
            this.storageNodeId = (StorageNodeId)rId;
        } else {
            this.storageNodeId = null;
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.storageNodeId);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.ARB_NODE;
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        result = 37 * result + (this.storageNodeId == null ? 0 : this.storageNodeId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArbNode other = (ArbNode)obj;
        return this.propertiesEquals(other);
    }

    public boolean propertiesEquals(ArbNode other) {
        return !(this.storageNodeId == null ? other.storageNodeId != null : !this.storageNodeId.equals(other.storageNodeId));
    }

    public RepGroupId getRepGroupId() {
        return new RepGroupId(((ArbNodeId)this.getResourceId()).getGroupId());
    }

    @Override
    public StorageNodeId getStorageNodeId() {
        return this.storageNodeId;
    }

    @Override
    public ArbNode clone() {
        return new ArbNode(this);
    }

    @Override
    public boolean isMonitorEnabled() {
        return true;
    }

    public String toString() {
        return "[" + this.getResourceId() + "] sn=" + this.storageNodeId;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode top = JsonUtils.createObjectNode();
        top.put("resourceId", ((ArbNodeId)this.getResourceId()).toString());
        top.put("snId", this.storageNodeId.toString());
        return top;
    }

    @Override
    public int compareTo(ArbNode other) {
        return ((ArbNodeId)this.getResourceId()).compareTo((ArbNodeId)other.getResourceId());
    }
}

