/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

public class PartitionId
extends ResourceId
implements Comparable<PartitionId> {
    public static PartitionId NULL_ID = new PartitionId(-1);
    private static final long serialVersionUID = 1L;
    private final int partitionId;

    public PartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public boolean isNull() {
        return this.partitionId == PartitionId.NULL_ID.partitionId;
    }

    PartitionId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.partitionId = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.partitionId);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.PARTITION;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public String getPartitionName() {
        return "p" + this.partitionId;
    }

    public static boolean isPartitionName(String name) {
        if (name.startsWith("p")) {
            try {
                Integer.parseInt(name.substring(1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return this.getType() + "-" + this.partitionId;
    }

    public Partition getComponent(Topology topology) {
        return topology.get(this);
    }

    protected Partition readComponent(Topology topology, DataInput in, short serialVersion) throws IOException {
        return new Partition(topology, this, in, serialVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionId other = (PartitionId)obj;
        return this.partitionId == other.partitionId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.partitionId;
        return result;
    }

    @Override
    public int compareTo(PartitionId other) {
        return this.partitionId - other.partitionId;
    }

    @Override
    public PartitionId clone() {
        return new PartitionId(this.partitionId);
    }
}

