/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.io.DataInput;
import java.io.IOException;
import oracle.kv.impl.map.HashKeyToPartitionMap;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

public class PartitionMap
extends ComponentMap<PartitionId, Partition> {
    private static final long serialVersionUID = 1L;
    transient HashKeyToPartitionMap keyToPartitionMap;

    public PartitionMap(Topology topology) {
        super(topology);
    }

    PartitionMap(Topology topology, DataInput in, short serialVersion) throws IOException {
        super(topology, in, serialVersion);
    }

    public int getNPartitions() {
        return this.cmap.size();
    }

    PartitionId getPartitionId(byte[] keyBytes) {
        if (this.keyToPartitionMap == null || this.keyToPartitionMap.getNPartitions() != this.size()) {
            this.keyToPartitionMap = new HashKeyToPartitionMap(this.size());
        }
        return this.keyToPartitionMap.getPartitionId(keyBytes);
    }

    public RepGroupId getRepGroupId(PartitionId partitionId) {
        Partition p = (Partition)this.cmap.get(partitionId);
        return p == null ? null : p.getRepGroupId();
    }

    @Override
    PartitionId nextId() {
        return new PartitionId(this.nextSequence());
    }

    @Override
    ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.PARTITION;
    }

    @Override
    Class<Partition> getComponentClass() {
        return Partition.class;
    }
}

