/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerializationUtil;

public class StorageNode
extends Topology.Component<StorageNodeId>
implements Comparable<StorageNode> {
    private static final long serialVersionUID = 1L;
    private final DatacenterId datacenterId;
    private final String hostname;
    private final int registryPort;

    public StorageNode(Datacenter datacenter, String hostname, int registryPort) {
        this.datacenterId = (DatacenterId)datacenter.getResourceId();
        this.hostname = hostname;
        this.registryPort = registryPort;
    }

    StorageNode(Topology topology, StorageNodeId snId, DataInput in, short serialVersion) throws IOException {
        super(topology, snId, in, serialVersion);
        if (in.readBoolean()) {
            ResourceId rId = ResourceId.readFastExternal(in, serialVersion);
            if (!(rId instanceof DatacenterId)) {
                throw new IOException("Expected DatacenterId: " + rId);
            }
            this.datacenterId = (DatacenterId)rId;
        } else {
            this.datacenterId = null;
        }
        this.hostname = SerializationUtil.readString(in, serialVersion);
        this.registryPort = SerializationUtil.readPackedInt(in);
    }

    private StorageNode(StorageNode storageNode) {
        super(storageNode);
        this.datacenterId = storageNode.datacenterId.clone();
        this.hostname = storageNode.hostname;
        this.registryPort = storageNode.registryPort;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.datacenterId);
        SerializationUtil.writeString(out, serialVersion, this.hostname);
        SerializationUtil.writePackedInt(out, this.registryPort);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.STORAGE_NODE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.datacenterId == null ? 0 : this.datacenterId.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.registryPort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.propertiesEquals((StorageNode)obj);
    }

    public boolean propertiesEquals(StorageNode other) {
        if (this.datacenterId == null ? other.datacenterId != null : !this.datacenterId.equals(other.datacenterId)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        return this.registryPort == other.registryPort;
    }

    public DatacenterId getDatacenterId() {
        return this.datacenterId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    @Override
    public Topology.Component<?> clone() {
        return new StorageNode(this);
    }

    @Override
    public StorageNodeId getStorageNodeId() {
        return (StorageNodeId)this.getResourceId();
    }

    @Override
    public boolean isMonitorEnabled() {
        return true;
    }

    public String toString() {
        return "[" + this.getResourceId() + "] " + "zn" + ":[id=" + this.datacenterId + " name=" + this.getTopology().get(this.datacenterId).getName() + "] " + this.hostname + ":" + this.registryPort;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode top = JsonUtils.createObjectNode();
        top.put("resourceId", ((StorageNodeId)this.getResourceId()).toString());
        top.put("hostname", this.hostname);
        top.put("registryPort", this.registryPort);
        top.set("zone", this.getTopology().get(this.datacenterId).toJson());
        return top;
    }

    @Override
    public int compareTo(StorageNode other) {
        return this.getStorageNodeId().compareTo(other.getStorageNodeId());
    }
}

