/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;

public class StorageNodeId
extends ResourceId
implements Comparable<StorageNodeId> {
    private static final long serialVersionUID = 1L;
    private static final String SN_PREFIX = "sn";
    private final int storageNodeId;

    public StorageNodeId(int storageNodeId) {
        this.storageNodeId = storageNodeId;
    }

    StorageNodeId(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.storageNodeId = in.readInt();
    }

    public static String getPrefix() {
        return SN_PREFIX;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.storageNodeId);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.STORAGE_NODE;
    }

    public int getStorageNodeId() {
        return this.storageNodeId;
    }

    @Override
    public String getFullName() {
        return SN_PREFIX + this.storageNodeId;
    }

    public static StorageNodeId parse(String s) {
        return new StorageNodeId(StorageNodeId.parseForInt(SN_PREFIX, s));
    }

    public String toString() {
        return this.getFullName();
    }

    public StorageNode getComponent(Topology topology) {
        return (StorageNode)topology.getStorageNodeMap().get(this);
    }

    protected StorageNode readComponent(Topology topology, DataInput in, short serialVersion) throws IOException {
        return new StorageNode(topology, this, in, serialVersion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageNodeId other = (StorageNodeId)obj;
        return this.storageNodeId == other.storageNodeId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.storageNodeId;
        return result;
    }

    @Override
    public int compareTo(StorageNodeId other) {
        int y;
        int x = this.getStorageNodeId();
        return x < (y = other.getStorageNodeId()) ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public StorageNodeId clone() {
        return new StorageNodeId(this.storageNodeId);
    }
}

