/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.fault.UnknownVersionException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterMap;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepGroupMap;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.StorageNodeMap;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.topo.change.TopologyChangeTracker;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class Topology
implements FastExternalizable,
Metadata<TopologyInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int version;
    private long id = 0L;
    private String kvStoreName;
    private PartitionMap partitionMap;
    private RepGroupMap repGroupMap;
    private StorageNodeMap storageNodeMap;
    private DatacenterMap datacenterMap;
    private Map<ResourceId.ResourceType, ComponentMap<? extends ResourceId, ? extends Component<?>>> typeToComponentMaps;
    private TopologyChangeTracker changeTracker;
    private transient byte[] signature;
    public static final int EMPTY_TOPOLOGY_ID = -1;
    public static final int NOCHECK_TOPOLOGY_ID = 0;
    public static final int CURRENT_VERSION = 1;

    public Topology(String kvStoreName) {
        this(kvStoreName, System.currentTimeMillis());
    }

    public Topology(String kvStoreName, long topoId) {
        this.version = 1;
        this.id = topoId;
        this.kvStoreName = kvStoreName;
        this.partitionMap = new PartitionMap(this);
        this.repGroupMap = new RepGroupMap(this);
        this.storageNodeMap = new StorageNodeMap(this);
        this.datacenterMap = new DatacenterMap(this);
        this.changeTracker = new TopologyChangeTracker(this);
        this.createTypeToComponentMaps();
    }

    private void createTypeToComponentMaps() {
        this.typeToComponentMaps = new HashMap();
        for (ComponentMap<?, ?> m : this.getAllComponentMaps()) {
            this.typeToComponentMaps.put(m.getResourceType(), m);
        }
    }

    public Topology(DataInput in, short serialVersion) throws IOException {
        this.version = SerializationUtil.readPackedInt(in);
        this.id = in.readLong();
        this.kvStoreName = SerializationUtil.readString(in, serialVersion);
        this.partitionMap = new PartitionMap(this, in, serialVersion);
        this.repGroupMap = new RepGroupMap(this, in, serialVersion);
        this.storageNodeMap = new StorageNodeMap(this, in, serialVersion);
        this.datacenterMap = new DatacenterMap(this, in, serialVersion);
        this.changeTracker = new TopologyChangeTracker(this);
        this.createTypeToComponentMaps();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writePackedInt(out, this.version);
        out.writeLong(this.id);
        SerializationUtil.writeString(out, serialVersion, this.kvStoreName);
        this.partitionMap.writeFastExternal(out, serialVersion);
        this.repGroupMap.writeFastExternal(out, serialVersion);
        this.storageNodeMap.writeFastExternal(out, serialVersion);
        this.datacenterMap.writeFastExternal(out, serialVersion);
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TOPOLOGY;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    ComponentMap<?, ?>[] getAllComponentMaps() {
        return new ComponentMap[]{this.partitionMap, this.repGroupMap, this.storageNodeMap, this.datacenterMap};
    }

    public String getKVStoreName() {
        return this.kvStoreName;
    }

    public Component<?> get(ResourceId resourceId) {
        return resourceId.getComponent(this);
    }

    public Datacenter get(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.get(datacenterId);
    }

    public StorageNode get(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.get(storageNodeId);
    }

    public RepGroup get(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.get(repGroupId);
    }

    public Partition get(PartitionId partitionMapId) {
        return (Partition)this.partitionMap.get(partitionMapId);
    }

    public RepNode get(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        return rg == null ? null : rg.get(repNodeId);
    }

    public ArbNode get(ArbNodeId arbNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(arbNodeId.getGroupId()));
        return rg == null ? null : rg.get(arbNodeId);
    }

    public Datacenter getDatacenter(StorageNodeId storageNodeId) {
        return this.get(this.getDatacenterId(storageNodeId));
    }

    public DatacenterId getDatacenterId(StorageNodeId storageNodeId) {
        return this.get(storageNodeId).getDatacenterId();
    }

    public Datacenter getDatacenter(RepNodeId repNodeId) {
        return this.get(this.getDatacenterId(repNodeId));
    }

    public DatacenterId getDatacenterId(RepNodeId repNodeId) {
        return this.getDatacenterId(this.get(repNodeId));
    }

    public DatacenterId getDatacenterId(RepNode repNode) {
        return this.getDatacenterId(repNode.getStorageNodeId());
    }

    public DatacenterId getDatacenterId(ArbNodeId arbNodeId) {
        return this.getDatacenterId(this.get(arbNodeId).getStorageNodeId());
    }

    public PartitionId getPartitionId(byte[] keyBytes) {
        if (this.partitionMap.size() == 0) {
            throw new IllegalArgumentException("Store is not yet configured and deployed, and cannot accept data");
        }
        return this.partitionMap.getPartitionId(keyBytes);
    }

    public RepGroupId getRepGroupId(PartitionId partitionId) {
        return this.partitionMap.getRepGroupId(partitionId);
    }

    public Set<RepGroupId> getRepGroupIds() {
        HashSet<RepGroupId> rgIdSet = new HashSet<RepGroupId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            rgIdSet.add((RepGroupId)rg.getResourceId());
        }
        return rgIdSet;
    }

    public int getNumRepGroups() {
        return this.repGroupMap.size();
    }

    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    public RepGroupMap getRepGroupMap() {
        return this.repGroupMap;
    }

    public StorageNodeMap getStorageNodeMap() {
        return this.storageNodeMap;
    }

    public List<RepGroupId> getSortedRepGroupIds() {
        ArrayList<RepGroupId> rgIdList = new ArrayList<RepGroupId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            rgIdList.add((RepGroupId)rg.getResourceId());
        }
        Collections.sort(rgIdList);
        return rgIdList;
    }

    public List<RepNode> getSortedRepNodes() {
        ArrayList<RepNode> srn = new ArrayList<RepNode>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                srn.add(rn);
            }
        }
        Collections.sort(srn);
        return srn;
    }

    public List<RepNodeId> getSortedRepNodeIds(RepGroupId rgId) {
        ArrayList<RepNodeId> srn = new ArrayList<RepNodeId>();
        for (RepNode rn : ((RepGroup)this.repGroupMap.get(rgId)).getRepNodes()) {
            srn.add((RepNodeId)rn.getResourceId());
        }
        Collections.sort(srn);
        return srn;
    }

    public List<StorageNode> getSortedStorageNodes() {
        ArrayList<StorageNode> sns = new ArrayList<StorageNode>(this.storageNodeMap.getAll());
        Collections.sort(sns);
        return sns;
    }

    public List<StorageNodeId> getStorageNodeIds() {
        ArrayList<StorageNodeId> snIds = new ArrayList<StorageNodeId>();
        for (StorageNode sn : this.storageNodeMap.getAll()) {
            snIds.add((StorageNodeId)sn.getResourceId());
        }
        return snIds;
    }

    public List<StorageNodeId> getSortedStorageNodeIds() {
        List<StorageNodeId> snIds = this.getStorageNodeIds();
        Collections.sort(snIds);
        return snIds;
    }

    public Set<RepNodeId> getRepNodeIds(DatacenterId dcid) {
        HashSet<RepNodeId> allRNIds = new HashSet<RepNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeId rnid = (RepNodeId)rn.getResourceId();
                if (dcid == null) {
                    allRNIds.add(rnid);
                    continue;
                }
                if (!dcid.equals(this.getDatacenter(rnid).getResourceId())) continue;
                allRNIds.add(rnid);
            }
        }
        return allRNIds;
    }

    public Set<StorageNode> getStorageNodes(DatacenterId dcid) {
        HashSet<StorageNode> allStorageNodes = new HashSet<StorageNode>();
        for (StorageNode sn : this.storageNodeMap.getAll()) {
            if (dcid == null) {
                allStorageNodes.add(sn);
                continue;
            }
            if (!dcid.equals(sn.getDatacenterId())) continue;
            allStorageNodes.add(sn);
        }
        return allStorageNodes;
    }

    public Set<RepNodeId> getRepNodeIds() {
        return this.getRepNodeIds(null);
    }

    public Set<RepNodeId> getHostedRepNodeIds(StorageNodeId snId) {
        HashSet<RepNodeId> snRNIds = new HashSet<RepNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                if (!rn.getStorageNodeId().equals(snId)) continue;
                snRNIds.add((RepNodeId)rn.getResourceId());
            }
        }
        return snRNIds;
    }

    public Set<ArbNodeId> getArbNodeIds() {
        return this.getArbNodeIds(null);
    }

    public Set<ArbNodeId> getArbNodeIds(DatacenterId dcid) {
        HashSet<ArbNodeId> allARBIds = new HashSet<ArbNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (ArbNode arb : rg.getArbNodes()) {
                ArbNodeId arbid = (ArbNodeId)arb.getResourceId();
                if (dcid == null) {
                    allARBIds.add(arbid);
                    continue;
                }
                if (!dcid.equals(this.getDatacenterId(arbid))) continue;
                allARBIds.add(arbid);
            }
        }
        return allARBIds;
    }

    public Set<ArbNodeId> getHostedArbNodeIds(StorageNodeId snId) {
        HashSet<ArbNodeId> snARBIds = new HashSet<ArbNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (ArbNode arb : rg.getArbNodes()) {
                if (!arb.getStorageNodeId().equals(snId)) continue;
                snARBIds.add((ArbNodeId)arb.getResourceId());
            }
        }
        return snARBIds;
    }

    public List<ArbNode> getSortedArbNodes() {
        ArrayList<ArbNode> san = new ArrayList<ArbNode>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (ArbNode an : rg.getArbNodes()) {
                san.add(an);
            }
        }
        Collections.sort(san);
        return san;
    }

    public List<ArbNodeId> getSortedArbNodeIds(RepGroupId rgId) {
        ArrayList<ArbNodeId> san = new ArrayList<ArbNodeId>();
        for (ArbNode an : ((RepGroup)this.repGroupMap.get(rgId)).getArbNodes()) {
            san.add((ArbNodeId)an.getResourceId());
        }
        Collections.sort(san);
        return san;
    }

    public DatacenterMap getDatacenterMap() {
        return this.datacenterMap;
    }

    public List<Datacenter> getSortedDatacenters() {
        ArrayList<Datacenter> sdc = new ArrayList<Datacenter>(this.datacenterMap.getAll());
        Collections.sort(sdc, new Comparator<Datacenter>(){

            @Override
            public int compare(Datacenter o1, Datacenter o2) {
                DatacenterId id1 = (DatacenterId)o1.getResourceId();
                DatacenterId id2 = (DatacenterId)o2.getResourceId();
                return id1.getDatacenterId() - id2.getDatacenterId();
            }
        });
        return sdc;
    }

    public Datacenter getDatacenter(String datacenterName) {
        for (Datacenter datacenter : this.datacenterMap.getAll()) {
            if (!datacenter.getName().equals(datacenterName)) continue;
            return datacenter;
        }
        return null;
    }

    public TopologyChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    @Override
    public int getSequenceNumber() {
        return this.changeTracker.getSeqNum();
    }

    public Topology getCopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Topology)ois.readObject();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public boolean apply(List<TopologyChange> changes) {
        if (changes == null) {
            return false;
        }
        if (changes.isEmpty()) {
            return false;
        }
        if (changes.get(0).getSequenceNumber() > this.getSequenceNumber() + 1) {
            throw new IllegalStateException("Unexpected gap in topology sequence. Current sequence=" + this.getSequenceNumber() + ", first change =" + changes.get(0).getSequenceNumber());
        }
        int changeCount = 0;
        for (TopologyChange change : changes) {
            RepGroup rg;
            if (change.getSequenceNumber() <= this.getSequenceNumber()) continue;
            ++changeCount;
            ResourceId.ResourceType rtype = change.getResourceId().getType();
            if (rtype == ResourceId.ResourceType.REP_NODE) {
                RepNodeId rnId = (RepNodeId)change.getResourceId();
                rg = (RepGroup)this.repGroupMap.get(new RepGroupId(rnId.getGroupId()));
                rg.apply(change);
                continue;
            }
            if (rtype == ResourceId.ResourceType.ARB_NODE) {
                ArbNodeId anid = (ArbNodeId)change.getResourceId();
                rg = (RepGroup)this.repGroupMap.get(new RepGroupId(anid.getGroupId()));
                rg.applyArbChange(change);
                continue;
            }
            this.typeToComponentMaps.get(rtype).apply(change);
        }
        return changeCount > 0;
    }

    @Override
    public TopologyInfo getChangeInfo(int startSeqNum) {
        return new TopologyInfo(this, this.getChanges(startSeqNum));
    }

    public List<TopologyChange> getChanges(int startSeqNum) {
        return this.changeTracker.getChanges(startSeqNum);
    }

    public void discardChanges(int startSeqNum) {
        this.changeTracker.discardChanges(startSeqNum);
    }

    public Topology pruneChanges(int limitSeqNum, int maxTopoChanges) {
        int firstChangeSeqNum = this.getChangeTracker().getFirstChangeSeqNum();
        if (firstChangeSeqNum == -1) {
            return this;
        }
        int firstRetainedChangeSeqNum = Math.min(this.getSequenceNumber() - maxTopoChanges + 1, limitSeqNum);
        if (firstRetainedChangeSeqNum <= firstChangeSeqNum) {
            return this;
        }
        this.changeTracker.discardChanges(firstRetainedChangeSeqNum - 1);
        return this;
    }

    public Datacenter add(Datacenter datacenter) {
        return this.datacenterMap.add(datacenter);
    }

    public StorageNode add(StorageNode storageNode) {
        return this.storageNodeMap.add(storageNode);
    }

    public RepGroup add(RepGroup repGroup) {
        return this.repGroupMap.add(repGroup);
    }

    public Partition add(Partition partition) {
        return this.partitionMap.add(partition);
    }

    public Partition add(Partition partition, PartitionId partitionId) {
        return this.partitionMap.add(partition, partitionId);
    }

    public Datacenter update(DatacenterId datacenterId, Datacenter datacenter) {
        return this.datacenterMap.update(datacenterId, datacenter);
    }

    public StorageNode update(StorageNodeId storageNodeId, StorageNode storageNode) {
        return this.storageNodeMap.update(storageNodeId, storageNode);
    }

    public RepGroup update(RepGroupId repGroupId, RepGroup repGroup) {
        return this.repGroupMap.update(repGroupId, repGroup);
    }

    public Partition update(PartitionId partitionId, Partition partition) {
        return this.partitionMap.update(partitionId, partition);
    }

    public Partition updatePartition(PartitionId partitionId, RepGroupId repGroupId) {
        return this.update(partitionId, new Partition(repGroupId));
    }

    public Datacenter remove(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.remove(datacenterId);
    }

    public StorageNode remove(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.remove(storageNodeId);
    }

    public RepGroup remove(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.remove(repGroupId);
    }

    public Partition remove(PartitionId partitionId) {
        return (Partition)this.partitionMap.remove(partitionId);
    }

    public RepNode remove(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        if (rg == null) {
            throw new IllegalArgumentException("Rep Group: " + repNodeId.getGroupId() + " is not in the topology");
        }
        return rg.remove(repNodeId);
    }

    public ArbNode remove(ArbNodeId anid) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(anid.getGroupId()));
        if (rg == null) {
            throw new IllegalArgumentException("Rep Group: " + anid.getGroupId() + " is not in the topology");
        }
        return rg.remove(anid);
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return Arrays.copyOf(this.signature, this.signature.length);
    }

    public void updateSignature(byte[] newSignature) {
        this.signature = newSignature == null ? null : Arrays.copyOf(newSignature, newSignature.length);
    }

    public void stripSignature() {
        this.signature = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArrayForSignature() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this.version);
            dos.writeLong(this.id);
            dos.writeUTF(this.kvStoreName);
            dos.writeInt(this.changeTracker.getSeqNum());
            for (ComponentMap<?, ?> m : this.getAllComponentMaps()) {
                dos.write(m.toByteArrayForSignature());
            }
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public boolean layoutEquals(Topology otherTopo) {
        return Arrays.equals(this.getAllComponentMaps(), otherTopo.getAllComponentMaps());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        boolean hasSignature;
        ois.defaultReadObject();
        try {
            hasSignature = ois.readBoolean();
        }
        catch (EOFException eofe) {
            this.upgrade();
            return;
        }
        if (hasSignature) {
            int sigSize = ois.readInt();
            this.signature = new byte[sigSize];
            ois.read(this.signature);
        }
        this.upgrade();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.signature != null) {
            oos.writeBoolean(true);
            oos.writeInt(this.signature.length);
            oos.write(this.signature);
        } else {
            oos.writeBoolean(false);
        }
    }

    public boolean upgrade() throws UnknownVersionException {
        if (this.version == 1) {
            return false;
        }
        if (this.version > 1) {
            throw new UnknownVersionException("Upgrade encountered unknown version", Topology.class.getName(), 1, this.version);
        }
        if (this.getRepGroupMap().getAll().size() == 0) {
            this.version = 1;
            return true;
        }
        RepGroup protoGroup = (RepGroup)this.getRepGroupMap().getAll().iterator().next();
        HashMap<DatacenterId, Integer> protoMap = this.getRFMap(protoGroup);
        for (RepGroup repGroup : this.getRepGroupMap().getAll()) {
            HashMap<DatacenterId, Integer> rfMap = this.getRFMap(repGroup);
            if (protoMap.equals(rfMap)) continue;
            return false;
        }
        for (Map.Entry entry : protoMap.entrySet()) {
            Datacenter dc = this.get((DatacenterId)entry.getKey());
            dc.setRepFactor((Integer)entry.getValue());
        }
        this.version = 1;
        return true;
    }

    private HashMap<DatacenterId, Integer> getRFMap(RepGroup rgProto) {
        HashMap<DatacenterId, Integer> rfMap = new HashMap<DatacenterId, Integer>();
        for (RepNode rn : rgProto.getRepNodes()) {
            DatacenterId dcId = this.get(rn.getStorageNodeId()).getDatacenterId();
            Integer rf = rfMap.get(dcId);
            if (rf == null) {
                rf = 0;
            }
            rfMap.put(dcId, rf + 1);
        }
        return rfMap;
    }

    public static abstract class Component<T extends ResourceId>
    implements FastExternalizable,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private Topology topology;
        private ResourceId resourceId;
        private int sequenceNumber;

        public Component() {
        }

        public static Component<?> readFastExternal(Topology topology, DataInput in, short serialVersion) throws IOException {
            ResourceId resourceId = ResourceId.readFastExternal(in, serialVersion);
            return resourceId.readComponent(topology, in, serialVersion);
        }

        protected Component(Topology topology, ResourceId resourceId, DataInput in, short serialVersion) throws IOException {
            this.topology = topology;
            this.resourceId = resourceId;
            this.sequenceNumber = SerializationUtil.readPackedInt(in);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            this.resourceId.writeFastExternal(out, serialVersion);
            SerializationUtil.writePackedInt(out, this.sequenceNumber);
        }

        public abstract Component<?> clone();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
            result = 31 * result + this.sequenceNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Component other = (Component)obj;
            if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
                return false;
            }
            return this.sequenceNumber == other.sequenceNumber;
        }

        public abstract ObjectNode toJson();

        public Component<?> cloneForLog() {
            Object clone = this.clone();
            ((Component)clone).topology = null;
            return clone;
        }

        protected Component(Component<?> other) {
            this.topology = other.topology;
            this.resourceId = other.resourceId;
            this.sequenceNumber = other.sequenceNumber;
        }

        public Topology getTopology() {
            return this.topology;
        }

        public void setTopology(Topology topology) {
            assert (this.topology == null || topology == null);
            this.topology = topology;
        }

        public void setResourceId(T resourceId) {
            assert (this.resourceId == null);
            this.resourceId = resourceId;
        }

        public T getResourceId() {
            return (T)this.resourceId;
        }

        abstract ResourceId.ResourceType getResourceType();

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public StorageNodeId getStorageNodeId() {
            throw new UnsupportedOperationException("Not supported for component " + this.resourceId);
        }

        public boolean isMonitorEnabled() {
            return false;
        }
    }
}

