/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.ObjectUtil;

public class Add
extends TopologyChange {
    private static final long serialVersionUID = 1L;
    private final Topology.Component<?> component;

    Add(int sequenceNumber, Topology.Component<?> component) {
        super(sequenceNumber);
        ObjectUtil.checkNull("component", component);
        ObjectUtil.checkNull("component.resourceId", component.getResourceId());
        this.component = component;
    }

    Add(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.component = Topology.Component.readFastExternal(null, in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.component.writeFastExternal(out, serialVersion);
    }

    @Override
    public TopologyChange.Type getType() {
        return TopologyChange.Type.ADD;
    }

    @Override
    public Topology.Component<?> getComponent() {
        return this.component;
    }

    @Override
    public ResourceId getResourceId() {
        return this.component.getResourceId();
    }

    @Override
    public Add clone() {
        Object comp = this.component.clone();
        ((Topology.Component)comp).setTopology(null);
        return new Add(this.sequenceNumber, (Topology.Component<?>)comp);
    }

    @Override
    public String toString() {
        return "Add " + this.component.getResourceId() + " seq=" + this.sequenceNumber;
    }
}

