/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sleepycat.je.Database;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VerifyError;
import com.sleepycat.je.VerifyListener;
import com.sleepycat.je.VerifySummary;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.util.DbVerifyLog;
import com.sleepycat.je.util.VerifyLogError;
import com.sleepycat.je.util.VerifyLogListener;
import com.sleepycat.je.util.VerifyLogSummary;
import com.sleepycat.je.utilint.StoppableThread;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.JsonUtils;

public class DatabaseUtils {
    public static volatile TestHook<ReplicatedEnvironment> VERIFY_ERROR_HOOK;
    public static volatile TestHook<VerificationThread> VERIFY_INTERRUPT_HOOK;
    public static volatile TestHook<Object[]> VERIFY_CORRUPTDATA_HOOK;
    public static volatile TestHook<VerificationInfo> VERIFY_CORRUPTFILE_HOOK;

    private DatabaseUtils() {
    }

    public static boolean handleException(RuntimeException re, Logger logger, String dbName) {
        try {
            throw re;
        }
        catch (ReplicaWriteException | UnknownMasterException de) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, de.getMessage()});
            return true;
        }
        catch (InsufficientReplicasException ire) {
            logger.log(Level.FINE, "Insufficient replicas when creating database {0}. {1}", new Object[]{dbName, ire.getMessage()});
            return true;
        }
        catch (InsufficientAcksException iae) {
            logger.log(Level.FINE, "Insufficient acks when creating database {0}. {1}", new Object[]{dbName, iae.getMessage()});
            return false;
        }
        catch (IllegalStateException ise) {
            logger.log(Level.FINE, "Problem accessing database {0}. {1}", new Object[]{dbName, ise.getMessage()});
            return true;
        }
        catch (LockTimeoutException lte) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, lte.getMessage()});
            return true;
        }
        catch (LockNotAvailableException lna) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, lna.getMessage()});
            return true;
        }
    }

    public static void resetRepGroup(File envDir, EnvironmentConfig envConfig, ReplicationConfig repConfig) {
        Durability durability = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.NONE);
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setDurability(durability);
        repConfig.setHelperHosts(repConfig.getNodeHostPort());
        repConfig.setConfigParam(RepParams.RESET_REP_GROUP.getName(), "true");
        ReplicatedEnvironment repEnv = new ReplicatedEnvironment(envDir, repConfig, envConfig);
        repEnv.close();
    }

    public static boolean needsRefresh(Database db, Environment current) {
        if (db == null) {
            return true;
        }
        Environment dbEnv = db.getEnvironment();
        if (dbEnv == null) {
            return true;
        }
        if (dbEnv == current) {
            return false;
        }
        if (dbEnv.isValid()) {
            throw new IllegalStateException("Database needs refreshing, but references a valid environment");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyData(ReplicatedEnvironment env, VerifyConfig verifyBtreeConfig, VerifyLogListener logListener, long logDelay, Logger logger) throws IOException {
        logger.info("Stop running scheduled verification.");
        EnvironmentMutableConfig mutableConfig = env.getMutableConfig();
        String oldScheduledConfig = mutableConfig.getConfigParam("je.env.runVerifier");
        try {
            mutableConfig.setConfigParam("je.env.runVerifier", "false");
            assert (TestHookExecute.doHookIfSet(VERIFY_ERROR_HOOK, env));
            if (verifyBtreeConfig != null) {
                logger.info("Start JE btree verification.");
                env.verify(verifyBtreeConfig);
            }
            if (logListener != null) {
                DbVerifyLog logVerify = new DbVerifyLog((Environment)env, 0, logListener);
                if (logDelay >= 0L) {
                    logVerify.setReadDelay(logDelay, TimeUnit.MILLISECONDS);
                }
                logger.info("Start JE log verification.");
                logVerify.verifyAll();
            }
        }
        finally {
            mutableConfig.setConfigParam("je.env.runVerifier", oldScheduledConfig);
        }
    }

    public static class VerificationOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final boolean verifyBtree;
        public final boolean verifyLog;
        public final boolean verifyIndex;
        public final boolean verifyRecord;
        public final long btreeDelay;
        public final long logDelay;
        public final long expiredTime;
        public final boolean showMissingFiles;

        public VerificationOptions(boolean verifyBtree, boolean verifyLog, boolean verifyIndex, boolean verifyRecord, long btreeDelay, long logDelay, long expiredTime, boolean showMissingFiles) {
            this.verifyBtree = verifyBtree;
            this.verifyLog = verifyLog;
            this.verifyIndex = verifyIndex;
            this.verifyRecord = verifyRecord;
            this.btreeDelay = btreeDelay;
            this.logDelay = logDelay;
            this.expiredTime = expiredTime;
            this.showMissingFiles = showMissingFiles;
        }

        public boolean equals(VerificationOptions other) {
            if (other == null) {
                return false;
            }
            return this.verifyBtree == other.verifyBtree && this.verifyLog == other.verifyLog && this.verifyIndex == other.verifyIndex && this.verifyRecord == other.verifyRecord && this.btreeDelay == other.btreeDelay && this.logDelay == other.logDelay && this.showMissingFiles == other.showMissingFiles;
        }
    }

    public static class VerificationInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private State currentState = State.NOT_STARTED;
        private long completeTime = 0L;
        private String exceptionMsg = null;
        public final boolean verifyBtree;
        public final boolean verifyLog;
        public final ResourceId id;
        public final Map<List<byte[]>, List<VerifyError>> recordErrorList = new HashMap<List<byte[]>, List<VerifyError>>();
        public final Map<String, List<VerifyError>> dbErrorList = new HashMap<String, List<VerifyError>>();
        public final List<VerifyError> otherErrorList = new ArrayList<VerifyError>();
        public final Map<Long, List<VerifyLogError>> logFileErrorList = new HashMap<Long, List<VerifyLogError>>();
        public final Set<Long> missingFilesReferenced = new HashSet<Long>();
        public final Set<Long> reservedFilesReferenced = new HashSet<Long>();
        public final Set<Long> reservedFilesRepaired = new HashSet<Long>();
        public boolean moreCorruptKeys = false;
        public boolean isInterrupted = false;
        public boolean interruptedByAnotherPlan = false;

        public VerificationInfo(boolean verifyBtree, boolean verifyLog, ResourceId id) {
            this.verifyBtree = verifyBtree;
            this.verifyLog = verifyLog;
            this.id = id;
        }

        public void setNotStarted() {
            this.currentState = State.NOT_STARTED;
        }

        public State getCurrentState() {
            return this.currentState;
        }

        public void startVerify() {
            this.currentState = State.INPROGRESS;
        }

        public void completeVerify() {
            this.currentState = State.COMPLETED;
            this.completeTime = System.currentTimeMillis();
        }

        public void setException(String errorMsg) {
            this.currentState = State.ERROR;
            this.exceptionMsg = errorMsg;
            this.completeTime = System.currentTimeMillis();
        }

        public long getLastVerifyTime() {
            return this.completeTime;
        }

        public String getExceptionMsg() {
            return this.exceptionMsg;
        }

        public boolean noBtreeCorruptions() {
            return this.recordErrorList.isEmpty() && this.dbErrorList.isEmpty() && this.otherErrorList.isEmpty() && this.missingFilesReferenced.isEmpty() && this.reservedFilesReferenced.isEmpty() && this.reservedFilesRepaired.isEmpty();
        }

        public boolean noLogFileCorruptions() {
            return this.logFileErrorList.isEmpty();
        }

        public ObjectNode getJson(boolean showMissingFiles) {
            ObjectNode jsonNodeTop = JsonUtils.createObjectNode();
            ObjectNode jsonNode = jsonNodeTop.putObject("" + this.id);
            if (this.getCurrentState() == State.ERROR) {
                jsonNode.put("Verification failed. Error", this.getExceptionMsg());
                return jsonNodeTop;
            }
            if (this.interruptedByAnotherPlan) {
                jsonNode.put("INTERRUPTED", "Verification interrupted by another plan.");
                return jsonNodeTop;
            }
            if (this.isInterrupted) {
                jsonNode.put("INTERRUPTED", "Verification interrupted by users.");
            }
            if (this.verifyBtree) {
                if (!this.noBtreeCorruptions()) {
                    ObjectNode jsonBtreeVerify = jsonNode.putObject("Btree Verify");
                    if (!this.dbErrorList.isEmpty()) {
                        this.putDbCorruptionJson(jsonBtreeVerify);
                    }
                    this.putKeyCorruptionJson(jsonBtreeVerify);
                    if (showMissingFiles) {
                        this.putFileCorruptionJson(jsonBtreeVerify);
                    }
                    if (!this.otherErrorList.isEmpty()) {
                        this.putOtherErrorJson(jsonBtreeVerify);
                    }
                } else {
                    jsonNode.put("Btree Verify", "No Btree Corruptions");
                }
            }
            if (this.verifyLog) {
                if (!this.noLogFileCorruptions()) {
                    this.putVerifyLogJson(jsonNode);
                } else {
                    jsonNode.put("Log File Verify", "No Log File Corruptions");
                }
            }
            return jsonNodeTop;
        }

        private void putDbCorruptionJson(ObjectNode jsonBtreeVerify) {
            ObjectNode jsonDbErrors = jsonBtreeVerify.putObject("Database corruptions");
            jsonDbErrors.put("Total Number", this.dbErrorList.size());
            ObjectNode jsonErrorList = jsonDbErrors.putObject("List");
            for (String dbName : this.dbErrorList.keySet()) {
                List<VerifyError> errors = this.dbErrorList.get(dbName);
                ObjectNode jsonDbName = jsonErrorList.putObject(dbName);
                int i = 1;
                for (VerifyError error : errors) {
                    jsonDbName.put("" + i, error.getMessage());
                    ++i;
                }
            }
        }

        private void putKeyCorruptionJson(ObjectNode jsonBtreeVerify) {
            if (!this.recordErrorList.isEmpty()) {
                ObjectNode jsonCorruptKeys = jsonBtreeVerify.putObject("Corrupt Keys");
                jsonCorruptKeys.put("Total number", this.recordErrorList.size());
                ObjectNode jsonErrorList = jsonCorruptKeys.putObject("List");
                for (List<byte[]> keys : this.recordErrorList.keySet()) {
                    List<VerifyError> errors = this.recordErrorList.get(keys);
                    ObjectNode jsonKey = jsonErrorList.putObject("dbName: " + (keys.get(0) == null ? "null" : new String(keys.get(0))) + " priKey: " + (keys.get(1) == null ? "null" : new String(keys.get(1))) + " secKey: " + (keys.get(2) == null ? "null" : new String(keys.get(2))));
                    int i = 1;
                    for (VerifyError error : errors) {
                        jsonKey.put("" + i, error.getProblem() + ": " + error.getMessage());
                        ++i;
                    }
                }
                if (this.moreCorruptKeys) {
                    jsonErrorList.putObject("Number of corrupt keys exceeds the limit. There are more to report. Please fix the reported corruption first and run verification again.");
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void putFileCorruptionJson(ObjectNode jsonBtreeVerify) {
            if (!(this.missingFilesReferenced.isEmpty() && this.reservedFilesReferenced.isEmpty() && this.reservedFilesRepaired.isEmpty())) {
                ObjectNode jsonMissingFile = jsonBtreeVerify.putObject("Missing Files Referenced");
                jsonMissingFile.put("Total number", this.missingFilesReferenced.size());
                if (!this.missingFilesReferenced.isEmpty()) {
                    ObjectNode jsonCorruptFilesList = jsonMissingFile.putObject("List");
                    int i = 1;
                    for (Long l : this.missingFilesReferenced) {
                        jsonCorruptFilesList.put("" + i, "" + l);
                        ++i;
                    }
                }
                ObjectNode jsonReservedFile = jsonBtreeVerify.putObject("Reserved Files Referenced");
                jsonReservedFile.put("Total number", this.reservedFilesReferenced.size());
                if (!this.reservedFilesReferenced.isEmpty()) {
                    ObjectNode jsonReservedFilesList = jsonReservedFile.putObject("List");
                    int i = 1;
                    for (Long file : this.reservedFilesReferenced) {
                        jsonReservedFilesList.put("" + i, "" + file);
                        ++i;
                    }
                }
                ObjectNode jsonRepairedFile = jsonBtreeVerify.putObject("Reserved Files Repaired");
                jsonRepairedFile.put("Total number", this.reservedFilesRepaired.size());
                if (!this.reservedFilesRepaired.isEmpty()) {
                    ObjectNode jsonRepairedFilesList = jsonRepairedFile.putObject("List");
                    boolean bl = true;
                    for (Long file : this.reservedFilesRepaired) {
                        void var6_13;
                        jsonRepairedFilesList.put("" + (int)var6_13, "" + file);
                        ++var6_13;
                    }
                }
            }
        }

        private void putOtherErrorJson(ObjectNode jsonBtreeVerify) {
            ObjectNode jsonOtherErrors = jsonBtreeVerify.putObject("Other Errors");
            jsonOtherErrors.put("Total number", this.otherErrorList.size());
            ObjectNode jsonOtherErrorList = jsonOtherErrors.putObject("List");
            int i = 1;
            for (VerifyError error : this.otherErrorList) {
                jsonOtherErrorList.put("" + i, error.getMessage());
                ++i;
            }
        }

        private void putVerifyLogJson(ObjectNode jsonNode) {
            ObjectNode jsonLogVerify = jsonNode.putObject("Log File Verify");
            ObjectNode jsonLogError = jsonLogVerify.putObject("Log File Error");
            jsonLogError.put("Total number", this.logFileErrorList.size());
            ObjectNode jsonLogErrorList = jsonLogError.putObject("List");
            for (Long file : this.logFileErrorList.keySet()) {
                ObjectNode jsonLogName = jsonLogErrorList.putObject("Log File " + file);
                int i = 1;
                for (VerifyLogError error : this.logFileErrorList.get(file)) {
                    jsonLogName.put("" + i, error.getMessage());
                    ++i;
                }
            }
        }

        public static enum State {
            NOT_STARTED,
            INPROGRESS,
            COMPLETED{

                @Override
                public boolean isDone() {
                    return true;
                }
            }
            ,
            ERROR{

                @Override
                public boolean isDone() {
                    return true;
                }
            };


            public boolean isDone() {
                return false;
            }
        }
    }

    public static class VerificationManager {
        private VerificationInfo info;
        private volatile VerificationThread curThread;
        private ReplicatedEnvironment env;
        private final ResourceId id;
        private final Logger logger;
        private VerificationOptions curOptions;
        private int curPlanId;

        public VerificationManager(ResourceId id, Logger logger) {
            this.id = id;
            this.logger = logger;
            this.info = null;
        }

        public synchronized void setEnv(ReplicatedEnvironment env) {
            this.env = env;
        }

        public synchronized VerificationInfo getInfo() {
            return this.info;
        }

        public synchronized VerificationThread getThread() {
            return this.curThread;
        }

        public synchronized VerificationInfo startAndPollVerification(VerificationOptions options, int planId) {
            if (this.env == null) {
                throw new IllegalStateException("Environment cannot be null.");
            }
            if (this.info != null) {
                if (planId < this.curPlanId) {
                    VerificationInfo oldInfo = new VerificationInfo(false, false, this.id);
                    oldInfo.interruptedByAnotherPlan = true;
                    oldInfo.completeVerify();
                    return oldInfo;
                }
                if (!this.info.getCurrentState().isDone()) {
                    if (planId != this.curPlanId) {
                        if (options != null) {
                            this.interruptVerification();
                            this.startNewVerification(options, planId);
                            return this.info;
                        }
                        return null;
                    }
                    return this.info;
                }
                long curTime = System.currentTimeMillis();
                if (options == null && this.curPlanId == planId || options != null && curTime - this.info.getLastVerifyTime() < options.expiredTime && options.equals(this.curOptions) && !this.info.isInterrupted) {
                    return this.info;
                }
            }
            if (options == null) {
                this.curPlanId = Math.max(planId, this.curPlanId);
                this.info = null;
                return this.info;
            }
            assert (TestHookExecute.doHookIfSet(VERIFY_CORRUPTDATA_HOOK, new Object[]{this.env, this.id}));
            this.startNewVerification(options, planId);
            return this.info;
        }

        private void startNewVerification(VerificationOptions options, int planId) {
            this.info = new VerificationInfo(options.verifyBtree, options.verifyLog, this.id);
            this.curThread = new VerificationThread(this.env, this.info, options, this.logger);
            this.curOptions = options;
            this.curPlanId = planId;
            this.curThread.start();
        }

        public synchronized boolean interruptVerification() {
            if (this.curThread == null || this.info == null || this.info.getCurrentState().isDone()) {
                return false;
            }
            try {
                this.curThread.join(this.curThread.initiateSoftShutdown());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.info.isInterrupted = true;
            return true;
        }
    }

    public static class VerificationThread
    extends StoppableThread {
        private final ReplicatedEnvironment env;
        private final VerificationInfo info;
        private final VerificationOptions options;
        private final Logger logger;
        private volatile boolean isShutdown = false;
        private static final int THREAD_SOFT_SHUTDOWN_MS = 10000;
        private static final int MAXIMUM_CORRUPT_KEYS_NUM = 5000;

        public VerificationThread(ReplicatedEnvironment env, VerificationInfo info, VerificationOptions options, Logger logger) {
            super("VerificationThread");
            this.env = env;
            this.info = info;
            this.options = options;
            this.logger = logger;
        }

        public void run() {
            try {
                VerifyConfig config = null;
                if (this.options.verifyBtree) {
                    VerifyListener listener = this.getBtreeVerifyListener();
                    config = new VerifyConfig();
                    if (this.options.btreeDelay >= 0L) {
                        config.setBatchDelay(this.options.btreeDelay, TimeUnit.MILLISECONDS);
                    }
                    config.setVerifyDataRecords(this.options.verifyRecord);
                    config.setVerifySecondaries(this.options.verifyIndex);
                    config.setListener(listener);
                }
                VerifyLogListener logListener = null;
                if (this.options.verifyLog) {
                    logListener = this.getLogVerifyListener();
                }
                DatabaseUtils.verifyData(this.env, config, logListener, this.options.logDelay, this.logger);
            }
            catch (Exception e) {
                String errorMsg = "Verification fails. Exception: " + e.getMessage();
                this.info.setException(errorMsg);
            }
            finally {
                if (this.info.getCurrentState() != VerificationInfo.State.COMPLETED && this.info.getCurrentState() != VerificationInfo.State.ERROR) {
                    this.info.setException("UNKNOWN ERROR.");
                }
                this.initiateSoftShutdown();
            }
        }

        protected synchronized int initiateSoftShutdown() {
            this.isShutdown = true;
            ((Object)((Object)this)).notifyAll();
            return 10000;
        }

        protected synchronized boolean checkForDone() {
            return this.isShutdown;
        }

        protected Logger getLogger() {
            return this.logger;
        }

        private VerifyLogListener getLogVerifyListener() {
            VerifyLogListener listener = new VerifyLogListener(){

                public boolean onBegin(int totalFiles) {
                    info.startVerify();
                    return !isShutdown;
                }

                public void onEnd(VerifyLogSummary summary) {
                    info.completeVerify();
                }

                public boolean onFile(long file, List<VerifyLogError> errors, boolean deleted) {
                    if (!errors.isEmpty()) {
                        ((VerificationThread)this).info.logFileErrorList.put(file, new ArrayList<VerifyLogError>(errors));
                    }
                    return !isShutdown;
                }

                public boolean onRead(long file, int bytesRead) {
                    return !isShutdown;
                }
            };
            return listener;
        }

        private VerifyListener getBtreeVerifyListener() {
            VerifyListener listener = new VerifyListener(){

                public boolean onBegin() {
                    info.startVerify();
                    assert (TestHookExecute.doHookIfSet(VERIFY_INTERRUPT_HOOK, null));
                    return !isShutdown;
                }

                public boolean onDatabase(String dbName, List<VerifyError> errors) {
                    if (errors != null && !errors.isEmpty()) {
                        ((VerificationThread)this).info.dbErrorList.put(dbName, new ArrayList<VerifyError>(errors));
                    }
                    return !isShutdown;
                }

                public void onEnd(VerifySummary summary) {
                    if (!((VerificationThread)this).options.verifyLog) {
                        info.completeVerify();
                    }
                    if (((VerificationThread)this).options.showMissingFiles) {
                        assert (TestHookExecute.doHookIfSet(VERIFY_CORRUPTFILE_HOOK, info));
                        ((VerificationThread)this).info.missingFilesReferenced.addAll(summary.getMissingFilesReferenced());
                        ((VerificationThread)this).info.reservedFilesReferenced.addAll(summary.getReservedFilesReferenced());
                        ((VerificationThread)this).info.reservedFilesRepaired.addAll(summary.getReservedFilesRepaired());
                    }
                }

                public boolean onOtherError(List<VerifyError> errors) {
                    ((VerificationThread)this).info.otherErrorList.addAll(errors);
                    return !isShutdown;
                }

                public boolean onRecord(String dbName, byte[] priKey, byte[] secKey, List<VerifyError> errors) {
                    if (errors != null && !errors.isEmpty()) {
                        if (((VerificationThread)this).info.recordErrorList.size() < 5000) {
                            ArrayList<byte[]> keys = new ArrayList<byte[]>();
                            keys.add(dbName.getBytes());
                            keys.add(priKey);
                            keys.add(secKey);
                            ((VerificationThread)this).info.recordErrorList.put(keys, new ArrayList<VerifyError>(errors));
                        } else {
                            ((VerificationThread)this).info.moreCorruptKeys = true;
                            return false;
                        }
                    }
                    return !isShutdown;
                }
            };
            return listener;
        }
    }
}

