/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonUtils {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private static final String HEX = "0123456789ABCDEF";

    public static JsonParser createJsonParser(Reader in) throws IOException {
        return JsonUtils.enableFeatures(mapper.getFactory().createParser(in));
    }

    public static JsonParser createJsonParser(InputStream in) throws IOException {
        return JsonUtils.enableFeatures(mapper.getFactory().createParser(in));
    }

    private static JsonParser enableFeatures(JsonParser parser) {
        parser.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return mapper.createArrayNode();
    }

    public static ObjectWriter createWriter(boolean pretty) {
        return pretty ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
    }

    public static String getAsText(JsonNode node, String field) {
        return JsonUtils.getAsText(node, field, null);
    }

    public static String getAsText(JsonNode node, String field, String defaultValue) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isValueNode()) {
            return defaultValue;
        }
        return fieldNode.asText();
    }

    public static Long getLong(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isLong()) {
            return null;
        }
        return fieldNode.asLong();
    }

    public static Integer getInt(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isInt()) {
            return null;
        }
        return fieldNode.asInt();
    }

    public static Double getDouble(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isDouble()) {
            return null;
        }
        return fieldNode.asDouble();
    }

    public static Boolean getBoolean(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isBoolean()) {
            return null;
        }
        return fieldNode.asBoolean();
    }

    public static boolean getBoolean(JsonNode node, String field, boolean defaultValue) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isBoolean()) {
            return defaultValue;
        }
        return fieldNode.asBoolean();
    }

    public static ObjectNode getObject(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isObject()) {
            return null;
        }
        return (ObjectNode)fieldNode;
    }

    public static Iterable<JsonNode> getArray(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        if (fieldNode == null || !fieldNode.isArray()) {
            return Collections.emptyList();
        }
        return fieldNode;
    }

    public static boolean jsonStringsEqual(String a, String b) {
        Map<String, Object> mapa = JsonUtils.getMapFromJsonStr(a);
        Map<String, Object> mapb = JsonUtils.getMapFromJsonStr(b);
        if (mapa == null) {
            return false;
        }
        return mapa.equals(mapb);
    }

    public static Map<String, Object> getMapFromJsonStr(String s) {
        return JsonUtils.getMapFromJsonStr(s, null);
    }

    public static Map<String, Object> getMapFromJsonStr(String s, Logger logger) {
        try {
            return mapper.readValue(s, HashMap.class);
        }
        catch (IOException e) {
            if (logger != null) {
                String errStr = "JsonUtils.getMapFromJsonStr: WARNING - " + e;
                logger.log(Level.WARNING, errStr, e);
            }
            return null;
        }
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static String convertBytesToHex(byte[] byteArray) {
        char[] hexValue = new char[byteArray.length * 2];
        char[] hexSymbols = HEX.toCharArray();
        for (int i = 0; i < byteArray.length; ++i) {
            int current = byteArray[i] & 0xFF;
            hexValue[i * 2 + 1] = hexSymbols[current & 0xF];
            hexValue[i * 2] = hexSymbols[current >> 4];
        }
        return new String(hexValue);
    }

    public static byte[] convertHexToBytes(String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string length");
        }
        byte[] result = new byte[hexString.length() / 2];
        int n = hexString.length();
        for (int i = 0; i < n; i += 2) {
            int hb = HEX.indexOf(hexString.charAt(i));
            int lb = HEX.indexOf(hexString.charAt(i + 1));
            result[i / 2] = (byte)(hb << 4 | lb);
        }
        return result;
    }
}

