/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.KVVersion;

public class SerialVersion {
    public static final short UNKNOWN = -1;
    private static final Map<Short, KVVersion> kvVersions = new HashMap<Short, KVVersion>();
    private static final short V1 = 1;
    private static final short V2 = 2;
    private static final short V3 = 3;
    private static final short V4 = 4;
    private static final short V5 = 5;
    private static final short V6 = 6;
    private static final short V7 = 7;
    private static final short V8 = 8;
    private static final short V9 = 9;
    public static final short ADMIN_CLI_JSON_V1_VERSION = 9;
    public static final short V10 = 10;
    public static final short TTL_SERIAL_VERSION = 10;
    public static final short V11 = 11;
    public static final short QUERY_VERSION = 11;
    public static final short V12 = 12;
    public static final short QUERY_VERSION_2 = 12;
    public static final short V13 = 13;
    public static final short QUERY_VERSION_3 = 13;
    public static final short V14 = 14;
    public static final short STD_UTF8_VERSION = 14;
    public static final short JSON_INDEX_VERSION = 14;
    public static final short NAMESPACE_VERSION = 14;
    public static final short QUERY_VERSION_4 = 14;
    public static final short SNAPSHOT_ON_SERVER_VERSION = 14;
    public static final short NETWORK_RESTORE_UTIL_VERSION = 14;
    public static final short V15 = 15;
    public static final short CHAR_ARRAY_STATEMENTS_VERSION = 15;
    public static final short QUERY_VERSION_5 = 15;
    public static final short VALUE_FORMAT_TABLE_V1_VERSION = 15;
    public static final short V16 = 16;
    public static final short QUERY_VERSION_6 = 16;
    public static final short RESULT_WITH_METADATA_SEQNUM = 16;
    public static final short TABLE_LIMITS_VERSION = 16;
    public static final short TOPOLOGY_REMOVESHARD_VERSION = 16;
    public static final short RESOURCE_TRACKING_VERSION = 16;
    public static final short MASTER_AFFINITY_VERSION = 16;
    public static final short VERIFY_DATA_VERSION = 16;
    public static final short GET_TABLE_BY_ID_VERSION = 16;
    public static final short ADMIN_CLI_JSON_V2_VERSION = 16;
    public static final short ENABLE_REQUEST_TYPE_VERSION = 16;
    public static final short EMPTY_READ_FACTOR_VERSION = 16;
    public static final short LOGCONTEXT_REQUEST_VERSION = 16;
    public static final short MAXKB_ITERATE_VERSION = 16;
    public static final short EXECUTE_OP_TABLE_ID = 16;
    public static final short MULTIDELTBL_WRITEKB_RESUMEKEY = 16;
    public static final short V17 = 17;
    public static final short PUSH_TABLE_COST = 17;
    public static final short V18 = 18;
    public static final short QUERY_VERSION_7 = 18;
    public static final short NAMESPACE_VERSION_2 = 18;
    public static final short IDENTITY_VERSION = 17;
    public static final short PUT_BATCH_OVERWRITE = 18;
    public static final short V19 = 19;
    public static final short RN_SHUTDOWN_STREAM_VERSION = 19;
    public static final short UPGRADE_VERIFY_DATA_VERSION = 19;
    public static final short V20 = 20;
    public static final short SKIP_NULLS_VERSION = 20;
    public static final short V21 = 21;
    public static final short QUERY_VERSION_8 = 21;
    private static final short DEFAULT_CURRENT = 21;
    private static final short DEFAULT_MINIMUM = 10;
    public static final short MINIMUM;
    public static final short CURRENT;

    private static void init(short version, KVVersion kvVersion) {
        kvVersions.put(version, kvVersion);
    }

    public static KVVersion getKVVersion(short serialVersion) {
        return kvVersions.get(serialVersion);
    }

    public static UnsupportedOperationException clientUnsupportedException(short clientSerialVersion, short requiredSerialVersion) {
        return new UnsupportedOperationException("The client is incompatible with this service. Client version is " + SerialVersion.getKVVersion(clientSerialVersion).getNumericVersionString() + ", but the minimum required version is " + SerialVersion.getKVVersion(requiredSerialVersion).getNumericVersionString());
    }

    public static UnsupportedOperationException serverUnsupportedException(short serverSerialVersion, short requiredSerialVersion) {
        return new UnsupportedOperationException("The server is incompatible with this client.  Server version is " + SerialVersion.getKVVersion(serverSerialVersion).getNumericVersionString() + ", but the minimum required version is " + SerialVersion.getKVVersion(requiredSerialVersion).getNumericVersionString());
    }

    static {
        SerialVersion.init((short)1, KVVersion.R1_2_123);
        SerialVersion.init((short)2, KVVersion.R2_0_23);
        SerialVersion.init((short)3, KVVersion.R2_1);
        SerialVersion.init((short)4, KVVersion.R3_0);
        SerialVersion.init((short)5, KVVersion.R3_1);
        SerialVersion.init((short)6, KVVersion.R3_2);
        SerialVersion.init((short)7, KVVersion.R3_2);
        SerialVersion.init((short)8, KVVersion.R3_4);
        SerialVersion.init((short)9, KVVersion.R3_5);
        SerialVersion.init((short)10, KVVersion.R4_0);
        SerialVersion.init((short)11, KVVersion.R4_1);
        SerialVersion.init((short)12, KVVersion.R4_2);
        SerialVersion.init((short)13, KVVersion.R4_3);
        SerialVersion.init((short)14, KVVersion.R4_4);
        SerialVersion.init((short)15, KVVersion.R4_5);
        SerialVersion.init((short)16, KVVersion.R18_1);
        SerialVersion.init((short)17, KVVersion.R18_2);
        SerialVersion.init((short)18, KVVersion.R18_3);
        SerialVersion.init((short)19, KVVersion.R19_1);
        SerialVersion.init((short)20, KVVersion.R19_2);
        SerialVersion.init((short)21, KVVersion.R19_3);
        assert (KVVersion.PREREQUISITE_VERSION == SerialVersion.getKVVersion((short)10));
        MINIMUM = Integer.getInteger("oracle.kv.minimum.serial.version", 10).shortValue();
        if (MINIMUM != 10) {
            System.err.println("Setting SerialVersion.MINIMUM=" + MINIMUM);
        }
        if ((CURRENT = Integer.getInteger("oracle.kv.test.currentserialversion", 21).shortValue()) != 21) {
            System.err.println("Setting SerialVersion.CURRENT=" + CURRENT);
        }
    }
}

