/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.impl.api.AsyncRequestHandlerAPI;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.DelegatingResultHandler;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.DialogType;
import oracle.kv.impl.async.DialogTypeFamily;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointConfigBuilder;
import oracle.kv.impl.async.EndpointGroup;
import oracle.kv.impl.async.FailureResultHandler;
import oracle.kv.impl.async.IOBufferPool;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.async.StandardDialogTypeFamily;
import oracle.kv.impl.async.dialog.nio.NioEndpointGroup;
import oracle.kv.impl.async.exception.DialogException;
import oracle.kv.impl.async.registry.ServiceEndpoint;
import oracle.kv.impl.async.registry.ServiceRegistry;
import oracle.kv.impl.async.registry.ServiceRegistryAPI;
import oracle.kv.impl.async.registry.ServiceRegistryImpl;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.registry.AsyncControl;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.ServerSocketFactory;

public class AsyncRegistryUtils
extends AsyncControl {
    private static EndpointGroup endpointGroup = null;
    private static String serverHostName = null;
    private static final ServiceRegistryAPI.Factory registryFactory = new TranslatingExceptionsRegistryFactory();

    private AsyncRegistryUtils() {
        throw new AssertionError();
    }

    public static synchronized EndpointGroup getEndpointGroup() {
        if (endpointGroup == null) {
            throw new IllegalStateException("The async EndpointGroup is not initialized");
        }
        return endpointGroup;
    }

    public static synchronized void initEndpointGroup(Logger logger, int numThreads, boolean forClient) {
        ObjectUtil.checkNull("logger", logger);
        if (endpointGroup != null) {
            return;
        }
        if (!forClient && !serverUseAsync) {
            return;
        }
        IOBufferPool.setLogger(logger);
        try {
            endpointGroup = new NioEndpointGroup(logger, numThreads);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception creating the async endpoint group: " + e.getMessage(), e);
        }
    }

    public static synchronized String getServerHostName() throws UnknownHostException {
        if (serverHostName != null) {
            return serverHostName;
        }
        return InetAddress.getLocalHost().getHostName();
    }

    public static synchronized void setServerHostName(String hostName) {
        serverHostName = ObjectUtil.checkNull("hostName", hostName);
        System.setProperty("java.rmi.server.hostname", hostName);
    }

    public static void getRequestHandler(Topology topology, RepNodeId repNodeId, final ResourceId callerId, long timeoutMs, final Logger logger, final ResultHandler<AsyncRequestHandlerAPI> resultHandler) {
        EndpointConfig registryEndpointConfig;
        final long stopTime = System.currentTimeMillis() + timeoutMs;
        RepNode repNode = topology.get(repNodeId);
        if (repNode == null) {
            resultHandler.onResult(null, null);
            return;
        }
        try {
            registryEndpointConfig = AsyncRegistryUtils.getRegistryEndpointConfig(topology.getKVStoreName());
        }
        catch (IOException e) {
            resultHandler.onResult(null, e);
            return;
        }
        final String bindingName = RegistryUtils.bindingName(topology.getKVStoreName(), repNodeId.getFullName(), RegistryUtils.InterfaceType.MAIN);
        StorageNode sn = topology.get(repNode.getStorageNodeId());
        class LookupRegistryResultHandler
        extends FailureResultHandler<ServiceRegistryAPI> {
            LookupRegistryResultHandler() {
                super(resultHandler2);
            }

            @Override
            protected void onResultInternal(ServiceRegistryAPI registry, Throwable e) {
                if (e != null) {
                    resultHandler.onResult(null, e);
                    return;
                }
                long timeout = stopTime - System.currentTimeMillis();
                if (timeout < 0L) {
                    resultHandler.onResult(null, null);
                    return;
                }
                class LookupResultHandler
                extends FailureResultHandler<ServiceEndpoint> {
                    final /* synthetic */ ResultHandler val$resultHandler;
                    final /* synthetic */ ResourceId val$callerId;
                    final /* synthetic */ long val$stopTime;
                    final /* synthetic */ Logger val$logger;

                    LookupResultHandler(ResultHandler<?> resultHandler) {
                        this.val$resultHandler = resultHandler;
                        this.val$callerId = var3_3;
                        this.val$stopTime = l;
                        this.val$logger = var6_5;
                        super(rh);
                    }

                    @Override
                    protected void onResultInternal(ServiceEndpoint serviceEndpoint, Throwable exception) throws IOException {
                        if (serviceEndpoint == null) {
                            this.val$resultHandler.onResult(null, exception);
                            return;
                        }
                        ClientSocketFactory csf = serviceEndpoint.getClientSocketFactory();
                        EndpointConfig endpointConfig = csf.getEndpointConfigBuilder().configId(this.val$callerId).build();
                        long timeout = this.val$stopTime - System.currentTimeMillis();
                        if (timeout < 0L) {
                            this.val$resultHandler.onResult(null, null);
                            return;
                        }
                        AsyncRequestHandlerAPI.wrap(AsyncRegistryUtils.getEndpointGroup().getCreatorEndpoint(serviceEndpoint.getNetworkAddress(), NetworkAddress.convert(csf.getLocalAddr()), endpointConfig), serviceEndpoint.getDialogType(), timeout, this.val$logger, this.val$resultHandler);
                    }
                }
                registry.lookup(bindingName, StandardDialogTypeFamily.ASYNC_REQUEST_HANDLER, timeout, new LookupResultHandler(resultHandler, resultHandler, callerId, stopTime, logger));
            }
        }
        AsyncRegistryUtils.getRegistry(topology.getKVStoreName(), sn.getHostname(), sn.getRegistryPort(), registryEndpointConfig, timeoutMs, logger, new LookupRegistryResultHandler());
    }

    private static EndpointConfig getRegistryEndpointConfig(String storeName) throws IOException {
        ClientSocketFactory csf = RegistryUtils.getRegistryCSF(storeName);
        if (csf != null) {
            return csf.getEndpointConfig();
        }
        return new EndpointConfigBuilder().option(AsyncOption.DLG_CONNECT_TIMEOUT, 3000).option(AsyncOption.DLG_IDLE_TIMEOUT, 10000).build();
    }

    private static void getRegistry(String storeName, String hostname, int port, EndpointConfig endpointConfig, long timeout, Logger logger, ResultHandler<ServiceRegistryAPI> hand) {
        ClientSocketFactory csf = RegistryUtils.getRegistryCSF(storeName);
        InetSocketAddress localAddr = csf != null ? csf.getLocalAddr() : null;
        registryFactory.wrap(AsyncRegistryUtils.getEndpointGroup().getCreatorEndpoint(new NetworkAddress(hostname, port), NetworkAddress.convert(localAddr), endpointConfig), timeout, logger, new TranslateExceptions<ServiceRegistryAPI>(hand));
    }

    public static EndpointGroup.ListenHandle createRegistry(String hostname, int port, ServerSocketFactory ssf, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler) throws IOException {
        ObjectUtil.checkNull("ssf", ssf);
        if (port != 0) {
            ssf = ssf.newInstance(port);
        }
        ServiceRegistryImpl server = new ServiceRegistryImpl(logger, exceptionHandler);
        class ServiceRegistryDialogHandlerFactory
        implements DialogHandlerFactory {
            final /* synthetic */ ServiceRegistryImpl val$server;

            ServiceRegistryDialogHandlerFactory(ServiceRegistryImpl serviceRegistryImpl) {
                this.val$server = serviceRegistryImpl;
            }

            @Override
            public DialogHandler create() {
                return this.val$server.createDialogHandler();
            }

            @Override
            public void onChannelError(ListenerConfig config, Throwable e, boolean channelClosed) {
            }
        }
        return AsyncRegistryUtils.getEndpointGroup().listen(ssf.getListenerConfig(), StandardDialogTypeFamily.SERVICE_REGISTRY_DIALOG_TYPE.getDialogTypeId(), new ServiceRegistryDialogHandlerFactory(server));
    }

    public static long rebind(String hostname, int registryPort, String storeName, final String serviceName, final DialogTypeFamily dialogTypeFamily, final DialogHandlerFactory dialogHandlerFactory, final ClientSocketFactory clientSocketFactory, final ServerSocketFactory serverSocketFactory, Logger logger, final ResultHandler<EndpointGroup.ListenHandle> resultHandler) {
        EndpointConfig endpointConfig;
        try {
            endpointConfig = AsyncRegistryUtils.getRegistryEndpointConfig(storeName);
        }
        catch (IOException e) {
            resultHandler.onResult(null, e);
            return 0L;
        }
        final long timeout = endpointConfig.getOption(AsyncOption.DLG_IDLE_TIMEOUT).longValue();
        class ListenAndRebindResultHandler
        extends FailureResultHandler<ServiceRegistryAPI> {
            ListenAndRebindResultHandler() {
                super(resultHandler2);
            }

            @Override
            protected void onResultInternal(ServiceRegistryAPI registry, Throwable e) {
                if (e != null) {
                    resultHandler.onResult(null, e);
                    return;
                }
                AsyncRegistryUtils.listenAndRebind(serviceName, dialogTypeFamily, dialogHandlerFactory, registry, timeout, clientSocketFactory, serverSocketFactory, resultHandler);
            }
        }
        AsyncRegistryUtils.getRegistry(storeName, hostname, registryPort, endpointConfig, timeout, logger, new ListenAndRebindResultHandler());
        return 2L * timeout;
    }

    private static void listenAndRebind(String serviceName, DialogTypeFamily dialogTypeFamily, DialogHandlerFactory dialogHandlerFactory, ServiceRegistryAPI registry, long timeout, ClientSocketFactory csf, ServerSocketFactory ssf, final ResultHandler<EndpointGroup.ListenHandle> rh) {
        DialogType dialogType = new DialogType(dialogTypeFamily);
        try {
            final EndpointGroup.ListenHandle listenHandle = AsyncRegistryUtils.getEndpointGroup().listen(ssf.getListenerConfig(), dialogType.getDialogTypeId(), dialogHandlerFactory);
            NetworkAddress addr = new NetworkAddress(AsyncRegistryUtils.getServerHostName(), listenHandle.getLocalAddress().getPort());
            class BindResultHandler
            extends FailureResultHandler<Void> {
                BindResultHandler() {
                    super(resultHandler);
                }

                @Override
                protected void onResultInternal(Void ignore, Throwable exception) {
                    if (exception != null) {
                        rh.onResult(null, exception);
                    } else {
                        rh.onResult(listenHandle, null);
                    }
                }
            }
            registry.bind(serviceName, new ServiceEndpoint(addr, dialogType, csf), timeout, new BindResultHandler());
        }
        catch (IOException e) {
            rh.onResult(null, e);
        }
    }

    public static long unbind(String hostname, int registryPort, String storeName, final String serviceName, Logger logger, final ResultHandler<Void> resultHandler) {
        EndpointConfig endpointConfig;
        try {
            endpointConfig = AsyncRegistryUtils.getRegistryEndpointConfig(storeName);
        }
        catch (IOException e) {
            resultHandler.onResult(null, e);
            return 0L;
        }
        final long timeout = endpointConfig.getOption(AsyncOption.DLG_IDLE_TIMEOUT).longValue();
        class UnbindResultHandler
        extends FailureResultHandler<ServiceRegistryAPI> {
            UnbindResultHandler() {
                super(resultHandler2);
            }

            @Override
            protected void onResultInternal(ServiceRegistryAPI registry, Throwable e) {
                if (e != null) {
                    resultHandler.onResult(null, e);
                } else {
                    registry.unbind(serviceName, timeout, resultHandler);
                }
            }
        }
        AsyncRegistryUtils.getRegistry(storeName, hostname, registryPort, endpointConfig, timeout, logger, new UnbindResultHandler());
        return timeout * 2L;
    }

    private static class ExceptionWrappingServiceRegistryAPI
    extends ServiceRegistryAPI {
        ExceptionWrappingServiceRegistryAPI(ServiceRegistry remote, short serialVersion) {
            super(remote, serialVersion);
        }

        @Override
        public void lookup(String name, DialogTypeFamily family, long timeout, ResultHandler<ServiceEndpoint> handler) {
            super.lookup(name, family, timeout, this.translate(handler));
        }

        @Override
        public void bind(String name, ServiceEndpoint endpoint, long timeout, ResultHandler<Void> handler) {
            super.bind(name, endpoint, timeout, this.translate(handler));
        }

        @Override
        public void unbind(String name, long timeout, ResultHandler<Void> h) {
            super.unbind(name, timeout, this.translate(h));
        }

        @Override
        public void list(long timeout, ResultHandler<List<String>> handler) {
            super.list(timeout, this.translate(handler));
        }

        private <T> ResultHandler<T> translate(ResultHandler<T> handler) {
            return new TranslateExceptions<T>(handler);
        }
    }

    private static class TranslateExceptions<T>
    extends DelegatingResultHandler<T, T> {
        TranslateExceptions(ResultHandler<T> handler) {
            super(handler);
        }

        @Override
        protected void onResultInternal(T result, Throwable exception) {
            Throwable underlyingException;
            if (exception instanceof DialogException && (underlyingException = ((DialogException)exception).getUnderlyingException()) instanceof SSLHandshakeException) {
                exception = new AuthenticationFailureException(underlyingException);
            }
            this.resultHandler.onResult(result, exception);
        }
    }

    private static class TranslatingExceptionsRegistryFactory
    extends ServiceRegistryAPI.Factory {
        private TranslatingExceptionsRegistryFactory() {
        }

        @Override
        protected ServiceRegistryAPI createAPI(ServiceRegistry remote, short serialVersion) {
            return new ExceptionWrappingServiceRegistryAPI(remote, serialVersion);
        }
    }
}

