/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import com.sleepycat.utilint.Latency;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import oracle.nosql.common.sklogger.MetricFamilySamples;
import oracle.nosql.common.sklogger.RateMetric;
import oracle.nosql.common.sklogger.StatsData;

public class PerfQuantile
extends RateMetric<RateResult, Element> {
    private final int maxTracked;

    public PerfQuantile(String name, int maxTracked, String ... labelNames) {
        super(name, labelNames);
        if (maxTracked <= 0) {
            throw new IllegalArgumentException("maxTracked value must be positive.");
        }
        this.maxTracked = maxTracked;
        this.initializeNoLabelsElement();
    }

    @Override
    protected Element newElement() {
        return new Element(this.maxTracked);
    }

    public void observe(int val) {
        ((Element)this.noLabelsElement).observe(val);
    }

    public void observe(int val, int times) {
        ((Element)this.noLabelsElement).observe(val, times);
    }

    public void observeNanoLatency(long nanoLatency, int times) {
        ((Element)this.noLabelsElement).observeNanoLatency(nanoLatency, times);
    }

    @Override
    public MetricFamilySamples<RateResult> collect() {
        return this.collect(StatsData.Type.PERF_QUANTILE);
    }

    @Override
    public MetricFamilySamples<RateResult> collectSinceLastTime(String watcherName) {
        return this.collectSinceLastTime(StatsData.Type.PERF_QUANTILE, watcherName);
    }

    public static class RateResult
    extends RateMetric.RateResult {
        private static final long serialVersionUID = 1L;
        private final int maxTracked;
        private final long requestCount;
        private final long operationCount;
        private final long overflowCount;
        private final int min;
        private final int max;
        private final int percent95;
        private final int percent99;
        private final long totalLatency;

        public RateResult(int maxTracked, long duration, long requestCount, long operationCount, long overflowCount, int min, int max, int percent95, int percent99, long totalLatency) {
            super(duration);
            this.maxTracked = maxTracked;
            this.requestCount = requestCount;
            this.operationCount = operationCount;
            this.overflowCount = overflowCount;
            this.min = min;
            this.max = max;
            this.percent95 = percent95;
            this.percent99 = percent99;
            this.totalLatency = totalLatency;
        }

        public long getRequestCount() {
            return this.requestCount;
        }

        public long getOperationCount() {
            return this.operationCount;
        }

        public long getOverflowCount() {
            return this.overflowCount;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int get95th() {
            return this.percent95;
        }

        public int get99th() {
            return this.percent99;
        }

        public float getAvgMs() {
            if (this.operationCount == 0L) {
                return 0.0f;
            }
            return (float)this.totalLatency / (float)this.operationCount;
        }

        public Latency getLatency() {
            Latency latency = new Latency(this.maxTracked, this.min, this.max, this.getAvgMs(), this.operationCount, this.requestCount, this.percent95, this.percent99, (int)this.overflowCount);
            return latency;
        }

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = super.toMap();
            map.put("requestCount", this.requestCount);
            map.put("operationCount", this.operationCount);
            map.put("overflowCount", this.overflowCount);
            map.put("operationMin", this.min);
            map.put("operationMax", this.max);
            map.put("operationAvg", Float.valueOf(this.getAvgMs()));
            map.put("quantile_0.95", this.percent95);
            map.put("quantile_0.99", this.percent99);
            return map;
        }
    }

    public static final class Element
    extends RateMetric.Element<RateResult> {
        private static final int DEFAULT_VAL = 0;
        private final int maxTracked;
        private final AtomicLong totalRequests;
        private final AtomicLong overflowRequests;
        private final AtomicLongArray cumulativeCounts;
        private final Max overallMax;
        private final ConcurrentHashMap<String, HistoryItem> watchers;

        private Element(int maxTracked) {
            this.maxTracked = maxTracked;
            this.totalRequests = new AtomicLong();
            this.overflowRequests = new AtomicLong();
            this.cumulativeCounts = new AtomicLongArray(maxTracked + 1);
            this.overallMax = new Max();
            this.watchers = new ConcurrentHashMap();
        }

        public void observeNanoLatency(long nanoLatency, int times) {
            if (nanoLatency < 0L) {
                return;
            }
            int millisRounded = (int)((nanoLatency + 500000L) / 1000000L);
            this.observe(millisRounded, times);
        }

        public void observe(int val) {
            this.observe(val, 1);
        }

        public void observe(int val, int times) {
            if (val < 0) {
                return;
            }
            this.totalRequests.incrementAndGet();
            if (val < this.maxTracked) {
                this.cumulativeCounts.addAndGet(val, times);
            } else {
                this.cumulativeCounts.addAndGet(this.maxTracked, times);
                this.overflowRequests.incrementAndGet();
            }
            this.updateMax(val);
        }

        private void updateMax(int val) {
            this.overallMax.updateMax(val);
            for (HistoryItem item : this.watchers.values()) {
                item.max.updateMax(val);
            }
        }

        private RateResult calculate(long duration, long requestCount, long overflowCount, long operationCount, long[] histogramCounts, int max) {
            long percent99Count;
            long percent95Count;
            int percent95 = 0;
            int percent99 = 0;
            int min = -1;
            if (operationCount == 1L) {
                percent95Count = 1L;
                percent99Count = 1L;
            } else {
                percent95Count = (int)((double)operationCount * 0.95);
                percent99Count = (int)((double)operationCount * 0.99);
            }
            long numRequestsSeen = 0L;
            long totalLatency = 0L;
            for (int latency = 0; latency < histogramCounts.length; ++latency) {
                if (histogramCounts[latency] == 0L) continue;
                if (numRequestsSeen < percent95Count) {
                    percent95 = latency;
                }
                if (numRequestsSeen < percent99Count) {
                    percent99 = latency;
                }
                if (min == -1) {
                    min = latency;
                }
                while (max < latency) {
                    max = latency;
                }
                numRequestsSeen += histogramCounts[latency];
                totalLatency += histogramCounts[latency] * (long)latency;
            }
            if (min == -1) {
                min = 0;
            }
            return new RateResult(this.maxTracked, duration, requestCount, operationCount, overflowCount, min, max, percent95, percent99, totalLatency);
        }

        @Override
        public RateResult rate() {
            long[] intervalCounts = new long[this.maxTracked + 1];
            long intervalTotalCount = 0L;
            for (int i = 0; i < intervalCounts.length; ++i) {
                intervalCounts[i] = this.cumulativeCounts.get(i);
                intervalTotalCount += intervalCounts[i];
            }
            return this.calculate(System.nanoTime() - this.initialTime, this.totalRequests.get(), this.overflowRequests.get(), intervalTotalCount, intervalCounts, this.overallMax.val);
        }

        @Override
        public RateResult rateSinceLastTime(String watcherName) {
            long[] lastHistogramCounts;
            long currentTime = System.nanoTime();
            long currentTotalRequests = this.totalRequests.get();
            long currentOverflowRequests = this.overflowRequests.get();
            long lastTime = this.initialTime;
            long lastRequestCount = 0L;
            long lastOverflowCount = 0L;
            int max = 0;
            HistoryItem historyItem = this.watchers.get(watcherName);
            if (historyItem != null) {
                lastTime = historyItem.lastTime;
                lastHistogramCounts = historyItem.lastHistogramCounts;
                lastRequestCount = historyItem.lastRequestCount;
                lastOverflowCount = historyItem.lastOverflowCount;
                max = historyItem.max.val;
                historyItem.lastTime = currentTime;
                historyItem.lastRequestCount = currentTotalRequests;
                historyItem.lastOverflowCount = currentOverflowRequests;
                historyItem.max.reset();
            } else {
                lastHistogramCounts = new long[this.maxTracked + 1];
                this.watchers.put(watcherName, new HistoryItem(currentTime, currentTotalRequests, currentOverflowRequests, lastHistogramCounts));
            }
            long[] intervalCounts = new long[this.maxTracked + 1];
            long cumulativeICount = 0L;
            long intervalTotalCount = 0L;
            for (int i = 0; i < intervalCounts.length; ++i) {
                cumulativeICount = this.cumulativeCounts.get(i);
                intervalCounts[i] = cumulativeICount - lastHistogramCounts[i];
                lastHistogramCounts[i] = cumulativeICount;
                intervalTotalCount += intervalCounts[i];
            }
            return this.calculate(currentTime - lastTime, currentTotalRequests - lastRequestCount, currentOverflowRequests - lastOverflowCount, intervalTotalCount, intervalCounts, max);
        }

        private static final class Max {
            private volatile int val;

            private Max() {
                this.reset();
            }

            private void reset() {
                this.val = 0;
            }

            private void updateMax(int next) {
                while (this.val < next) {
                    this.val = next;
                }
            }
        }

        private static final class HistoryItem {
            private long lastTime;
            private long lastRequestCount;
            private long lastOverflowCount;
            private long[] lastHistogramCounts;
            private Max max;

            private HistoryItem(long time, long requestCount, long overflowCount, long[] histogramCounts) {
                this.lastTime = time;
                this.lastRequestCount = requestCount;
                this.lastOverflowCount = overflowCount;
                this.lastHistogramCounts = histogramCounts;
                this.max = new Max();
            }
        }
    }
}

