/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.query;

import java.math.MathContext;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.query.PrepareCallback;
import oracle.kv.table.TableIteratorOptions;

public class ExecuteOptions {
    private Consistency consistency;
    private Durability durability;
    private long timeout;
    private TimeUnit timeoutUnit;
    private int maxConcurrentRequests;
    private int resultsBatchSize;
    private byte traceLevel;
    private MathContext mathContext = MathContext.DECIMAL32;
    private String namespace;
    private PrepareCallback prepareCallback;
    private int maxReadKB;
    private int maxWriteKB;
    private byte[] continuationKey;
    private boolean useBatchSizeAsLimit;
    private AuthContext authContext = null;
    private LogContext logContext = null;
    private boolean doPrefetching = true;
    private long maxMemoryConsumption = 0x6400000L;
    private int geoMaxCoveringCells = 1000;
    private int geoMinCoveringCells = 100;
    private int geoMaxRanges = 300;
    private double geoSplitRatio = 0.2;
    private int geoMaxSplits = 5;
    private int deleteLimit = 1000;
    private boolean validateNamespace = true;
    private boolean isCloudQuery;
    private int driverQueryVersion;

    public ExecuteOptions() {
    }

    public ExecuteOptions(TableIteratorOptions options) {
        if (options != null) {
            this.maxConcurrentRequests = options.getMaxConcurrentRequests();
            this.resultsBatchSize = options.getResultsBatchSize();
            this.maxReadKB = options.getMaxReadKB();
            this.consistency = options.getConsistency();
            this.timeout = options.getTimeout();
            this.timeoutUnit = options.getTimeoutUnit();
            this.logContext = options.getLogContext();
            this.authContext = options.getAuthContext();
        }
    }

    public ExecuteOptions setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public ExecuteOptions setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public ExecuteOptions setTimeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        if (timeout != 0L && timeoutUnit == null) {
            throw new IllegalArgumentException("A non-zero timeout requires a non-null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public ExecuteOptions setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    public int getResultsBatchSize() {
        return this.resultsBatchSize > 0 ? this.resultsBatchSize : (this.getMaxReadKB() == 0 ? KVStoreImpl.DEFAULT_ITERATOR_BATCH_SIZE : 0);
    }

    public ExecuteOptions setResultsBatchSize(int resultsBatchSize) {
        if (resultsBatchSize < 0) {
            throw new IllegalArgumentException("The batch size can not be a negative value: " + resultsBatchSize);
        }
        this.resultsBatchSize = resultsBatchSize;
        return this;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public ExecuteOptions setMathContext(MathContext mathContext) {
        if (mathContext != null) {
            this.mathContext = mathContext;
        }
        return this;
    }

    public byte getTraceLevel() {
        return this.traceLevel;
    }

    public ExecuteOptions setTraceLevel(byte level) {
        this.traceLevel = level;
        return this;
    }

    public ExecuteOptions setNamespace(String namespace) {
        return this.setNamespace(namespace, true);
    }

    public ExecuteOptions setNamespace(String namespace, boolean validate) {
        if (namespace != null) {
            TableImpl.validateNamespace(namespace);
        }
        this.namespace = namespace;
        this.validateNamespace = validate;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ExecuteOptions setPrepareCallback(PrepareCallback prepareCallback) {
        this.prepareCallback = prepareCallback;
        return this;
    }

    public PrepareCallback getPrepareCallback() {
        return this.prepareCallback;
    }

    public ExecuteOptions setMaxReadKB(int maxReadKB) {
        if (maxReadKB < 0) {
            throw new IllegalArgumentException("The max read KB can not be a negative value: " + maxReadKB);
        }
        this.maxReadKB = maxReadKB;
        return this;
    }

    public int getMaxReadKB() {
        return this.maxReadKB;
    }

    public ExecuteOptions setMaxWriteKB(int maxWriteKB) {
        if (maxWriteKB < 0) {
            throw new IllegalArgumentException("The max read KB can not be a negative value: " + maxWriteKB);
        }
        this.maxWriteKB = maxWriteKB;
        return this;
    }

    public int getMaxWriteKB() {
        return this.maxWriteKB;
    }

    public ExecuteOptions setUseBatchSizeAsLimit(boolean value) {
        this.useBatchSizeAsLimit = value;
        return this;
    }

    public boolean getUseBatchSizeAsLimit() {
        return this.useBatchSizeAsLimit;
    }

    public ExecuteOptions setContinuationKey(byte[] continuationKey) {
        this.continuationKey = continuationKey;
        return this;
    }

    public byte[] getContinuationKey() {
        return this.continuationKey;
    }

    public ExecuteOptions setLogContext(LogContext lc) {
        this.logContext = lc;
        return this;
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public void setDoPrefetching(boolean v) {
        this.doPrefetching = v;
    }

    public boolean getDoPrefetching() {
        return this.doPrefetching;
    }

    public void setMaxMemoryConsumption(long v) {
        this.maxMemoryConsumption = v;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public int getGeoMaxCoveringCells() {
        return this.geoMaxCoveringCells;
    }

    public void setGeoMaxCoveringCells(int v) {
        this.geoMaxCoveringCells = v;
    }

    public int getGeoMinCoveringCells() {
        return this.geoMinCoveringCells;
    }

    public void setGeoMinCoveringCells(int v) {
        this.geoMinCoveringCells = v;
    }

    public int getGeoMaxRanges() {
        return this.geoMaxRanges;
    }

    public void setGeoMaxRanges(int v) {
        this.geoMaxRanges = v;
    }

    public int getGeoMaxSplits() {
        return this.geoMaxSplits;
    }

    public void setGeoMaxSplits(int v) {
        this.geoMaxSplits = v;
    }

    public double getGeoSplitRatio() {
        return this.geoSplitRatio;
    }

    public void setGeoSplitRatio(double v) {
        this.geoSplitRatio = v;
    }

    public void setDeleteLimit(int v) {
        this.deleteLimit = v;
    }

    public int getDeleteLimit() {
        return this.deleteLimit;
    }

    public boolean isValidateNamespace() {
        return this.validateNamespace;
    }

    public ExecuteOptions setIsCloudQuery(boolean v) {
        this.isCloudQuery = v;
        return this;
    }

    public boolean isCloudQuery() {
        return this.isCloudQuery;
    }

    public ExecuteOptions setDriverQueryVersion(int v) {
        this.driverQueryVersion = v;
        return this;
    }

    public int getDriverQueryVersion() {
        return this.driverQueryVersion;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public ExecuteOptions setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
        return this;
    }
}

