/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.util.contextlogger.LogContext;

public class ReadOptions {
    private final Consistency consistency;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private LogContext logContext;
    private AuthContext authContext;

    public ReadOptions(Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        if (timeout != 0L && timeoutUnit == null) {
            throw new IllegalArgumentException("A non-zero timeout requires a non-null timeout unit");
        }
        this.consistency = consistency;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public ReadOptions setLogContext(LogContext logContext) {
        this.logContext = logContext;
        return this;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public ReadOptions setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
        return this;
    }
}

