/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class TimeToLive
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final TimeUnit unit;
    public static final TimeToLive DO_NOT_EXPIRE = new TimeToLive(0L, TimeUnit.DAYS);

    public static TimeToLive ofHours(long hours) {
        return TimeToLive.createTimeToLive(hours, TimeUnit.HOURS);
    }

    public static TimeToLive ofDays(long days) {
        return TimeToLive.createTimeToLive(days, TimeUnit.DAYS);
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.value, this.unit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.value, this.unit);
    }

    public long toExpirationTime(long referenceTime) {
        if (this.value == 0L) {
            return 0L;
        }
        return referenceTime + this.toMillis();
    }

    public static TimeToLive fromExpirationTime(long expirationTime, long referenceTime) {
        long MILLIS_PER_HOUR = 3600000L;
        if (expirationTime == 0L) {
            return DO_NOT_EXPIRE;
        }
        long hours = (expirationTime + 3600000L - 1L) / 3600000L;
        boolean timeInHours = hours % 24L != 0L;
        long duration = expirationTime - referenceTime;
        if (duration == 0L) {
            duration = -3600000L;
            timeInHours = true;
        }
        if (timeInHours) {
            if (duration > 0L && duration < 3600000L) {
                return new TimeToLive(1L, TimeUnit.HOURS);
            }
            return new TimeToLive(TimeUnit.HOURS.convert(duration, TimeUnit.MILLISECONDS), TimeUnit.HOURS);
        }
        if (duration > 0L && duration < 86400000L) {
            return new TimeToLive(1L, TimeUnit.DAYS);
        }
        return new TimeToLive(TimeUnit.DAYS.convert(duration, TimeUnit.MILLISECONDS), TimeUnit.DAYS);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeToLive)) {
            return false;
        }
        TimeToLive otherTTL = (TimeToLive)other;
        if (this.value == 0L && otherTTL.value == 0L) {
            return true;
        }
        return this.unit == otherTTL.unit && this.value == otherTTL.value;
    }

    public int hashCode() {
        return (int)(this.value >>> 32 ^ this.value) + this.unit.hashCode();
    }

    public String toString() {
        return this.value + " " + this.unit.toString();
    }

    public static TimeToLive createTimeToLive(long value, TimeUnit unit) {
        if (value < 0L) {
            throw new IllegalArgumentException("TimeToLive does not support negative time periods");
        }
        return value == 0L ? DO_NOT_EXPIRE : new TimeToLive(value, unit);
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    private TimeToLive(long value, TimeUnit unit) {
        if (unit != TimeUnit.DAYS && unit != TimeUnit.HOURS) {
            throw new IllegalArgumentException("Invalid TimeUnit (" + (Object)((Object)unit) + ") in TimeToLive construction.Must be DAYS or HOURS.");
        }
        this.value = value;
        this.unit = unit;
    }

    private long toMillis() {
        return TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public static TimeToLive readFastExternal(DataInput in, short serialVersion) throws IOException {
        int ttlVal = TimeToLive.readTTLValue(in);
        TimeUnit ttlUnit = TimeToLive.readTTLUnit(in, ttlVal);
        return TimeToLive.createTimeToLive(ttlVal, ttlUnit);
    }

    public static int readTTLValue(DataInput in) throws IOException {
        return in.readInt();
    }

    public static TimeUnit readTTLUnit(DataInput in, int ttlVal) throws IOException {
        try {
            return TimeToLive.convertTimeToLiveUnit(ttlVal, ttlVal == 0 ? (byte)0 : in.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid value: " + e.getMessage(), e);
        }
    }

    public static TimeUnit convertTimeToLiveUnit(int ttlVal, byte unitOrdinal) {
        if (ttlVal == 0) {
            return TimeUnit.DAYS;
        }
        switch (unitOrdinal) {
            case 6: {
                return TimeUnit.DAYS;
            }
            case 5: {
                return TimeUnit.HOURS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit ordinal: " + unitOrdinal);
    }

    public static int getTTLValue(TimeToLive ttl) {
        return ttl != null ? (int)ttl.getValue() : 0;
    }

    public static TimeUnit getTTLUnit(TimeToLive ttl) {
        return ttl != null ? ttl.getUnit() : TimeUnit.DAYS;
    }

    public static void writeFastExternal(DataOutput out, short serialVersion, int ttlVal, TimeUnit ttlUnit) throws IOException {
        out.writeInt(ttlVal);
        if (ttlVal == 0) {
            return;
        }
        if (ttlUnit != TimeUnit.DAYS && ttlUnit != TimeUnit.HOURS) {
            throw new IllegalArgumentException("Invalid TTL time unit: " + (Object)((Object)ttlUnit));
        }
        out.writeByte((byte)ttlUnit.ordinal());
    }
}

