/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import java.util.concurrent.TimeUnit;
import oracle.kv.Durability;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.util.contextlogger.LogContext;

public class WriteOptions
implements Cloneable {
    private Durability durability;
    private long timeout;
    private TimeUnit timeoutUnit;
    private boolean updateTTL;
    private int maxWriteKB;
    private int identityCacheSize = 0;
    private LogContext logContext;
    private AuthContext authContext;

    public WriteOptions() {
        this(null, 0L, null);
    }

    public WriteOptions(Durability durability, long timeout, TimeUnit timeoutUnit) {
        this.setTimeout(timeout, timeoutUnit).setDurability(durability);
    }

    public WriteOptions(WriteOptions options) {
        this(options.durability, options.timeout, options.timeoutUnit);
        this.updateTTL = options.updateTTL;
        this.maxWriteKB = options.maxWriteKB;
        this.identityCacheSize = options.identityCacheSize;
    }

    public WriteOptions setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public WriteOptions setTimeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        if (timeout != 0L && timeoutUnit == null) {
            throw new IllegalArgumentException("A non-zero timeout requires a non-null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public WriteOptions setUpdateTTL(boolean flag) {
        this.updateTTL = flag;
        return this;
    }

    public boolean getUpdateTTL() {
        return this.updateTTL;
    }

    public WriteOptions setIdentityCacheSize(int identityCacheSize) {
        this.identityCacheSize = identityCacheSize;
        return this;
    }

    public int getIdentityCacheSize() {
        return this.identityCacheSize;
    }

    public WriteOptions setMaxWriteKB(int maxWriteKB) {
        if (maxWriteKB < 0) {
            throw new IllegalArgumentException("maxWriteKB must be >= 0");
        }
        this.maxWriteKB = maxWriteKB;
        return this;
    }

    public int getMaxWriteKB() {
        return this.maxWriteKB;
    }

    protected Object clone() throws CloneNotSupportedException {
        WriteOptions clone = new WriteOptions();
        clone.setDurability(this.durability);
        clone.setTimeout(this.timeout, this.timeoutUnit);
        clone.setUpdateTTL(this.updateTTL);
        clone.setIdentityCacheSize(this.identityCacheSize);
        return clone;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Durability ").append(this.durability).append(" timeout=").append(this.timeout).append(this.timeoutUnit == null ? "" : this.timeoutUnit).append(" updateTTL=").append(this.updateTTL).append(" identityCacheSize=").append(this.identityCacheSize);
        return buf.toString();
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public WriteOptions setLogContext(LogContext logContext) {
        this.logContext = logContext;
        return this;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public WriteOptions setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
        return this;
    }
}

