/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;

public class MessageFileProcessor {
    public static final String MESSAGES_FILE_BASE_NAME = "messages";
    public static final String MESSAGES_FILE_SUFFIX = "properties";
    public static final String MESSAGES_FILE_NAME = "messages.properties";
    private static final String ARG_CODELINE_BASEDIR = "-d";
    private static final String COMMENT_DELIMITER = "/";
    private static final String MESSAGE_LINE_DELIMETER = ",";
    private static final String LINE_SEP = "\n";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String OVERRIDE_TAG = "@Override";
    private static final String GEN_CODE_PKG_NAME = "oracle.kv.util";
    private static final String GEN_CODE_CLASS_NAME = "ErrorMessage";
    private static final String GENERATOR_CLASS_NAME = "MessageFileProcessor";
    private static final String ERR_CODE_ENUM_PREFIX = "NOSQL_";
    private static final String GEN_CODE_GET_VALUE_DECALARE = "public abstract int getValue();";
    private static final String GEN_CODE_GET_VALUE_METHOD = "public int getValue()";
    private static final String GEN_CODE_GET_ENUM_METHOD = "public static ErrorMessage getEnum(int value)";
    private static final String PATH_TO_MESSAGE_FILE = FILE_SEP + "resources" + FILE_SEP + "msgs" + FILE_SEP + "messages.properties";
    private static final String PATH_TO_GENERATED_JAVA_CLASS = FILE_SEP + "src" + FILE_SEP + "oracle" + FILE_SEP + "kv" + FILE_SEP + "util" + FILE_SEP + "ErrorMessage" + ".java";
    private static final String PATH_TO_GENERATOR_JAVA_CLASS = FILE_SEP + "src" + FILE_SEP + "oracle" + FILE_SEP + "kv" + FILE_SEP + "util" + FILE_SEP + "MessageFileProcessor" + ".java";
    private static final String WARNING_COMMENT = "/*-\n * Copyright (C) 2011, 2019 Oracle and/or its affiliates. All rights reserved.\n *\n * This file was distributed by Oracle as part of a version of Oracle NoSQL\n * Database made available at:\n *\n * http://www.oracle.com/technetwork/database/database-technologies/nosqldb/downloads/index.html\n *\n * Please see the LICENSE file included in the top-level directory of the\n * appropriate version of Oracle NoSQL Database for a copy of the license and\n * additional information.\n */\n\n//---------------------------------------------------------------------------\n//--------         DO NOT EDIT THIS FILE DIRECTLY                 -----------\n//--------         See kv.util.MessageFileProcessor.java          -----------\n//---------------------------------------------------------------------------\n";
    private static String codelineBaseDir = null;

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(ARG_CODELINE_BASEDIR)) {
                if (args.length <= i) {
                    MessageFileProcessor.usageAndExit();
                }
                codelineBaseDir = args[i + 1];
                i += 2;
                continue;
            }
            MessageFileProcessor.usageAndExit();
        }
        if (codelineBaseDir == null) {
            MessageFileProcessor.usageAndExit();
        }
        try {
            MessageFileProcessor.genJavaEnumFromMsgFile(codelineBaseDir + PATH_TO_MESSAGE_FILE, codelineBaseDir + PATH_TO_GENERATED_JAVA_CLASS, codelineBaseDir + PATH_TO_GENERATOR_JAVA_CLASS);
        }
        catch (IOException E) {
            System.out.println(E.toString());
            E.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genJavaEnumFromMsgFile(String msgFilePath, String generatedEnumSrcFilePath, String msgFileProcessorFilePath) throws IOException {
        if (new File(generatedEnumSrcFilePath).lastModified() > new File(msgFilePath).lastModified() && new File(generatedEnumSrcFilePath).lastModified() > new File(msgFileProcessorFilePath).lastModified()) {
            return;
        }
        PrintStream ps = new PrintStream(generatedEnumSrcFilePath);
        ps.println(WARNING_COMMENT);
        ps.println("package oracle.kv.util;\n");
        ps.println("public enum ErrorMessage {\n");
        try (LineNumberReader reader = new LineNumberReader(new FileReader(msgFilePath));){
            String currLine = null;
            boolean firstLine = true;
            while ((currLine = reader.readLine()) != null) {
                String key = MessageFileProcessor.getKey(currLine.trim(), reader.getLineNumber());
                if (key == null) continue;
                if (!firstLine) {
                    ps.println(MESSAGE_LINE_DELIMETER);
                } else {
                    firstLine = false;
                }
                ps.println("\t// " + MessageFileProcessor.getMessageForKey(key, currLine, reader.getLineNumber()));
                ps.print("\tNOSQL_" + key + "() {" + LINE_SEP);
                ps.print(MessageFileProcessor.genGetValueMethodBlock("\t\t", key));
                ps.print("\t}");
            }
            ps.println(";\n");
            ps.println("\tpublic abstract int getValue();");
            ps.println();
            ps.println(MessageFileProcessor.genGetEnumMethodBlock("\t"));
            ps.println("}");
            ps.flush();
            ps.close();
            System.out.println("Successfully wrote " + generatedEnumSrcFilePath);
        }
    }

    private static String genGetValueMethodBlock(String leftIndent, String key) {
        return leftIndent + OVERRIDE_TAG + LINE_SEP + leftIndent + GEN_CODE_GET_VALUE_METHOD + " {" + LINE_SEP + leftIndent + "\treturn " + key + ";" + LINE_SEP + leftIndent + "}" + LINE_SEP;
    }

    private static String genGetEnumMethodBlock(String leftIndent) {
        return leftIndent + GEN_CODE_GET_ENUM_METHOD + " {" + LINE_SEP + leftIndent + "\tfor (ErrorMessage msg : values()) {" + LINE_SEP + leftIndent + "\t\tif (msg.getValue() == value) {" + LINE_SEP + leftIndent + "\t\t\treturn msg;" + LINE_SEP + leftIndent + "\t\t}" + LINE_SEP + leftIndent + "\t}" + LINE_SEP + leftIndent + "\tthrow new IllegalArgumentException(\"unknow value: \" + value);" + LINE_SEP + leftIndent + "}" + LINE_SEP;
    }

    public static String getKey(String currLine, int lineNumber) {
        String[] tokens = MessageFileProcessor.parseLine(currLine, lineNumber);
        return tokens != null ? tokens[0] : null;
    }

    public static String getMessageForKey(String requestedKey, LineNumberReader ln) throws IOException {
        String currLine = null;
        while ((currLine = ln.readLine()) != null) {
            String msg;
            if (currLine.length() == 0 || currLine.startsWith(COMMENT_DELIMITER) || (msg = MessageFileProcessor.getMessageForKey(requestedKey, currLine.trim(), ln.getLineNumber())) == null) continue;
            return msg;
        }
        return null;
    }

    private static String getMessageForKey(String requestedKey, String currLine, int lineNumber) {
        String[] pair = MessageFileProcessor.parseLine(currLine, lineNumber);
        if (pair[0].equals(requestedKey)) {
            return pair[1];
        }
        return null;
    }

    private static String[] parseLine(String currLine, int lineNumber) throws RuntimeException {
        if (currLine.length() == 0 || currLine.startsWith(COMMENT_DELIMITER)) {
            return null;
        }
        String[] msgTokens = currLine.split(MESSAGE_LINE_DELIMETER, 3);
        if (msgTokens.length < 3 || msgTokens[0] == null || msgTokens[0].length() == 0 || msgTokens[2] == null || msgTokens[2].length() == 0) {
            throw new RuntimeException("Unexpected message format at line " + lineNumber);
        }
        try {
            Integer.parseInt(msgTokens[0]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Expected to find an integer as the first token on line " + lineNumber + " but found '" + msgTokens[0] + "'");
        }
        String[] ret = new String[2];
        ret[0] = msgTokens[0];
        String message = msgTokens[2].trim();
        if (!message.startsWith("\"")) {
            throw new RuntimeException("Expected message on line " + lineNumber + " to start with \" but found '" + message.substring(0, 1) + "' instead.");
        }
        if (!message.endsWith("\"")) {
            throw new RuntimeException("Expected message on line " + lineNumber + " to end with \" but found '" + message.substring(message.length() - 1) + "' instead.");
        }
        ret[1] = message.substring(1, message.length() - 1);
        return ret;
    }

    private static void usageAndExit() {
        System.out.println("Usage: ");
        System.out.println("\t" + MessageFileProcessor.class.getName() + " " + ARG_CODELINE_BASEDIR + " path_to_root_of_codeline");
        System.exit(-1);
    }
}

