/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.AdminStatus;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.arb.ArbNodeStatus;
import oracle.kv.impl.rep.MasterRepNodeStats;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.util.Ping;

public class PingDisplay {
    public static void topologyOverviewToJson(Topology topology, RepGroupId shard, ObjectNode jsonTop) {
        ObjectNode on = jsonTop.putObject("topology");
        on.put("storeName", topology.getKVStoreName());
        on.put("sequenceNumber", topology.getSequenceNumber());
        if (shard == null) {
            on.put("numPartitions", topology.getPartitionMap().getNPartitions());
            on.put("numStorageNodes", topology.getStorageNodeMap().size());
        } else {
            on.put("shardName", shard.toString());
            Map partToRG = TopologyPrinter.sortPartitions((Topology)topology);
            List partIds = (List)partToRG.get(shard);
            on.put("numPartitions", partIds.size());
            on.put("numStorageNodes", topology.getRepNodeIds().size() / topology.getRepGroupIds().size());
        }
        on.put("time", System.currentTimeMillis());
        on.put("version", KVVersion.CURRENT_VERSION.getNumericVersionString());
    }

    public static String displayTopologyOverview(JsonNode jsonTop) {
        ObjectNode on = JsonUtils.getObject(jsonTop, "topology");
        if (on == null) {
            return "";
        }
        Long timeValue = JsonUtils.getLong(on, "time");
        String time = timeValue == null ? "?" : FormatUtils.formatDateAndTime(timeValue);
        String result = "store " + JsonUtils.getAsText(on, "storeName", "?") + " based upon topology sequence #" + JsonUtils.getAsText(on, "sequenceNumber", "?") + "\n";
        if (on.has("shardName")) {
            result = result + " shard " + JsonUtils.getAsText(on, "shardName", "?") + "\n";
        }
        return result + JsonUtils.getAsText(on, "numPartitions", "?") + " partitions and " + JsonUtils.getAsText(on, "numStorageNodes", "?") + " storage nodes\nTime: " + time + "   Version: " + JsonUtils.getAsText(on, "version", "?");
    }

    public static ObjectNode zoneOverviewToJson(Topology topology, Datacenter dc, Ping.RepNodeStatusFunction rnStatusFunc, Ping.ArbNodeStatusFunction anStatusFunc, RepGroupId shard) {
        DatacenterId dcId = (DatacenterId)dc.getResourceId();
        int online = 0;
        int offline = 0;
        int readonly = 0;
        int onlineANs = 0;
        int offlineANs = 0;
        boolean hasReplicas = false;
        Long maxDelay = null;
        Long maxCatchupTime = null;
        Collection repGroups = topology.getRepGroupMap().getAll();
        for (RepGroup rg : repGroups) {
            if (shard != null && !((RepGroupId)rg.getResourceId()).equals(shard)) continue;
            MasterRepNodeStats masterStats = null;
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeStatus rnStatus = rnStatusFunc.get(rn);
                if (rnStatus == null || !rnStatus.getReplicationState().isMaster()) continue;
                masterStats = rnStatus.getMasterRepNodeStats();
                break;
            }
            for (RepNode rn : rg.getRepNodes()) {
                StorageNode sn = topology.get(rn.getStorageNodeId());
                if (!dcId.equals(sn.getDatacenterId())) continue;
                RepNodeStatus status = rnStatusFunc.get(rn);
                if (status == null) {
                    ++offline;
                    continue;
                }
                if (status.getReplicationState().isActive()) {
                    if (status.getReplicationState().isMaster() && !status.getIsAuthoritativeMaster() || "READONLY".equals(status.getEnabledRequestType())) {
                        ++readonly;
                    } else if ("NONE".equals(status.getEnabledRequestType())) {
                        ++offline;
                    } else {
                        ++online;
                    }
                } else {
                    if (status.getReplicationState().isUnknown()) {
                        ++readonly;
                        continue;
                    }
                    ++offline;
                    continue;
                }
                if (status.getReplicationState().isMaster()) continue;
                hasReplicas = true;
                Long delay = null;
                Long catchupTime = null;
                long networkRestoreTime = status.getNetworkRestoreTimeSecs();
                if (networkRestoreTime != 0L) {
                    catchupTime = networkRestoreTime;
                } else if (masterStats != null) {
                    String replicaName = ((RepNodeId)rn.getResourceId()).toString();
                    delay = (Long)masterStats.getReplicaDelayMillisMap().get(replicaName);
                    catchupTime = masterStats.getReplicaCatchupTimeSecs(replicaName);
                }
                if (delay != null && (maxDelay == null || delay > maxDelay)) {
                    maxDelay = delay;
                }
                if (!PingDisplay.useForMaxTime(catchupTime, maxCatchupTime)) continue;
                maxCatchupTime = catchupTime;
            }
            for (ArbNode an : rg.getArbNodes()) {
                ArbNodeStatus status = anStatusFunc.get(an);
                if (status != null && status.getArbiterState().isActive()) {
                    ++onlineANs;
                    continue;
                }
                ++offlineANs;
            }
        }
        ObjectNode on = JsonUtils.createObjectNode();
        PingDisplay.zoneNameToJson(dc, on);
        ObjectNode rnStatus = on.putObject("rnSummaryStatus");
        rnStatus.put("online", online);
        rnStatus.put("offline", offline);
        rnStatus.put("read-only", readonly);
        rnStatus.put("hasReplicas", hasReplicas);
        if (maxDelay != null) {
            rnStatus.put("maxDelayMillis", maxDelay);
        }
        if (maxCatchupTime != null) {
            rnStatus.put("maxCatchupTimeSecs", maxCatchupTime);
        }
        if (onlineANs > 0 || offlineANs > 0) {
            ObjectNode anStatus = on.putObject("anSummaryStatus");
            anStatus.put("online", onlineANs);
            anStatus.put("offline", offlineANs);
        }
        return on;
    }

    public static String displayZoneOverview(JsonNode jsonZone) {
        ObjectNode jsonRN = JsonUtils.getObject(jsonZone, "rnSummaryStatus");
        if (jsonRN == null) {
            return "Zone " + PingDisplay.displayZoneName(jsonZone);
        }
        boolean hasReplicas = JsonUtils.getBoolean(jsonRN, "hasReplicas", false);
        String maxDelay = !hasReplicas ? null : JsonUtils.getAsText(jsonRN, "maxDelayMillis", "?");
        Long maxCatchupValue = JsonUtils.getLong(jsonRN, "maxCatchupTimeSecs");
        String maxCatchup = !hasReplicas ? null : (maxCatchupValue == null ? "?" : (maxCatchupValue == Long.MAX_VALUE ? "-" : maxCatchupValue.toString()));
        return "Zone " + PingDisplay.displayZoneName(jsonZone) + "   RN Status: online:" + JsonUtils.getAsText(jsonRN, "online", "?") + " read-only:" + JsonUtils.getAsText(jsonRN, "read-only", "?") + " offline:" + JsonUtils.getAsText(jsonRN, "offline", "?") + (maxDelay != null ? " maxDelayMillis:" + maxDelay : "") + (maxCatchup != null ? " maxCatchupTimeSecs:" + maxCatchup : "");
    }

    public static void shardOverviewToJson(Topology topology, Ping.RepNodeStatusFunction rnStatusFunc, Ping.ArbNodeStatusFunction anStatusFunc, RepGroupId shard, ObjectNode jsonTop) {
        int totalRF = 0;
        int totalPrimaryRF = 0;
        for (Datacenter dc : topology.getDatacenterMap().getAll()) {
            int rf = dc.getRepFactor();
            totalRF += rf;
            if (!dc.getDatacenterType().isPrimary()) continue;
            totalPrimaryRF += rf;
        }
        int quorum = totalPrimaryRF / 2 + 1;
        int healthy = 0;
        int writableDegraded = 0;
        int readonly = 0;
        int offline = 0;
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            if (shard != null && !((RepGroupId)rg.getResourceId()).equals(shard)) continue;
            int onlineRNs = 0;
            int onlinePrimaryRNs = 0;
            int onlineReadOnlyRNs = 0;
            int onlineANs = 0;
            int offlineANs = 0;
            for (RepNode rn : rg.getRepNodes()) {
                StorageNode sn = topology.get(rn.getStorageNodeId());
                Datacenter dc = topology.get(sn.getDatacenterId());
                RepNodeStatus status = rnStatusFunc.get(rn);
                if (status == null) continue;
                if (status.getReplicationState().isActive()) {
                    if ("READONLY".equals(status.getEnabledRequestType())) {
                        ++onlineReadOnlyRNs;
                        continue;
                    }
                    if ("NONE".equals(status.getEnabledRequestType())) continue;
                    ++onlineRNs;
                    if (!dc.getDatacenterType().isPrimary()) continue;
                    ++onlinePrimaryRNs;
                    continue;
                }
                if (!status.getReplicationState().isUnknown()) continue;
                ++onlineReadOnlyRNs;
            }
            for (ArbNode an : rg.getArbNodes()) {
                ArbNodeStatus status = anStatusFunc.get(an);
                if (status != null && status.getArbiterState().isActive()) {
                    ++onlineANs;
                    continue;
                }
                ++offlineANs;
            }
            if (onlineRNs >= totalRF && offlineANs == 0) {
                ++healthy;
            } else if (onlinePrimaryRNs + onlineANs >= quorum) {
                ++writableDegraded;
            } else if (onlineRNs > 0 || onlineReadOnlyRNs > 0) {
                ++readonly;
            } else {
                ++offline;
            }
            if (shard == null) continue;
            ObjectNode on = jsonTop.putObject("shardStatus");
            if (healthy != 0) {
                on.putObject("healthy");
            } else if (writableDegraded != 0) {
                on.putObject("writable-degraded");
            } else if (readonly != 0) {
                on.putObject("read-only");
            } else {
                on.putObject("offline");
            }
            return;
        }
        ObjectNode on = jsonTop.putObject("shardStatus");
        on.put("healthy", healthy);
        on.put("writable-degraded", writableDegraded);
        on.put("read-only", readonly);
        on.put("offline", offline);
        on.put("total", topology.getRepGroupIds().size());
    }

    public static String displayShardOverview(JsonNode jsonTop) {
        ObjectNode on = JsonUtils.getObject(jsonTop, "shardStatus");
        if (on == null) {
            return "";
        }
        return "Shard Status: healthy:" + JsonUtils.getAsText(on, "healthy", "?") + " writable-degraded:" + JsonUtils.getAsText(on, "writable-degraded", "?") + " read-only:" + JsonUtils.getAsText(on, "read-only", "?") + " offline:" + JsonUtils.getAsText(on, "offline", "?") + " total:" + JsonUtils.getAsText(on, "total", "?");
    }

    public static String displaySpecificShardOverview(JsonNode jsonTop) {
        ObjectNode on = JsonUtils.getObject(jsonTop, "shardStatus");
        if (on == null) {
            return "";
        }
        if (JsonUtils.getObject(on, "healthy") != null) {
            return "Shard Status: healthy";
        }
        if (JsonUtils.getObject(on, "writable-degraded") != null) {
            return "Shard Status: writable-degraded";
        }
        if (JsonUtils.getObject(on, "read-only") != null) {
            return "Shard Status: read-only";
        }
        if (JsonUtils.getObject(on, "offline") != null) {
            return "Shard Status: offline";
        }
        return "Shard Status: unknown";
    }

    public static void adminOverviewToJson(Parameters parameters, Ping.AdminStatusFunction adminStatusFunc, ObjectNode jsonTop) {
        boolean foundAuthoritativeMaster = false;
        boolean foundOnline = false;
        boolean foundOffline = false;
        for (AdminId adminId : parameters.getAdminIds()) {
            AdminStatus adminStatus = adminStatusFunc.get(adminId);
            if (adminStatus == null || adminStatus.getServiceStatus() != ConfigurableService.ServiceStatus.RUNNING) {
                foundOffline = true;
                continue;
            }
            foundOnline = true;
            if (!adminStatus.getReplicationState().isMaster() || !adminStatus.getIsAuthoritativeMaster()) continue;
            foundAuthoritativeMaster = true;
        }
        String status = !foundOnline ? "offline" : (!foundAuthoritativeMaster ? "read-only" : (foundOffline ? "writable-degraded" : "healthy"));
        jsonTop.put("adminStatus", status);
    }

    public static String displayAdminOverview(JsonNode jsonTop) {
        String adminStatus = JsonUtils.getAsText(jsonTop, "adminStatus");
        if (adminStatus == null) {
            return "";
        }
        return "Admin Status: " + adminStatus;
    }

    public static ObjectNode repNodeToJson(RepNode rn, RepNodeStatus status, RepNodeStatus masterStatus, ConfigurableService.ServiceStatus expected) {
        MasterRepNodeStats stats;
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", ((RepNodeId)rn.getResourceId()).toString());
        PingDisplay.statusToJson(status, on);
        if (expected != null) {
            on.put("expectedStatus", expected.toString());
        }
        if (status == null) {
            return on;
        }
        on.put("sequenceNumber", status.getVlsn());
        on.put("haPort", status.getHAPort());
        long availableStorageSize = status.getAvailableLogSize();
        String availableStorageSizeInUnits = TopologyPrinter.getSizeInUnits((long)availableStorageSize);
        boolean isEnvironmentStatsAvailable = status.isEnvironmentStatsAvailable();
        on.put("availableStorageSize", isEnvironmentStatsAvailable ? availableStorageSizeInUnits : "NOT AVAILABLE");
        if (status.getReplicationState().isMaster()) {
            return on;
        }
        long networkRestoreTime = status.getNetworkRestoreTimeSecs();
        if (networkRestoreTime > 0L) {
            on.put("networkRestoreUnderway", true);
            on.put("catchupTimeSecs", networkRestoreTime);
            return on;
        }
        on.put("networkRestoreUnderway", false);
        if (masterStatus != null && (stats = masterStatus.getMasterRepNodeStats()) != null) {
            Long catchupRate;
            Long catchupTime;
            String replicaName = ((RepNodeId)rn.getResourceId()).toString();
            Long delay = (Long)stats.getReplicaDelayMillisMap().get(replicaName);
            if (delay != null) {
                on.put("delayMillis", delay);
            }
            if ((catchupTime = stats.getReplicaCatchupTimeSecs(replicaName)) != null) {
                on.put("catchupTimeSecs", catchupTime);
            }
            if ((catchupRate = stats.getReplicaCatchupRate(replicaName)) != null) {
                on.put("catchupRateMillisPerMinute", catchupRate);
            }
        }
        return on;
    }

    public static String displayRepNode(JsonNode node) {
        String stopped;
        String result = "\tRep Node [" + JsonUtils.getAsText(node, "resourceId", "?") + "]\tStatus: " + PingDisplay.displayStatus(node) + PingDisplay.displayEnabledRequestType(node);
        String string = stopped = "UNREACHABLE".equals(JsonUtils.getAsText(node, "expectedStatus")) ? " (Stopped)" : "";
        if (JsonUtils.getAsText(node, "status", "UNREACHABLE").equals("UNREACHABLE")) {
            return result + stopped;
        }
        Long sequenceNumber = JsonUtils.getLong(node, "sequenceNumber");
        result = result + " sequenceNumber:" + (sequenceNumber != null ? String.format("%,d", sequenceNumber) : "?") + " haPort:" + JsonUtils.getAsText(node, "haPort", "?");
        String availableStorage = JsonUtils.getAsText(node, "availableStorageSize");
        result = result + " available storage size:" + availableStorage;
        if ("MASTER".equals(JsonUtils.getAsText(node, "state"))) {
            return result + stopped;
        }
        Long catchupTimeValue = JsonUtils.getLong(node, "catchupTimeSecs");
        String catchupTime = catchupTimeValue == null ? "?" : (catchupTimeValue == Long.MAX_VALUE ? "-" : catchupTimeValue.toString());
        boolean networkRestoreUnderway = JsonUtils.getBoolean(node, "networkRestoreUnderway", false);
        return result + " delayMillis:" + JsonUtils.getAsText(node, "delayMillis", "?") + " catchupTimeSecs:" + catchupTime + (networkRestoreUnderway ? " networkRestoreUnderway" : "") + stopped;
    }

    public static String displayArbNode(JsonNode node) {
        String stopped;
        String result = "\tArb Node [" + JsonUtils.getAsText(node, "resourceId", "?") + "]\tStatus: " + PingDisplay.displayStatus(node);
        String string = stopped = "UNREACHABLE".equals(JsonUtils.getAsText(node, "expectedStatus")) ? " (Stopped)" : "";
        if (JsonUtils.getAsText(node, "status", "UNREACHABLE").equals("UNREACHABLE")) {
            return result + stopped;
        }
        Long sequenceNumber = JsonUtils.getLong(node, "sequenceNumber");
        result = result + " sequenceNumber:" + (sequenceNumber != null ? String.format("%,d", sequenceNumber) : "?") + " haPort:" + JsonUtils.getAsText(node, "haPort", "?");
        return result;
    }

    public static ObjectNode storageNodeToJson(Topology topology, StorageNode sn, StorageNodeStatus status) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", ((StorageNodeId)sn.getResourceId()).toString());
        on.put("hostname", sn.getHostname());
        on.put("registryPort", sn.getRegistryPort());
        PingDisplay.zoneNameToJson(topology.get(sn.getDatacenterId()), on.putObject("zone"));
        if (status != null) {
            on.put("serviceStatus", status.getServiceStatus().toString());
            on.put("version", status.getKVVersion().toString());
        } else {
            on.put("serviceStatus", "UNREACHABLE");
        }
        return on;
    }

    public static String displayStorageNode(JsonNode node) {
        String serviceStatus = JsonUtils.getAsText(node, "serviceStatus", "UNREACHABLE");
        return "Storage Node [" + JsonUtils.getAsText(node, "resourceId", "?") + "] on " + JsonUtils.getAsText(node, "hostname", "?") + ":" + JsonUtils.getAsText(node, "registryPort", "?") + "    Zone: " + PingDisplay.displayZoneName(JsonUtils.getObject(node, "zone")) + " " + (!"UNREACHABLE".equals(serviceStatus) ? "   Status: " + serviceStatus + "   Ver: " + JsonUtils.getAsText(node, "version", "?") : "UNREACHABLE");
    }

    public static ObjectNode adminToJson(AdminId aId, AdminStatus adminStatus) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", aId.toString());
        PingDisplay.statusToJson((ServiceInfo)adminStatus, on);
        return on;
    }

    public static String displayAdmin(JsonNode node) {
        return "\tAdmin [" + JsonUtils.getAsText(node, "resourceId", "?") + "]\t\tStatus: " + PingDisplay.displayStatus(node);
    }

    private static String displayStatus(JsonNode node) {
        String state = JsonUtils.getAsText(node, "state");
        String authoritative = "MASTER".equals(state) && !JsonUtils.getBoolean(node, "authoritativeMaster", true) ? " (non-authoritative)" : "";
        return JsonUtils.getAsText(node, "status", "UNREACHABLE") + (state == null ? "" : "," + state + authoritative);
    }

    private static String displayEnabledRequestType(JsonNode node) {
        String requestsEnabled = JsonUtils.getAsText(node, "requestsEnabled");
        return requestsEnabled == null || "ALL".equals(requestsEnabled) ? "" : ("READONLY".equals(requestsEnabled) ? " readonly requests enabled" : " requests disabled");
    }

    private static boolean useForMaxTime(Long time, Long maxTime) {
        if (time == null) {
            return false;
        }
        if (maxTime == null) {
            return true;
        }
        if (time >= 0L && maxTime < 0L) {
            return false;
        }
        if (time < 0L && maxTime >= 0L) {
            return true;
        }
        return time > maxTime;
    }

    private static void zoneNameToJson(Datacenter dc, ObjectNode node) {
        node.put("resourceId", ((DatacenterId)dc.getResourceId()).toString());
        node.put("name", dc.getName());
        node.put("type", dc.getDatacenterType().toString());
        node.put("allowArbiters", dc.getAllowArbiters());
        node.put("masterAffinity", dc.getMasterAffinity());
    }

    private static String displayZoneName(JsonNode node) {
        return "[name=" + JsonUtils.getAsText(node, "name", "?") + " id=" + JsonUtils.getAsText(node, "resourceId", "?") + " type=" + JsonUtils.getAsText(node, "type", "?") + " allowArbiters=" + JsonUtils.getAsText(node, "allowArbiters", "?") + " masterAffinity=" + JsonUtils.getAsText(node, "masterAffinity", "?") + "]";
    }

    private static void statusToJson(ServiceInfo status, ObjectNode on) {
        if (status == null) {
            on.put("status", "UNREACHABLE");
        } else {
            ReplicatedEnvironment.State replicationState;
            on.put("status", status.getServiceStatus().toString());
            if (status instanceof RepNodeStatus) {
                String enabledRequestType = ((RepNodeStatus)status).getEnabledRequestType();
                on.put("requestsEnabled", enabledRequestType);
            }
            if ((replicationState = status.getReplicationState()) != null) {
                on.put("state", replicationState.toString());
                if (replicationState.isMaster()) {
                    on.put("authoritativeMaster", status.getIsAuthoritativeMaster());
                }
            }
        }
    }

    private static void statusToJson(ArbNodeStatus status, ObjectNode on) {
        if (status == null) {
            on.put("status", "UNREACHABLE");
        } else {
            on.put("status", status.getServiceStatus().toString());
            ReplicatedEnvironment.State arbState = status.getArbiterState();
            on.put("state", arbState.toString());
        }
    }

    public static ObjectNode arbNodeToJson(ArbNode an, ArbNodeStatus status, ConfigurableService.ServiceStatus expected) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", ((ArbNodeId)an.getResourceId()).toString());
        PingDisplay.statusToJson(status, on);
        if (expected != null) {
            on.put("expectedStatus", expected.toString());
        }
        if (status == null) {
            return on;
        }
        on.put("sequenceNumber", status.getVlsn());
        on.put("haPort", status.getHAHostPort());
        return on;
    }

    public static interface ServiceInfo {
        public ConfigurableService.ServiceStatus getServiceStatus();

        public ReplicatedEnvironment.State getReplicationState();

        public boolean getIsAuthoritativeMaster();
    }
}

